/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.ptb.base;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.io.ptb.base.PTPosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTSection {
    private int number;
    private int staffs;
    private List<PTPosition> positions;

    public PTSection(int number) {
        this.number = number;
        this.positions = new ArrayList<PTPosition>();
    }

    public int getNumber() {
        return this.number;
    }

    public int getStaffs() {
        return this.staffs;
    }

    public void setStaffs(int staffs) {
        this.staffs = staffs;
    }

    public List<PTPosition> getPositions() {
        return this.positions;
    }

    public PTPosition getPosition(int position) {
        PTPosition p2;
        for (PTPosition p2 : this.getPositions()) {
            if (p2.getPosition() != position) continue;
            return p2;
        }
        p2 = new PTPosition(position);
        this.getPositions().add(p2);
        return p2;
    }

    public int getNextPositionNumber() {
        int next = 0;
        for (PTPosition p : this.getPositions()) {
            next = Math.max(next, p.getPosition() + 1);
        }
        return next;
    }

    public void sort() {
        int count = this.getPositions().size();
        for (int i = 0; i < count; ++i) {
            PTPosition minimum = null;
            for (int j = i; j < count; ++j) {
                PTPosition position = this.getPositions().get(j);
                if (minimum != null && position.getPosition() >= minimum.getPosition()) continue;
                minimum = position;
            }
            this.getPositions().remove(minimum);
            this.getPositions().add(i, minimum);
        }
    }
}

