/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.browser;

import java.io.InputStream;
import java.util.List;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowser;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserCallBack;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserElement;
import org.herac.tuxguitar.community.browser.TGBrowserConnection;
import org.herac.tuxguitar.community.browser.TGBrowserElementImpl;
import org.herac.tuxguitar.util.TGContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGBrowserImpl
implements TGBrowser {
    private TGBrowserConnection connection;
    private TGBrowserElementImpl element = null;

    public TGBrowserImpl(TGContext context) {
        this.connection = new TGBrowserConnection(context);
    }

    public void open(TGBrowserCallBack<Object> cb) {
        try {
            cb.onSuccess(null);
        }
        catch (Throwable throwable) {
            cb.handleError(throwable);
        }
    }

    public void close(TGBrowserCallBack<Object> cb) {
        try {
            cb.onSuccess(null);
        }
        catch (Throwable throwable) {
            cb.handleError(throwable);
        }
    }

    public void cdRoot(TGBrowserCallBack<Object> cb) {
        try {
            this.element = null;
            cb.onSuccess((Object)this.element);
        }
        catch (Throwable throwable) {
            cb.handleError(throwable);
        }
    }

    public void cdUp(TGBrowserCallBack<Object> cb) {
        try {
            if (this.element != null) {
                this.element = this.element.getParent();
            }
            cb.onSuccess((Object)this.element);
        }
        catch (Throwable throwable) {
            cb.handleError(throwable);
        }
    }

    public void cdElement(TGBrowserCallBack<Object> cb, TGBrowserElement element) {
        try {
            if (element instanceof TGBrowserElementImpl) {
                TGBrowserElementImpl nextElement = (TGBrowserElementImpl)element;
                nextElement.setParent(this.element);
                this.element = nextElement;
            }
            cb.onSuccess((Object)this.element);
        }
        catch (Throwable throwable) {
            cb.handleError(throwable);
        }
    }

    public void listElements(TGBrowserCallBack<List<TGBrowserElement>> cb) {
        this.connection.fillElements(cb, this.element);
    }

    public void getInputStream(TGBrowserCallBack<InputStream> cb, TGBrowserElement element) {
        try {
            cb.onSuccess((Object)((TGBrowserElementImpl)element).getInputStream());
        }
        catch (Throwable e) {
            cb.handleError(e);
        }
    }
}

