/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg.v12;

import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.util.TGVersion;

public class TGStream {
    public static final String TG_FORMAT_NAME = "TuxGuitar File Format";
    public static final String TG_FORMAT_VERSION = "TuxGuitar File Format - " + new TGVersion(1, 2, 0).getVersion();
    public static final String TG_FORMAT_EXTENSION = ".tg";
    public static final TGFileFormat TG_FORMAT = new TGFileFormat("TuxGuitar 1.2", "audio/x-tuxguitar", new String[]{"tg"});
    public static final int TRACK_SOLO = 1;
    public static final int TRACK_MUTE = 2;
    public static final int TRACK_LYRICS = 4;
    public static final int MEASURE_HEADER_TIMESIGNATURE = 1;
    public static final int MEASURE_HEADER_TEMPO = 2;
    public static final int MEASURE_HEADER_REPEAT_OPEN = 4;
    public static final int MEASURE_HEADER_REPEAT_CLOSE = 8;
    public static final int MEASURE_HEADER_REPEAT_ALTERNATIVE = 16;
    public static final int MEASURE_HEADER_MARKER = 32;
    public static final int MEASURE_HEADER_TRIPLET_FEEL = 64;
    public static final int MEASURE_CLEF = 1;
    public static final int MEASURE_KEYSIGNATURE = 2;
    public static final int BEAT_HAS_NEXT = 1;
    public static final int BEAT_HAS_STROKE = 2;
    public static final int BEAT_HAS_CHORD = 4;
    public static final int BEAT_HAS_TEXT = 8;
    public static final int BEAT_HAS_VOICE = 16;
    public static final int BEAT_HAS_VOICE_CHANGES = 32;
    public static final int VOICE_HAS_NOTES = 1;
    public static final int VOICE_NEXT_DURATION = 2;
    public static final int VOICE_DIRECTION_UP = 4;
    public static final int VOICE_DIRECTION_DOWN = 8;
    public static final int NOTE_HAS_NEXT = 1;
    public static final int NOTE_TIED = 2;
    public static final int NOTE_EFFECT = 4;
    public static final int NOTE_VELOCITY = 8;
    public static final int DURATION_DOTTED = 1;
    public static final int DURATION_DOUBLE_DOTTED = 2;
    public static final int DURATION_NO_TUPLET = 4;
    public static final int EFFECT_BEND = 1;
    public static final int EFFECT_TREMOLO_BAR = 2;
    public static final int EFFECT_HARMONIC = 4;
    public static final int EFFECT_GRACE = 8;
    public static final int EFFECT_TRILL = 16;
    public static final int EFFECT_TREMOLO_PICKING = 32;
    public static final int EFFECT_VIBRATO = 64;
    public static final int EFFECT_DEAD = 128;
    public static final int EFFECT_SLIDE = 256;
    public static final int EFFECT_HAMMER = 512;
    public static final int EFFECT_GHOST = 1024;
    public static final int EFFECT_ACCENTUATED = 2048;
    public static final int EFFECT_HEAVY_ACCENTUATED = 4096;
    public static final int EFFECT_PALM_MUTE = 8192;
    public static final int EFFECT_STACCATO = 16384;
    public static final int EFFECT_TAPPING = 32768;
    public static final int EFFECT_SLAPPING = 65536;
    public static final int EFFECT_POPPING = 131072;
    public static final int EFFECT_FADE_IN = 262144;
    public static final int EFFECT_LET_RING = 524288;
    public static final int GRACE_FLAG_DEAD = 1;
    public static final int GRACE_FLAG_ON_BEAT = 2;

    public TGFileFormat getFileFormat() {
        return TG_FORMAT;
    }

    public class TGVoiceData {
        private long start;
        private int velocity;
        private int flags;
        private TGDuration duration;

        public TGVoiceData(TGMeasure measure) {
            this.init(measure);
        }

        private void init(TGMeasure measure) {
            this.flags = 0;
            this.setStart(measure.getStart());
            this.setVelocity(95);
            this.setDuration(new TGFactory().newDuration());
        }

        public TGDuration getDuration() {
            return this.duration;
        }

        public void setDuration(TGDuration duration) {
            this.duration = duration;
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public int getVelocity() {
            return this.velocity;
        }

        public void setVelocity(int velocity) {
            this.velocity = velocity;
        }

        public int getFlags() {
            return this.flags;
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }
    }

    public class TGBeatData {
        private long currentStart;
        private TGVoiceData[] voices;

        public TGBeatData(TGMeasure measure) {
            this.init(measure);
        }

        private void init(TGMeasure measure) {
            this.currentStart = measure.getStart();
            this.voices = new TGVoiceData[2];
            for (int i = 0; i < this.voices.length; ++i) {
                this.voices[i] = new TGVoiceData(measure);
            }
        }

        public TGVoiceData getVoice(int index) {
            return this.voices[index];
        }

        public long getCurrentStart() {
            long minimumStart = -1L;
            for (int i = 0; i < this.voices.length; ++i) {
                if (this.voices[i].getStart() <= this.currentStart || minimumStart >= 0L && this.voices[i].getStart() >= minimumStart) continue;
                minimumStart = this.voices[i].getStart();
            }
            if (minimumStart > this.currentStart) {
                this.currentStart = minimumStart;
            }
            return this.currentStart;
        }
    }
}

