/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.system.config;

import org.herac.tuxguitar.ui.resource.UIColorModel;
import org.herac.tuxguitar.ui.resource.UIFontModel;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGConfigManager
extends org.herac.tuxguitar.util.configuration.TGConfigManager {
    public static final String CONFIGURATION_MODULE = "tuxguitar";

    public TGConfigManager(TGContext context) {
        super(context, CONFIGURATION_MODULE);
    }

    public void setValue(String key, UIColorModel model) {
        this.setValue(key, model.getRed() + "," + model.getGreen() + "," + model.getBlue());
    }

    public void setValue(String key, UIFontModel fm) {
        this.setValue(key, fm.getName() + "," + fm.getHeight() + "," + fm.isBold() + "," + fm.isItalic());
    }

    public UIFontModel getFontModelConfigValue(String key) {
        try {
            String[] values;
            String value = this.getProperties().getValue(key);
            if (value != null && (values = value.trim().split(",")) != null && values.length == 4) {
                try {
                    String name = values[0].trim();
                    float size = Float.valueOf(values[1].trim()).floatValue();
                    boolean bold = Boolean.valueOf(values[2].trim());
                    boolean italic = Boolean.valueOf(values[3].trim());
                    return new UIFontModel(name == null ? "Default" : name, size, bold, italic);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public UIFontModel getUIFontModelConfigValue(String key) {
        UIFontModel fm = this.getFontModelConfigValue(key);
        if (fm != null) {
            return new UIFontModel(fm.getName(), fm.getHeight(), fm.isBold(), fm.isItalic());
        }
        return null;
    }

    public UIColorModel getColorModelConfigValue(String key) {
        try {
            String[] values;
            String value = this.getProperties().getValue(key);
            if (value != null && (values = value.trim().split(",")) != null && values.length == 3) {
                try {
                    int red = Integer.parseInt(values[0].trim());
                    int green = Integer.parseInt(values[1].trim());
                    int blue = Integer.parseInt(values[2].trim());
                    return new UIColorModel(red, green, blue);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public UIColorModel getUIColorModelConfigValue(String key) {
        UIColorModel cm = this.getColorModelConfigValue(key);
        if (cm != null) {
            return new UIColorModel(cm.getRed(), cm.getGreen(), cm.getBlue());
        }
        return null;
    }

    public static TGConfigManager getInstance(TGContext context) {
        return (TGConfigManager)((Object)TGSingletonUtil.getInstance((TGContext)context, (String)TGConfigManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGConfigManager>(){

            public TGConfigManager createInstance(TGContext context) {
                return new TGConfigManager(context);
            }
        }));
    }
}

