/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.tab;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingActionManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.component.tab.TGControlPaintListener;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterListenerLocked;
import org.herac.tuxguitar.graphics.control.TGBeatImpl;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UIFocusEvent;
import org.herac.tuxguitar.ui.event.UIFocusGainedListener;
import org.herac.tuxguitar.ui.event.UIMouseDownListener;
import org.herac.tuxguitar.ui.event.UIMouseExitListener;
import org.herac.tuxguitar.ui.event.UIMouseMoveListener;
import org.herac.tuxguitar.ui.event.UIMouseUpListener;
import org.herac.tuxguitar.ui.event.UIPaintListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.widget.UICanvas;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIScrollBar;
import org.herac.tuxguitar.ui.widget.UIScrollBarPanel;
import org.herac.tuxguitar.util.TGContext;

public class TGControl {
    private static final int SCROLL_INCREMENT = 50;
    private TGContext context;
    private UIScrollBarPanel container;
    private UICanvas canvas;
    private UIScrollBar hScroll;
    private UIScrollBar vScroll;
    private Tablature tablature;
    private int width;
    private int height;
    private int scrollX;
    private int scrollY;
    private boolean resetScroll;
    protected long lastVScrollTime;
    protected long lastHScrollTime;
    private boolean painting;

    public TGControl(TGContext context, UIContainer parent) {
        this.context = context;
        this.tablature = TablatureEditor.getInstance(this.context).getTablature();
        this.initialize(parent);
    }

    public void initialize(UIContainer parent) {
        UIFactory factory = TGApplication.getInstance(this.context).getFactory();
        UITableLayout layout = new UITableLayout(Float.valueOf(0.0f));
        this.container = factory.createScrollBarPanel(parent, true, true, false);
        this.container.setLayout((UILayout)layout);
        this.container.addFocusGainedListener(new UIFocusGainedListener(){

            public void onFocusGained(UIFocusEvent event) {
                TGControl.this.setFocus();
            }
        });
        this.canvas = factory.createCanvas((UIContainer)this.container, false);
        this.hScroll = this.container.getHScroll();
        this.vScroll = this.container.getVScroll();
        this.canvas.addPaintListener((UIPaintListener)new TGBufferedPainterListenerLocked(this.context, new TGControlPaintListener(this)));
        this.canvas.addMouseDownListener((UIMouseDownListener)this.tablature.getEditorKit().getMouseKit());
        this.canvas.addMouseUpListener((UIMouseUpListener)this.tablature.getEditorKit().getMouseKit());
        this.canvas.addMouseMoveListener((UIMouseMoveListener)this.tablature.getEditorKit().getMouseKit());
        this.canvas.addMouseExitListener((UIMouseExitListener)this.tablature.getEditorKit().getMouseKit());
        this.hScroll.setIncrement(50);
        this.hScroll.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGControl.this.redraw();
            }
        });
        this.vScroll.setIncrement(50);
        this.vScroll.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGControl.this.redraw();
            }
        });
        KeyBindingActionManager.getInstance(this.context).appendListenersTo((UIControl)this.canvas);
        this.canvas.setPopupMenu(TuxGuitar.getInstance().getItemManager().getPopupMenu());
        this.canvas.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGControl.this.canvas.setPopupMenu(null);
            }
        });
        layout.set((UIControl)this.canvas, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
    }

    public void paintTablature(UIPainter painter) {
        this.setPainting(true);
        try {
            this.checkScroll();
            int oldWidth = this.width;
            int oldHeight = this.height;
            UIRectangle area = this.createRectangle(this.canvas.getBounds());
            this.scrollX = this.hScroll.getValue();
            this.scrollY = this.vScroll.getValue();
            this.tablature.paintTablature(painter, area, -this.scrollX, -this.scrollY);
            this.width = Math.round(this.tablature.getViewLayout().getWidth());
            this.height = Math.round(this.tablature.getViewLayout().getHeight());
            this.updateScroll();
            if (MidiPlayer.getInstance((TGContext)this.context).isRunning()) {
                this.paintTablaturePlayMode(painter);
            } else if (this.tablature.getCaret().hasChanges() || this.width != oldWidth || this.height != oldHeight) {
                this.tablature.getCaret().setChanges(false);
                this.moveScrollTo(this.tablature.getCaret().getMeasure(), area);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.setPainting(false);
    }

    private void paintTablaturePlayMode(UIPainter painter) {
        try {
            TGMeasureImpl measure = TuxGuitar.getInstance().getEditorCache().getPlayMeasure();
            TGBeatImpl beat = TuxGuitar.getInstance().getEditorCache().getPlayBeat();
            if (measure != null && measure.hasTrack(this.tablature.getCaret().getTrack().getNumber())) {
                this.moveScrollTo(measure);
                if (!measure.isOutOfBounds()) {
                    this.tablature.getViewLayout().paintPlayMode(painter, measure, beat);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void resetScroll() {
        this.resetScroll = true;
    }

    public void checkScroll() {
        if (this.resetScroll) {
            this.hScroll.setValue(0);
            this.vScroll.setValue(0);
            this.resetScroll = false;
        }
    }

    public void updateScroll() {
        UIRectangle bounds = this.canvas.getBounds();
        this.hScroll.setMaximum(Math.max(Math.round((float)this.width - bounds.getWidth()), 0));
        this.vScroll.setMaximum(Math.max(Math.round((float)this.height - bounds.getHeight()), 0));
        this.hScroll.setThumb(Math.round(bounds.getWidth()));
        this.vScroll.setThumb(Math.round(bounds.getHeight()));
    }

    public void moveScrollTo(TGMeasureImpl measure) {
        this.moveScrollTo(measure, this.createRectangle(this.canvas.getBounds()));
    }

    public void moveScrollTo(TGMeasureImpl measure, UIRectangle area) {
        if (measure != null && measure.getTs() != null) {
            Integer vScrollValue;
            int mX = Math.round(measure.getPosX());
            int mY = Math.round(measure.getPosY());
            int mWidth = Math.round(measure.getWidth(this.tablature.getViewLayout()));
            int mHeight = Math.round(measure.getTs().getSize());
            int marginWidth = Math.round(this.tablature.getViewLayout().getFirstMeasureSpacing());
            int marginHeight = Math.round(this.tablature.getViewLayout().getFirstTrackSpacing());
            boolean playMode = MidiPlayer.getInstance((TGContext)this.context).isRunning();
            Integer hScrollValue = this.computeScrollValue(this.scrollX, mX, mWidth, marginWidth, Math.round(area.getWidth()), this.width, playMode);
            if (hScrollValue != null) {
                this.hScroll.setValue(hScrollValue.intValue());
            }
            if ((vScrollValue = this.computeScrollValue(this.scrollY, mY, mHeight, marginHeight, Math.round(area.getHeight()), this.height, playMode)) != null) {
                this.vScroll.setValue(vScrollValue.intValue());
            }
            if (this.scrollX != this.hScroll.getValue() || this.scrollY != this.vScroll.getValue()) {
                this.redraw();
            }
        }
    }

    public Integer computeScrollValue(int scrollPos, int mPos, int mSize, int mMargin, int areaSize, int fullSize, boolean playMode) {
        Integer value = null;
        if (mPos < 0 && (areaSize >= mSize + mMargin || mPos + mSize - mMargin <= 0)) {
            value = scrollPos + mPos - mMargin;
        } else if (mPos + mSize > areaSize && (areaSize >= mSize + mMargin || mPos > areaSize)) {
            value = scrollPos + mPos + mSize + mMargin - areaSize;
            if (playMode) {
                value = value + Math.min(fullSize - (scrollPos + mPos + mSize + mMargin), areaSize - mSize - mMargin * 2);
            }
        }
        return value != null ? Integer.valueOf(Math.max(value, 0)) : null;
    }

    public void setFocus() {
        if (!this.isDisposed()) {
            this.canvas.setFocus();
        }
    }

    public void redraw() {
        if (!this.isDisposed()) {
            this.setPainting(true);
            this.canvas.redraw();
        }
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed() && !this.isPainting() && MidiPlayer.getInstance((TGContext)this.context).isRunning()) {
            this.redraw();
        }
    }

    public boolean isPainting() {
        return this.painting;
    }

    public void setPainting(boolean painting) {
        this.painting = painting;
    }

    public TGContext getContext() {
        return this.context;
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public UIContainer getContainer() {
        return this.container;
    }

    public UICanvas getCanvas() {
        return this.canvas;
    }

    public boolean isDisposed() {
        return this.container == null || this.container.isDisposed() || this.canvas == null || this.canvas.isDisposed();
    }

    public UIRectangle createRectangle(UIRectangle rectangle) {
        return new UIRectangle(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }
}

