/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.table;

import org.herac.tuxguitar.app.view.component.table.TGTable;
import org.herac.tuxguitar.app.view.component.table.TGTableCanvasPainter;
import org.herac.tuxguitar.app.view.component.table.TGTableRowCell;
import org.herac.tuxguitar.app.view.component.table.TGTableRowLayout;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterListenerLocked;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterLocked;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIMouseDoubleClickListener;
import org.herac.tuxguitar.ui.event.UIMouseDownListener;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.event.UIMouseUpListener;
import org.herac.tuxguitar.ui.event.UIPaintListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.herac.tuxguitar.ui.widget.UICanvas;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIPanel;

public class TGTableRow {
    private TGTable table;
    private UIPanel row;
    private TGTableRowCell number;
    private TGTableRowCell soloMute;
    private TGTableRowCell name;
    private TGTableRowCell instrument;
    private UICanvas painter;
    private UIMouseUpListener mouseUpListenerLabel;
    private UIMouseDownListener mouseDownListenerLabel;
    private UIMouseDoubleClickListener mouseDoubleClickListenerLabel;
    private UIMouseUpListener mouseUpListenerCanvas;
    private UIMouseDownListener mouseDownListenerCanvas;
    private UIMouseDoubleClickListener mouseDoubleClickListenerCanvas;
    private TGTableCanvasPainter paintListenerCanvas;

    public TGTableRow(TGTable table) {
        this.table = table;
        this.init();
    }

    public void init() {
        UIFactory uiFactory = this.table.getUIFactory();
        MouseListenerLabel mouseListenerLabel = new MouseListenerLabel();
        MouseListenerCanvas mouseListenerCanvas = new MouseListenerCanvas();
        this.row = uiFactory.createPanel((UIContainer)this.table.getRowControl(), false);
        this.row.setLayout((UILayout)new TGTableRowLayout(this));
        this.number = new TGTableRowCell(this);
        this.number.addMouseDownListener(mouseListenerLabel);
        this.number.addMouseUpListener(mouseListenerLabel);
        this.number.addMouseDoubleClickListener(mouseListenerLabel);
        this.soloMute = new TGTableRowCell(this);
        this.soloMute.addMouseDownListener(mouseListenerLabel);
        this.soloMute.addMouseUpListener(mouseListenerLabel);
        this.soloMute.addMouseDoubleClickListener(mouseListenerLabel);
        this.name = new TGTableRowCell(this);
        this.name.addMouseDownListener(mouseListenerLabel);
        this.name.addMouseUpListener(mouseListenerLabel);
        this.name.addMouseDoubleClickListener(mouseListenerLabel);
        this.instrument = new TGTableRowCell(this);
        this.instrument.addMouseDownListener(mouseListenerLabel);
        this.instrument.addMouseUpListener(mouseListenerLabel);
        this.instrument.addMouseDoubleClickListener(mouseListenerLabel);
        this.painter = uiFactory.createCanvas((UIContainer)this.row, false);
        this.painter.addMouseDownListener((UIMouseDownListener)mouseListenerCanvas);
        this.painter.addMouseUpListener((UIMouseUpListener)mouseListenerCanvas);
        this.painter.addMouseDoubleClickListener((UIMouseDoubleClickListener)mouseListenerCanvas);
        this.painter.addPaintListener((UIPaintListener)new TGBufferedPainterListenerLocked(this.table.getContext(), new TGTableRowPaintHandle()));
        this.table.appendListeners((UIControl)this.painter);
    }

    public void setBgColor(UIColor background) {
        this.number.setBgColor(background);
        this.soloMute.setBgColor(background);
        this.name.setBgColor(background);
        this.instrument.setBgColor(background);
    }

    public void setFgColor(UIColor foreground) {
        this.number.setFgColor(foreground);
        this.soloMute.setFgColor(foreground);
        this.name.setFgColor(foreground);
        this.instrument.setFgColor(foreground);
    }

    public void dispose() {
        this.row.dispose();
    }

    public TGTable getTable() {
        return this.table;
    }

    public UIPanel getControl() {
        return this.row;
    }

    public UICanvas getPainter() {
        return this.painter;
    }

    public TGTableRowCell getInstrument() {
        return this.instrument;
    }

    public TGTableRowCell getName() {
        return this.name;
    }

    public TGTableRowCell getNumber() {
        return this.number;
    }

    public TGTableRowCell getSoloMute() {
        return this.soloMute;
    }

    public UIMouseUpListener getMouseUpListenerLabel() {
        return this.mouseUpListenerLabel;
    }

    public void setMouseUpListenerLabel(UIMouseUpListener mouseUpListenerLabel) {
        this.mouseUpListenerLabel = mouseUpListenerLabel;
    }

    public UIMouseDownListener getMouseDownListenerLabel() {
        return this.mouseDownListenerLabel;
    }

    public void setMouseDownListenerLabel(UIMouseDownListener mouseDownListenerLabel) {
        this.mouseDownListenerLabel = mouseDownListenerLabel;
    }

    public UIMouseDoubleClickListener getMouseDoubleClickListenerLabel() {
        return this.mouseDoubleClickListenerLabel;
    }

    public void setMouseDoubleClickListenerLabel(UIMouseDoubleClickListener mouseDoubleClickListenerLabel) {
        this.mouseDoubleClickListenerLabel = mouseDoubleClickListenerLabel;
    }

    public UIMouseUpListener getMouseUpListenerCanvas() {
        return this.mouseUpListenerCanvas;
    }

    public void setMouseUpListenerCanvas(UIMouseUpListener mouseUpListenerCanvas) {
        this.mouseUpListenerCanvas = mouseUpListenerCanvas;
    }

    public UIMouseDownListener getMouseDownListenerCanvas() {
        return this.mouseDownListenerCanvas;
    }

    public void setMouseDownListenerCanvas(UIMouseDownListener mouseDownListenerCanvas) {
        this.mouseDownListenerCanvas = mouseDownListenerCanvas;
    }

    public UIMouseDoubleClickListener getMouseDoubleClickListenerCanvas() {
        return this.mouseDoubleClickListenerCanvas;
    }

    public void setMouseDoubleClickListenerCanvas(UIMouseDoubleClickListener mouseDoubleClickListenerCanvas) {
        this.mouseDoubleClickListenerCanvas = mouseDoubleClickListenerCanvas;
    }

    public TGTableCanvasPainter getPaintListenerCanvas() {
        return this.paintListenerCanvas;
    }

    public void setPaintListenerCanvas(TGTableCanvasPainter paintListenerCanvas) {
        this.paintListenerCanvas = paintListenerCanvas;
    }

    private class TGTableRowPaintHandle
    implements TGBufferedPainterLocked.TGBufferedPainterHandle {
        public void paintControl(UIPainter painter) {
            if (TGTableRow.this.getPaintListenerCanvas() != null) {
                TGTableRow.this.getPaintListenerCanvas().paintTrack(TGTableRow.this, painter);
            }
        }

        public UICanvas getPaintableControl() {
            return TGTableRow.this.getPainter();
        }
    }

    private class MouseListenerCanvas
    implements UIMouseUpListener,
    UIMouseDownListener,
    UIMouseDoubleClickListener {
        public void onMouseDoubleClick(UIMouseEvent event) {
            if (TGTableRow.this.getMouseDoubleClickListenerCanvas() != null) {
                TGTableRow.this.getMouseDoubleClickListenerCanvas().onMouseDoubleClick(event);
            }
        }

        public void onMouseDown(UIMouseEvent event) {
            if (TGTableRow.this.getMouseDownListenerCanvas() != null) {
                TGTableRow.this.getMouseDownListenerCanvas().onMouseDown(event);
            }
        }

        public void onMouseUp(UIMouseEvent event) {
            if (TGTableRow.this.getMouseUpListenerCanvas() != null) {
                TGTableRow.this.getMouseUpListenerCanvas().onMouseUp(event);
            }
        }
    }

    private class MouseListenerLabel
    implements UIMouseUpListener,
    UIMouseDownListener,
    UIMouseDoubleClickListener {
        public void onMouseDoubleClick(UIMouseEvent event) {
            if (TGTableRow.this.getMouseDoubleClickListenerLabel() != null) {
                TGTableRow.this.getMouseDoubleClickListenerLabel().onMouseDoubleClick(event);
            }
        }

        public void onMouseDown(UIMouseEvent event) {
            if (TGTableRow.this.getMouseDownListenerLabel() != null) {
                TGTableRow.this.getMouseDownListenerLabel().onMouseDown(event);
            }
        }

        public void onMouseUp(UIMouseEvent event) {
            if (TGTableRow.this.getMouseUpListenerLabel() != null) {
                TGTableRow.this.getMouseUpListenerLabel().onMouseUp(event);
            }
        }
    }
}

