/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.settings.items;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.dialog.settings.TGSettingsEditor;
import org.herac.tuxguitar.app.view.dialog.settings.items.TGSettingsOption;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.chooser.UIColorChooser;
import org.herac.tuxguitar.ui.chooser.UIColorChooserHandler;
import org.herac.tuxguitar.ui.chooser.UIFontChooser;
import org.herac.tuxguitar.ui.chooser.UIFontChooserHandler;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIColorModel;
import org.herac.tuxguitar.ui.resource.UIFontModel;
import org.herac.tuxguitar.ui.toolbar.UIToolBar;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;

public class StylesOption
extends TGSettingsOption {
    private static final float BUTTON_WIDTH = 200.0f;
    private boolean initialized = false;
    private UIFontModel defaultFontData = new UIFontModel();
    private UIFontModel noteFontData = new UIFontModel();
    private UIFontModel textFontData = new UIFontModel();
    private UIFontModel lyricFontData = new UIFontModel();
    private UIFontModel printerDefaultFontData = new UIFontModel();
    private UIFontModel printerNoteFontData = new UIFontModel();
    private UIFontModel printerTextFontData = new UIFontModel();
    private UIFontModel printerLyricFontData = new UIFontModel();
    private UIButton defaultFontButton;
    private UIButton noteFontButton;
    private UIButton textFontButton;
    private UIButton lyricFontButton;
    private UIButton printerDefaultFontButton;
    private UIButton printerNoteFontButton;
    private UIButton printerTextFontButton;
    private UIButton printerLyricFontButton;
    private UIColorButton scoreNoteColorButton;
    private UIColorButton tabNoteColorButton;
    private UIColorButton playNoteColorButton;
    private UIColorButton linesColorButton;

    public StylesOption(TGSettingsEditor configEditor, UIToolBar toolBar, UILayoutContainer parent) {
        super(configEditor, toolBar, parent, TuxGuitar.getProperty("settings.config.styles"));
    }

    public void createOption() {
        UIFactory uiFactory = this.getUIFactory();
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.styles"));
        this.getToolItem().setImage(TuxGuitar.getInstance().getIconManager().getOptionStyle());
        this.getToolItem().addSelectionListener((UISelectionListener)this);
        this.showLabel((UILayoutContainer)this.getPanel(), TuxGuitar.getProperty("settings.config.styles.general"), true, 1, 1);
        UIPanel mainSection = uiFactory.createPanel((UIContainer)this.getPanel(), false);
        mainSection.setLayout((UILayout)new UITableLayout());
        this.indent((UIControl)mainSection, 2, 1);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.font.default"), false, 1, 1);
        this.defaultFontButton = this.createFontButton((UILayoutContainer)mainSection, this.defaultFontData, 1, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.font.note"), false, 2, 1);
        this.noteFontButton = this.createFontButton((UILayoutContainer)mainSection, this.noteFontData, 2, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.font.lyric"), false, 3, 1);
        this.lyricFontButton = this.createFontButton((UILayoutContainer)mainSection, this.lyricFontData, 3, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.font.text"), false, 4, 1);
        this.textFontButton = this.createFontButton((UILayoutContainer)mainSection, this.textFontData, 4, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.color.score-note"), false, 5, 1);
        this.scoreNoteColorButton = this.createColorButton((UILayoutContainer)mainSection, TuxGuitar.getProperty("choose"), 5, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.color.tab-note"), false, 6, 1);
        this.tabNoteColorButton = this.createColorButton((UILayoutContainer)mainSection, TuxGuitar.getProperty("choose"), 6, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.color.play-note"), false, 7, 1);
        this.playNoteColorButton = this.createColorButton((UILayoutContainer)mainSection, TuxGuitar.getProperty("choose"), 7, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.color.lines"), false, 8, 1);
        this.linesColorButton = this.createColorButton((UILayoutContainer)mainSection, TuxGuitar.getProperty("choose"), 8, 2);
        this.showLabel((UILayoutContainer)this.getPanel(), TuxGuitar.getProperty("settings.config.styles.printer"), true, 3, 1);
        UIPanel printerSection = uiFactory.createPanel((UIContainer)this.getPanel(), false);
        printerSection.setLayout((UILayout)new UITableLayout());
        this.indent((UIControl)printerSection, 4, 1);
        this.showLabel((UILayoutContainer)printerSection, TuxGuitar.getProperty("settings.config.styles.font.default"), false, 1, 1);
        this.printerDefaultFontButton = this.createFontButton((UILayoutContainer)printerSection, this.printerDefaultFontData, 1, 2);
        this.showLabel((UILayoutContainer)printerSection, TuxGuitar.getProperty("settings.config.styles.font.note"), false, 2, 1);
        this.printerNoteFontButton = this.createFontButton((UILayoutContainer)printerSection, this.printerNoteFontData, 2, 2);
        this.showLabel((UILayoutContainer)printerSection, TuxGuitar.getProperty("settings.config.styles.font.lyric"), false, 3, 1);
        this.printerLyricFontButton = this.createFontButton((UILayoutContainer)printerSection, this.printerLyricFontData, 3, 2);
        this.showLabel((UILayoutContainer)printerSection, TuxGuitar.getProperty("settings.config.styles.font.text"), false, 4, 1);
        this.printerTextFontButton = this.createFontButton((UILayoutContainer)printerSection, this.printerTextFontData, 4, 2);
        this.loadConfig();
    }

    public UIColorButton createColorButton(UILayoutContainer parent, String text, int row, int col) {
        UIColorButton button = new UIColorButton(this.getWindow(), (UIContainer)parent, text);
        UITableLayout uiLayout = (UITableLayout)parent.getLayout();
        uiLayout.set(button.getControl(), Integer.valueOf(row), Integer.valueOf(col), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(200.0f), null, null);
        return button;
    }

    public UIButton createFontButton(UILayoutContainer parent, UIFontModel fontModel, int row, int col) {
        UIButton uiButton = this.getUIFactory().createButton((UIContainer)parent);
        uiButton.setText("-");
        UITableLayout uiLayout = (UITableLayout)parent.getLayout();
        uiLayout.set((UIControl)uiButton, Integer.valueOf(row), Integer.valueOf(col), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(200.0f), null, null);
        this.addFontButtonListeners(uiButton, fontModel);
        return uiButton;
    }

    private void addFontButtonListeners(final UIButton button, final UIFontModel fontModel) {
        button.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (StylesOption.this.initialized) {
                    UIFontModel defaultModel = new UIFontModel();
                    StylesOption.this.copyFontData(fontModel, defaultModel);
                    UIFontChooser uiFontChooser = StylesOption.this.getUIFactory().createFontChooser(StylesOption.this.getWindow());
                    uiFontChooser.setDefaultModel(defaultModel);
                    uiFontChooser.choose(new UIFontChooserHandler(){

                        public void onSelectFont(UIFontModel selection) {
                            if (selection != null) {
                                StylesOption.this.loadFontData(selection, fontModel, button);
                            }
                        }
                    });
                }
            }
        });
    }

    protected void loadFontData(UIFontModel src, UIFontModel dst, UIButton button) {
        this.copyFontData(src, dst);
        this.setButtonFontData(button, dst);
    }

    protected void loadColor(UIColorButton button, UIColorModel rgb) {
        button.loadColor(rgb);
    }

    protected void setButtonFontData(UIButton button, UIFontModel fontModel) {
        String text = fontModel.getName();
        if (fontModel.isBold()) {
            text = text + " Bold";
        }
        if (fontModel.isItalic()) {
            text = text + " Italic";
        }
        text = text + " " + fontModel.getHeight();
        button.setText(text);
    }

    protected void copyFontData(UIFontModel src, UIFontModel dst) {
        dst.setName(src.getName());
        dst.setHeight(src.getHeight());
        dst.setBold(src.isBold());
        dst.setItalic(src.isItalic());
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                final UIFontModel defaultFontData = StylesOption.this.getConfig().getUIFontModelConfigValue("font.default");
                final UIFontModel noteFontData = StylesOption.this.getConfig().getUIFontModelConfigValue("font.note");
                final UIFontModel textFontData = StylesOption.this.getConfig().getUIFontModelConfigValue("font.text");
                final UIFontModel lyricFontData = StylesOption.this.getConfig().getUIFontModelConfigValue("font.lyric");
                final UIFontModel printerDefaultFontData = StylesOption.this.getConfig().getUIFontModelConfigValue("font.printer.default");
                final UIFontModel printerNoteFontData = StylesOption.this.getConfig().getUIFontModelConfigValue("font.printer.note");
                final UIFontModel printerTextFontData = StylesOption.this.getConfig().getUIFontModelConfigValue("font.printer.text");
                final UIFontModel printerLyricFontData = StylesOption.this.getConfig().getUIFontModelConfigValue("font.printer.lyric");
                final UIColorModel scoreNoteRGB = StylesOption.this.getConfig().getUIColorModelConfigValue("color.score.note");
                final UIColorModel tabNoteRGB = StylesOption.this.getConfig().getUIColorModelConfigValue("color.tab.note");
                final UIColorModel playNoteRGB = StylesOption.this.getConfig().getUIColorModelConfigValue("color.play.note");
                final UIColorModel linesRGB = StylesOption.this.getConfig().getUIColorModelConfigValue("color.line");
                TGSynchronizer.getInstance((TGContext)StylesOption.this.getViewContext().getContext()).executeLater(new Runnable(){

                    public void run() {
                        if (!StylesOption.this.isDisposed()) {
                            StylesOption.this.loadFontData(defaultFontData, StylesOption.this.defaultFontData, StylesOption.this.defaultFontButton);
                            StylesOption.this.loadFontData(noteFontData, StylesOption.this.noteFontData, StylesOption.this.noteFontButton);
                            StylesOption.this.loadFontData(textFontData, StylesOption.this.textFontData, StylesOption.this.textFontButton);
                            StylesOption.this.loadFontData(lyricFontData, StylesOption.this.lyricFontData, StylesOption.this.lyricFontButton);
                            StylesOption.this.loadFontData(printerDefaultFontData, StylesOption.this.printerDefaultFontData, StylesOption.this.printerDefaultFontButton);
                            StylesOption.this.loadFontData(printerNoteFontData, StylesOption.this.printerNoteFontData, StylesOption.this.printerNoteFontButton);
                            StylesOption.this.loadFontData(printerTextFontData, StylesOption.this.printerTextFontData, StylesOption.this.printerTextFontButton);
                            StylesOption.this.loadFontData(printerLyricFontData, StylesOption.this.printerLyricFontData, StylesOption.this.printerLyricFontButton);
                            StylesOption.this.scoreNoteColorButton.loadColor(scoreNoteRGB);
                            StylesOption.this.tabNoteColorButton.loadColor(tabNoteRGB);
                            StylesOption.this.playNoteColorButton.loadColor(playNoteRGB);
                            StylesOption.this.linesColorButton.loadColor(linesRGB);
                            StylesOption.this.initialized = true;
                            StylesOption.this.pack();
                        }
                    }
                });
            }
        }).start();
    }

    public void updateConfig() {
        if (this.initialized) {
            this.getConfig().setValue("font.default", this.defaultFontData);
            this.getConfig().setValue("font.note", this.noteFontData);
            this.getConfig().setValue("font.text", this.textFontData);
            this.getConfig().setValue("font.lyric", this.lyricFontData);
            this.getConfig().setValue("font.printer.default", this.printerDefaultFontData);
            this.getConfig().setValue("font.printer.note", this.printerNoteFontData);
            this.getConfig().setValue("font.printer.text", this.printerTextFontData);
            this.getConfig().setValue("font.printer.lyric", this.printerLyricFontData);
            this.getConfig().setValue("color.score.note", this.scoreNoteColorButton.getValue());
            this.getConfig().setValue("color.tab.note", this.tabNoteColorButton.getValue());
            this.getConfig().setValue("color.play.note", this.playNoteColorButton.getValue());
            this.getConfig().setValue("color.line", this.linesColorButton.getValue());
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setValue("font.default", this.getDefaults().getValue("font.default"));
            this.getConfig().setValue("font.note", this.getDefaults().getValue("font.note"));
            this.getConfig().setValue("font.text", this.getDefaults().getValue("font.text"));
            this.getConfig().setValue("font.lyric", this.getDefaults().getValue("font.lyric"));
            this.getConfig().setValue("font.printer.default", this.getDefaults().getValue("font.printer.default"));
            this.getConfig().setValue("font.printer.note", this.getDefaults().getValue("font.printer.note"));
            this.getConfig().setValue("font.printer.text", this.getDefaults().getValue("font.printer.text"));
            this.getConfig().setValue("font.printer.lyric", this.getDefaults().getValue("font.printer.lyric"));
            this.getConfig().setValue("color.score.note", this.getDefaults().getValue("color.score.note"));
            this.getConfig().setValue("color.tab.note", this.getDefaults().getValue("color.tab.note"));
            this.getConfig().setValue("color.play.note", this.getDefaults().getValue("color.play.note"));
            this.getConfig().setValue("color.line", this.getDefaults().getValue("color.line"));
        }
    }

    private class UIColorButton {
        private UIWindow window;
        private UIButton button;
        private UIColor color;
        private UIColorModel value;

        public UIColorButton(UIWindow window, UIContainer parent, String text) {
            this.window = window;
            this.value = new UIColorModel();
            this.button = StylesOption.this.getUIFactory().createButton(parent);
            this.button.setText(text);
            this.addListeners();
        }

        public void loadColor(UIColorModel cm) {
            this.value.setRed(cm.getRed());
            this.value.setGreen(cm.getGreen());
            this.value.setBlue(cm.getBlue());
            UIColor color = StylesOption.this.getUIFactory().createColor(this.value);
            this.button.setFgColor(color);
            this.disposeColor();
            this.color = color;
        }

        public void disposeColor() {
            if (this.color != null && !this.color.isDisposed()) {
                this.color.dispose();
                this.color = null;
            }
        }

        public void addListeners() {
            this.button.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    UIColorChooser dlg = StylesOption.this.getUIFactory().createColorChooser(UIColorButton.this.window);
                    dlg.setDefaultModel(UIColorButton.this.value);
                    dlg.setText(TuxGuitar.getProperty("choose-color"));
                    dlg.choose(new UIColorChooserHandler(){

                        public void onSelectColor(UIColorModel model) {
                            if (model != null) {
                                UIColorButton.this.loadColor(model);
                            }
                        }
                    });
                }
            });
            this.button.addDisposeListener(new UIDisposeListener(){

                public void onDispose(UIDisposeEvent event) {
                    UIColorButton.this.disposeColor();
                }
            });
        }

        public UIControl getControl() {
            return this.button;
        }

        public UIColorModel getValue() {
            return this.value;
        }
    }
}

