/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.tempo;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIRadioButton;
import org.herac.tuxguitar.ui.widget.UISpinner;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

public class TGTempoDialog {
    private static final int MIN_TEMPO = 30;
    private static final int MAX_TEMPO = 320;
    protected static final int[] DEFAULT_PERCENTS = new int[]{25, 50, 75, 100, 125, 150, 175, 200};

    public void show(final TGViewContext context) {
        final TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final TGMeasureHeader header = (TGMeasureHeader)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
        UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("composition.tempo"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty("composition.tempo"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        TGTempo currentTempo = header.getTempo();
        UILabel tempoLabel = uiFactory.createLabel((UIContainer)group);
        tempoLabel.setText(TuxGuitar.getProperty("composition.tempo"));
        groupLayout.set((UIControl)tempoLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UISpinner tempo = uiFactory.createSpinner((UIContainer)group);
        tempo.setMinimum(30);
        tempo.setMaximum(320);
        tempo.setValue(currentTempo.getValue());
        groupLayout.set((UIControl)tempo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(150.0f), null, null);
        UITableLayout optionsLayout = new UITableLayout();
        UILegendPanel options = uiFactory.createLegendPanel((UIContainer)dialog);
        options.setLayout((UILayout)optionsLayout);
        options.setText(TuxGuitar.getProperty("options"));
        dialogLayout.set((UIControl)options, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UIRadioButton applyToAllMeasures = uiFactory.createRadioButton((UIContainer)options);
        applyToAllMeasures.setText(TuxGuitar.getProperty("composition.tempo.start-to-end"));
        applyToAllMeasures.setSelected(true);
        optionsLayout.set((UIControl)applyToAllMeasures, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UIRadioButton applyToEnd = uiFactory.createRadioButton((UIContainer)options);
        applyToEnd.setText(TuxGuitar.getProperty("composition.tempo.position-to-end"));
        optionsLayout.set((UIControl)applyToEnd, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UIRadioButton applyToNext = uiFactory.createRadioButton((UIContainer)options);
        applyToNext.setText(TuxGuitar.getProperty("composition.tempo.position-to-next"));
        optionsLayout.set((UIControl)applyToNext, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                Integer value = tempo.getValue();
                Integer applyTo = TGTempoDialog.this.parseApplyTo(applyToAllMeasures, applyToEnd, applyToNext);
                TGTempoDialog.this.changeTempo(context.getContext(), song, header, value, applyTo);
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    private Integer parseApplyTo(UIRadioButton applyToAll, UIRadioButton applyToEnd, UIRadioButton applyToNext) {
        if (applyToAll.isSelected()) {
            return 1;
        }
        if (applyToEnd.isSelected()) {
            return 2;
        }
        if (applyToNext.isSelected()) {
            return 3;
        }
        return 0;
    }

    public void changeTempo(TGContext context, TGSong song, TGMeasureHeader header, Integer value, Integer applyTo) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.composition.change-tempo-range");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, (Object)header);
        tgActionProcessor.setAttribute("tempoValue", (Object)value);
        tgActionProcessor.setAttribute("applyTo", (Object)applyTo);
        tgActionProcessor.processOnNewThread();
    }
}

