/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tef;

import java.util.Collections;
import java.util.Comparator;
import org.herac.tuxguitar.io.tef.TGSongAdjuster;
import org.herac.tuxguitar.io.tef.base.TEChord;
import org.herac.tuxguitar.io.tef.base.TEComponent;
import org.herac.tuxguitar.io.tef.base.TEComponentChord;
import org.herac.tuxguitar.io.tef.base.TEComponentNote;
import org.herac.tuxguitar.io.tef.base.TESong;
import org.herac.tuxguitar.io.tef.base.TETimeSignature;
import org.herac.tuxguitar.io.tef.base.TETrack;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGDivisionType;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;

public class TESongParser {
    private static final int[][] PERCUSSION_TUNINGS = new int[][]{{49, 41, 32}, {49, 51, 42, 50}, {49, 42, 50, 37, 32}, {49, 51, 42, 50, 45, 37}, {49, 51, 42, 50, 45, 37, 41}};
    private TGSongManager manager;

    public TESongParser(TGFactory factory) {
        this.manager = new TGSongManager(factory);
    }

    public TGSong parseSong(TESong song) {
        TGSong tgSong = this.manager.newSong();
        this.sortComponents(song);
        this.addTracksAndHeaders(tgSong, song.getTracks().length, song.getMeasures(), song.getTempo().getValue());
        this.addMeasureValues(tgSong, song);
        this.addTrackValues(tgSong, song.getTracks());
        this.addComponents(tgSong, song);
        return new TGSongAdjuster(this.manager, tgSong).process();
    }

    private void addTracksAndHeaders(TGSong song, int tracks, int measures, int tempo) {
        this.manager.getFirstMeasureHeader(song).getTempo().setValue(tempo);
        while (song.countTracks() < tracks) {
            this.manager.addTrack(song);
        }
        while (song.countMeasureHeaders() < measures) {
            this.manager.addNewMeasureBeforeEnd(song);
        }
    }

    private void addMeasureValues(TGSong tgSong, TESong song) {
        TGTimeSignature timeSignature = this.manager.getFactory().newTimeSignature();
        for (int i = 0; i < tgSong.countMeasureHeaders(); ++i) {
            TGMeasureHeader header = tgSong.getMeasureHeader(i);
            TETimeSignature ts = song.getTimeSignature(i);
            timeSignature.setNumerator(ts.getNumerator());
            timeSignature.getDenominator().setValue(ts.getDenominator());
            this.manager.changeTimeSignature(tgSong, header, timeSignature, false);
        }
    }

    private void addTrackValues(TGSong tgSong, TETrack[] tracks) {
        for (int i = 0; i < tracks.length; ++i) {
            TGTrack track = tgSong.getTrack(i);
            TGChannel tgChannel = this.manager.addChannel(tgSong);
            tgChannel.setVolume((short)((15 - tracks[i].getVolume()) * 127 / 15));
            tgChannel.setBalance((short)(tracks[i].getPan() * 127 / 15));
            tgChannel.setProgram((short)tracks[i].getInstrument());
            tgChannel.setBank(tracks[i].isPercussion() ? (short)128 : 0);
            tgChannel.setName(this.manager.createChannelNameFromProgram(tgSong, tgChannel));
            track.setChannelId(tgChannel.getChannelId());
            track.getStrings().clear();
            int[] strings = tracks[i].getStrings();
            for (int j = 0; j < strings.length && j < 7; ++j) {
                TGString string = this.manager.getFactory().newString();
                string.setNumber(j + 1);
                string.setValue(tracks[i].isPercussion() ? 0 : 96 - strings[j]);
                track.getStrings().add(string);
            }
        }
    }

    private void addComponents(TGSong tgSong, TESong song) {
        for (TEComponent component : song.getComponents()) {
            if (component.getMeasure() < 0 || component.getMeasure() >= tgSong.countMeasureHeaders()) continue;
            int offset = 0;
            TETrack[] tracks = song.getTracks();
            for (int i = 0; i < tracks.length; ++i) {
                int strings = tracks[i].getStrings().length;
                int string = component.getString() - offset;
                if (string >= 0 && string < strings && string < 7) {
                    TGTrack tgTrack = tgSong.getTrack(i);
                    TGMeasure tgMeasure = tgTrack.getMeasure(component.getMeasure());
                    if (component instanceof TEComponentNote) {
                        this.addNote(tracks[i], (TEComponentNote)component, string, strings, tgMeasure);
                    } else if (component instanceof TEComponentChord) {
                        this.addChord(song.getChords(), (TEComponentChord)component, tgTrack, tgMeasure);
                    }
                }
                offset += strings;
            }
        }
    }

    private TGBeat getBeat(TGMeasure measure, long start) {
        TGBeat beat = this.manager.getMeasureManager().getBeat(measure, start);
        if (beat == null) {
            beat = this.manager.getFactory().newBeat();
            beat.setStart(start);
            measure.addBeat(beat);
        }
        return beat;
    }

    private long getStart(TGDuration duration, TGMeasure measure, int position) {
        float fixedPosition = position;
        if (duration != null && !duration.getDivision().isEqual(TGDivisionType.NORMAL)) {
            fixedPosition = fixedPosition - fixedPosition % 64.0f + fixedPosition % 64.0f * 2.0f * 2.0f / 3.0f;
        }
        long start = (long)((float)measure.getStart() + fixedPosition * 960.0f / 64.0f);
        return start;
    }

    private TGDuration getDuration(int duration) {
        TGDuration tgDuration = this.manager.getFactory().newDuration();
        int value = 1;
        for (int i = 0; i < duration / 3; ++i) {
            value *= 2;
        }
        if (duration % 3 == 1) {
            value *= 2;
            tgDuration.setDotted(true);
        } else if (duration % 3 == 2) {
            tgDuration.getDivision().setEnters(3);
            tgDuration.getDivision().setTimes(2);
        }
        tgDuration.setValue(value);
        return tgDuration;
    }

    private void addNote(TETrack track, TEComponentNote note, int string, int strings, TGMeasure tgMeasure) {
        int value = note.getFret();
        if (track.isPercussion()) {
            int tuning = Math.min(strings - 2, PERCUSSION_TUNINGS.length) - 1;
            if (string >= 0 && string < PERCUSSION_TUNINGS[tuning].length) {
                value += PERCUSSION_TUNINGS[tuning][string];
            }
        }
        TGNote tgNote = this.manager.getFactory().newNote();
        tgNote.setString(string + 1);
        tgNote.setValue(value);
        TGDuration tgDuration = this.getDuration(note.getDuration());
        TGBeat tgBeat = this.getBeat(tgMeasure, this.getStart(tgDuration, tgMeasure, note.getPosition()));
        tgBeat.getVoice(0).getDuration().copyFrom(tgDuration);
        tgBeat.getVoice(0).addNote(tgNote);
    }

    private void addChord(TEChord[] chords, TEComponentChord component, TGTrack tgTrack, TGMeasure tgMeasure) {
        if (component.getChord() >= 0 && component.getChord() < chords.length) {
            TEChord chord = chords[component.getChord()];
            byte[] strings = chord.getStrings();
            TGChord tgChord = this.manager.getFactory().newChord(tgTrack.stringCount());
            tgChord.setName(chord.getName());
            for (int i = 0; i < tgChord.countStrings(); ++i) {
                int value = i < strings.length ? strings[i] : -1;
                tgChord.addFretValue(i, value);
            }
            if (tgChord.countNotes() > 0) {
                TGBeat tgBeat = this.getBeat(tgMeasure, this.getStart(null, tgMeasure, component.getPosition()));
                tgBeat.setChord(tgChord);
            }
        }
    }

    public void sortComponents(TESong song) {
        Collections.sort(song.getComponents(), new Comparator<TEComponent>(){

            @Override
            public int compare(TEComponent c1, TEComponent c2) {
                if (c1 != null && c2 != null) {
                    if (c1.getMeasure() < c2.getMeasure()) {
                        return -1;
                    }
                    if (c1.getMeasure() > c2.getMeasure()) {
                        return 1;
                    }
                    if (c1.getPosition() < c2.getPosition()) {
                        return -1;
                    }
                    if (c1.getPosition() > c2.getPosition()) {
                        return 1;
                    }
                    if (c1 instanceof TEComponentNote && !(c2 instanceof TEComponentNote)) {
                        return -1;
                    }
                    if (c2 instanceof TEComponentNote && !(c1 instanceof TEComponentNote)) {
                        return 1;
                    }
                }
                return 0;
            }
        });
    }
}

