/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.draw.VerticalPositionMark;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.html.CssAppliers;
import com.itextpdf.tool.xml.html.HTMLUtils;
import com.itextpdf.tool.xml.html.pdfelement.TabbedChunk;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParaGraph
extends AbstractTagProcessor {
    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        String sanitized = HTMLUtils.sanitize(content);
        ArrayList<Element> l = new ArrayList<Element>(1);
        if (sanitized.length() > 0) {
            HtmlPipelineContext myctx;
            try {
                myctx = this.getHtmlPipelineContext(ctx);
            }
            catch (NoCustomContextException e) {
                throw new RuntimeWorkerException(e);
            }
            if (null != tag.getCSS().get("tab-interval")) {
                TabbedChunk tabbedChunk = new TabbedChunk(sanitized);
                if (null != this.getLastChild(tag) && null != this.getLastChild(tag).getCSS().get("xfa-tab-count")) {
                    tabbedChunk.setTabCount(Integer.parseInt(this.getLastChild(tag).getCSS().get("xfa-tab-count")));
                }
                l.add(CssAppliers.getInstance().apply((Element)tabbedChunk, tag, myctx));
            } else if (null != this.getLastChild(tag) && null != this.getLastChild(tag).getCSS().get("xfa-tab-count")) {
                TabbedChunk tabbedChunk = new TabbedChunk(sanitized);
                tabbedChunk.setTabCount(Integer.parseInt(this.getLastChild(tag).getCSS().get("xfa-tab-count")));
                l.add(CssAppliers.getInstance().apply((Element)tabbedChunk, tag, myctx));
            } else {
                l.add(CssAppliers.getInstance().apply((Element)new Chunk(sanitized), tag, myctx));
            }
        }
        return l;
    }

    private Tag getLastChild(Tag tag) {
        if (0 != tag.getChildren().size()) {
            return tag.getChildren().get(tag.getChildren().size() - 1);
        }
        return null;
    }

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        ArrayList<Element> l = new ArrayList<Element>(1);
        if (currentContent.size() > 0) {
            Paragraph p = new Paragraph();
            Map<String, String> css = tag.getCSS();
            if (null != css.get("tab-interval")) {
                this.addTabIntervalContent(currentContent, p, css.get("tab-interval"));
                l.add((Element)p);
            } else if (null != css.get("tab-stops")) {
                this.addTabStopsContent(currentContent, p, css.get("tab-stops"));
                l.add((Element)p);
            } else if (null != css.get("xfa-tab-stops")) {
                this.addTabStopsContent(currentContent, p, css.get("xfa-tab-stops"));
                l.add((Element)p);
            } else {
                for (Element e : this.currentContentToParagraph(currentContent, true, true, tag, ctx)) {
                    l.add(e);
                }
            }
        }
        return l;
    }

    private void addTabIntervalContent(List<Element> currentContent, Paragraph p, String value) {
        float width = 0.0f;
        for (Element e : currentContent) {
            if (e instanceof TabbedChunk) {
                TabbedChunk tab = new TabbedChunk(new VerticalPositionMark(), width += (float)((TabbedChunk)e).getTabCount() * CssUtils.getInstance().parsePxInCmMmPcToPt(value), false);
                p.add((Element)new Chunk((Chunk)tab));
                p.add((Element)new Chunk((Chunk)((TabbedChunk)e)));
                continue;
            }
            p.add(e);
        }
    }

    private void addTabStopsContent(List<Element> currentContent, Paragraph p, String value) {
        ArrayList<TabbedChunk> tabs = new ArrayList<TabbedChunk>();
        String[] alignAndWidth = value.split(" ");
        float tabWidth = 0.0f;
        int i = 0;
        for (int j = 1; j < alignAndWidth.length; j += 2) {
            TabbedChunk tab = new TabbedChunk(new VerticalPositionMark(), tabWidth += CssUtils.getInstance().parsePxInCmMmPcToPt(alignAndWidth[j]), true, alignAndWidth[i]);
            tabs.add(tab);
            i += 2;
        }
        int tabsPerRow = tabs.size();
        int currentTab = 0;
        for (Element e : currentContent) {
            if (!(e instanceof TabbedChunk)) continue;
            if (currentTab == tabsPerRow) {
                currentTab = 0;
            }
            if (((TabbedChunk)e).getTabCount() == 0) continue;
            p.add((Element)new Chunk((Chunk)tabs.get(currentTab)));
            p.add((Element)new Chunk((Chunk)((TabbedChunk)e)));
            ++currentTab;
        }
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }
}

