/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static final String RUN_AWT_INVOKE_LATER_KEY = "org.eclipse.swt.internal.runAWTInvokeLater";
    static final String JDK17_FRAME = "sun.lwawt.macosx.CViewEmbeddedFrame";
    static boolean loaded;
    static boolean swingInitialized;

    static final native long getAWTHandle(Canvas var0);

    static final native Object initFrame(long var0, String var2);

    static final native void validateWithBounds(Frame var0, int var1, int var2, int var3, int var4);

    static final native void synthesizeWindowActivation(Frame var0, boolean var1);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        Toolkit.getDefaultToolkit();
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        try {
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", new Class[0]);
            if (method != null) {
                method.invoke(clazz, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Frame getFrame(Composite composite) {
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)composite.getData(EMBEDDED_FRAME_KEY);
    }

    public static Frame new_Frame(final Composite composite) {
        Object object;
        Object object2;
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        final long l = composite.view.id;
        final String string = embeddedFrameClass != null ? embeddedFrameClass : JDK17_FRAME;
        try {
            if (embeddedFrameClass != null) {
                Class.forName(string);
            }
            SWT_AWT.loadLibrary();
        }
        catch (ClassNotFoundException classNotFoundException) {
            SWT.error(20, classNotFoundException);
        }
        catch (Throwable throwable) {
            SWT.error(1, throwable, " [Error while starting AWT]");
        }
        SWT_AWT.initializeSwing();
        final Frame[] frameArray = new Frame[1];
        final Throwable[] throwableArray = new Throwable[1];
        Runnable runnable = new Runnable(){
            boolean run;

            @Override
            public void run() {
                if (this.run) {
                    return;
                }
                this.run = true;
                Object object = SWT_AWT.initFrame(l, string);
                if (object == null || !(object instanceof Frame)) {
                    throwableArray[0] = new Throwable("[Error while creating AWT embedded frame]");
                    SWT.error(1, throwableArray[0]);
                    return;
                }
                frameArray[0] = (Frame)object;
                frameArray[0].addNotify();
            }
        };
        if (EventQueue.isDispatchThread() || composite.getDisplay().getSyncThread() != null) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
            object2 = composite.getDisplay();
            while (frameArray[0] == null && throwableArray[0] == null) {
                ((Display)object2).setData(RUN_AWT_INVOKE_LATER_KEY, new Boolean(true));
                object = (Boolean)((Display)object2).getData(RUN_AWT_INVOKE_LATER_KEY);
                if (object == null || ((Boolean)object).booleanValue()) continue;
                runnable.run();
            }
        }
        if (throwableArray[0] != null) {
            SWT.error(20, throwableArray[0]);
        }
        object2 = frameArray[0];
        composite.setData(EMBEDDED_FRAME_KEY, object2);
        object = arg_0 -> SWT_AWT.lambda$new_Frame$2((Frame)object2, arg_0);
        Shell shell = composite.getShell();
        shell.addListener(20, (Listener)object);
        shell.addListener(19, (Listener)object);
        Display display = composite.getDisplay();
        display.addListener(12, new Listener((Frame)object2, display){
            final /* synthetic */ Frame val$frame;
            final /* synthetic */ Display val$display;
            {
                this.val$frame = frame;
                this.val$display = display;
            }

            @Override
            public void handleEvent(Event event) {
                while (this.val$frame.isDisplayable() && !this.val$display.isDisposed()) {
                    if (this.val$display.readAndDispatch()) continue;
                    this.val$display.sleep();
                }
                if (!this.val$display.isDisposed()) {
                    this.val$display.removeListener(12, this);
                }
            }
        });
        Listener listener = new Listener((Listener)object, (Frame)object2){
            final /* synthetic */ Listener val$shellListener;
            final /* synthetic */ Frame val$frame;
            {
                this.val$shellListener = listener;
                this.val$frame = frame;
            }

            @Override
            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        Shell shell = composite.getShell();
                        shell.removeListener(20, this.val$shellListener);
                        shell.removeListener(19, this.val$shellListener);
                        shell.removeListener(26, this);
                        shell.removeListener(27, this);
                        composite.setVisible(false);
                        EventQueue.invokeLater(() -> {
                            try {
                                this.val$frame.dispose();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        });
                        break;
                    }
                    case 26: {
                        if (!composite.isFocusControl()) {
                            return;
                        }
                    }
                    case 15: {
                        EventQueue.invokeLater(() -> {
                            if (this.val$frame.isActive()) {
                                return;
                            }
                            try {
                                SWT_AWT.synthesizeWindowActivation(this.val$frame, Boolean.TRUE);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        });
                        break;
                    }
                    case 16: 
                    case 27: {
                        EventQueue.invokeLater(() -> {
                            if (!this.val$frame.isActive()) {
                                return;
                            }
                            try {
                                SWT_AWT.synthesizeWindowActivation(this.val$frame, Boolean.FALSE);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        });
                    }
                }
            }
        };
        composite.addListener(15, listener);
        composite.addListener(16, listener);
        shell.addListener(26, listener);
        shell.addListener(27, listener);
        composite.addListener(12, listener);
        display.asyncExec(() -> SWT_AWT.lambda$new_Frame$3(composite, (Frame)object2));
        return object2;
    }

    public static Shell new_Shell(final Display display, final Canvas canvas) {
        if (display == null) {
            SWT.error(4);
        }
        if (canvas == null) {
            SWT.error(4);
        }
        long l = 0L;
        try {
            SWT_AWT.loadLibrary();
            l = SWT_AWT.getAWTHandle(canvas);
        }
        catch (Throwable throwable) {
            SWT.error(20, throwable);
        }
        if (l == 0L) {
            SWT.error(5, null, " [peer not created]");
        }
        final Shell shell = Shell.cocoa_new(display, l);
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                display.asyncExec(() -> {
                    if (shell.isDisposed()) {
                        return;
                    }
                    Dimension dimension = canvas.getSize();
                    shell.setSize(dimension.width, dimension.height);
                });
            }
        };
        canvas.addComponentListener(componentAdapter);
        shell.addListener(12, event -> canvas.removeComponentListener(componentAdapter));
        shell.setVisible(true);
        return shell;
    }

    private static /* synthetic */ void lambda$new_Frame$3(Composite composite, Frame frame) {
        if (composite.isDisposed()) {
            return;
        }
        Rectangle rectangle = composite.getClientArea();
        try {
            SWT_AWT.validateWithBounds(frame, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static /* synthetic */ void lambda$new_Frame$2(Frame frame, Event event) {
        switch (event.type) {
            case 20: {
                EventQueue.invokeLater(() -> frame.dispatchEvent(new WindowEvent(frame, 204)));
                break;
            }
            case 19: {
                EventQueue.invokeLater(() -> frame.dispatchEvent(new WindowEvent(frame, 203)));
            }
        }
    }

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
    }
}

