/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.DOMDocument;
import org.eclipse.swt.internal.cocoa.DOMKeyboardEvent;
import org.eclipse.swt.internal.cocoa.DOMMouseEvent;
import org.eclipse.swt.internal.cocoa.DOMWheelEvent;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSError;
import org.eclipse.swt.internal.cocoa.NSHTTPCookie;
import org.eclipse.swt.internal.cocoa.NSHTTPCookieStorage;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableURLRequest;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPrintInfo;
import org.eclipse.swt.internal.cocoa.NSPrintOperation;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.NSURLAuthenticationChallenge;
import org.eclipse.swt.internal.cocoa.NSURLCredential;
import org.eclipse.swt.internal.cocoa.NSURLDownload;
import org.eclipse.swt.internal.cocoa.NSURLProtectionSpace;
import org.eclipse.swt.internal.cocoa.NSURLRequest;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SFCertificateTrustPanel;
import org.eclipse.swt.internal.cocoa.SWTWebViewDelegate;
import org.eclipse.swt.internal.cocoa.WebDataSource;
import org.eclipse.swt.internal.cocoa.WebDocumentRepresentation;
import org.eclipse.swt.internal.cocoa.WebFrame;
import org.eclipse.swt.internal.cocoa.WebFrameView;
import org.eclipse.swt.internal.cocoa.WebOpenPanelResultListener;
import org.eclipse.swt.internal.cocoa.WebPolicyDecisionListener;
import org.eclipse.swt.internal.cocoa.WebPreferences;
import org.eclipse.swt.internal.cocoa.WebScriptObject;
import org.eclipse.swt.internal.cocoa.WebView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class WebKit
extends WebBrowser {
    WebView webView;
    WebPreferences preferences;
    SWTWebViewDelegate delegate;
    boolean loadingText;
    boolean untrustedText;
    String lastHoveredLinkURL;
    String lastNavigateURL;
    String html;
    long identifier;
    int resourceCount;
    String url = "";
    Point location;
    Point size;
    boolean statusBar = true;
    boolean toolBar = true;
    boolean ignoreDispose;
    int lastMouseMoveX;
    int lastMouseMoveY;
    static long delegateClass;
    static boolean Initialized;
    static Callback Callback3;
    static Callback Callback4;
    static Callback Callback5;
    static Callback Callback6;
    static Callback Callback7;
    static final int MIN_SIZE = 16;
    static final int MAX_PROGRESS = 100;
    static final String WebElementLinkURLKey = "WebElementLinkURL";
    static final String AGENT_STRING = "Safari/522.0";
    static final String URI_FILEROOT = "file:///";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String ABOUT_BLANK = "about:blank";
    static final String HEADER_SETCOOKIE = "Set-Cookie";
    static final String POST = "POST";
    static final String USER_AGENT = "user-agent";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final String WEBKIT_EVENTS_FIX_KEY = "org.eclipse.swt.internal.webKitEventsFix";
    static final byte[] SWT_OBJECT;
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";

    WebKit() {
    }

    @Override
    public void create(Composite composite, int n) {
        Class<?> clazz;
        if (delegateClass == 0L) {
            long l;
            long l2;
            long l3;
            long l4;
            long l5;
            clazz = this.getClass();
            Callback3 = new Callback(clazz, "browserProc", 3);
            long l6 = Callback3.getAddress();
            if (l6 == 0L) {
                SWT.error(3);
            }
            if ((l5 = (Callback4 = new Callback(clazz, "browserProc", 4)).getAddress()) == 0L) {
                SWT.error(3);
            }
            if ((l4 = (Callback5 = new Callback(clazz, "browserProc", 5)).getAddress()) == 0L) {
                SWT.error(3);
            }
            if ((l3 = (Callback6 = new Callback(clazz, "browserProc", 6)).getAddress()) == 0L) {
                SWT.error(3);
            }
            if ((l2 = (Callback7 = new Callback(clazz, "browserProc", 7)).getAddress()) == 0L) {
                SWT.error(3);
            }
            if ((l = OS.CALLBACK_webView_setFrame_(l5)) == 0L) {
                SWT.error(3);
            }
            String string = "SWTWebViewDelegate";
            byte[] byArray = new byte[]{42, 0};
            int n2 = C.PTR_SIZEOF;
            int n3 = C.PTR_SIZEOF == 4 ? 2 : 3;
            delegateClass = OS.objc_allocateClassPair(OS.class_NSObject, string, 0L);
            OS.class_addIvar(delegateClass, SWT_OBJECT, n2, (byte)n3, byArray);
            OS.class_addMethod(delegateClass, OS.sel_webView_didChangeLocationWithinPageForFrame_, l5, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_didFailProvisionalLoadWithError_forFrame_, l4, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_didFinishLoadForFrame_, l5, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_didReceiveTitle_forFrame_, l4, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_didStartProvisionalLoadForFrame_, l5, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_didCommitLoadForFrame_, l5, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_resource_didFinishLoadingFromDataSource_, l4, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_resource_didReceiveAuthenticationChallenge_fromDataSource_, l3, "@:@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_resource_didFailLoadingWithError_fromDataSource_, l3, "@:@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_identifierForInitialRequest_fromDataSource_, l4, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_resource_willSendRequest_redirectResponse_fromDataSource_, l2, "@:@@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_createWebViewWithRequest_, l5, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webViewShow_, l6, "@:@");
            OS.class_addMethod(delegateClass, OS.sel_webViewClose_, l6, "@:@");
            OS.class_addMethod(delegateClass, OS.sel_webView_contextMenuItemsForElement_defaultMenuItems_, l4, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_setStatusBarVisible_, l5, "@:@B");
            OS.class_addMethod(delegateClass, OS.sel_webView_setResizable_, l5, "@:@B");
            OS.class_addMethod(delegateClass, OS.sel_webView_setToolbarsVisible_, l5, "@:@B");
            OS.class_addMethod(delegateClass, OS.sel_webView_setStatusText_, l5, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webViewFocus_, l6, "@:@");
            OS.class_addMethod(delegateClass, OS.sel_webViewUnfocus_, l6, "@:@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame_, l4, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runJavaScriptAlertPanelWithMessage_, l5, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runJavaScriptAlertPanelWithMessage_initiatedByFrame_, l4, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runJavaScriptConfirmPanelWithMessage_, l5, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runJavaScriptConfirmPanelWithMessage_initiatedByFrame_, l4, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runOpenPanelForFileButtonWithResultListener_, l5, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_mouseDidMoveOverElement_modifierFlags_, l4, "@:@@I");
            OS.class_addMethod(delegateClass, OS.sel_webView_printFrameView_, l5, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_decidePolicyForMIMEType_request_frame_decisionListener_, l2, "@:@@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_decidePolicyForNavigationAction_request_frame_decisionListener_, l2, "@:@@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_decidePolicyForNewWindowAction_request_newFrameName_decisionListener_, l2, "@:@@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_unableToImplementPolicyWithError_frame_, l4, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_download_decideDestinationWithSuggestedFilename_, l5, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_handleEvent_, l6, "@:@");
            OS.class_addMethod(delegateClass, OS.sel_webView_setFrame_, l, "@:@{NSRect}");
            OS.class_addMethod(delegateClass, OS.sel_webView_windowScriptObjectAvailable_, l5, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_callJava, l3, "@:@@@@");
            OS.class_addMethod(delegateClass, OS.sel_callRunBeforeUnloadConfirmPanelWithMessage, l5, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_createPanelDidEnd, l4, "@:@@@");
            OS.objc_registerClassPair(delegateClass);
            long l7 = OS.objc_getMetaClass(string);
            OS.class_addMethod(l7, OS.sel_isSelectorExcludedFromWebScript_, l6, "@:@");
            OS.class_addMethod(l7, OS.sel_webScriptNameForSelector_, l6, "@:@");
        }
        this.browser.setData(WEBKIT_EVENTS_FIX_KEY);
        clazz = (WebView)new WebView().alloc();
        if (clazz == null) {
            SWT.error(2);
        }
        ((WebView)((Object)clazz)).initWithFrame(this.browser.view.frame(), null, null);
        ((NSView)((Object)clazz)).setAutoresizingMask(18L);
        if (((NSObject)((Object)clazz)).respondsToSelector(OS.sel__setDashboardBehavior)) {
            OS.objc_msgSend(((WebView)((Object)clazz)).id, OS.sel__setDashboardBehavior, 2L, 1L);
        }
        SWTWebViewDelegate sWTWebViewDelegate = (SWTWebViewDelegate)new SWTWebViewDelegate().alloc().init();
        Display display = this.browser.getDisplay();
        display.setData(ADD_WIDGET_KEY, new Object[]{sWTWebViewDelegate, this.browser});
        this.delegate = sWTWebViewDelegate;
        this.webView = clazz;
        this.browser.view.addSubview((NSView)((Object)clazz));
        Listener listener = event -> {
            switch (event.type) {
                case 15: {
                    this.webView.window().makeFirstResponder(this.webView);
                    break;
                }
                case 12: {
                    if (this.ignoreDispose) {
                        this.ignoreDispose = false;
                        break;
                    }
                    this.ignoreDispose = true;
                    this.browser.notifyListeners(event.type, event);
                    event.type = 0;
                    if (!this.browser.isDisposed()) {
                        if (!this.browser.isClosing) {
                            this.close(false);
                        }
                        event.display.setData(ADD_WIDGET_KEY, new Object[]{sWTWebViewDelegate, null});
                    }
                    this.webView.setFrameLoadDelegate(null);
                    this.webView.setResourceLoadDelegate(null);
                    this.webView.setUIDelegate(null);
                    this.webView.setPolicyDelegate(null);
                    this.webView.setDownloadDelegate(null);
                    this.webView.release();
                    this.webView = null;
                    this.delegate.release();
                    this.delegate = null;
                    this.html = null;
                    this.lastNavigateURL = null;
                    this.lastHoveredLinkURL = null;
                    Iterator iterator = this.functions.values().iterator();
                    while (iterator.hasNext()) {
                        ((BrowserFunction)iterator.next()).dispose(false);
                    }
                    this.functions = null;
                    if (this.preferences != null) {
                        this.preferences.release();
                    }
                    this.preferences = null;
                    break;
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(1, listener);
        this.browser.addListener(15, listener);
        ((WebView)((Object)clazz)).setFrameLoadDelegate(sWTWebViewDelegate);
        ((WebView)((Object)clazz)).setResourceLoadDelegate(sWTWebViewDelegate);
        ((WebView)((Object)clazz)).setUIDelegate(sWTWebViewDelegate);
        ((WebView)((Object)clazz)).setPolicyDelegate(sWTWebViewDelegate);
        ((WebView)((Object)clazz)).setDownloadDelegate(sWTWebViewDelegate);
        ((WebView)((Object)clazz)).setApplicationNameForUserAgent(NSString.stringWith(AGENT_STRING));
        if (!Initialized) {
            Initialized = true;
            WebPreferences.standardPreferences().setJavaEnabled(false);
        }
    }

    @Override
    public boolean back() {
        this.html = null;
        return this.webView.goBack();
    }

    static long browserProc(long l, long l2, long l3) {
        Display display;
        if (l == delegateClass) {
            if (l2 == OS.sel_isSelectorExcludedFromWebScript_) {
                return WebKit.isSelectorExcludedFromWebScript(l3) ? 1L : 0L;
            }
            if (l2 == OS.sel_webScriptNameForSelector_) {
                return WebKit.webScriptNameForSelector(l3);
            }
        }
        if ((display = Display.getCurrent()) == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(l);
        if (widget == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)((Browser)widget).webBrowser;
        if (l2 == OS.sel_webViewShow_) {
            webKit.webViewShow(l3);
        } else if (l2 == OS.sel_webViewClose_) {
            webKit.webViewClose(l3);
        } else if (l2 == OS.sel_webViewFocus_) {
            webKit.webViewFocus(l3);
        } else if (l2 == OS.sel_webViewUnfocus_) {
            webKit.webViewUnfocus(l3);
        } else if (l2 == OS.sel_handleEvent_) {
            webKit.handleEvent(l3);
        }
        return 0L;
    }

    static long browserProc(long l, long l2, long l3, long l4) {
        Display display = Display.getCurrent();
        if (display == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(l);
        if (widget == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)((Browser)widget).webBrowser;
        if (l2 == OS.sel_webView_didChangeLocationWithinPageForFrame_) {
            webKit.webView_didChangeLocationWithinPageForFrame(l3, l4);
        } else if (l2 == OS.sel_webView_didFinishLoadForFrame_) {
            webKit.webView_didFinishLoadForFrame(l3, l4);
        } else if (l2 == OS.sel_webView_didStartProvisionalLoadForFrame_) {
            webKit.webView_didStartProvisionalLoadForFrame(l3, l4);
        } else if (l2 == OS.sel_webView_didCommitLoadForFrame_) {
            webKit.webView_didCommitLoadForFrame(l3, l4);
        } else if (l2 == OS.sel_webView_setFrame_) {
            webKit.webView_setFrame(l3, l4);
        } else {
            if (l2 == OS.sel_webView_createWebViewWithRequest_) {
                return webKit.webView_createWebViewWithRequest(l3, l4);
            }
            if (l2 == OS.sel_webView_setStatusBarVisible_) {
                webKit.webView_setStatusBarVisible(l3, l4 != 0L);
            } else if (l2 == OS.sel_webView_setResizable_) {
                webKit.webView_setResizable(l3, l4 != 0L);
            } else if (l2 == OS.sel_webView_setStatusText_) {
                webKit.webView_setStatusText(l3, l4);
            } else if (l2 == OS.sel_webView_setToolbarsVisible_) {
                webKit.webView_setToolbarsVisible(l3, l4 != 0L);
            } else if (l2 == OS.sel_webView_runJavaScriptAlertPanelWithMessage_) {
                webKit.webView_runJavaScriptAlertPanelWithMessage(l3, l4);
            } else {
                if (l2 == OS.sel_webView_runJavaScriptConfirmPanelWithMessage_) {
                    return webKit.webView_runJavaScriptConfirmPanelWithMessage(l3, l4);
                }
                if (l2 == OS.sel_webView_runOpenPanelForFileButtonWithResultListener_) {
                    webKit.webView_runOpenPanelForFileButtonWithResultListener(l3, l4);
                } else if (l2 == OS.sel_download_decideDestinationWithSuggestedFilename_) {
                    webKit.download_decideDestinationWithSuggestedFilename(l3, l4);
                } else if (l2 == OS.sel_webView_printFrameView_) {
                    webKit.webView_printFrameView(l3, l4);
                } else if (l2 == OS.sel_webView_windowScriptObjectAvailable_) {
                    webKit.webView_windowScriptObjectAvailable(l3, l4);
                } else if (l2 == OS.sel_callRunBeforeUnloadConfirmPanelWithMessage) {
                    return webKit.callRunBeforeUnloadConfirmPanelWithMessage((long)l3, (long)l4).id;
                }
            }
        }
        return 0L;
    }

    static long browserProc(long l, long l2, long l3, long l4, long l5) {
        Display display = Display.getCurrent();
        if (display == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(l);
        if (widget == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)((Browser)widget).webBrowser;
        if (l2 == OS.sel_webView_didFailProvisionalLoadWithError_forFrame_) {
            webKit.webView_didFailProvisionalLoadWithError_forFrame(l3, l4, l5);
        } else if (l2 == OS.sel_webView_didReceiveTitle_forFrame_) {
            webKit.webView_didReceiveTitle_forFrame(l3, l4, l5);
        } else if (l2 == OS.sel_webView_resource_didFinishLoadingFromDataSource_) {
            webKit.webView_resource_didFinishLoadingFromDataSource(l3, l4, l5);
        } else {
            if (l2 == OS.sel_webView_identifierForInitialRequest_fromDataSource_) {
                return webKit.webView_identifierForInitialRequest_fromDataSource(l3, l4, l5);
            }
            if (l2 == OS.sel_webView_contextMenuItemsForElement_defaultMenuItems_) {
                return webKit.webView_contextMenuItemsForElement_defaultMenuItems(l3, l4, l5);
            }
            if (l2 == OS.sel_webView_mouseDidMoveOverElement_modifierFlags_) {
                webKit.webView_mouseDidMoveOverElement_modifierFlags(l3, l4, l5);
            } else if (l2 == OS.sel_webView_unableToImplementPolicyWithError_frame_) {
                webKit.webView_unableToImplementPolicyWithError_frame(l3, l4, l5);
            } else {
                if (l2 == OS.sel_webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame_) {
                    return webKit.webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame(l3, l4, l5) ? 1L : 0L;
                }
                if (l2 == OS.sel_webView_runJavaScriptAlertPanelWithMessage_initiatedByFrame_) {
                    webKit.webView_runJavaScriptAlertPanelWithMessage(l3, l4);
                } else {
                    if (l2 == OS.sel_webView_runJavaScriptConfirmPanelWithMessage_initiatedByFrame_) {
                        return webKit.webView_runJavaScriptConfirmPanelWithMessage(l3, l4);
                    }
                    if (l2 == OS.sel_createPanelDidEnd) {
                        webKit.createPanelDidEnd(l3, l4, l5);
                    }
                }
            }
        }
        return 0L;
    }

    static long browserProc(long l, long l2, long l3, long l4, long l5, long l6) {
        Display display = Display.getCurrent();
        if (display == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(l);
        if (widget == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)((Browser)widget).webBrowser;
        if (l2 == OS.sel_webView_resource_didFailLoadingWithError_fromDataSource_) {
            webKit.webView_resource_didFailLoadingWithError_fromDataSource(l3, l4, l5, l6);
        } else if (l2 == OS.sel_webView_resource_didReceiveAuthenticationChallenge_fromDataSource_) {
            webKit.webView_resource_didReceiveAuthenticationChallenge_fromDataSource(l3, l4, l5, l6);
        } else if (l2 == OS.sel_callJava) {
            NSObject nSObject = webKit.callJava(l3, l4, l5, l6);
            return nSObject == null ? 0L : nSObject.id;
        }
        return 0L;
    }

    static long browserProc(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        Display display = Display.getCurrent();
        if (display == null || display.isDisposed()) {
            return 0L;
        }
        Widget widget = display.findWidget(l);
        if (widget == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)((Browser)widget).webBrowser;
        if (l2 == OS.sel_webView_resource_willSendRequest_redirectResponse_fromDataSource_) {
            return webKit.webView_resource_willSendRequest_redirectResponse_fromDataSource(l3, l4, l5, l6, l7);
        }
        if (l2 == OS.sel_webView_decidePolicyForMIMEType_request_frame_decisionListener_) {
            webKit.webView_decidePolicyForMIMEType_request_frame_decisionListener(l3, l4, l5, l6, l7);
        } else if (l2 == OS.sel_webView_decidePolicyForNavigationAction_request_frame_decisionListener_) {
            webKit.webView_decidePolicyForNavigationAction_request_frame_decisionListener(l3, l4, l5, l6, l7);
        } else if (l2 == OS.sel_webView_decidePolicyForNewWindowAction_request_newFrameName_decisionListener_) {
            webKit.webView_decidePolicyForNewWindowAction_request_newFrameName_decisionListener(l3, l4, l5, l6, l7);
        }
        return 0L;
    }

    static boolean isSelectorExcludedFromWebScript(long l) {
        return l != OS.sel_callJava && l != OS.sel_callRunBeforeUnloadConfirmPanelWithMessage;
    }

    static long webScriptNameForSelector(long l) {
        if (l == OS.sel_callJava) {
            return NSString.stringWith((String)"callJava").id;
        }
        if (l == OS.sel_callRunBeforeUnloadConfirmPanelWithMessage) {
            return NSString.stringWith((String)"callRunBeforeUnloadConfirmPanelWithMessage").id;
        }
        return 0L;
    }

    @Override
    public boolean close() {
        return this.close(true);
    }

    boolean close(boolean bl) {
        if (!this.jsEnabled) {
            return true;
        }
        String string = "SWTExecuteTemporaryFunctionCLOSE";
        StringBuffer stringBuffer = new StringBuffer("function ");
        stringBuffer.append(string);
        stringBuffer.append("(win) {\n");
        stringBuffer.append("var fn = win.onbeforeunload; if (fn != null) {try {var str = fn(); ");
        if (bl) {
            stringBuffer.append("if (str != null) { ");
            stringBuffer.append("var result = window.external.callRunBeforeUnloadConfirmPanelWithMessage(str);");
            stringBuffer.append("if (!result) return false;}");
        }
        stringBuffer.append("} catch (e) {}}");
        stringBuffer.append("try {for (var i = 0; i < win.frames.length; i++) {var result = ");
        stringBuffer.append(string);
        stringBuffer.append("(win.frames[i]); if (!result) return false;}} catch (e) {} return true;");
        stringBuffer.append("\n};");
        this.execute(stringBuffer.toString());
        Boolean bl2 = (Boolean)this.evaluate("return " + string + "(window);");
        if (bl2 == null) {
            return false;
        }
        return bl2;
    }

    @Override
    public boolean execute(String string) {
        WebFrame webFrame = this.webView.mainFrame();
        long l = webFrame.globalContext();
        byte[] byArray = (string + '\u0000').getBytes(StandardCharsets.UTF_8);
        long l2 = OS.JSStringCreateWithUTF8CString(byArray);
        byArray = (this.getUrl() + '\u0000').getBytes(StandardCharsets.UTF_8);
        long l3 = OS.JSStringCreateWithUTF8CString(byArray);
        long l4 = OS.JSEvaluateScript(l, l2, 0L, l3, 0, null);
        OS.JSStringRelease(l3);
        OS.JSStringRelease(l2);
        return l4 != 0L;
    }

    @Override
    public boolean forward() {
        this.html = null;
        return this.webView.goForward();
    }

    @Override
    public String getBrowserType() {
        return "webkit";
    }

    @Override
    public String getText() {
        WebFrame webFrame = this.webView.mainFrame();
        WebDataSource webDataSource = webFrame.dataSource();
        if (webDataSource == null) {
            return "";
        }
        WebDocumentRepresentation webDocumentRepresentation = webDataSource.representation();
        if (webDocumentRepresentation == null) {
            return "";
        }
        NSString nSString = webDocumentRepresentation.documentSource();
        if (nSString == null) {
            return "";
        }
        return nSString.getString();
    }

    @Override
    public String getUrl() {
        if (this.url.length() == 0) {
            return ABOUT_BLANK;
        }
        return this.url;
    }

    @Override
    public boolean isBackEnabled() {
        return this.webView.canGoBack();
    }

    @Override
    public boolean isForwardEnabled() {
        return this.webView.canGoForward();
    }

    @Override
    public void refresh() {
        this.html = null;
        this.webView.reload(null);
    }

    @Override
    public boolean setText(String string, boolean bl) {
        boolean bl2 = this.html != null;
        this.html = string;
        boolean bl3 = this.untrustedText = !bl;
        if (bl2) {
            return true;
        }
        NSURL nSURL = NSURL.URLWithString(NSString.stringWith(ABOUT_BLANK));
        NSURLRequest nSURLRequest = NSURLRequest.requestWithURL(nSURL);
        WebFrame webFrame = this.webView.mainFrame();
        webFrame.loadRequest(nSURLRequest);
        return true;
    }

    @Override
    public boolean setUrl(String string, String string2, String[] stringArray) {
        Object object;
        Object object2;
        this.html = null;
        this.lastNavigateURL = string;
        if (string.indexOf(47) == 0) {
            string = PROTOCOL_FILE + string;
        } else if (string.indexOf(58) == -1) {
            string = PROTOCOL_HTTP + string;
        }
        NSString nSString = NSString.stringWith(string);
        NSString nSString2 = NSString.stringWith("%#");
        long l = OS.CFURLCreateStringByAddingPercentEscapes(0L, nSString.id, nSString2.id, 0L, 0x8000100);
        NSString nSString3 = new NSString(l);
        NSURL nSURL = NSURL.URLWithString(nSString3);
        OS.CFRelease(l);
        NSMutableURLRequest nSMutableURLRequest = (NSMutableURLRequest)NSMutableURLRequest.requestWithURL(nSURL);
        if (string2 != null) {
            nSMutableURLRequest.setHTTPMethod(NSString.stringWith(POST));
            object2 = string2.getBytes();
            object = NSData.dataWithBytes((byte[])object2, ((Object)object2).length);
            nSMutableURLRequest.setHTTPBody((NSData)object);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                object = stringArray[i];
                if (object == null || (n = ((String)object).indexOf(58)) == -1) continue;
                String string3 = ((String)object).substring(0, n).trim();
                String string4 = ((String)object).substring(n + 1).trim();
                if (string3.length() <= 0 || string4.length() <= 0) continue;
                if (string3.equalsIgnoreCase(USER_AGENT)) {
                    this.webView.setCustomUserAgent(NSString.stringWith(string4));
                    continue;
                }
                nSMutableURLRequest.setValue(NSString.stringWith(string4), NSString.stringWith(string3));
            }
        }
        object2 = this.webView.mainFrame();
        ((WebFrame)object2).loadRequest(nSMutableURLRequest);
        this.webView.setCustomUserAgent(null);
        return true;
    }

    @Override
    public void stop() {
        this.html = null;
        this.webView.stopLoading(null);
    }

    @Override
    boolean translateMnemonics() {
        return false;
    }

    void webView_didChangeLocationWithinPageForFrame(long l, long l2) {
        int n;
        TypedEvent typedEvent;
        boolean bl;
        WebFrame webFrame = new WebFrame(l2);
        WebDataSource webDataSource = webFrame.dataSource();
        NSMutableURLRequest nSMutableURLRequest = webDataSource.request();
        NSURL nSURL = nSMutableURLRequest.URL();
        NSString nSString = nSURL.absoluteString();
        int n2 = (int)nSString.length();
        if (n2 == 0) {
            return;
        }
        String string = nSString.getString();
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n2 = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n2) == '#') {
                string = ABOUT_BLANK + string.substring(n2);
            }
        }
        Display display = this.browser.getDisplay();
        boolean bl2 = bl = l2 == this.webView.mainFrame().id;
        if (bl) {
            typedEvent = new StatusTextEvent(this.browser);
            typedEvent.display = display;
            typedEvent.widget = this.browser;
            typedEvent.text = string;
            for (n = 0; n < this.statusTextListeners.length; ++n) {
                this.statusTextListeners[n].changed((StatusTextEvent)typedEvent);
            }
        }
        typedEvent = new LocationEvent(this.browser);
        ((LocationEvent)typedEvent).display = display;
        ((LocationEvent)typedEvent).widget = this.browser;
        ((LocationEvent)typedEvent).location = string;
        ((LocationEvent)typedEvent).top = bl;
        for (n = 0; n < this.locationListeners.length; ++n) {
            this.locationListeners[n].changed((LocationEvent)typedEvent);
        }
    }

    void webView_didFailProvisionalLoadWithError_forFrame(long l, long l2, long l3) {
        Object object;
        Object object2;
        Object object3;
        id id2;
        NSError nSError;
        long l4;
        if (l3 == this.webView.mainFrame().id) {
            this.identifier = 0L;
        }
        if (-1000L < (l4 = (nSError = new NSError(l2)).code())) {
            return;
        }
        NSURL nSURL = null;
        NSDictionary nSDictionary = nSError.userInfo();
        if (nSDictionary != null && (id2 = nSDictionary.valueForKey(NSString.stringWith("NSErrorFailingURLKey"))) != null) {
            nSURL = new NSURL(id2);
        }
        if (nSURL != null && -1204L <= l4 && l4 <= -1200L) {
            id2 = nSDictionary.objectForKey(NSString.stringWith("NSErrorPeerCertificateChainKey"));
            object3 = new long[1];
            object2 = new long[1];
            object = new long[1];
            boolean bl = false;
            int n = OS.SecPolicySearchCreate(3L, 0L, 0L, (long[])object3);
            if (n == 0 && object3[0] != 0L && (n = OS.SecPolicySearchCopyNext((long)object3[0], (long[])object2)) == 0 && object2[0] != 0L && (n = OS.SecTrustCreateWithCertificates(id2.id, (long)object2[0], (long[])object)) == 0 && object[0] != 0L) {
                SFCertificateTrustPanel sFCertificateTrustPanel = SFCertificateTrustPanel.sharedCertificateTrustPanel();
                String string = nSURL.absoluteString().getString();
                String string2 = Compatibility.getMessage("SWT_InvalidCert_Message", new Object[]{string});
                sFCertificateTrustPanel.setAlternateButtonTitle(NSString.stringWith(Compatibility.getMessage("SWT_Cancel")));
                sFCertificateTrustPanel.setShowsHelp(true);
                nSURL.retain();
                NSWindow nSWindow = this.browser.getShell().view.window();
                sFCertificateTrustPanel.beginSheetForWindow(nSWindow, this.delegate, OS.sel_createPanelDidEnd, nSURL.id, (long)object[0], NSString.stringWith(string2));
                bl = true;
            }
            if (object[0] != 0L) {
                OS.CFRelease((long)object[0]);
            }
            if (object2[0] != 0L) {
                OS.CFRelease((long)object2[0]);
            }
            if (object3[0] != 0L) {
                OS.CFRelease((long)object3[0]);
            }
            if (bl) {
                return;
            }
        }
        if ((id2 = nSError.localizedDescription()) != null) {
            object3 = ((NSString)id2).getString();
            object2 = nSURL != null ? nSURL.absoluteString().getString() + "\n\n" : "";
            object2 = (String)object2 + Compatibility.getMessage("SWT_Page_Load_Failed", new Object[]{object3});
            object = new MessageBox(this.browser.getShell(), 33);
            ((MessageBox)object).setMessage((String)object2);
            ((MessageBox)object).open();
        }
    }

    void createPanelDidEnd(long l, long l2, long l3) {
        NSURL nSURL = new NSURL(l3);
        nSURL.autorelease();
        if (l2 != 1L) {
            return;
        }
        long l4 = OS.class_getClassMethod(OS.class_NSURLRequest, OS.sel_setAllowsAnyHTTPSCertificate);
        if (l4 != 0L) {
            OS.objc_msgSend(OS.class_NSURLRequest, OS.sel_setAllowsAnyHTTPSCertificate, 1L, nSURL.host().id);
            this.setUrl(nSURL.absoluteString().getString(), null, null);
        }
    }

    void webView_didFinishLoadForFrame(long l, long l2) {
        if (l2 == this.webView.mainFrame().id) {
            Object object;
            NSObject nSObject;
            NSObject nSObject2;
            Object object2;
            if (this.html != null && this.getUrl().startsWith(ABOUT_BLANK)) {
                this.loadingText = true;
                object2 = NSString.stringWith(this.html);
                nSObject2 = this.untrustedText ? NSString.stringWith(ABOUT_BLANK) : NSString.stringWith(URI_FILEROOT);
                nSObject = NSURL.URLWithString((NSString)nSObject2);
                object = this.webView.mainFrame();
                ((WebFrame)object).loadHTMLString((NSString)object2, (NSURL)nSObject);
                this.html = null;
            }
            if (!this.loadingText) {
                object2 = this.browser.getDisplay();
                nSObject2 = new WebFrame(l2);
                nSObject = nSObject2.dataSource();
                if (nSObject != null && (object = nSObject.pageTitle()) == null) {
                    TitleEvent titleEvent = new TitleEvent(this.browser);
                    titleEvent.display = object2;
                    titleEvent.widget = this.browser;
                    titleEvent.title = this.getUrl();
                    for (int i = 0; i < this.titleListeners.length; ++i) {
                        this.titleListeners[i].changed(titleEvent);
                    }
                    if (this.browser.isDisposed()) {
                        return;
                    }
                }
                object = new ProgressEvent(this.browser);
                ((ProgressEvent)object).display = object2;
                ((ProgressEvent)object).widget = this.browser;
                ((ProgressEvent)object).current = 100;
                ((ProgressEvent)object).total = 100;
                for (int i = 0; i < this.progressListeners.length; ++i) {
                    this.progressListeners[i].completed((ProgressEvent)object);
                }
            }
            this.loadingText = false;
            if (this.browser.isDisposed()) {
                return;
            }
            this.identifier = 0L;
        }
    }

    void hookDOMKeyListeners(long l) {
        WebFrame webFrame = new WebFrame(l);
        DOMDocument dOMDocument = webFrame.DOMDocument();
        if (dOMDocument == null) {
            return;
        }
        NSString nSString = NSString.stringWith(DOMEVENT_KEYDOWN);
        dOMDocument.addEventListener(nSString, this.delegate, false);
        nSString = NSString.stringWith(DOMEVENT_KEYUP);
        dOMDocument.addEventListener(nSString, this.delegate, false);
    }

    void hookDOMMouseListeners(long l) {
        WebFrame webFrame = new WebFrame(l);
        DOMDocument dOMDocument = webFrame.DOMDocument();
        if (dOMDocument == null) {
            return;
        }
        NSString nSString = NSString.stringWith(DOMEVENT_MOUSEDOWN);
        dOMDocument.addEventListener(nSString, this.delegate, false);
        nSString = NSString.stringWith(DOMEVENT_MOUSEUP);
        dOMDocument.addEventListener(nSString, this.delegate, false);
        nSString = NSString.stringWith(DOMEVENT_MOUSEMOVE);
        dOMDocument.addEventListener(nSString, this.delegate, false);
        nSString = NSString.stringWith(DOMEVENT_MOUSEWHEEL);
        dOMDocument.addEventListener(nSString, this.delegate, false);
    }

    void webView_didReceiveTitle_forFrame(long l, long l2, long l3) {
        if (l3 == this.webView.mainFrame().id) {
            NSString nSString = new NSString(l2);
            String string = nSString.getString();
            TitleEvent titleEvent = new TitleEvent(this.browser);
            titleEvent.display = this.browser.getDisplay();
            titleEvent.widget = this.browser;
            titleEvent.title = string;
            for (int i = 0; i < this.titleListeners.length; ++i) {
                this.titleListeners[i].changed(titleEvent);
            }
        }
    }

    void webView_didStartProvisionalLoadForFrame(long l, long l2) {
    }

    void webView_didCommitLoadForFrame(long l, long l2) {
        boolean bl;
        WebFrame webFrame = new WebFrame(l2);
        WebDataSource webDataSource = webFrame.dataSource();
        NSMutableURLRequest nSMutableURLRequest = webDataSource.request();
        NSURL nSURL = nSMutableURLRequest.URL();
        NSString nSString = nSURL.absoluteString();
        int n = (int)nSString.length();
        if (n == 0) {
            return;
        }
        String string = nSString.getString();
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n) == '#') {
                string = ABOUT_BLANK + string.substring(n);
            }
        }
        Display display = this.browser.getDisplay();
        boolean bl2 = bl = l2 == this.webView.mainFrame().id;
        if (bl) {
            Object object2;
            this.resourceCount = 0;
            this.url = string;
            if (string.startsWith(ABOUT_BLANK) && this.html != null) {
                return;
            }
            for (Object object2 : this.functions.values()) {
                this.execute(((BrowserFunction)object2).functionString);
            }
            object2 = new ProgressEvent(this.browser);
            ((ProgressEvent)object2).display = display;
            ((ProgressEvent)object2).widget = this.browser;
            ((ProgressEvent)object2).current = 1;
            ((ProgressEvent)object2).total = 100;
            for (int i = 0; i < this.progressListeners.length; ++i) {
                this.progressListeners[i].changed((ProgressEvent)object2);
            }
            if (this.browser.isDisposed()) {
                return;
            }
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = display;
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = string;
            for (int i = 0; i < this.statusTextListeners.length; ++i) {
                this.statusTextListeners[i].changed(statusTextEvent);
            }
            if (this.browser.isDisposed()) {
                return;
            }
            this.hookDOMKeyListeners(l2);
        }
        this.hookDOMMouseListeners(l2);
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = display;
        locationEvent.widget = this.browser;
        locationEvent.location = string;
        locationEvent.top = bl;
        for (int i = 0; i < this.locationListeners.length; ++i) {
            this.locationListeners[i].changed(locationEvent);
        }
    }

    void webView_windowScriptObjectAvailable(long l, long l2) {
        NSObject nSObject = new NSObject(l2);
        NSString nSString = NSString.stringWith("external");
        nSObject.setValue(this.delegate, nSString);
    }

    void webView_resource_didFinishLoadingFromDataSource(long l, long l2, long l3) {
    }

    void webView_resource_didFailLoadingWithError_fromDataSource(long l, long l2, long l3, long l4) {
    }

    void webView_resource_didReceiveAuthenticationChallenge_fromDataSource(long l, long l2, long l3, long l4) {
        String string;
        NSURLProtectionSpace nSURLProtectionSpace;
        String string2;
        boolean bl;
        long l5;
        long l6;
        long l7;
        NSURLAuthenticationChallenge nSURLAuthenticationChallenge = new NSURLAuthenticationChallenge(l3);
        if (nSURLAuthenticationChallenge.previousFailureCount() < 3L) {
            for (int i = 0; i < this.authenticationListeners.length; ++i) {
                AuthenticationEvent authenticationEvent = new AuthenticationEvent(this.browser);
                authenticationEvent.location = this.lastNavigateURL;
                this.authenticationListeners[i].authenticate(authenticationEvent);
                if (!authenticationEvent.doit) {
                    id id2 = nSURLAuthenticationChallenge.sender();
                    OS.objc_msgSend(id2.id, OS.sel_cancelAuthenticationChallenge_, l3);
                    return;
                }
                if (authenticationEvent.user == null || authenticationEvent.password == null) continue;
                id id3 = nSURLAuthenticationChallenge.sender();
                NSString nSString = NSString.stringWith(authenticationEvent.user);
                NSString nSString2 = NSString.stringWith(authenticationEvent.password);
                NSURLCredential nSURLCredential = NSURLCredential.credentialWithUser(nSString, nSString2, 1L);
                OS.objc_msgSend(id3.id, OS.sel_useCredential_forAuthenticationChallenge_, nSURLCredential.id, l3);
                return;
            }
        }
        if ((l7 = OS.class_WebPanelAuthenticationHandler) != 0L && (l6 = OS.class_getClassMethod(l7, OS.sel_sharedHandler)) != 0L && (l5 = OS.objc_msgSend(l7, OS.sel_sharedHandler)) != 0L) {
            OS.objc_msgSend(l5, OS.sel_startAuthentication, l3, this.webView.window().id);
            return;
        }
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        NSURLCredential nSURLCredential = nSURLAuthenticationChallenge.proposedCredential();
        if (nSURLCredential != null) {
            stringArray[0] = nSURLCredential.user().getString();
            if (nSURLCredential.hasPassword()) {
                stringArray2[0] = nSURLCredential.password().getString();
            }
        }
        if (!(bl = this.showAuthenticationDialog(stringArray, stringArray2, string2 = (nSURLProtectionSpace = nSURLAuthenticationChallenge.protectionSpace()).host().getString() + ':' + nSURLProtectionSpace.port(), string = nSURLProtectionSpace.realm().getString()))) {
            id id4 = nSURLAuthenticationChallenge.sender();
            OS.objc_msgSend(id4.id, OS.sel_cancelAuthenticationChallenge_, l3);
            return;
        }
        id id5 = nSURLAuthenticationChallenge.sender();
        NSString nSString = NSString.stringWith(stringArray[0]);
        NSString nSString3 = NSString.stringWith(stringArray2[0]);
        NSURLCredential nSURLCredential2 = NSURLCredential.credentialWithUser(nSString, nSString3, 1L);
        OS.objc_msgSend(id5.id, OS.sel_useCredential_forAuthenticationChallenge_, nSURLCredential2.id, l3);
    }

    boolean showAuthenticationDialog(String[] stringArray, String[] stringArray2, String string, String string2) {
        Shell shell = new Shell(this.browser.getShell());
        shell.setLayout(new GridLayout());
        String string3 = SWT.getMessage("SWT_Authentication_Required");
        shell.setText(string3);
        Label label = new Label(shell, 64);
        label.setText(Compatibility.getMessage("SWT_Enter_Username_and_Password", new String[]{string2, string}));
        GridData gridData = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int n = monitor.getBounds().width * 2 / 3;
        int n2 = label.computeSize((int)-1, (int)-1).x;
        gridData.widthHint = Math.min(n2, n);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        Label label2 = new Label(shell, 0);
        label2.setText(SWT.getMessage("SWT_Username"));
        Text text = new Text(shell, 2048);
        if (stringArray[0] != null) {
            text.setText(stringArray[0]);
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData(gridData);
        Label label3 = new Label(shell, 0);
        label3.setText(SWT.getMessage("SWT_Password"));
        Text text2 = new Text(shell, 0x400800);
        if (stringArray2[0] != null) {
            text2.setText(stringArray2[0]);
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text2.setLayoutData(gridData);
        boolean[] blArray = new boolean[1];
        Button[] buttonArray = new Button[2];
        Listener listener = event -> {
            stringArray[0] = text.getText();
            stringArray2[0] = text2.getText();
            blArray[0] = event.widget == buttonArray[1];
            shell.close();
        };
        Composite composite = new Composite(shell, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        composite.setLayoutData(gridData);
        composite.setLayout(new GridLayout(2, true));
        buttonArray[0] = new Button(composite, 8);
        buttonArray[0].setText(SWT.getMessage("SWT_Cancel"));
        buttonArray[0].setLayoutData(new GridData(768));
        buttonArray[0].addListener(13, listener);
        buttonArray[1] = new Button(composite, 8);
        buttonArray[1].setText(SWT.getMessage("SWT_OK"));
        buttonArray[1].setLayoutData(new GridData(768));
        buttonArray[1].addListener(13, listener);
        shell.setDefaultButton(buttonArray[1]);
        shell.pack();
        shell.open();
        Display display = this.browser.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return blArray[0];
    }

    long webView_identifierForInitialRequest_fromDataSource(long l, long l2, long l3) {
        ProgressEvent progressEvent = new ProgressEvent(this.browser);
        progressEvent.display = this.browser.getDisplay();
        progressEvent.widget = this.browser;
        progressEvent.current = this.resourceCount;
        progressEvent.total = Math.max(this.resourceCount, 100);
        for (int i = 0; i < this.progressListeners.length; ++i) {
            this.progressListeners[i].changed(progressEvent);
        }
        if (this.browser.isDisposed()) {
            return 0L;
        }
        NSNumber nSNumber = NSNumber.numberWithInt(this.resourceCount++);
        if (this.identifier == 0L) {
            WebDataSource webDataSource = new WebDataSource(l3);
            WebFrame webFrame = webDataSource.webFrame();
            if (webFrame.id == this.webView.mainFrame().id) {
                this.identifier = nSNumber.id;
            }
        }
        return nSNumber.id;
    }

    long webView_resource_willSendRequest_redirectResponse_fromDataSource(long l, long l2, long l3, long l4, long l5) {
        NSURLRequest nSURLRequest = new NSURLRequest(l3);
        NSURL nSURL = nSURLRequest.URL();
        if (nSURL.isFileURL()) {
            NSMutableURLRequest nSMutableURLRequest = new NSMutableURLRequest(nSURLRequest.mutableCopy());
            nSMutableURLRequest.autorelease();
            nSMutableURLRequest.setCachePolicy(1L);
            return nSMutableURLRequest.id;
        }
        return l3;
    }

    long webView_createWebViewWithRequest(long l, long l2) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        windowEvent.required = true;
        if (this.openWindowListeners != null) {
            for (int i = 0; i < this.openWindowListeners.length; ++i) {
                this.openWindowListeners[i].open(windowEvent);
            }
        }
        WebView webView = null;
        Widget widget = null;
        if (windowEvent.browser != null && windowEvent.browser.webBrowser instanceof WebKit) {
            widget = windowEvent.browser;
        }
        if (widget != null && !widget.isDisposed()) {
            webView = ((WebKit)((Browser)widget).webBrowser).webView;
            if (l2 != 0L) {
                WebFrame webFrame = webView.mainFrame();
                webFrame.loadRequest(new NSURLRequest(l2));
            }
        }
        return webView != null ? webView.id : 0L;
    }

    void webViewShow(long l) {
        Shell shell = this.browser.getShell();
        Point point = shell.getSize();
        shell.setSize(point.x + 1, point.y);
        shell.setSize(point.x, point.y);
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        if (this.location != null) {
            windowEvent.location = this.location;
        }
        if (this.size != null) {
            windowEvent.size = this.size;
        }
        windowEvent.addressBar = this.toolBar;
        windowEvent.menuBar = true;
        windowEvent.statusBar = this.statusBar;
        windowEvent.toolBar = this.toolBar;
        for (int i = 0; i < this.visibilityWindowListeners.length; ++i) {
            this.visibilityWindowListeners[i].show(windowEvent);
        }
        this.location = null;
        this.size = null;
    }

    void webView_setFrame(long l, long l2) {
        NSRect nSRect = new NSRect();
        OS.memmove(nSRect, l2, (long)NSRect.sizeof);
        Rectangle rectangle = this.browser.getDisplay().getBounds();
        this.location = new Point((int)nSRect.x, rectangle.height - (int)nSRect.y - (int)nSRect.height);
        this.size = new Point((int)nSRect.width, (int)nSRect.height);
    }

    void webViewFocus(long l) {
    }

    void webViewUnfocus(long l) {
    }

    NSNumber callRunBeforeUnloadConfirmPanelWithMessage(long l, long l2) {
        boolean bl = this.webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame(0L, l, 0L);
        return NSNumber.numberWithBool(bl);
    }

    boolean webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame(long l, long l2, long l3) {
        NSString nSString = new NSString(l2);
        StringBuffer stringBuffer = new StringBuffer(Compatibility.getMessage("SWT_OnBeforeUnload_Message1"));
        stringBuffer.append("\n\n");
        stringBuffer.append(nSString.getString());
        stringBuffer.append("\n\n");
        stringBuffer.append(Compatibility.getMessage("SWT_OnBeforeUnload_Message2"));
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 268435748);
        messageBox.setMessage(stringBuffer.toString());
        return messageBox.open() == 32;
    }

    void webView_runJavaScriptAlertPanelWithMessage(long l, long l2) {
        NSString nSString = new NSString(l2);
        String string = nSString.getString();
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 40);
        messageBox.setText("Javascript");
        messageBox.setMessage(string);
        messageBox.open();
    }

    int webView_runJavaScriptConfirmPanelWithMessage(long l, long l2) {
        NSString nSString = new NSString(l2);
        String string = nSString.getString();
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 292);
        messageBox.setText("Javascript");
        messageBox.setMessage(string);
        return messageBox.open() == 32 ? 1 : 0;
    }

    void webView_runOpenPanelForFileButtonWithResultListener(long l, long l2) {
        FileDialog fileDialog = new FileDialog(this.browser.getShell(), 0);
        String string = fileDialog.open();
        WebOpenPanelResultListener webOpenPanelResultListener = new WebOpenPanelResultListener(l2);
        if (string == null) {
            webOpenPanelResultListener.cancel();
            return;
        }
        webOpenPanelResultListener.chooseFilename(NSString.stringWith(string));
    }

    void webViewClose(long l) {
        Shell shell = this.browser.getShell();
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        for (int i = 0; i < this.closeWindowListeners.length; ++i) {
            this.closeWindowListeners[i].close(windowEvent);
        }
        this.browser.dispose();
        if (shell.isDisposed()) {
            return;
        }
        Point point = shell.getSize();
        shell.setSize(point.x + 1, point.y);
        shell.setSize(point.x, point.y);
    }

    long webView_contextMenuItemsForElement_defaultMenuItems(long l, long l2, long l3) {
        Point point = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = point.x;
        event.y = point.y;
        this.browser.notifyListeners(35, event);
        Menu menu = this.browser.getMenu();
        if (!event.doit) {
            return 0L;
        }
        if (menu != null && !menu.isDisposed()) {
            if (event.x != point.x || event.y != point.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 0L;
        }
        return l3;
    }

    void webView_setStatusBarVisible(long l, boolean bl) {
        this.statusBar = bl;
    }

    void webView_setStatusText(long l, long l2) {
        NSString nSString = new NSString(l2);
        int n = (int)nSString.length();
        if (n == 0) {
            return;
        }
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = nSString.getString();
        for (int i = 0; i < this.statusTextListeners.length; ++i) {
            this.statusTextListeners[i].changed(statusTextEvent);
        }
    }

    void webView_setResizable(long l, boolean bl) {
    }

    void webView_setToolbarsVisible(long l, boolean bl) {
        this.toolBar = bl;
    }

    void webView_mouseDidMoveOverElement_modifierFlags(long l, long l2, long l3) {
        if (l2 == 0L) {
            return;
        }
        NSDictionary nSDictionary = new NSDictionary(l2);
        NSString nSString = NSString.stringWith(WebElementLinkURLKey);
        id id2 = nSDictionary.valueForKey(nSString);
        if (id2 == null) {
            if (this.lastHoveredLinkURL == null) {
                return;
            }
            this.lastHoveredLinkURL = null;
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = this.browser.getDisplay();
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = "";
            for (int i = 0; i < this.statusTextListeners.length; ++i) {
                this.statusTextListeners[i].changed(statusTextEvent);
            }
            return;
        }
        NSString nSString2 = new NSURL(id2.id).absoluteString();
        int n = (int)nSString2.length();
        String string = n == 0 ? "" : nSString2.getString();
        if (string.equals(this.lastHoveredLinkURL)) {
            return;
        }
        this.lastHoveredLinkURL = string;
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = string;
        for (int i = 0; i < this.statusTextListeners.length; ++i) {
            this.statusTextListeners[i].changed(statusTextEvent);
        }
    }

    void webView_printFrameView(long l, long l2) {
        WebFrameView webFrameView = new WebFrameView(l2);
        boolean bl = webFrameView.documentViewShouldHandlePrint();
        if (bl) {
            webFrameView.printDocumentView();
            return;
        }
        NSPrintInfo nSPrintInfo = NSPrintInfo.sharedPrintInfo();
        NSPrintOperation nSPrintOperation = webFrameView.printOperationWithPrintInfo(nSPrintInfo);
        if (nSPrintOperation != null) {
            nSPrintOperation.runOperation();
        }
    }

    void webView_decidePolicyForMIMEType_request_frame_decisionListener(long l, long l2, long l3, long l4, long l5) {
        boolean bl = WebView.canShowMIMEType(new NSString(l2));
        WebPolicyDecisionListener webPolicyDecisionListener = new WebPolicyDecisionListener(l5);
        if (bl) {
            webPolicyDecisionListener.use();
        } else {
            webPolicyDecisionListener.download();
        }
    }

    void webView_decidePolicyForNavigationAction_request_frame_decisionListener(long l, long l2, long l3, long l4, long l5) {
        NSURL nSURL = new NSURLRequest(l3).URL();
        WebPolicyDecisionListener webPolicyDecisionListener = new WebPolicyDecisionListener(l5);
        if (this.loadingText) {
            webPolicyDecisionListener.use();
            return;
        }
        if (nSURL == null) {
            webPolicyDecisionListener.ignore();
            return;
        }
        if (nSURL.isFileURL() && this.getUrl().startsWith(ABOUT_BLANK) && this.untrustedText) {
            webPolicyDecisionListener.ignore();
            return;
        }
        NSString nSString = nSURL.absoluteString();
        String string = nSString.getString();
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            int n = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n) == '#') {
                string = ABOUT_BLANK + string.substring(n);
            }
        }
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.location = string;
        locationEvent.doit = true;
        if (this.locationListeners != null) {
            for (int i = 0; i < this.locationListeners.length; ++i) {
                this.locationListeners[i].changing(locationEvent);
            }
        }
        if (locationEvent.doit) {
            if (this.jsEnabled != this.jsEnabledOnNextPage) {
                this.jsEnabled = this.jsEnabledOnNextPage;
                if (this.preferences == null) {
                    this.preferences = (WebPreferences)new WebPreferences().alloc().init();
                    this.webView.setPreferences(this.preferences);
                }
                this.preferences.setJavaScriptEnabled(this.jsEnabled);
            }
            webPolicyDecisionListener.use();
            this.lastNavigateURL = string;
        } else {
            webPolicyDecisionListener.ignore();
        }
    }

    void webView_decidePolicyForNewWindowAction_request_newFrameName_decisionListener(long l, long l2, long l3, long l4, long l5) {
        WebPolicyDecisionListener webPolicyDecisionListener = new WebPolicyDecisionListener(l5);
        webPolicyDecisionListener.use();
    }

    void webView_unableToImplementPolicyWithError_frame(long l, long l2, long l3) {
    }

    void download_decideDestinationWithSuggestedFilename(long l, long l2) {
        NSString nSString = new NSString(l2);
        String string = nSString.getString();
        FileDialog fileDialog = new FileDialog(this.browser.getShell(), 8192);
        fileDialog.setText(SWT.getMessage("SWT_FileDownload"));
        fileDialog.setFileName(string);
        String string2 = fileDialog.open();
        NSURLDownload nSURLDownload = new NSURLDownload(l);
        if (string2 == null) {
            nSURLDownload.cancel();
            return;
        }
        nSURLDownload.setDestination(NSString.stringWith(string2), true);
    }

    void handleEvent(long l) {
        NSString nSString = new NSString(OS.objc_msgSend(l, OS.sel_type));
        String string = nSString.getString();
        if (DOMEVENT_KEYDOWN.equals(string) || DOMEVENT_KEYUP.equals(string)) {
            int n;
            int n2;
            int n3;
            DOMKeyboardEvent dOMKeyboardEvent = new DOMKeyboardEvent(l);
            boolean bl = dOMKeyboardEvent.ctrlKey();
            boolean bl2 = dOMKeyboardEvent.shiftKey();
            boolean bl3 = dOMKeyboardEvent.altKey();
            boolean bl4 = dOMKeyboardEvent.metaKey();
            int n4 = dOMKeyboardEvent.keyCode();
            int n5 = dOMKeyboardEvent.charCode();
            Event event = new Event();
            event.widget = this.browser;
            event.type = n3 = DOMEVENT_KEYDOWN.equals(string) ? 1 : 2;
            event.keyCode = n2 = this.translateKey(n4);
            event.character = (char)n5;
            event.stateMask = n = (bl3 ? 65536 : 0) | (bl ? 262144 : 0) | (bl2 ? 131072 : 0) | (bl4 ? 0x400000 : 0);
            boolean bl5 = true;
            if (event.type == 1) {
                bl5 = this.sendKeyEvent(event);
            } else {
                this.browser.notifyListeners(event.type, event);
                bl5 = event.doit;
            }
            if (!bl5) {
                dOMKeyboardEvent.preventDefault();
            } else if (n3 == 1 && n == 0x400000) {
                if (n2 == 118) {
                    this.webView.paste(this.webView);
                    dOMKeyboardEvent.preventDefault();
                } else if (n2 == 99) {
                    this.webView.copy(this.webView);
                    dOMKeyboardEvent.preventDefault();
                } else if (n2 == 120) {
                    this.webView.cut(this.webView);
                    dOMKeyboardEvent.preventDefault();
                }
            }
            return;
        }
        if (DOMEVENT_MOUSEWHEEL.equals(string)) {
            DOMWheelEvent dOMWheelEvent = new DOMWheelEvent(l);
            int n = dOMWheelEvent.screenX();
            int n6 = dOMWheelEvent.screenY();
            Point point = new Point(n, n6);
            point = this.browser.getDisplay().map(null, (Control)this.browser, point);
            int n7 = dOMWheelEvent.wheelDelta();
            boolean bl = dOMWheelEvent.ctrlKey();
            boolean bl6 = dOMWheelEvent.shiftKey();
            boolean bl7 = dOMWheelEvent.altKey();
            boolean bl8 = dOMWheelEvent.metaKey();
            Event event = new Event();
            event.type = 37;
            event.widget = this.browser;
            event.x = point.x;
            event.y = point.y;
            event.count = n7 / 120;
            event.stateMask = (bl7 ? 65536 : 0) | (bl ? 262144 : 0) | (bl6 ? 131072 : 0) | (bl8 ? 0x400000 : 0);
            this.browser.notifyListeners(event.type, event);
            return;
        }
        DOMMouseEvent dOMMouseEvent = new DOMMouseEvent(l);
        int n = dOMMouseEvent.screenX();
        int n8 = dOMMouseEvent.screenY();
        Point point = new Point(n, n8);
        point = this.browser.getDisplay().map(null, (Control)this.browser, point);
        int n9 = dOMMouseEvent.detail();
        short s = dOMMouseEvent.button();
        boolean bl = dOMMouseEvent.ctrlKey();
        boolean bl9 = dOMMouseEvent.shiftKey();
        boolean bl10 = dOMMouseEvent.altKey();
        boolean bl11 = dOMMouseEvent.metaKey();
        Event event = new Event();
        event.widget = this.browser;
        event.x = point.x;
        event.y = point.y;
        event.stateMask = (bl10 ? 65536 : 0) | (bl ? 262144 : 0) | (bl9 ? 131072 : 0) | (bl11 ? 0x400000 : 0);
        if (DOMEVENT_MOUSEDOWN.equals(string)) {
            event.type = 3;
            event.button = s + 1;
            event.count = n9;
        } else if (DOMEVENT_MOUSEUP.equals(string)) {
            event.type = 4;
            event.button = s + 1;
            event.count = n9;
            switch (event.button) {
                case 1: {
                    event.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    event.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    event.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    event.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    event.stateMask |= 0x2000000;
                }
            }
        } else if (DOMEVENT_MOUSEMOVE.equals(string)) {
            if (event.x == this.lastMouseMoveX && event.y == this.lastMouseMoveY) {
                return;
            }
            event.type = 5;
            this.lastMouseMoveX = event.x;
            this.lastMouseMoveY = event.y;
        }
        this.browser.notifyListeners(event.type, event);
        if (n9 == 2 && DOMEVENT_MOUSEDOWN.equals(string)) {
            event = new Event();
            event.widget = this.browser;
            event.x = point.x;
            event.y = point.y;
            event.stateMask = (bl10 ? 65536 : 0) | (bl ? 262144 : 0) | (bl9 ? 131072 : 0) | (bl11 ? 0x400000 : 0);
            event.type = 8;
            event.button = s + 1;
            event.count = n9;
            this.browser.notifyListeners(event.type, event);
        }
    }

    Object convertToJava(long l) {
        Object[] objectArray;
        NSObject nSObject;
        NSObject nSObject2 = new NSObject(l);
        long l2 = OS.objc_lookUpClass("NSString");
        if (nSObject2.isKindOfClass(l2)) {
            NSString nSString = new NSString(l);
            return nSString.getString();
        }
        l2 = OS.objc_lookUpClass("NSNumber");
        if (nSObject2.isKindOfClass(l2)) {
            nSObject = new NSNumber(l);
            long l3 = ((NSValue)nSObject).objCType();
            objectArray = new byte[1];
            OS.memmove(objectArray, l3, 1L);
            if (objectArray[0] == 99 || objectArray[0] == 66) {
                return new Boolean(((NSNumber)nSObject).boolValue());
            }
            if ("islqISLQfd".indexOf(objectArray[0]) != -1) {
                return new Double(((NSNumber)nSObject).doubleValue());
            }
        }
        if (nSObject2.isKindOfClass(l2 = OS.objc_lookUpClass("WebScriptObject"))) {
            nSObject = new WebScriptObject(l);
            id id2 = nSObject.valueForKey(NSString.stringWith("length"));
            if (id2 == null) {
                SWT.error(5);
            }
            int n = new NSNumber(id2).intValue();
            objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                id id3 = ((WebScriptObject)nSObject).webScriptValueAtIndex(i);
                if (id3 == null) continue;
                objectArray[i] = (byte)this.convertToJava(id3.id);
            }
            return objectArray;
        }
        l2 = OS.objc_lookUpClass("WebUndefined");
        if (nSObject2.isKindOfClass(l2)) {
            return null;
        }
        SWT.error(5);
        return null;
    }

    NSObject convertToJS(Object object) {
        if (object == null) {
            long l = OS.objc_msgSend(OS.class_NSNull, OS.sel_null);
            return l != 0L ? new NSObject(l) : null;
        }
        if (object instanceof String) {
            return NSString.stringWith((String)object);
        }
        if (object instanceof Boolean) {
            return NSNumber.numberWithBool((Boolean)object);
        }
        if (object instanceof Number) {
            return NSNumber.numberWithDouble(((Number)object).doubleValue());
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(n);
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray[i];
                nSMutableArray.addObject(this.convertToJS(object2));
            }
            return nSMutableArray;
        }
        SWT.error(51);
        return null;
    }

    NSObject callJava(long l, long l2, long l3, long l4) {
        Object object = null;
        NSObject nSObject = new NSObject(l);
        long l5 = OS.objc_lookUpClass("NSNumber");
        if (nSObject.isKindOfClass(l5)) {
            NSNumber nSNumber = new NSNumber(l);
            Integer n = new Integer(nSNumber.intValue());
            nSObject = new NSObject(l2);
            l5 = OS.objc_lookUpClass("NSString");
            if (nSObject.isKindOfClass(l5)) {
                NSString nSString = new NSString(l2);
                BrowserFunction browserFunction = (BrowserFunction)this.functions.get(n);
                if (browserFunction != null && nSString.getString().equals(browserFunction.token)) {
                    try {
                        Object object2 = this.convertToJava(l3);
                        if (object2 instanceof Object[]) {
                            Object[] objectArray = (Object[])object2;
                            try {
                                object = browserFunction.function(objectArray);
                            }
                            catch (Exception exception) {
                                object = WebBrowser.CreateErrorString(exception.getLocalizedMessage());
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (browserFunction.isEvaluate) {
                            browserFunction.function(new String[]{WebBrowser.CreateErrorString(new SWTException(51).getLocalizedMessage())});
                        }
                        object = WebBrowser.CreateErrorString(illegalArgumentException.getLocalizedMessage());
                    }
                }
            }
        }
        try {
            return this.convertToJS(object);
        }
        catch (SWTException sWTException) {
            return this.convertToJS(WebBrowser.CreateErrorString(sWTException.getLocalizedMessage()));
        }
    }

    static {
        SWT_OBJECT = new byte[]{83, 87, 84, 95, 79, 66, 74, 69, 67, 84, 0};
        NativeClearSessions = () -> {
            NSHTTPCookieStorage nSHTTPCookieStorage = NSHTTPCookieStorage.sharedHTTPCookieStorage();
            NSArray nSArray = nSHTTPCookieStorage.cookies();
            int n = (int)nSArray.count();
            for (int i = 0; i < n; ++i) {
                NSHTTPCookie nSHTTPCookie = new NSHTTPCookie(nSArray.objectAtIndex(i));
                if (!nSHTTPCookie.isSessionOnly()) continue;
                nSHTTPCookieStorage.deleteCookie(nSHTTPCookie);
            }
        };
        NativeGetCookie = () -> {
            NSURL nSURL;
            NSHTTPCookieStorage nSHTTPCookieStorage = NSHTTPCookieStorage.sharedHTTPCookieStorage();
            NSArray nSArray = nSHTTPCookieStorage.cookiesForURL(nSURL = NSURL.URLWithString(NSString.stringWith(CookieUrl)));
            int n = (int)nSArray.count();
            if (n == 0) {
                return;
            }
            NSString nSString = NSString.stringWith(CookieName);
            for (int i = 0; i < n; ++i) {
                NSHTTPCookie nSHTTPCookie = new NSHTTPCookie(nSArray.objectAtIndex(i));
                if (nSHTTPCookie.name().compare(nSString) != 0L) continue;
                CookieValue = nSHTTPCookie.value().getString();
                return;
            }
        };
        NativeSetCookie = () -> {
            NSURL nSURL = NSURL.URLWithString(NSString.stringWith(CookieUrl));
            NSMutableDictionary nSMutableDictionary = NSMutableDictionary.dictionaryWithCapacity(1L);
            nSMutableDictionary.setValue(NSString.stringWith(CookieValue), NSString.stringWith(HEADER_SETCOOKIE));
            NSArray nSArray = NSHTTPCookie.cookiesWithResponseHeaderFields(nSMutableDictionary, nSURL);
            if (nSArray.count() == 0L) {
                return;
            }
            NSHTTPCookieStorage nSHTTPCookieStorage = NSHTTPCookieStorage.sharedHTTPCookieStorage();
            NSHTTPCookie nSHTTPCookie = new NSHTTPCookie(nSArray.objectAtIndex(0L));
            nSHTTPCookieStorage.setCookie(nSHTTPCookie);
            CookieResult = true;
        };
        if (NativePendingCookies != null) {
            WebKit.SetPendingCookies(NativePendingCookies);
        }
        NativePendingCookies = null;
    }
}

