/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTabView;
import org.eclipse.swt.internal.cocoa.NSTabViewItem;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    static final int IMAGE_GAP = 2;
    TabFolder parent;
    Control control;
    String toolTipText;
    NSTabViewItem nsItem;
    NSAttributedString attriStr;

    public TabItem(TabFolder tabFolder, int n) {
        super(tabFolder, n);
        this.parent = tabFolder;
        tabFolder.createItem(this, tabFolder.getItemCount());
    }

    public TabItem(TabFolder tabFolder, int n, int n2) {
        super(tabFolder, n);
        this.parent = tabFolder;
        tabFolder.createItem(this, n2);
    }

    @Override
    long accessibilityAttributeValue(long l, long l2, long l3) {
        if (l == this.nsItem.id) {
            NSString nSString = new NSString(l3);
            if (nSString.isEqualToString(OS.NSAccessibilityTitleAttribute)) {
                if (this.text != null) {
                    return NSString.stringWith((String)this.text).id;
                }
            } else if (nSString.isEqualToString(OS.NSAccessibilityHelpAttribute) && this.toolTipText != null) {
                return NSString.stringWith((String)this.toolTipText).id;
            }
        }
        return super.accessibilityAttributeValue(l, l2, l3);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.nsItem);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    @Override
    void drawLabelInRect(long l, long l2, boolean bl, NSRect nSRect) {
        if (this.image != null && !this.image.isDisposed()) {
            NSSize nSSize = this.image.handle.size();
            NSRect nSRect2 = new NSRect();
            nSRect2.x = nSRect.x;
            nSRect2.y = nSRect.y;
            nSRect2.width = nSSize.width;
            nSRect2.height = nSSize.height;
            NSGraphicsContext.static_saveGraphicsState();
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.scaleXBy(1.0, -1.0);
            nSAffineTransform.translateXBy(0.0, -(nSRect2.height + 2.0 * nSRect2.y));
            nSAffineTransform.concat();
            this.image.handle.drawInRect(nSRect2, new NSRect(), 2L, 1.0);
            NSGraphicsContext.static_restoreGraphicsState();
            nSRect.x += nSSize.width + 2.0;
            nSRect.width -= nSSize.width + 2.0;
        }
        if (this.attriStr != null) {
            this.attriStr.drawInRect(nSRect);
        }
        super.drawLabelInRect(l, l2, bl, nSRect);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (this.nsItem.respondsToSelector(OS.sel_accessibilityAttributeValue_)) {
            long l = OS.objc_msgSend(this.nsItem.id, OS.sel_accessibilityAttributeValue_, OS.NSAccessibilityPositionAttribute());
            long l2 = OS.objc_msgSend(this.nsItem.id, OS.sel_accessibilityAttributeValue_, OS.NSAccessibilitySizeAttribute());
            NSValue nSValue = new NSValue(l);
            NSPoint nSPoint = nSValue.pointValue();
            NSWindow nSWindow = this.parent.view.window();
            nSPoint = nSWindow.convertScreenToBase(nSPoint);
            nSPoint = this.parent.view.convertPoint_fromView_(nSPoint, null);
            nSValue = new NSValue(l2);
            NSSize nSSize = nSValue.sizeValue();
            rectangle.width = (int)Math.ceil(nSSize.width);
            rectangle.height = (int)Math.ceil(nSSize.height);
            rectangle.x = (int)nSPoint.x;
            rectangle.y = (int)nSPoint.y - rectangle.height;
        }
        return rectangle;
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.nsItem, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.nsItem != null) {
            this.nsItem.release();
        }
        this.nsItem = null;
        if (this.attriStr != null) {
            this.attriStr.release();
        }
        this.attriStr = null;
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        int n = this.parent.indexOf(this);
        if (n == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
    }

    public void setControl(Control control) {
        NSView nSView;
        Object object;
        int n;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control control2 = this.control;
        Control control3 = control;
        this.control = control;
        int n2 = this.parent.indexOf(this);
        if (n2 != (n = this.parent.getSelectionIndex())) {
            if (control3 != null) {
                boolean bl = true;
                if (n != -1 && (object = this.parent.getItem(n).getControl()) == control3) {
                    bl = false;
                }
                if (bl) {
                    control3.setVisible(false);
                }
            }
        } else {
            if (control3 != null) {
                control3.setVisible(true);
            }
            if (control2 != null && control3 != null && control2 != control3) {
                control2.setVisible(false);
            }
        }
        if (control3 != null) {
            nSView = control3.topView();
        } else {
            nSView = (NSView)new NSView().alloc();
            nSView.init();
            nSView.autorelease();
        }
        this.nsItem.setView(nSView);
        if (control2 != null && ((NSView)(object = control2.topView())).superview() == null) {
            this.parent.contentView().addSubview((NSView)object, -1L, null);
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        super.setImage(image);
        this.nsItem.setLabel(NSString.string());
    }

    @Override
    public void setText(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setText(string);
        this.updateText();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.parent.checkToolTip(this);
    }

    @Override
    NSSize sizeOfLabel(long l, long l2, boolean bl) {
        NSSize nSSize;
        NSSize nSSize2 = super.sizeOfLabel(l, l2, bl);
        if (this.image != null && !this.image.isDisposed()) {
            nSSize = this.image.handle.size();
            nSSize2.width += nSSize.width + 2.0;
        }
        if (this.attriStr != null) {
            nSSize = this.attriStr.size();
            nSSize2.width += nSSize.width;
        }
        return nSSize2;
    }

    @Override
    String tooltipText() {
        return this.toolTipText;
    }

    void updateText() {
        NSTabViewItem nSTabViewItem = ((NSTabView)this.parent.view).selectedTabViewItem();
        this.updateText(nSTabViewItem != null && nSTabViewItem.id == this.nsItem.id);
    }

    void updateText(boolean bl) {
        double[] dArray;
        if (this.attriStr != null) {
            this.attriStr.release();
        }
        if ((dArray = this.parent.foreground) == null && bl && OS.VERSION >= 4208) {
            dArray = this.display.getNSColorRGB(NSColor.alternateSelectedControlTextColor());
        }
        this.attriStr = this.parent.createString(this.text, null, dArray, 0, false, true, true);
        this.nsItem.setLabel(NSString.string());
    }
}

