/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    Shell tip;
    TrayItem item;
    int x;
    int y;
    int[] borderPolygon;
    boolean spikeAbove;
    boolean autohide;
    Listener listener;
    Listener parentListener;
    TextLayout layoutText;
    TextLayout layoutMessage;
    Region region;
    Font boldFont;
    Runnable runnable;
    static final int BORDER = 5;
    static final int PADDING = 5;
    static final int INSET = 4;
    static final int TIP_HEIGHT = 20;
    static final int IMAGE_SIZE = 16;
    static final int DELAY = 10000;

    public ToolTip(Shell shell, int n) {
        super(shell, ToolTip.checkStyle(n));
        this.parent = shell;
        this.autohide = true;
        this.y = -1;
        this.x = -1;
        Display display = this.getDisplay();
        this.tip = new Shell(shell, 16392);
        Color color = display.getSystemColor(29);
        this.tip.setBackground(color);
        this.listener = event -> {
            switch (event.type) {
                case 12: {
                    this.onDispose(event);
                    break;
                }
                case 9: {
                    this.onPaint(event);
                    break;
                }
                case 3: {
                    this.onMouseDown(event);
                }
            }
        };
        this.addListener(12, this.listener);
        this.tip.addListener(9, this.listener);
        this.tip.addListener(3, this.listener);
        this.parentListener = event -> this.dispose();
        shell.addListener(12, this.parentListener);
    }

    static int checkStyle(int n) {
        int n2 = 11;
        if ((n & n2) == 0) {
            return n;
        }
        return ToolTip.checkBits(n, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void configure() {
        int[] nArray;
        Object object;
        Display display = this.parent.getDisplay();
        int n = this.x;
        int n2 = this.y;
        if (n == -1 || n2 == -1) {
            object = this.item != null ? this.item.getLocation() : display.getCursorLocation();
            n = ((Point)object).x;
            n2 = ((Point)object).y;
        }
        object = this.parent.getMonitor();
        Rectangle rectangle = ((Monitor)object).getBounds();
        Point point = this.getSize(rectangle.width / 4);
        int n3 = point.x;
        int n4 = point.y;
        int n5 = (this.style & 0x1000) != 0 ? 20 : 0;
        int n6 = (this.style & 0x1000) != 0 ? 16 : 0;
        this.tip.setSize(n3, n4 + n5);
        boolean bl = this.spikeAbove = rectangle.height >= n2 + point.y + n5;
        if (rectangle.width >= n + point.x) {
            if (rectangle.height >= n2 + point.y + n5) {
                nArray = new int[]{0, 5 + n5, 1, 5 + n5, 1, 3 + n5, 3, 1 + n5, 5, 1 + n5, 5, n5, 16, n5, 16, 0, 35, n5, n3 - 5, n5, n3 - 5, 1 + n5, n3 - 3, 1 + n5, n3 - 1, 3 + n5, n3 - 1, 5 + n5, n3, 5 + n5, n3, n4 - 5 + n5, n3 - 1, n4 - 5 + n5, n3 - 1, n4 - 3 + n5, n3 - 2, n4 - 3 + n5, n3 - 2, n4 - 2 + n5, n3 - 3, n4 - 2 + n5, n3 - 3, n4 - 1 + n5, n3 - 5, n4 - 1 + n5, n3 - 5, n4 + n5, 5, n4 + n5, 5, n4 - 1 + n5, 3, n4 - 1 + n5, 3, n4 - 2 + n5, 2, n4 - 2 + n5, 2, n4 - 3 + n5, 1, n4 - 3 + n5, 1, n4 - 5 + n5, 0, n4 - 5 + n5, 0, 5 + n5};
                this.borderPolygon = new int[]{0, 5 + n5, 1, 4 + n5, 1, 3 + n5, 3, 1 + n5, 4, 1 + n5, 5, n5, 16, n5, 16, 1, 35, n5, n3 - 6, 0 + n5, n3 - 5, 1 + n5, n3 - 4, 1 + n5, n3 - 2, 3 + n5, n3 - 2, 4 + n5, n3 - 1, 5 + n5, n3 - 1, n4 - 6 + n5, n3 - 2, n4 - 5 + n5, n3 - 2, n4 - 4 + n5, n3 - 4, n4 - 2 + n5, n3 - 5, n4 - 2 + n5, n3 - 6, n4 - 1 + n5, 5, n4 - 1 + n5, 4, n4 - 2 + n5, 3, n4 - 2 + n5, 1, n4 - 4 + n5, 1, n4 - 5 + n5, 0, n4 - 6 + n5, 0, 5 + n5};
                this.tip.setLocation(Math.max(0, n - n6), n2);
            } else {
                nArray = new int[]{0, 5, 1, 5, 1, 3, 3, 1, 5, 1, 5, 0, n3 - 5, 0, n3 - 5, 1, n3 - 3, 1, n3 - 1, 3, n3 - 1, 5, n3, 5, n3, n4 - 5, n3 - 1, n4 - 5, n3 - 1, n4 - 3, n3 - 2, n4 - 3, n3 - 2, n4 - 2, n3 - 3, n4 - 2, n3 - 3, n4 - 1, n3 - 5, n4 - 1, n3 - 5, n4, 35, n4, 16, n4 + n5, 16, n4, 5, n4, 5, n4 - 1, 3, n4 - 1, 3, n4 - 2, 2, n4 - 2, 2, n4 - 3, 1, n4 - 3, 1, n4 - 5, 0, n4 - 5, 0, 5};
                this.borderPolygon = new int[]{0, 5, 1, 4, 1, 3, 3, 1, 4, 1, 5, 0, n3 - 6, 0, n3 - 5, 1, n3 - 4, 1, n3 - 2, 3, n3 - 2, 4, n3 - 1, 5, n3 - 1, n4 - 6, n3 - 2, n4 - 5, n3 - 2, n4 - 4, n3 - 4, n4 - 2, n3 - 5, n4 - 2, n3 - 6, n4 - 1, 36, n4 - 1, 16, n4 + n5 - 1, 16, n4 - 1, 5, n4 - 1, 4, n4 - 2, 3, n4 - 2, 1, n4 - 4, 1, n4 - 5, 0, n4 - 6, 0, 5};
                this.tip.setLocation(Math.max(0, n - n6), n2 - point.y - n5);
            }
        } else if (rectangle.height >= n2 + point.y + n5) {
            nArray = new int[]{0, 5 + n5, 1, 5 + n5, 1, 3 + n5, 3, 1 + n5, 5, 1 + n5, 5, n5, n3 - 35, n5, n3 - 16, 0, n3 - 16, n5, n3 - 5, n5, n3 - 5, 1 + n5, n3 - 3, 1 + n5, n3 - 1, 3 + n5, n3 - 1, 5 + n5, n3, 5 + n5, n3, n4 - 5 + n5, n3 - 1, n4 - 5 + n5, n3 - 1, n4 - 3 + n5, n3 - 2, n4 - 3 + n5, n3 - 2, n4 - 2 + n5, n3 - 3, n4 - 2 + n5, n3 - 3, n4 - 1 + n5, n3 - 5, n4 - 1 + n5, n3 - 5, n4 + n5, 5, n4 + n5, 5, n4 - 1 + n5, 3, n4 - 1 + n5, 3, n4 - 2 + n5, 2, n4 - 2 + n5, 2, n4 - 3 + n5, 1, n4 - 3 + n5, 1, n4 - 5 + n5, 0, n4 - 5 + n5, 0, 5 + n5};
            this.borderPolygon = new int[]{0, 5 + n5, 1, 4 + n5, 1, 3 + n5, 3, 1 + n5, 4, 1 + n5, 5, n5, n3 - 35, n5, n3 - 17, 2, n3 - 17, n5, n3 - 6, n5, n3 - 5, 1 + n5, n3 - 4, 1 + n5, n3 - 2, 3 + n5, n3 - 2, 4 + n5, n3 - 1, 5 + n5, n3 - 1, n4 - 6 + n5, n3 - 2, n4 - 5 + n5, n3 - 2, n4 - 4 + n5, n3 - 4, n4 - 2 + n5, n3 - 5, n4 - 2 + n5, n3 - 6, n4 - 1 + n5, 5, n4 - 1 + n5, 4, n4 - 2 + n5, 3, n4 - 2 + n5, 1, n4 - 4 + n5, 1, n4 - 5 + n5, 0, n4 - 6 + n5, 0, 5 + n5};
            this.tip.setLocation(Math.min(rectangle.width - point.x, n - point.x + n6), n2);
        } else {
            nArray = new int[]{0, 5, 1, 5, 1, 3, 3, 1, 5, 1, 5, 0, n3 - 5, 0, n3 - 5, 1, n3 - 3, 1, n3 - 1, 3, n3 - 1, 5, n3, 5, n3, n4 - 5, n3 - 1, n4 - 5, n3 - 1, n4 - 3, n3 - 2, n4 - 3, n3 - 2, n4 - 2, n3 - 3, n4 - 2, n3 - 3, n4 - 1, n3 - 5, n4 - 1, n3 - 5, n4, n3 - 16, n4, n3 - 16, n4 + n5, n3 - 35, n4, 5, n4, 5, n4 - 1, 3, n4 - 1, 3, n4 - 2, 2, n4 - 2, 2, n4 - 3, 1, n4 - 3, 1, n4 - 5, 0, n4 - 5, 0, 5};
            this.borderPolygon = new int[]{0, 5, 1, 4, 1, 3, 3, 1, 4, 1, 5, 0, n3 - 6, 0, n3 - 5, 1, n3 - 4, 1, n3 - 2, 3, n3 - 2, 4, n3 - 1, 5, n3 - 1, n4 - 6, n3 - 2, n4 - 5, n3 - 2, n4 - 4, n3 - 4, n4 - 2, n3 - 5, n4 - 2, n3 - 6, n4 - 1, n3 - 17, n4 - 1, n3 - 17, n4 + n5 - 2, n3 - 36, n4 - 1, 5, n4 - 1, 4, n4 - 2, 3, n4 - 2, 1, n4 - 4, 1, n4 - 5, 0, n4 - 6, 0, 5};
            this.tip.setLocation(Math.min(rectangle.width - point.x, n - point.x + n6), n2 - point.y - n5);
        }
        if ((this.style & 0x1000) != 0) {
            if (this.region != null) {
                this.region.dispose();
            }
            this.region = new Region(display);
            this.region.add(nArray);
            this.tip.setRegion(this.region);
        }
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autohide;
    }

    Point getSize(int n) {
        int n2 = 0;
        int n3 = 0;
        if (this.layoutText != null) {
            this.layoutText.setWidth(-1);
            n2 = this.layoutText.getBounds().width;
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.setWidth(-1);
            n3 = this.layoutMessage.getBounds().width;
        }
        int n4 = 28;
        boolean bl = this.layoutText != null && (this.style & 0x1000) != 0 && (this.style & 0xB) != 0;
        int n5 = n4 + (bl ? 16 : 0);
        int n6 = Math.min(n, Math.max(n2 + n5, n3 + n4));
        int n7 = 0;
        int n8 = 0;
        if (this.layoutText != null) {
            this.layoutText.setWidth(n - n5);
            n7 = this.layoutText.getBounds().height;
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.setWidth(n - n4);
            n8 = this.layoutMessage.getBounds().height;
        }
        int n9 = 20 + n8;
        if (this.layoutText != null) {
            n9 += Math.max(16, n7) + 10;
        }
        return new Point(n6, n9);
    }

    public String getMessage() {
        this.checkWidget();
        return this.layoutMessage != null ? this.layoutMessage.getText() : "";
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        return this.layoutText != null ? this.layoutText.getText() : "";
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.tip.getVisible();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void onDispose(Event event) {
        Shell shell = this.getParent();
        shell.removeListener(12, this.parentListener);
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        if (this.runnable != null) {
            Display display = this.getDisplay();
            display.timerExec(-1, this.runnable);
        }
        this.runnable = null;
        this.tip.dispose();
        this.tip = null;
        if (this.region != null) {
            this.region.dispose();
        }
        this.region = null;
        if (this.layoutText != null) {
            this.layoutText.dispose();
        }
        this.layoutText = null;
        if (this.layoutMessage != null) {
            this.layoutMessage.dispose();
        }
        this.layoutMessage = null;
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        this.boldFont = null;
        this.borderPolygon = null;
    }

    void onMouseDown(Event event) {
        this.sendSelectionEvent(13, null, true);
        this.setVisible(false);
    }

    void onPaint(Event event) {
        GC gC = event.gc;
        int n = 10;
        int n2 = 10;
        if ((this.style & 0x1000) != 0) {
            if (this.spikeAbove) {
                n2 += 20;
            }
            gC.drawPolygon(this.borderPolygon);
        } else {
            Rectangle rectangle = this.tip.getClientArea();
            gC.drawRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
        if (this.layoutText != null) {
            int n3 = this.style & 0xB;
            if ((this.style & 0x1000) != 0 && n3 != 0) {
                Display display = this.getDisplay();
                Image image = display.getSystemImage(n3);
                Rectangle rectangle = image.getBounds();
                gC.drawImage(image, 0, 0, rectangle.width, rectangle.height, n, n2, 16, 16);
                n += 16;
            }
            this.layoutText.draw(gC, n += 4, n2);
            n2 += 10 + Math.max(16, this.layoutText.getBounds().height);
        }
        if (this.layoutMessage != null) {
            n = 14;
            this.layoutMessage.draw(gC, n, n2);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAutoHide(boolean bl) {
        this.checkWidget();
        this.autohide = bl;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        if (this.x == n && this.y == n2) {
            return;
        }
        this.x = n;
        this.y = n2;
        if (this.tip.getVisible()) {
            this.configure();
        }
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.dispose();
        }
        this.layoutMessage = null;
        if (string.length() != 0) {
            Display display = this.getDisplay();
            this.layoutMessage = new TextLayout(display);
            this.layoutMessage.setText(string);
        }
        if (this.tip.getVisible()) {
            this.configure();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.layoutText != null) {
            this.layoutText.dispose();
        }
        this.layoutText = null;
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        this.boldFont = null;
        if (string.length() != 0) {
            Display display = this.getDisplay();
            this.layoutText = new TextLayout(display);
            this.layoutText.setText(string);
            Font font = display.getSystemFont();
            FontData fontData = font.getFontData()[0];
            this.boldFont = new Font((Device)display, fontData.getName(), fontData.getHeight(), 1);
            TextStyle textStyle = new TextStyle(this.boldFont, null, null);
            this.layoutText.setStyle(textStyle, 0, string.length());
        }
        if (this.tip.getVisible()) {
            this.configure();
        }
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (bl) {
            this.configure();
        }
        this.tip.setVisible(bl);
        Display display = this.getDisplay();
        if (this.runnable != null) {
            display.timerExec(-1, this.runnable);
        }
        this.runnable = null;
        if (this.autohide && bl) {
            this.runnable = () -> {
                if (!this.isDisposed()) {
                    this.setVisible(false);
                }
            };
            display.timerExec(10000, this.runnable);
        }
    }
}

