/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control;

import org.herac.tuxguitar.graphics.control.TGBeatImpl;
import org.herac.tuxguitar.graphics.control.TGBeatSpacing;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.graphics.control.TGTrackSpacing;
import org.herac.tuxguitar.graphics.control.TGVoiceImpl;
import org.herac.tuxguitar.graphics.control.painters.TGKeySignaturePainter;
import org.herac.tuxguitar.graphics.control.painters.TGNotePainter;
import org.herac.tuxguitar.graphics.control.painters.TGNumberPainter;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.ui.resource.UIMargin;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.herac.tuxguitar.ui.resource.UIRectangle;

public class TGNoteImpl
extends TGNote {
    private float tabPosY;
    private float scorePosY;
    private int accidental;

    public TGNoteImpl(TGFactory factory) {
        super(factory);
    }

    public void update(TGLayout layout) {
        this.accidental = this.getMeasureImpl().getNoteAccidental(this.getRealValue());
        this.tabPosY = (float)this.getString() * layout.getStringSpacing() - layout.getStringSpacing();
        this.scorePosY = this.getVoiceImpl().getBeatGroup().getY1(layout, this, this.getMeasureImpl().getKeySignature(), this.getMeasureImpl().getClef());
    }

    public void paint(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        float spacing = this.getBeatImpl().getSpacing(layout);
        float tabMoveX = 2.0f * layout.getScale();
        this.paintScoreNote(layout, painter, fromX, fromY + this.getPaintPosition(8), spacing);
        if (!layout.isPlayModeEnabled()) {
            this.paintOfflineEffects(layout, painter, fromX, fromY, spacing);
        }
        this.paintTablatureNote(layout, painter, fromX + tabMoveX, fromY + this.getPaintPosition(14), spacing);
    }

    private void paintOfflineEffects(TGLayout layout, UIPainter painter, float fromX, float fromY, float spacing) {
        float y;
        float x;
        TGBeatSpacing bs = this.getBeatImpl().getBs();
        TGTrackSpacing ts = this.getMeasureImpl().getTs();
        TGNoteEffect effect = this.getEffect();
        float scale = layout.getScale();
        float tsY = fromY + ts.getPosition(12);
        float bsY = tsY + (ts.getSize(12) - bs.getSize());
        layout.setOfflineEffectStyle(painter);
        if (effect.isAccentuatedNote()) {
            x = fromX + this.getPosX() + spacing;
            y = bsY + bs.getPosition(0);
            this.paintAccentuated(layout, painter, x, y);
        }
        if (effect.isHeavyAccentuatedNote()) {
            x = fromX + this.getPosX() + spacing;
            y = bsY + bs.getPosition(1);
            this.paintHeavyAccentuated(layout, painter, x, y);
        }
        if (effect.isFadeIn()) {
            x = fromX + this.getPosX() + spacing;
            y = bsY + bs.getPosition(10);
            this.paintFadeIn(layout, painter, x, y);
        }
        if (effect.isHarmonic() && (layout.getStyle() & 4) == 0) {
            x = fromX + this.getPosX() + spacing;
            y = bsY + bs.getPosition(2);
            String key = new String();
            key = effect.getHarmonic().isNatural() ? "N.H" : key;
            key = effect.getHarmonic().isArtificial() ? "A.H" : key;
            key = effect.getHarmonic().isTapped() ? "T.H" : key;
            key = effect.getHarmonic().isPinch() ? "P.H" : key;
            key = effect.getHarmonic().isSemi() ? "S.H" : key;
            painter.drawString(key, x, y + painter.getFMTopLine() + 2.0f * scale);
        }
        if (effect.isTapping()) {
            x = fromX + this.getPosX() + spacing;
            y = bsY + bs.getPosition(3);
            painter.drawString("T", x, y + painter.getFMTopLine() + 2.0f * scale);
        }
        if (effect.isSlapping()) {
            x = fromX + this.getPosX() + spacing;
            y = bsY + bs.getPosition(4);
            painter.drawString("S", x, y + painter.getFMTopLine() + 2.0f * scale);
        }
        if (effect.isPopping()) {
            x = fromX + this.getPosX() + spacing;
            y = bsY + bs.getPosition(5);
            painter.drawString("P", x, y + painter.getFMTopLine() + 2.0f * scale);
        }
        if (effect.isPalmMute()) {
            x = fromX + this.getPosX() + spacing;
            y = bsY + bs.getPosition(6);
            painter.drawString("P.M", x, y + painter.getFMTopLine() + 2.0f * scale);
        }
        if (effect.isLetRing()) {
            x = fromX + this.getPosX() + spacing;
            y = bsY + bs.getPosition(7);
            painter.drawString("L.R", x, y + painter.getFMTopLine() + 2.0f * scale);
        }
        if (effect.isVibrato()) {
            x = fromX + this.getPosX() + spacing;
            y = bsY + bs.getPosition(8);
            this.paintVibrato(layout, painter, x, y);
        }
        if (effect.isTrill()) {
            x = fromX + this.getPosX() + spacing;
            y = bsY + bs.getPosition(9);
            this.paintTrill(layout, painter, x, y);
        }
    }

    public void paintTablatureNoteValue(TGLayout layout, UIPainter painter, UIMargin margin, float fromX, float fromY, boolean running) {
        if (layout.isTabNotePathRendererEnabled()) {
            this.paintTablatureNoteValuePathMode(layout, painter, margin, fromX, fromY, running);
        } else {
            this.paintTablatureNoteValueTextMode(layout, painter, margin, fromX, fromY, running);
        }
    }

    public void paintTablatureNoteValuePathMode(TGLayout layout, UIPainter painter, UIMargin margin, float fromX, float fromY, boolean running) {
        float noteSize = layout.getStringSpacing() - 2.0f;
        float noteWidth = this.getEffect().isDeadNote() ? 6.0f * layout.getScale() : TGNumberPainter.getDigitsWidth(this.getValue(), noteSize);
        float ghostWidth = this.getEffect().isGhostNote() ? 3.0f * layout.getScale() : 0.0f;
        margin.setTop(noteSize / 2.0f);
        margin.setBottom(noteSize / 2.0f);
        margin.setLeft(noteWidth / 2.0f + ghostWidth);
        margin.setRight(noteWidth / 2.0f + ghostWidth);
        this.fillBackground(layout, painter, margin, fromX, fromY);
        layout.setTabNotePathStyle(painter, running);
        if (this.getEffect().isDeadNote()) {
            painter.initPath(1);
            painter.moveTo(fromX - (margin.getLeft() - ghostWidth), fromY - margin.getTop());
            painter.lineTo(fromX + (margin.getRight() - ghostWidth), fromY + margin.getBottom());
            painter.moveTo(fromX + (margin.getRight() - ghostWidth), fromY - margin.getTop());
            painter.lineTo(fromX - (margin.getLeft() - ghostWidth), fromY + margin.getBottom());
            painter.closePath();
        } else {
            TGNumberPainter.paintDigits(this.getValue(), painter, fromX - (margin.getLeft() - ghostWidth), fromY - margin.getTop(), noteSize);
        }
        if (this.getEffect().isGhostNote()) {
            float ghostLineWidth = 2.0f * layout.getScale();
            float ghostY1 = fromY - margin.getTop();
            float ghostY2 = fromY + margin.getBottom();
            float ghostLeftX1 = fromX - (margin.getLeft() - ghostWidth);
            float ghostLeftX2 = fromX - margin.getLeft();
            float ghostRightX1 = fromX + (margin.getRight() - ghostWidth);
            float ghostRightX2 = fromX + margin.getRight();
            painter.initPath(2);
            painter.moveTo(ghostLeftX1, ghostY1);
            painter.cubicTo(ghostLeftX2 - ghostLineWidth, ghostY1, ghostLeftX2 - ghostLineWidth, ghostY2, ghostLeftX1, ghostY2);
            painter.cubicTo(ghostLeftX2, ghostY2, ghostLeftX2, ghostY1, ghostLeftX1, ghostY1);
            painter.closePath();
            painter.initPath(2);
            painter.moveTo(ghostRightX1, ghostY1);
            painter.cubicTo(ghostRightX2 + ghostLineWidth, ghostY1, ghostRightX2 + ghostLineWidth, ghostY2, ghostRightX1, ghostY2);
            painter.cubicTo(ghostRightX2, ghostY2, ghostRightX2, ghostY1, ghostRightX1, ghostY1);
            painter.closePath();
        }
    }

    public void paintTablatureNoteValueTextMode(TGLayout layout, UIPainter painter, UIMargin margin, float fromX, float fromY, boolean running) {
        layout.setTabNoteFontStyle(painter, running);
        String label = this.getNoteLabel(this);
        float fmWidth = painter.getFMWidth(label);
        float fmTopLine = painter.getFMTopLine();
        float fmMiddleLine = painter.getFMMiddleLine();
        float fmBaseLine = painter.getFMBaseLine();
        margin.setTop((fmTopLine - fmBaseLine) / 2.0f);
        margin.setBottom((fmTopLine - fmBaseLine) / 2.0f);
        margin.setLeft(fmWidth / 2.0f);
        margin.setRight(fmWidth / 2.0f);
        this.fillBackground(layout, painter, margin, fromX, fromY);
        layout.setTabNoteFontStyle(painter, running);
        painter.drawString(label, fromX - margin.getLeft(), fromY + fmMiddleLine);
    }

    public void paintTablatureNote(TGLayout layout, UIPainter painter, float fromX, float fromY, float spacing) {
        int style = layout.getStyle();
        if ((style & 8) != 0) {
            boolean running;
            UIMargin margin = new UIMargin();
            float scale = layout.getScale();
            float x = fromX + this.getPosX() + spacing;
            float y = fromY + this.getTabPosY();
            float stringSpacing = layout.getStringSpacing();
            boolean bl = running = layout.isPlayModeEnabled() && this.getBeatImpl().isPlaying(layout);
            if (this.isTiedNote() && (style & 4) == 0) {
                float tX = 0.0f;
                float tY = fromY + this.getTabPosY() + stringSpacing / 2.0f;
                TGNoteImpl noteForTie = this.getNoteForTie();
                tX = noteForTie != null ? fromX + noteForTie.getPosX() + noteForTie.getBeatImpl().getSpacing(layout) + 5.0f * scale : fromX + this.getPosX() + this.getBeatImpl().getSpacing(layout) - stringSpacing * 2.0f;
                float tWidth = x - tX;
                float tHeight1 = stringSpacing / 3.0f;
                float tHeight2 = tHeight1 + scale * 2.0f;
                layout.setTabTiedStyle(painter, running);
                painter.initPath(2);
                painter.moveTo(tX, tY);
                painter.cubicTo(tX, tY + tHeight1, tX + tWidth, tY + tHeight1, tX + tWidth, tY);
                painter.cubicTo(tX + tWidth, tY + tHeight2, tX, tY + tHeight2, tX, tY);
                painter.closePath();
            } else if (!this.isTiedNote()) {
                this.paintTablatureNoteValue(layout, painter, margin, x, y, running);
            }
            if (!layout.isPlayModeEnabled()) {
                this.paintEffects(layout, painter, margin, fromX, fromY, spacing);
                if ((style & 4) == 0 && this.getEffect().isTremoloPicking()) {
                    float y1 = fromY + this.getMeasureImpl().getTrackImpl().getTabHeight() + stringSpacing / 2.0f;
                    float y2 = fromY + this.getMeasureImpl().getTrackImpl().getTabHeight() + stringSpacing / 2.0f * 5.0f;
                    layout.setTabEffectStyle(painter);
                    painter.setLineWidth(layout.getLineWidth(2));
                    painter.initPath();
                    float posy = y1 + (y2 - y1) / 2.0f;
                    for (int i = 8; i <= this.getEffect().getTremoloPicking().getDuration().getValue(); i += i) {
                        painter.moveTo(x - 3.0f * scale, posy - 1.0f * scale);
                        painter.lineTo(x + 4.0f * scale, posy + 1.0f * scale);
                        posy += 4.0f * scale;
                    }
                    painter.closePath();
                    painter.setLineWidth(layout.getLineWidth(1));
                }
            }
        }
    }

    private void paintScoreNote(TGLayout layout, UIPainter painter, float fromX, float fromY, float spacing) {
        if ((layout.getStyle() & 4) != 0) {
            boolean fill;
            boolean playing;
            float scale = layout.getScoreLineSpacing();
            float layoutScale = layout.getScale();
            int direction = this.getVoiceImpl().getBeatGroup().getDirection();
            int key = this.getMeasureImpl().getKeySignature();
            int clef = this.getMeasureImpl().getClef();
            float x = fromX + this.getPosX() + spacing;
            float y1 = fromY + this.getScorePosY();
            boolean bl = playing = layout.isPlayModeEnabled() && this.getBeatImpl().isPlaying(layout);
            if (this.isTiedNote()) {
                TGNoteImpl noteForTie = this.getNoteForTie();
                float tX = x - 20.0f * layoutScale;
                float tY = y1 + layout.getScoreLineSpacing() / 2.0f;
                if (noteForTie != null) {
                    float tNoteX = fromX + noteForTie.getPosX() + noteForTie.getBeatImpl().getSpacing(layout);
                    float tNoteY = fromY + this.getScorePosY();
                    tX = tNoteX + 10.0f * layoutScale;
                    tY = tNoteY + layout.getScoreLineSpacing() / 2.0f;
                }
                float tWidth = x - tX - 3.0f * layoutScale;
                float tHeight1 = layout.getScoreLineSpacing() / 2.0f;
                float tHeight2 = tHeight1 - layoutScale * 2.0f;
                layout.setTiedStyle(painter, playing);
                painter.initPath(2);
                painter.moveTo(tX, tY);
                painter.cubicTo(tX, tY - tHeight1, tX + tWidth, tY - tHeight1, tX + tWidth, tY);
                painter.cubicTo(tX + tWidth, tY - tHeight2, tX, tY - tHeight2, tX, tY);
                painter.closePath();
            }
            layout.setScoreNoteStyle(painter, playing);
            if (this.accidental == 1) {
                painter.initPath(2);
                painter.setLineWidth(layout.getLineWidth(0));
                TGKeySignaturePainter.paintNatural(painter, x - (scale - scale / 4.0f), y1 + scale / 2.0f, scale);
                painter.closePath();
            } else if (this.accidental == 2) {
                painter.initPath(2);
                painter.setLineWidth(layout.getLineWidth(0));
                TGKeySignaturePainter.paintSharp(painter, x - (scale - scale / 4.0f), y1 + scale / 2.0f, scale);
                painter.closePath();
            } else if (this.accidental == 3) {
                painter.initPath(2);
                painter.setLineWidth(layout.getLineWidth(0));
                TGKeySignaturePainter.paintFlat(painter, x - (scale - scale / 4.0f), y1 + scale / 2.0f, scale);
                painter.closePath();
            }
            if (this.getEffect().isHarmonic()) {
                fill = this.getVoice().getDuration().getValue() >= 4;
                painter.setLineWidth(layout.getLineWidth(1));
                painter.initPath(fill ? 3 : 1);
                TGNotePainter.paintHarmonic(painter, x, y1 + 1.0f * (scale / 10.0f), layout.getScoreLineSpacing() - scale / 10.0f * 2.0f);
                painter.closePath();
            } else {
                fill = this.getVoice().getDuration().getValue() >= 4;
                float noteX = fill ? x - 0.6f * (scale / 10.0f) : x;
                float noteY = fill ? y1 + 0.6f * (scale / 10.0f) : y1 + 1.0f * (scale / 10.0f);
                float noteScale = fill ? layout.getScoreLineSpacing() - scale / 10.0f * 1.0f : layout.getScoreLineSpacing() - scale / 10.0f * 2.0f;
                painter.setLineWidth(layout.getLineWidth(1));
                painter.initPath(fill ? 2 : 1);
                TGNotePainter.paintNote(painter, noteX, noteY, noteScale);
                painter.closePath();
            }
            if (!layout.isPlayModeEnabled()) {
                float scoreNoteWidth = layout.getScoreNoteWidth();
                if (this.getEffect().isGrace()) {
                    this.paintGrace(layout, painter, x, y1);
                }
                if (this.getVoice().getDuration().isDotted() || this.getVoice().getDuration().isDoubleDotted()) {
                    this.getVoiceImpl().paintDot(layout, painter, x + 12.0f * (scale / 8.0f), y1 + layout.getScoreLineSpacing() / 2.0f, scale / 10.0f);
                }
                if (this.getVoice().getDuration().getValue() >= 2) {
                    layout.setScoreNoteFooterStyle(painter);
                    float xMove = direction == 1 ? scoreNoteWidth : 0.0f;
                    float y2 = fromY + this.getVoiceImpl().getBeatGroup().getY2(layout, this.getPosX() + spacing, key, clef);
                    if (this.getEffect().isStaccato()) {
                        float size = 3.0f * layoutScale;
                        float sX = x + xMove;
                        float sY = y2 + 4.0f * layoutScale * (float)(direction == 1 ? -1 : 1);
                        layout.setScoreEffectStyle(painter);
                        painter.setLineWidth(layout.getLineWidth(1));
                        painter.initPath(2);
                        painter.moveTo(sX, sY);
                        painter.addCircle(sX, sY, size);
                        painter.closePath();
                    }
                    if (this.getEffect().isTremoloPicking()) {
                        layout.setScoreEffectStyle(painter);
                        painter.setLineWidth(layout.getLineWidth(2));
                        painter.initPath();
                        float tpY = fromY;
                        tpY = direction == 1 ? (tpY += this.getVoiceImpl().getBeatGroup().getMaxNote().getScorePosY() - layout.getScoreLineSpacing() - 4.0f * layoutScale) : (tpY += this.getVoiceImpl().getBeatGroup().getMinNote().getScorePosY() + layout.getScoreLineSpacing() + 4.0f * layoutScale);
                        for (int i = 8; i <= this.getEffect().getTremoloPicking().getDuration().getValue(); i += i) {
                            painter.moveTo(x + xMove - 3.0f * layoutScale, tpY + 1.0f * layoutScale);
                            painter.lineTo(x + xMove + 4.0f * layoutScale, tpY - 1.0f * layoutScale);
                            tpY += 4.0f * layoutScale;
                        }
                        painter.closePath();
                        painter.setLineWidth(layout.getLineWidth(1));
                    }
                } else {
                    if (this.getEffect().isStaccato()) {
                        float size = 3.0f * layoutScale;
                        float sX = x + scoreNoteWidth / 2.0f;
                        float sY = fromY + this.getVoiceImpl().getBeatGroup().getMinNote().getScorePosY() + layout.getScoreLineSpacing() + 2.0f * layoutScale;
                        layout.setScoreEffectStyle(painter);
                        painter.setLineWidth(layout.getLineWidth(1));
                        painter.initPath(2);
                        painter.moveTo(sX, sY);
                        painter.addCircle(sX, sY, size);
                        painter.closePath();
                    }
                    if (this.getEffect().isTremoloPicking()) {
                        layout.setScoreEffectStyle(painter);
                        painter.setLineWidth(layout.getLineWidth(2));
                        painter.initPath();
                        float tpX = x + scoreNoteWidth / 2.0f;
                        float tpY = fromY + (this.getVoiceImpl().getBeatGroup().getMaxNote().getScorePosY() - layout.getScoreLineSpacing() - 4.0f * layoutScale);
                        for (int i = 8; i <= this.getEffect().getTremoloPicking().getDuration().getValue(); i += i) {
                            painter.moveTo(tpX - 3.0f * layoutScale, tpY + 1.0f * layoutScale);
                            painter.lineTo(tpX + 4.0f * layoutScale, tpY - 1.0f * layoutScale);
                            tpY += 4.0f * layoutScale;
                        }
                        painter.closePath();
                        painter.setLineWidth(layout.getLineWidth(1));
                    }
                }
            }
        }
    }

    private TGNoteImpl getNoteForTie() {
        for (int i = this.getMeasureImpl().countBeats() - 1; i >= 0; --i) {
            TGBeat beat = this.getMeasureImpl().getBeat(i);
            TGVoice voice = beat.getVoice(this.getVoice().getIndex());
            if (beat.getStart() >= this.getBeatImpl().getStart() || voice.isRestVoice()) continue;
            for (TGNoteImpl tGNoteImpl : voice.getNotes()) {
                if (tGNoteImpl.getString() != this.getString()) continue;
                return tGNoteImpl;
            }
        }
        return null;
    }

    private void paintEffects(TGLayout layout, UIPainter painter, UIMargin margin, float fromX, float fromY, float spacing) {
        float x = fromX + this.getPosX() + spacing;
        float y = fromY + this.getTabPosY();
        TGNoteEffect effect = this.getEffect();
        if (effect.isGrace()) {
            layout.setTabGraceStyle(painter);
            String value = Integer.toString(effect.getGrace().getFret());
            painter.drawString(value, x - margin.getLeft() - painter.getFMWidth(value), y + painter.getFMMiddleLine());
        }
        if (effect.isBend()) {
            this.paintBend(layout, painter, x + margin.getRight(), y);
        } else if (effect.isTremoloBar()) {
            this.paintTremoloBar(layout, painter, x + margin.getRight(), y);
        } else if (effect.isSlide() || effect.isHammer()) {
            float nextFromX = fromX;
            TGNoteImpl nextNote = (TGNoteImpl)layout.getSongManager().getMeasureManager().getNextNote(this.getMeasureImpl(), this.getBeatImpl().getStart(), this.getVoice().getIndex(), this.getString());
            if (effect.isSlide()) {
                this.paintSlide(layout, painter, nextNote, x, y, nextFromX);
            } else if (effect.isHammer()) {
                this.paintHammer(layout, painter, nextNote, x, y, nextFromX);
            }
        }
    }

    private void paintBend(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        float scale = layout.getScale();
        float x = fromX + 1.0f * scale;
        float y = fromY - 2.0f * scale;
        layout.setTabEffectStyle(painter);
        painter.setLineWidth(layout.getLineWidth(1));
        painter.initPath();
        painter.moveTo(x, y);
        painter.lineTo(x + 1.0f * scale, y);
        painter.cubicTo(x + 1.0f * scale, y, x + 3.0f * scale, y, x + 3.0f * scale, y - 2.0f * scale);
        painter.moveTo(x + 3.0f * scale, y - 2.0f * scale);
        painter.lineTo(x + 3.0f * scale, y - 12.0f * scale);
        painter.moveTo(x + 3.0f * scale, y - 12.0f * scale);
        painter.lineTo(x + 1.0f * scale, y - 10.0f * scale);
        painter.moveTo(x + 3.0f * scale, y - 12.0f * scale);
        painter.lineTo(x + 5.0f * scale, y - 10.0f * scale);
        painter.closePath();
    }

    private void paintTremoloBar(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        float scale = layout.getScale();
        float x1 = fromX + 1.0f * scale;
        float x2 = x1 + 8.0f * scale;
        float y1 = fromY;
        float y2 = y1 + 9.0f * scale;
        layout.setTabEffectStyle(painter);
        painter.setLineWidth(layout.getLineWidth(1));
        painter.initPath();
        painter.moveTo(x1, y1);
        painter.lineTo(x1 + (x2 - x1) / 2.0f, y2);
        painter.moveTo(x1 + (x2 - x1) / 2.0f, y2);
        painter.lineTo(x2, y1);
        painter.closePath();
    }

    private void paintSlide(TGLayout layout, UIPainter painter, TGNoteImpl nextNote, float fromX, float fromY, float nextFromX) {
        float xScale = layout.getScale();
        float yScale = layout.getStringSpacing() / 10.0f;
        float yMove = 3.0f * yScale;
        float x = fromX;
        float y = fromY;
        layout.setTabEffectStyle(painter);
        painter.setLineWidth(layout.getLineWidth(1));
        if (nextNote != null) {
            float nextX = nextNote.getPosX() + nextFromX + nextNote.getBeatImpl().getSpacing(layout);
            float nextY = y;
            if (nextNote.getValue() < this.getValue()) {
                y -= yMove;
                nextY += yMove;
            } else if (nextNote.getValue() > this.getValue()) {
                y += yMove;
                nextY -= yMove;
            } else {
                y -= yMove;
                nextY -= yMove;
            }
            painter.initPath();
            painter.moveTo(x + 5.0f * xScale, y);
            painter.lineTo(nextX - 5.0f * xScale, nextY);
            painter.closePath();
        } else {
            painter.initPath();
            painter.moveTo(x + 5.0f * xScale, y - yMove);
            painter.lineTo(x + 18.0f * xScale, y - yMove);
            painter.closePath();
        }
    }

    private void paintHammer(TGLayout layout, UIPainter painter, TGNoteImpl nextNote, float fromX, float fromY, float nextFromX) {
        float scale = layout.getScale();
        float x = fromX + 5.0f * scale;
        float y = fromY;
        float width = nextNote != null ? nextNote.getPosX() + nextFromX + nextNote.getBeatImpl().getSpacing(layout) - 5.0f * scale - x : 10.0f * scale;
        float height1 = layout.getStringSpacing() / 2.0f;
        float height2 = height1 - scale * 2.0f;
        layout.setTabEffectStyle(painter);
        painter.setLineWidth(layout.getLineWidth(1));
        painter.initPath(2);
        painter.moveTo(x, y);
        painter.cubicTo(x, y - height1, x + width, y - height1, x + width, y);
        painter.cubicTo(x + width, y - height2, x, y - height2, x, y);
        painter.closePath();
    }

    private void paintGrace(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        float scale = layout.getScoreLineSpacing() / 2.25f;
        float x = fromX - 2.0f * scale;
        float y = fromY + scale / 3.0f;
        layout.setScoreEffectStyle(painter);
        painter.setLineWidth(layout.getLineWidth(1));
        painter.initPath(2);
        TGNotePainter.paintFooter(painter, x, y, -1, scale);
        painter.closePath();
        painter.initPath();
        painter.moveTo(x, y - 2.0f * scale);
        painter.lineTo(x, y + 2.0f * scale - scale / 4.0f);
        painter.closePath();
        painter.initPath(3);
        TGNotePainter.paintNote(painter, x - scale * 1.33f, y + scale + scale / 4.0f, scale);
        painter.closePath();
        painter.initPath();
        painter.moveTo(x - scale, y);
        painter.lineTo(x + scale, y - scale);
        painter.closePath();
    }

    private void paintVibrato(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        float scale = layout.getScale();
        float x = fromX;
        float y = fromY + 2.0f * scale;
        float width = this.getVoiceImpl().getWidth() - 2.0f * scale;
        int loops = Math.round(width / (6.0f * scale));
        if (loops > 0) {
            int i;
            layout.setTabEffectStyle(painter);
            painter.setLineWidth(layout.getLineWidth(1));
            painter.initPath(2);
            painter.moveTo(x + 2.0f * scale, y + 1.0f * scale);
            for (i = 0; i < loops; ++i) {
                x = fromX + 6.0f * scale * (float)i;
                painter.lineTo(x + 2.0f * scale, y + 1.0f * scale);
                painter.cubicTo(x + 2.0f * scale, y + 1.0f * scale, x + 3.0f * scale, y, x + 4.0f * scale, y + 1.0f * scale);
                painter.lineTo(x + 6.0f * scale, y + 3.0f * scale);
            }
            painter.lineTo(x + 7.0f * scale, y + 2.0f * scale);
            painter.cubicTo(x + 7.0f * scale, y + 2.0f * scale, x + 8.0f * scale, y + 2.0f * scale, x + 7.0f * scale, y + 3.0f * scale);
            for (i = loops - 1; i >= 0; --i) {
                x = fromX + 6.0f * scale * (float)i;
                painter.lineTo(x + 6.0f * scale, y + 4.0f * scale);
                painter.cubicTo(x + 6.0f * scale, y + 4.0f * scale, x + 5.0f * scale, y + 5.0f * scale, x + 4.0f * scale, y + 4.0f * scale);
                painter.lineTo(x + 2.0f * scale, y + 2.0f * scale);
                painter.lineTo(x + 1.0f * scale, y + 3.0f * scale);
            }
            painter.cubicTo(x + 1.0f * scale, y + 3.0f * scale, x, y + 3.0f * scale, x + 1.0f * scale, y + 2.0f * scale);
            painter.lineTo(x + 2.0f * scale, y + 1.0f * scale);
            painter.closePath();
        }
    }

    private void paintTrill(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        String string = "Tr";
        float fmWidth = painter.getFMWidth(string);
        float scale = layout.getScale();
        float x = fromX + fmWidth;
        float y = fromY + 4.0f * scale;
        float textY = fromY + 2.0f * scale + painter.getFMTopLine();
        float width = this.getVoiceImpl().getWidth() - fmWidth - 2.0f * scale;
        int loops = Math.round(width / (6.0f * scale));
        if (loops > 0) {
            int i;
            painter.drawString(string, fromX, textY);
            layout.setTabEffectStyle(painter);
            painter.setLineWidth(layout.getLineWidth(1));
            painter.initPath(2);
            painter.moveTo(x + 2.0f * scale, y + 1.0f * scale);
            for (i = 0; i < loops; ++i) {
                x = fromX + fmWidth + 6.0f * scale * (float)i;
                painter.lineTo(x + 2.0f * scale, y + 1.0f * scale);
                painter.cubicTo(x + 2.0f * scale, y + 1.0f * scale, x + 3.0f * scale, y, x + 4.0f * scale, y + 1.0f * scale);
                painter.lineTo(x + 6.0f * scale, y + 3.0f * scale);
            }
            painter.lineTo(x + 7.0f * scale, y + 2.0f * scale);
            painter.cubicTo(x + 7.0f * scale, y + 2.0f * scale, x + 8.0f * scale, y + 2.0f * scale, x + 7.0f * scale, y + 3.0f * scale);
            for (i = loops - 1; i >= 0; --i) {
                x = fromX + fmWidth + 6.0f * scale * (float)i;
                painter.lineTo(x + 6.0f * scale, y + 4.0f * scale);
                painter.cubicTo(x + 6.0f * scale, y + 4.0f * scale, x + 5.0f * scale, y + 5.0f * scale, x + 4.0f * scale, y + 4.0f * scale);
                painter.lineTo(x + 2.0f * scale, y + 2.0f * scale);
                painter.lineTo(x + 1.0f * scale, y + 3.0f * scale);
            }
            painter.cubicTo(x + 1.0f * scale, y + 3.0f * scale, x, y + 3.0f * scale, x + 1.0f * scale, y + 2.0f * scale);
            painter.lineTo(x + 2.0f * scale, y + 1.0f * scale);
            painter.closePath();
        }
    }

    private void paintFadeIn(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        float scale = layout.getScale();
        float x = fromX;
        float y = fromY + 4.0f * scale;
        float width = this.getVoiceImpl().getWidth();
        painter.setLineWidth(layout.getLineWidth(1));
        painter.initPath();
        painter.moveTo(x, y);
        painter.cubicTo(x, y, x + width, y, x + width, y - 4.0f * scale);
        painter.moveTo(x, y);
        painter.cubicTo(x, y, x + width, y, x + width, y + 4.0f * scale);
        painter.moveTo(x + width, y + 4.0f * scale);
        painter.closePath();
    }

    private void paintAccentuated(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        float scale = layout.getScale();
        float x = fromX;
        float y = fromY + 2.0f * scale;
        painter.setLineWidth(layout.getLineWidth(1));
        painter.initPath();
        painter.moveTo(x, y);
        painter.lineTo(x + 6.0f * scale, y + 2.5f * scale);
        painter.moveTo(x + 6.0f * scale, y + 2.5f * scale);
        painter.lineTo(x, y + 5.0f * scale);
        painter.closePath();
    }

    private void paintHeavyAccentuated(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        float scale = layout.getScale();
        float x = fromX;
        float y = fromY;
        painter.setLineWidth(layout.getLineWidth(1));
        painter.initPath();
        painter.moveTo(x, y + 5.0f * scale);
        painter.lineTo(x + 3.0f * scale, y + 1.0f * scale);
        painter.moveTo(x + 3.0f * scale, y + 1.0f * scale);
        painter.lineTo(x + 6.0f * scale, y + 5.0f * scale);
        painter.closePath();
    }

    public void fillBackground(TGLayout layout, UIPainter painter, UIMargin margin, float fromX, float fromY) {
        UIRectangle uiRectangle = new UIRectangle();
        uiRectangle.getPosition().setX(fromX - margin.getLeft());
        uiRectangle.getPosition().setY(fromY - margin.getTop());
        uiRectangle.getSize().setWidth(margin.getLeft() + margin.getRight());
        uiRectangle.getSize().setHeight(margin.getTop() + margin.getBottom());
        layout.fillBackground(painter, uiRectangle);
    }

    public String getNoteLabel(TGNote note) {
        String label = null;
        label = note.isTiedNote() ? "L" : (note.getEffect().isDeadNote() ? "X" : Integer.toString(note.getValue()));
        return note.getEffect().isGhostNote() ? "(" + label + ")" : label;
    }

    public int getRealValue() {
        return this.getValue() + this.getMeasureImpl().getTrack().getString(this.getString()).getValue();
    }

    public float getScorePosY() {
        return this.scorePosY;
    }

    public float getTabPosY() {
        return this.tabPosY;
    }

    public TGMeasureImpl getMeasureImpl() {
        return this.getBeatImpl().getMeasureImpl();
    }

    public float getPaintPosition(int index) {
        return this.getMeasureImpl().getTs().getPosition(index);
    }

    public TGBeatImpl getBeatImpl() {
        return this.getVoiceImpl().getBeatImpl();
    }

    public TGVoiceImpl getVoiceImpl() {
        return (TGVoiceImpl)super.getVoice();
    }

    public float getPosX() {
        return this.getBeatImpl().getPosX();
    }
}

