/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.base;

import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.player.base.MidiRepeatController;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;

public class MidiPlayerCountDown {
    public static final int DEFAULT_TEMPO_PERCENT = 100;
    private MidiPlayer player;
    private boolean enabled;
    private boolean running;
    private int tempoPercent;

    public MidiPlayerCountDown(MidiPlayer player) {
        this.player = player;
        this.enabled = false;
        this.tempoPercent = 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            TGMeasureHeader header;
            this.running = true;
            int channelId = this.player.getPercussionChannelId();
            if (channelId >= 0 && (header = this.findMeasureHeader()) != null) {
                Object timerLock = new Object();
                int tgTempo = header.getTempo().getValue() * this.getTempoPercent() / 100;
                long tgLength = header.getTimeSignature().getDenominator().getTime();
                long tickLength = (long)(1000.0 * (60.0 / (double)tgTempo * (double)tgLength) / 960.0);
                long tickStart = System.currentTimeMillis();
                int tickIndex = 0;
                int tickCount = header.getTimeSignature().getNumerator();
                while (this.isRunning() && tickIndex <= tickCount) {
                    Object object;
                    long currentTime = System.currentTimeMillis();
                    if (tickStart <= currentTime) {
                        tickStart += tickLength;
                        if (++tickIndex <= tickCount) {
                            this.player.getOutputTransmitter().sendNoteOn(channelId, 37, 95, -1, false);
                            object = timerLock;
                            synchronized (object) {
                                timerLock.wait(1L);
                            }
                            this.player.getOutputTransmitter().sendNoteOff(channelId, 37, 95, -1, false);
                        }
                    }
                    object = timerLock;
                    synchronized (object) {
                        timerLock.wait(10L);
                    }
                }
            }
            this.running = false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public TGMeasureHeader findMeasureHeader() {
        long startPoint;
        long tick = this.player.getTickPosition();
        long start = startPoint = this.player.getLoopSPosition();
        long length = 0L;
        TGSong song = this.player.getSong();
        MidiRepeatController controller = new MidiRepeatController(song, this.player.getLoopSHeader(), this.player.getLoopEHeader());
        while (!controller.finished()) {
            TGMeasureHeader header = song.getMeasureHeader(controller.getIndex());
            controller.process();
            if (!controller.shouldPlay() || tick < (start += (length = header.getLength())) || tick >= start + length) continue;
            return header;
        }
        return null;
    }

    public boolean isRunning() {
        return this.enabled && this.running && this.player.isRunning() && !this.player.isChangeTickPosition();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getTempoPercent() {
        return this.tempoPercent;
    }

    public void setTempoPercent(int tempoPercent) {
        this.tempoPercent = tempoPercent;
    }
}

