/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.base;

import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;

public class MidiRepeatController {
    private TGSong song;
    private int count;
    private int index;
    private int lastIndex;
    private boolean shouldPlay;
    private boolean repeatOpen;
    private long repeatStart;
    private long repeatEnd;
    private long repeatMove;
    private int repeatStartIndex;
    private int repeatNumber;
    private int repeatAlternative;
    private int sHeader;
    private int eHeader;

    public MidiRepeatController(TGSong song, int sHeader, int eHeader) {
        this.song = song;
        this.sHeader = sHeader;
        this.eHeader = eHeader;
        this.count = song.countMeasureHeaders();
        this.index = 0;
        this.lastIndex = -1;
        this.shouldPlay = true;
        this.repeatOpen = true;
        this.repeatAlternative = 0;
        this.repeatStart = 960L;
        this.repeatEnd = 0L;
        this.repeatMove = 0L;
        this.repeatStartIndex = 0;
        this.repeatNumber = 0;
    }

    public void process() {
        TGMeasureHeader header = this.song.getMeasureHeader(this.index);
        if (this.sHeader != -1 && header.getNumber() < this.sHeader || this.eHeader != -1 && header.getNumber() > this.eHeader) {
            this.shouldPlay = false;
            ++this.index;
            return;
        }
        if (this.sHeader != -1 && header.getNumber() == this.sHeader || header.getNumber() == 1) {
            this.repeatStartIndex = this.index;
            this.repeatStart = header.getStart();
            this.repeatOpen = true;
        }
        this.shouldPlay = true;
        if (header.isRepeatOpen()) {
            this.repeatStartIndex = this.index;
            this.repeatStart = header.getStart();
            this.repeatOpen = true;
            if (this.index > this.lastIndex) {
                this.repeatNumber = 0;
                this.repeatAlternative = 0;
            }
        } else {
            if (this.repeatAlternative == 0) {
                this.repeatAlternative = header.getRepeatAlternative();
            }
            if (this.repeatOpen && this.repeatAlternative > 0 && (this.repeatAlternative & 1 << this.repeatNumber) == 0) {
                this.repeatMove -= header.getLength();
                if (header.getRepeatClose() > 0) {
                    this.repeatAlternative = 0;
                }
                this.shouldPlay = false;
                ++this.index;
                return;
            }
        }
        this.lastIndex = Math.max(this.lastIndex, this.index);
        if (this.repeatOpen && header.getRepeatClose() > 0) {
            if (this.repeatNumber < header.getRepeatClose() || this.repeatAlternative > 0) {
                this.repeatEnd = header.getStart() + header.getLength();
                this.repeatMove += this.repeatEnd - this.repeatStart;
                this.index = this.repeatStartIndex - 1;
                ++this.repeatNumber;
            } else {
                this.repeatStart = 0L;
                this.repeatNumber = 0;
                this.repeatEnd = 0L;
                this.repeatOpen = false;
            }
            this.repeatAlternative = 0;
        }
        ++this.index;
    }

    public boolean finished() {
        return this.index >= this.count;
    }

    public boolean shouldPlay() {
        return this.shouldPlay;
    }

    public int getIndex() {
        return this.index;
    }

    public long getRepeatMove() {
        return this.repeatMove;
    }
}

