/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.managers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGMeasureManager;
import org.herac.tuxguitar.song.managers.TGTrackManager;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChannelNames;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGSongManager {
    public static final short MAX_CHANNELS = 16;
    public static final int[][] DEFAULT_TUNING_VALUES = new int[][]{{43, 38, 33, 28}, {43, 38, 33, 28, 23}, {64, 59, 55, 50, 45, 40}, {64, 59, 55, 50, 45, 40, 35}};
    private TGFactory factory;
    private TGTrackManager trackManager;
    private TGMeasureManager measureManager;

    public TGSongManager() {
        this(new TGFactory());
    }

    public TGSongManager(TGFactory factory) {
        this.factory = factory;
    }

    public TGFactory getFactory() {
        return this.factory;
    }

    public void setFactory(TGFactory factory) {
        this.factory = factory;
    }

    public TGTrackManager getTrackManager() {
        if (this.trackManager == null) {
            this.trackManager = new TGTrackManager(this);
        }
        return this.trackManager;
    }

    public TGMeasureManager getMeasureManager() {
        if (this.measureManager == null) {
            this.measureManager = new TGMeasureManager(this);
        }
        return this.measureManager;
    }

    public void setSongName(TGSong song, String name) {
        song.setName(name);
    }

    public void setProperties(TGSong song, String name, String artist, String album, String author, String date, String copyright, String writer, String transcriber, String comments) {
        song.setName(name);
        song.setArtist(artist);
        song.setAlbum(album);
        song.setAuthor(author);
        song.setDate(date);
        song.setCopyright(copyright);
        song.setWriter(writer);
        song.setTranscriber(transcriber);
        song.setComments(comments);
    }

    public void clearSong(TGSong song) {
        song.clear();
    }

    public void fillSong(TGSong song) {
        TGChannel channel = this.getFactory().newChannel();
        channel.setChannelId(1);
        channel.setName(this.createDefaultChannelName(song, channel));
        TGMeasureHeader header = this.getFactory().newHeader();
        header.setNumber(1);
        header.setStart(960L);
        header.getTimeSignature().setNumerator(4);
        header.getTimeSignature().getDenominator().setValue(4);
        TGTrack track = this.getFactory().newTrack();
        track.setNumber(1);
        track.setName(this.getDefaultTrackName(track));
        track.setChannelId(channel.getChannelId());
        track.setStrings(this.createDefaultInstrumentStrings());
        track.addMeasure(this.getFactory().newMeasure(header));
        track.getColor().copyFrom(TGColor.RED);
        song.addChannel(channel);
        song.addMeasureHeader(header);
        song.addTrack(track);
    }

    public TGSong newSong() {
        TGSong song = this.getFactory().newSong();
        this.fillSong(song);
        return song;
    }

    public void copySongFrom(TGSong song, TGSong from) {
        song.copyFrom(this.getFactory(), from);
    }

    public TGChannel createChannel() {
        return this.getFactory().newChannel();
    }

    public TGChannel addChannel(TGSong tgSong) {
        TGChannel tgChannel = this.addChannel(tgSong, this.createChannel());
        tgChannel.setName(this.createDefaultChannelName(tgSong, tgChannel));
        return tgChannel;
    }

    public TGChannel addChannel(TGSong song, TGChannel tgChannel) {
        if (tgChannel != null) {
            if (tgChannel.getChannelId() <= 0) {
                tgChannel.setChannelId(this.getNextChannelId(song));
            }
            song.addChannel(tgChannel);
        }
        return tgChannel;
    }

    public void removeChannel(TGSong song, TGChannel channel) {
        if (channel != null) {
            song.removeChannel(channel);
        }
    }

    public void removeChannel(TGSong song, int channelId) {
        TGChannel channel = this.getChannel(song, channelId);
        if (channel != null) {
            this.removeChannel(song, channel);
        }
    }

    public void removeAllChannels(TGSong song) {
        while (song.countChannels() > 0) {
            this.removeChannel(song, song.getChannel(0));
        }
    }

    public TGChannel getChannel(TGSong song, int channelId) {
        Iterator<TGChannel> it = song.getChannels();
        while (it.hasNext()) {
            TGChannel channel = it.next();
            if (channel.getChannelId() != channelId) continue;
            return channel;
        }
        return null;
    }

    public List<TGChannel> getChannels(TGSong song) {
        ArrayList<TGChannel> channels = new ArrayList<TGChannel>();
        Iterator<TGChannel> it = song.getChannels();
        while (it.hasNext()) {
            channels.add(it.next());
        }
        return channels;
    }

    public List<TGChannel> findChannelsByName(TGSong song, String name) {
        ArrayList<TGChannel> channels = new ArrayList<TGChannel>();
        Iterator<TGChannel> it = song.getChannels();
        while (it.hasNext()) {
            TGChannel channel = it.next();
            if (!channel.getName().equals(name)) continue;
            channels.add(channel);
        }
        return channels;
    }

    public int getNextChannelId(TGSong song) {
        int maximumId = 0;
        Iterator<TGChannel> it = song.getChannels();
        while (it.hasNext()) {
            TGChannel channel = it.next();
            if (maximumId >= channel.getChannelId()) continue;
            maximumId = channel.getChannelId();
        }
        return maximumId + 1;
    }

    public TGChannel updateChannel(TGSong song, TGChannel source) {
        TGChannel channel = this.getChannel(song, source.getChannelId());
        if (channel != null) {
            channel.copyFrom(this.getFactory(), source);
        }
        return channel;
    }

    public boolean isPercussionChannel(TGSong song, int channelId) {
        TGChannel channel = this.getChannel(song, channelId);
        if (channel != null) {
            return channel.isPercussionChannel();
        }
        return false;
    }

    public boolean isAnyPercussionChannel(TGSong song) {
        Iterator<TGChannel> it = song.getChannels();
        while (it.hasNext()) {
            TGChannel channel = it.next();
            if (!channel.isPercussionChannel()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyTrackConnectedToChannel(TGSong song, int channelId) {
        Iterator<TGTrack> it = song.getTracks();
        while (it.hasNext()) {
            TGTrack track = it.next();
            if (track.getChannelId() != channelId) continue;
            return true;
        }
        return false;
    }

    public String createChannelName(TGSong song, TGChannel channel, String prefix) {
        int number = 0;
        String unusedName = null;
        while (unusedName == null) {
            String name = prefix + " " + ++number;
            if (!this.findChannelsByName(song, name).isEmpty()) continue;
            unusedName = name;
        }
        return unusedName;
    }

    public String createDefaultChannelName(TGSong song, TGChannel channel) {
        return this.createChannelName(song, channel, "Unnamed");
    }

    public String createChannelNameFromProgram(TGSong song, TGChannel channel) {
        if (channel.getProgram() >= 0 && channel.getProgram() < TGChannelNames.DEFAULT_NAMES.length) {
            return this.createChannelName(song, channel, TGChannelNames.DEFAULT_NAMES[channel.getProgram()]);
        }
        return this.createDefaultChannelName(song, channel);
    }

    private TGTrack createTrack(TGSong song) {
        TGTrack tgTrack = this.getFactory().newTrack();
        tgTrack.setNumber(this.getNextTrackNumber(song));
        tgTrack.setName(this.getDefaultTrackName(tgTrack));
        Iterator<TGMeasureHeader> it = song.getMeasureHeaders();
        while (it.hasNext()) {
            TGMeasureHeader header = it.next();
            TGMeasure measure = this.getFactory().newMeasure(header);
            tgTrack.addMeasure(measure);
        }
        tgTrack.setStrings(this.createDefaultInstrumentStrings());
        tgTrack.getColor().copyFrom(TGColor.RED);
        return tgTrack;
    }

    public TGTrack addTrack(TGSong song) {
        if (song.isEmpty()) {
            this.fillSong(song);
            return this.getLastTrack(song);
        }
        TGChannel tgChannel = this.addChannel(song);
        tgChannel.setName(this.createChannelNameFromProgram(song, tgChannel));
        TGTrack tgTrack = this.createTrack(song);
        tgTrack.setChannelId(tgChannel.getChannelId());
        this.addTrack(song, tgTrack);
        return tgTrack;
    }

    public void addTrack(TGSong song, TGTrack trackToAdd) {
        this.orderTracks(song);
        int addIndex = -1;
        for (int i = 0; i < song.countTracks(); ++i) {
            TGTrack track = song.getTrack(i);
            if (addIndex == -1 && track.getNumber() == trackToAdd.getNumber()) {
                addIndex = i;
            }
            if (addIndex < 0) continue;
            track.setNumber(track.getNumber() + 1);
        }
        if (addIndex < 0) {
            addIndex = song.countTracks();
        }
        song.addTrack(addIndex, trackToAdd);
    }

    public void removeTrack(TGSong song, TGTrack track) {
        this.removeTrack(song, track.getNumber());
    }

    public void removeTrack(TGSong song, int number) {
        int nextNumber = number;
        TGTrack trackToRemove = null;
        this.orderTracks(song);
        Iterator<TGTrack> it = song.getTracks();
        while (it.hasNext()) {
            TGTrack currTrack = it.next();
            if (trackToRemove == null && currTrack.getNumber() == nextNumber) {
                trackToRemove = currTrack;
                continue;
            }
            if (currTrack.getNumber() != nextNumber + 1) continue;
            currTrack.setNumber(nextNumber);
            ++nextNumber;
        }
        song.removeTrack(trackToRemove);
    }

    private void orderTracks(TGSong song) {
        for (int i = 0; i < song.countTracks(); ++i) {
            TGTrack minTrack = null;
            for (int trackIdx = i; trackIdx < song.countTracks(); ++trackIdx) {
                TGTrack track = song.getTrack(trackIdx);
                if (minTrack != null && track.getNumber() >= minTrack.getNumber()) continue;
                minTrack = track;
            }
            song.moveTrack(i, minTrack);
        }
    }

    public TGTrack getTrack(TGSong song, int number) {
        TGTrack track = null;
        for (int i = 0; i < song.countTracks(); ++i) {
            TGTrack currTrack = song.getTrack(i);
            if (currTrack.getNumber() != number) continue;
            track = currTrack;
            break;
        }
        return track;
    }

    public TGTrack getFirstTrack(TGSong song) {
        TGTrack track = null;
        if (!song.isEmpty()) {
            track = song.getTrack(0);
        }
        return track;
    }

    public TGTrack getLastTrack(TGSong song) {
        TGTrack track = null;
        if (!song.isEmpty()) {
            track = song.getTrack(song.countTracks() - 1);
        }
        return track;
    }

    public int getNextTrackNumber(TGSong song) {
        return song.countTracks() + 1;
    }

    public String getDefaultTrackName(TGTrack tgTrack) {
        if (tgTrack != null && tgTrack.getNumber() > 0) {
            return new String("Track " + tgTrack.getNumber());
        }
        return new String();
    }

    public TGTrack cloneTrack(TGSong song, TGTrack track) {
        TGTrack clone = track.clone(this.getFactory(), song);
        clone.setNumber(this.getNextTrackNumber(song));
        this.addTrack(song, clone);
        return clone;
    }

    public boolean moveTrackUp(TGSong song, TGTrack track) {
        if (track.getNumber() > 1) {
            TGTrack prevTrack = this.getTrack(song, track.getNumber() - 1);
            prevTrack.setNumber(prevTrack.getNumber() + 1);
            track.setNumber(track.getNumber() - 1);
            this.orderTracks(song);
            return true;
        }
        return false;
    }

    public boolean moveTrackDown(TGSong song, TGTrack track) {
        if (track.getNumber() < song.countTracks()) {
            TGTrack nextTrack = this.getTrack(song, track.getNumber() + 1);
            nextTrack.setNumber(nextTrack.getNumber() - 1);
            track.setNumber(track.getNumber() + 1);
            this.orderTracks(song);
            return true;
        }
        return false;
    }

    public void changeTimeSignature(TGSong song, long start, TGTimeSignature timeSignature, boolean toEnd) {
        this.changeTimeSignature(song, this.getMeasureHeaderAt(song, start), timeSignature, toEnd);
    }

    public void changeTimeSignature(TGSong song, TGMeasureHeader header, TGTimeSignature timeSignature, boolean toEnd) {
        header.getTimeSignature().copyFrom(timeSignature);
        long nextStart = header.getStart() + header.getLength();
        List<TGMeasureHeader> measures = this.getMeasureHeadersBeforeEnd(song, header.getStart() + 1L);
        for (TGMeasureHeader nextHeader : measures) {
            long theMove = nextStart - nextHeader.getStart();
            this.moveMeasureHeader(nextHeader, theMove, 0);
            if (toEnd) {
                nextHeader.getTimeSignature().copyFrom(timeSignature);
            }
            nextStart = nextHeader.getStart() + nextHeader.getLength();
        }
        this.moveOutOfBoundsBeatsToNewMeasure(song, header.getStart());
    }

    public void moveOutOfBoundsBeatsToNewMeasure(TGSong song, long start) {
        Iterator<TGTrack> it = song.getTracks();
        while (it.hasNext()) {
            TGTrack track = it.next();
            this.getTrackManager().moveOutOfBoundsBeatsToNewMeasure(track, start);
        }
    }

    public void changeTripletFeel(TGSong song, long start, int tripletFeel, boolean toEnd) {
        this.changeTripletFeel(song, this.getMeasureHeaderAt(song, start), tripletFeel, toEnd);
    }

    public void changeTripletFeel(TGSong song, TGMeasureHeader header, int tripletFeel, boolean toEnd) {
        header.setTripletFeel(tripletFeel);
        if (toEnd) {
            List<TGMeasureHeader> measures = this.getMeasureHeadersBeforeEnd(song, header.getStart() + 1L);
            for (TGMeasureHeader nextHeader : measures) {
                nextHeader.setTripletFeel(tripletFeel);
            }
        }
    }

    public void changeTempos(TGSong song, long start, TGTempo tempo, boolean toEnd) {
        this.changeTempos(song, this.getMeasureHeaderAt(song, start), tempo, toEnd);
    }

    public void changeTempos(TGSong song, TGMeasureHeader header, TGTempo tempo, boolean toEnd) {
        int oldValue = header.getTempo().getValue();
        for (TGMeasureHeader nextHeader : this.getMeasureHeadersAfter(song, header.getNumber() - 1)) {
            if (!toEnd && nextHeader.getTempo().getValue() != oldValue) break;
            this.changeTempo(nextHeader, tempo);
        }
    }

    public void changeTempos(TGSong song, List<TGTempo> tempos) {
        int length = tempos.size();
        if (length != song.countMeasureHeaders()) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            TGTempo tempo = tempos.get(i);
            TGMeasureHeader header = this.getMeasureHeader(song, i + 1);
            this.changeTempo(header, tempo);
        }
    }

    public void changeTempo(TGMeasureHeader header, TGTempo tempo) {
        header.getTempo().copyFrom(tempo);
    }

    public void changeOpenRepeat(TGSong song, long start) {
        TGMeasureHeader header;
        header.setRepeatOpen(!(header = this.getMeasureHeaderAt(song, start)).isRepeatOpen());
    }

    public void changeCloseRepeat(TGSong song, long start, int repeatClose) {
        TGMeasureHeader header = this.getMeasureHeaderAt(song, start);
        header.setRepeatClose(repeatClose);
    }

    public void changeAlternativeRepeat(TGSong song, long start, int repeatAlternative) {
        TGMeasureHeader header = this.getMeasureHeaderAt(song, start);
        header.setRepeatAlternative(repeatAlternative);
    }

    public TGMeasureHeader addNewMeasureBeforeEnd(TGSong song) {
        TGMeasureHeader lastHeader = this.getLastMeasureHeader(song);
        TGMeasureHeader header = this.getFactory().newHeader();
        header.setNumber(lastHeader.getNumber() + 1);
        header.setStart(lastHeader.getStart() + lastHeader.getLength());
        header.setRepeatOpen(false);
        header.setRepeatClose(0);
        header.setTripletFeel(lastHeader.getTripletFeel());
        header.getTimeSignature().copyFrom(lastHeader.getTimeSignature());
        header.getTempo().copyFrom(lastHeader.getTempo());
        song.addMeasureHeader(header);
        Iterator<TGTrack> it = song.getTracks();
        while (it.hasNext()) {
            TGTrack track = it.next();
            this.getTrackManager().addNewMeasureBeforeEnd(track, header);
        }
        return header;
    }

    public void addNewMeasure(TGSong song, int number) {
        TGMeasureHeader header = null;
        if (number == 1) {
            header = this.getMeasureHeader(song, number).clone(this.getFactory());
        } else {
            header = this.getMeasureHeader(song, number - 1).clone(this.getFactory());
            header.setStart(header.getStart() + header.getLength());
            header.setNumber(header.getNumber() + 1);
        }
        header.setMarker(null);
        header.setRepeatOpen(false);
        header.setRepeatAlternative(0);
        header.setRepeatClose(0);
        TGMeasureHeader nextHeader = this.getMeasureHeader(song, number);
        if (nextHeader != null) {
            this.moveMeasureHeaders(song, this.getMeasureHeadersBeforeEnd(song, nextHeader.getStart()), header.getLength(), 1, true);
        }
        this.addMeasureHeader(song, header.getNumber() - 1, header);
        Iterator<TGTrack> it = song.getTracks();
        while (it.hasNext()) {
            TGTrack track = it.next();
            this.getTrackManager().addNewMeasure(track, header);
        }
    }

    public List<TGMeasure> getMeasures(TGSong song, long start) {
        ArrayList<TGMeasure> measures = new ArrayList<TGMeasure>();
        Iterator<TGTrack> it = song.getTracks();
        while (it.hasNext()) {
            TGTrack track = it.next();
            TGMeasure measure = this.getTrackManager().getMeasureAt(track, start);
            if (measure == null) continue;
            measures.add(measure);
        }
        return measures;
    }

    public void copyTrackFrom(TGSong song, TGTrack track, TGTrack from) {
        while (song.countMeasureHeaders() < from.countMeasures()) {
            this.addNewMeasureBeforeEnd(song);
        }
        while (song.countMeasureHeaders() > from.countMeasures()) {
            this.removeLastMeasureHeader(song);
        }
        track.copyFrom(this.getFactory(), song, from);
    }

    public TGTrack replaceTrack(TGSong song, TGTrack track) {
        TGTrack current = this.getTrack(song, track.getNumber());
        if (current != null) {
            this.copyTrackFrom(song, current, track);
        }
        return current;
    }

    public TGMeasureHeader getFirstMeasureHeader(TGSong song) {
        TGMeasureHeader firstHeader = null;
        for (int i = 0; i < song.countMeasureHeaders(); ++i) {
            TGMeasureHeader currHeader = song.getMeasureHeader(i);
            if (firstHeader != null && currHeader.getStart() >= firstHeader.getStart()) continue;
            firstHeader = currHeader;
        }
        return firstHeader;
    }

    public TGMeasureHeader getLastMeasureHeader(TGSong song) {
        int lastIndex = song.countMeasureHeaders() - 1;
        return song.getMeasureHeader(lastIndex);
    }

    public TGMeasureHeader getPrevMeasureHeader(TGSong song, TGMeasureHeader header) {
        int prevIndex = header.getNumber() - 1;
        if (prevIndex > 0) {
            return song.getMeasureHeader(prevIndex - 1);
        }
        return null;
    }

    public TGMeasureHeader getNextMeasureHeader(TGSong song, TGMeasureHeader header) {
        int nextIndex = header.getNumber();
        if (nextIndex < song.countMeasureHeaders()) {
            return song.getMeasureHeader(nextIndex);
        }
        return null;
    }

    public TGMeasureHeader getMeasureHeaderAt(TGSong song, long start) {
        Iterator<TGMeasureHeader> it = song.getMeasureHeaders();
        while (it.hasNext()) {
            TGMeasureHeader header = it.next();
            long measureStart = header.getStart();
            long measureLength = header.getLength();
            if (start < measureStart || start >= measureStart + measureLength) continue;
            return header;
        }
        return null;
    }

    public TGMeasureHeader getMeasureHeader(TGSong song, int number) {
        for (int i = 0; i < song.countMeasureHeaders(); ++i) {
            TGMeasureHeader header = song.getMeasureHeader(i);
            if (header.getNumber() != number) continue;
            return header;
        }
        return null;
    }

    public int getMeasureHeaderIndex(TGSong song, TGMeasureHeader mh) {
        for (int i = 0; i < song.countMeasureHeaders(); ++i) {
            TGMeasureHeader header = song.getMeasureHeader(i);
            if (header.getNumber() != mh.getNumber()) continue;
            return i;
        }
        return -1;
    }

    public List<TGMeasureHeader> getMeasureHeadersBeforeEnd(TGSong song, long fromStart) {
        ArrayList<TGMeasureHeader> headers = new ArrayList<TGMeasureHeader>();
        Iterator<TGMeasureHeader> it = song.getMeasureHeaders();
        while (it.hasNext()) {
            TGMeasureHeader header = it.next();
            if (header.getStart() < fromStart) continue;
            headers.add(header);
        }
        return headers;
    }

    public List<TGMeasureHeader> getMeasureHeadersAfter(TGSong song, int number) {
        ArrayList<TGMeasureHeader> headers = new ArrayList<TGMeasureHeader>();
        Iterator<TGMeasureHeader> it = song.getMeasureHeaders();
        while (it.hasNext()) {
            TGMeasureHeader header = it.next();
            if (header.getNumber() <= number) continue;
            headers.add(header);
        }
        return headers;
    }

    public List<TGMeasureHeader> getMeasureHeadersBetween(TGSong song, long p1, long p2) {
        ArrayList<TGMeasureHeader> headers = new ArrayList<TGMeasureHeader>();
        Iterator<TGMeasureHeader> it = song.getMeasureHeaders();
        while (it.hasNext()) {
            TGMeasureHeader header = it.next();
            if (header.getStart() + header.getLength() <= p1 || header.getStart() >= p2) continue;
            headers.add(header);
        }
        return headers;
    }

    public void removeLastMeasure(TGSong song) {
        this.removeLastMeasureHeader(song);
    }

    public void removeMeasure(TGSong song, long start) {
        this.removeMeasureHeader(song, start);
    }

    public void removeMeasure(TGSong song, int number) {
        this.removeMeasureHeader(song, number);
    }

    public void addMeasureHeader(TGSong song, TGMeasureHeader measure) {
        song.addMeasureHeader(measure);
    }

    public void addMeasureHeader(TGSong song, int index, TGMeasureHeader measure) {
        song.addMeasureHeader(index, measure);
    }

    public void removeMeasureHeaders(TGSong song, int n1, int n2) {
        for (int i = n1; i <= n2; ++i) {
            TGMeasureHeader measure = this.getMeasureHeader(song, n1);
            this.removeMeasureHeader(song, measure);
        }
    }

    public void removeLastMeasureHeader(TGSong song) {
        this.removeMeasureHeader(song, this.getLastMeasureHeader(song));
    }

    public void removeMeasureHeader(TGSong song, long start) {
        this.removeMeasureHeader(song, this.getMeasureHeaderAt(song, start));
    }

    public void removeMeasureHeader(TGSong song, int number) {
        this.removeMeasureHeader(song, this.getMeasureHeader(song, number));
    }

    public void removeMeasureHeader(TGSong song, TGMeasureHeader header) {
        long start = header.getStart();
        long length = header.getLength();
        Iterator<TGTrack> it = song.getTracks();
        while (it.hasNext()) {
            TGTrack track = it.next();
            this.getTrackManager().removeMeasure(track, start);
        }
        this.moveMeasureHeaders(song, this.getMeasureHeadersBeforeEnd(song, start + 1L), -length, -1, true);
        song.removeMeasureHeader(header.getNumber() - 1);
    }

    public TGMeasureHeader replaceMeasureHeader(TGSong song, TGMeasureHeader newHeader) {
        TGMeasureHeader header = this.getMeasureHeaderAt(song, newHeader.getStart());
        int number = header.getNumber();
        this.copyMeasureHeaderFrom(song, header, newHeader);
        header.setNumber(number);
        return header;
    }

    public void copyMeasureHeaderFrom(TGSong song, TGMeasureHeader header, TGMeasureHeader from) {
        header.copyFrom(this.getFactory(), from);
    }

    public void moveMeasureHeaders(TGSong song, List<TGMeasureHeader> headers, long theMove, int numberMove, boolean moveComponents) {
        if (moveComponents) {
            for (TGMeasureHeader header : headers) {
                this.moveMeasureComponents(song, header, theMove);
            }
        }
        for (TGMeasureHeader header : headers) {
            this.moveMeasureHeader(header, theMove, numberMove);
        }
    }

    public void moveMeasureHeader(TGMeasureHeader header, long theMove, int numberMove) {
        header.setNumber(header.getNumber() + numberMove);
        header.setStart(header.getStart() + theMove);
    }

    public void moveMeasureComponents(TGSong song, TGMeasureHeader header, long theMove) {
        Iterator<TGTrack> it = song.getTracks();
        while (it.hasNext()) {
            TGTrack track = it.next();
            this.getTrackManager().moveMeasure(this.getTrackManager().getMeasure(track, header.getNumber()), theMove);
        }
    }

    public boolean isAtPosition(TGMeasureHeader header, long start) {
        return start >= header.getStart() && start < header.getStart() + header.getLength();
    }

    public TGMarker updateMarker(TGSong song, int measure, String title, TGColor color) {
        TGMeasureHeader header = this.getMeasureHeader(song, measure);
        if (header != null) {
            if (!header.hasMarker()) {
                header.setMarker(this.getFactory().newMarker());
            }
            header.getMarker().setMeasure(measure);
            header.getMarker().setTitle(title);
            header.getMarker().getColor().setR(color.getR());
            header.getMarker().getColor().setG(color.getG());
            header.getMarker().getColor().setB(color.getB());
            return header.getMarker();
        }
        return null;
    }

    public TGMarker updateMarker(TGSong song, TGMarker marker) {
        return this.updateMarker(song, marker.getMeasure(), marker.getTitle(), marker.getColor());
    }

    public void removeMarker(TGSong song, TGMarker marker) {
        if (marker != null) {
            this.removeMarker(song, marker.getMeasure());
        }
    }

    public void removeMarker(TGSong song, int number) {
        TGMeasureHeader header = this.getMeasureHeader(song, number);
        if (header != null && header.hasMarker()) {
            header.setMarker(null);
        }
    }

    public void removeAllMarkers(TGSong song) {
        Iterator<TGMeasureHeader> it = song.getMeasureHeaders();
        while (it.hasNext()) {
            TGMeasureHeader header = it.next();
            if (!header.hasMarker()) continue;
            header.setMarker(null);
        }
    }

    public List<TGMarker> getMarkers(TGSong song) {
        ArrayList<TGMarker> markers = new ArrayList<TGMarker>();
        Iterator<TGMeasureHeader> it = song.getMeasureHeaders();
        while (it.hasNext()) {
            TGMeasureHeader header = it.next();
            if (!header.hasMarker()) continue;
            markers.add(header.getMarker());
        }
        return markers;
    }

    public TGMarker getMarker(TGSong song, int number) {
        TGMeasureHeader header = this.getMeasureHeader(song, number);
        if (header != null && header.hasMarker()) {
            return header.getMarker();
        }
        return null;
    }

    public TGMarker getPreviousMarker(TGSong song, int from) {
        TGMeasureHeader previous = null;
        Iterator<TGMeasureHeader> it = song.getMeasureHeaders();
        while (it.hasNext()) {
            TGMeasureHeader header = it.next();
            if (!header.hasMarker() || header.getNumber() >= from || previous != null && previous.getNumber() >= header.getNumber()) continue;
            previous = header;
        }
        return previous != null ? previous.getMarker() : null;
    }

    public TGMarker getNextMarker(TGSong song, int from) {
        TGMeasureHeader next = null;
        Iterator<TGMeasureHeader> it = song.getMeasureHeaders();
        while (it.hasNext()) {
            TGMeasureHeader header = it.next();
            if (!header.hasMarker() || header.getNumber() <= from || next != null && next.getNumber() <= header.getNumber()) continue;
            next = header;
        }
        return next != null ? next.getMarker() : null;
    }

    public TGMarker getFirstMarker(TGSong song) {
        TGMeasureHeader first = null;
        Iterator<TGMeasureHeader> it = song.getMeasureHeaders();
        while (it.hasNext()) {
            TGMeasureHeader header = it.next();
            if (!header.hasMarker() || first != null && header.getNumber() >= first.getNumber()) continue;
            first = header;
        }
        return first != null ? first.getMarker() : null;
    }

    public TGMarker getLastMarker(TGSong song) {
        TGMeasureHeader next = null;
        Iterator<TGMeasureHeader> it = song.getMeasureHeaders();
        while (it.hasNext()) {
            TGMeasureHeader header = it.next();
            if (!header.hasMarker() || next != null && header.getNumber() <= next.getNumber()) continue;
            next = header;
        }
        return next != null ? next.getMarker() : null;
    }

    public void autoCompleteSilences(TGSong song) {
        Iterator<TGTrack> it = song.getTracks();
        while (it.hasNext()) {
            TGTrack track = it.next();
            this.getTrackManager().autoCompleteSilences(track);
        }
    }

    public void orderBeats(TGSong song) {
        Iterator<TGTrack> it = song.getTracks();
        while (it.hasNext()) {
            TGTrack track = it.next();
            this.getTrackManager().orderBeats(track);
        }
    }

    public List<TGString> createDefaultInstrumentStrings() {
        return this.createDefaultInstrumentStrings(6);
    }

    public List<TGString> createDefaultPercussionStrings() {
        return this.createPercussionStrings(6);
    }

    public List<TGString> createDefaultInstrumentStrings(int stringCount) {
        return this.createStrings(stringCount, DEFAULT_TUNING_VALUES);
    }

    public List<TGString> createPercussionStrings(int stringCount) {
        return this.createStrings(stringCount, null);
    }

    public List<TGString> createStrings(int stringCount, int[][] defaultTunings) {
        int i;
        ArrayList<TGString> strings = new ArrayList<TGString>();
        if (defaultTunings != null) {
            for (i = 0; i < defaultTunings.length; ++i) {
                if (stringCount != defaultTunings[i].length) continue;
                for (int n = 0; n < defaultTunings[i].length; ++n) {
                    strings.add(TGSongManager.newString(this.getFactory(), n + 1, defaultTunings[i][n]));
                }
                break;
            }
        }
        if (strings.isEmpty()) {
            for (i = 1; i <= stringCount; ++i) {
                strings.add(TGSongManager.newString(this.getFactory(), i, 0));
            }
        }
        return strings;
    }

    public static TGString newString(TGFactory factory, int number, int value) {
        TGString string = factory.newString();
        string.setNumber(number);
        string.setValue(value);
        return string;
    }

    public static long getDivisionLength(TGMeasureHeader header) {
        long defaultLength = 960L;
        int denominator = header.getTimeSignature().getDenominator().getValue();
        switch (denominator) {
            case 8: {
                if (header.getTimeSignature().getNumerator() % 3 != 0) break;
                defaultLength += 480L;
            }
        }
        return defaultLength;
    }
}

