/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.thread;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.thread.TGThreadHandler;
import org.herac.tuxguitar.thread.TGThreadLoop;
import org.herac.tuxguitar.util.TGException;

public class TGMultiThreadHandler
implements TGThreadHandler,
Runnable {
    private static final int WORKER_COUNT = 10;
    private boolean running = true;
    private Object mutex = new Object();
    private List<Runnable> queue = new ArrayList<Runnable>();

    public TGMultiThreadHandler() {
        this.initialize();
    }

    public void initialize() {
        for (int i = 0; i < 10; ++i) {
            new Thread(this).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Runnable runnable) {
        Object object = this.mutex;
        synchronized (object) {
            this.queue.add(runnable);
        }
    }

    public void loop(final TGThreadLoop loop) {
        final Object mutex = new Object();
        this.start(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block6: {
                    try {
                        Long timeout = loop.process();
                        if (TGThreadLoop.BREAK.equals(timeout)) break block6;
                        if (timeout != null && timeout > 0L) {
                            Object object = mutex;
                            synchronized (object) {
                                mutex.wait(timeout);
                            }
                        }
                        TGMultiThreadHandler.this.start(this);
                    }
                    catch (InterruptedException e) {
                        throw new TGException(e.getMessage(), e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNext() {
        Runnable runnable = null;
        Object object = this.mutex;
        synchronized (object) {
            if (!this.queue.isEmpty()) {
                runnable = this.queue.remove(0);
            }
        }
        if (runnable != null) {
            runnable.run();
        }
    }

    public void run() {
        while (this.running || !this.queue.isEmpty()) {
            this.processNext();
            this.yield();
        }
    }

    public void yield() {
        Thread.yield();
    }

    public void dispose() {
        this.running = false;
    }

    public Object getThreadId() {
        return Thread.currentThread().getId();
    }
}

