/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.core.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.sdg.xdman.core.common.ChunkFileInfo;
import org.sdg.xdman.core.common.Connection;
import org.sdg.xdman.core.common.Credential;
import org.sdg.xdman.core.common.DownloadInfo;
import org.sdg.xdman.core.common.DownloadProgressListener;
import org.sdg.xdman.core.common.DownloadStateListner;
import org.sdg.xdman.core.common.HelpListener;
import org.sdg.xdman.core.common.HelperConnection;
import org.sdg.xdman.core.common.IXDMConstants;
import org.sdg.xdman.core.common.UnsupportedProtocolException;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.core.common.ftp.FTPConnection;
import org.sdg.xdman.core.common.http.HttpConnection;
import org.sdg.xdman.gui.AuthDialog;
import org.sdg.xdman.gui.DownloadWindow;
import org.sdg.xdman.gui.StringResource;
import org.sdg.xdman.util.MIMEUtil;
import org.sdg.xdman.util.XDMUtil;

public class ConnectionManager
implements IXDMConstants,
HelpListener {
    UUID id;
    public ArrayList<String> cookieList;
    public String referer;
    public String userAgent;
    boolean init = false;
    long length = -1L;
    long downloaded = 0L;
    String fileName = null;
    String finalFileName;
    private String url;
    List<Connection> list = new ArrayList<Connection>();
    int MAX_CHUNK = 8;
    int timeout = 60000;
    List<ChunkFileInfo> fileList = new ArrayList<ChunkFileInfo>();
    private String tempdir;
    private String destdir;
    int fileCounter = 0;
    Object lock = new Object();
    String statefileName = ".state";
    File statefile;
    public boolean stop = false;
    long startTime;
    long prevdownload;
    String resume_support = "---";
    String status = StringResource.getString("CONNECTING");
    int cnc = 0;
    public int state = 40;
    String category;
    File prevtempdir;
    boolean assembling = false;
    long assemble_len = 0L;
    XDMConfig config;
    int MIN_CHUNK_SZ = 8192;
    HelperConnection helper;
    public DownloadProgressListener prgListener;
    public DownloadStateListner dwnListener;
    public boolean overwrite = false;
    long pdwnld = 0L;
    long ptime = 0L;
    float prate = 0.0f;
    long lastTime = 0L;
    long lastSavedTime = 0L;
    long endTime;
    MIMEUtil mimeutil;
    private Credential creditential;

    public UUID getUUID() {
        return this.id;
    }

    public void setProgressListener(DownloadProgressListener pl) {
        this.prgListener = pl;
    }

    public void setTempdir(String tempdir) {
        this.tempdir = tempdir;
        this.prevtempdir = new File(tempdir);
    }

    public String getTempdir() {
        return this.tempdir;
    }

    public void setFileName(String file) {
        this.finalFileName = file;
    }

    public String getFileName() {
        return this.finalFileName;
    }

    public void setDestdir(String destdir) {
        this.destdir = destdir;
    }

    public String getDestdir() {
        return this.destdir;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public ConnectionManager(UUID id, String url, String file, String destdir, String tempdir, String userAgent, String referer, ArrayList<String> cookies, XDMConfig config) {
        this.id = id;
        this.setUrl(url);
        this.setDestdir(destdir);
        this.setTempdir(tempdir);
        this.statefile = new File(tempdir, this.statefileName);
        this.fileName = file;
        this.finalFileName = file;
        this.category = XDMUtil.findCategory(this.fileName);
        this.config = config;
        this.userAgent = userAgent;
        this.referer = referer;
        if (cookies != null) {
            this.cookieList = new ArrayList();
            this.cookieList.addAll(cookies);
        }
        this.timeout = config.timeout;
        this.MAX_CHUNK = config.maxConn;
    }

    private String getUniqueFileName(String dir, String f) {
        return XDMUtil.getUniqueFileName(dir, f);
    }

    private File getUniqueFolderName() {
        return new File(this.tempdir, UUID.randomUUID().toString());
    }

    public synchronized void connected(Connection c) throws UnsupportedProtocolException {
        if (++this.cnc > 1) {
            this.resume_support = StringResource.getString("YES");
        }
        if (!this.init) {
            boolean redirected = !this.url.equals(c.url);
            this.setUrl(c.url);
            this.length = c.getLength();
            if (c.content_disposition != null) {
                this.finalFileName = this.fileName = this.getFileName(c.content_disposition);
            } else {
                if (redirected) {
                    this.fileName = this.getFileName(this.getUrl());
                    this.fileName = this.getUniqueFileName(this.destdir, this.fileName);
                }
                System.out.println("Checking auto extension...");
                this.checkExt(c.content_type);
                if (!this.overwrite) {
                    this.fileName = this.getUniqueFileName(this.destdir, this.fileName);
                }
                this.finalFileName = this.fileName;
            }
            if (!this.overwrite) {
                this.fileName = this.getUniqueFileName(this.destdir, this.fileName);
            }
            File f = this.getUniqueFolderName();
            f.mkdirs();
            this.tempdir = f.getAbsolutePath();
            this.statefile = new File(this.tempdir, ".state");
            c.fileName = new File(this.tempdir, String.valueOf(0) + this.fileName).toString();
            this.category = XDMUtil.findCategory(this.fileName);
            this.init = true;
            int state2 = this.state;
            this.state = 70;
            this.updated();
            this.state = state2;
            this.updated();
        }
        this.saveState();
        this.createChunk();
        this.status = StringResource.getString("DOWNLOADING");
    }

    public synchronized void failed(String error, int errorCode) {
        if (this.state == 30) {
            return;
        }
        if (this.cnc < 2) {
            this.resume_support = StringResource.getString("NO");
        }
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get((int)i).status != 30) {
                return;
            }
            ++i;
        }
        if (errorCode == 3) {
            long dwn = 0L;
            int i2 = 0;
            while (i2 < this.list.size()) {
                dwn += this.list.get((int)i2).downloaded;
                ++i2;
            }
            if (dwn > 0L) {
                errorCode = 2;
            }
        }
        this.status = errorCode == 5 ? StringResource.getString(errMsg[errorCode]) : StringResource.getString(errMsg[errorCode]);
        this.state = 30;
        this.updated();
        if (this.dwnListener != null) {
            this.dwnListener.downloadFailed(this.getUUID());
        }
    }

    public void updated() {
        long time = System.currentTimeMillis();
        if (this.state == 50 || this.state == 40 || this.state == 30 || this.state == 70) {
            this.lastTime = 0L;
            this.lastSavedTime = 0L;
        }
        if (time - this.lastTime > 1000L) {
            this.lastTime = time;
            try {
                DownloadInfo info = new DownloadInfo();
                info.id = this.id;
                info.path = new File(this.tempdir);
                info.url = this.getUrl();
                info.file = this.finalFileName;
                int sz = this.list.size() + this.fileList.size();
                long[] len = new long[sz];
                long[] start = new long[sz];
                long[] dwn = new long[sz];
                String stat = this.status;
                int k = 0;
                long dwnld = 0L;
                info.rlen = this.length;
                int i = 0;
                while (i < this.fileList.size()) {
                    ChunkFileInfo cinfo = this.fileList.get(i);
                    len[k] = cinfo.len;
                    start[k] = cinfo.start;
                    dwn[k] = cinfo.len;
                    dwnld += dwn[k];
                    ++k;
                    ++i;
                }
                info.stat = new String[this.list.size()];
                info.dwnld = new String[this.list.size()];
                i = 0;
                while (i < this.list.size()) {
                    Connection c = this.list.get(i);
                    len[k] = c.getLength();
                    start[k] = c.getStartOff();
                    dwn[k] = c.getDownloaded();
                    dwnld += dwn[k];
                    info.stat[i] = c.message;
                    info.dwnld[i] = XDMUtil.getFormattedLength(c.getDownloaded());
                    ++k;
                    ++i;
                }
                if (dwnld > this.length) {
                    dwnld = this.length;
                }
                info.rdwn = dwnld;
                info.len = len;
                info.startoff = start;
                info.dwn = dwn;
                info.length = XDMUtil.getFormattedLength(this.length);
                info.downloaded = XDMUtil.getFormattedLength(dwnld);
                long diff = dwnld - this.prevdownload;
                long dt = time - this.startTime;
                if (dt != 0L) {
                    float rate = (float)diff / (float)dt * 1000.0f;
                    info.eta = XDMUtil.getETA(this.length - dwnld, rate);
                }
                float rte = 0.0f;
                int m = 0;
                while (m < this.list.size()) {
                    rte += this.list.get((int)m).rate;
                    ++m;
                }
                info.speed = String.valueOf(XDMUtil.getFormattedLength(rte)) + "/sec";
                if (this.assembling) {
                    info.eta = "";
                    info.speed = "";
                }
                info.resume = this.resume_support;
                info.status = stat;
                float prg = 0.0f;
                if (!this.assembling) {
                    prg = this.length <= 0L ? 0.0f : (float)dwnld / (float)this.length * 100.0f;
                } else if (this.length > 0L) {
                    prg = (float)this.assemble_len / (float)this.length * 100.0f;
                }
                info.prg = (int)prg;
                info.progress = String.format("%.3f", Float.valueOf(prg));
                info.state = this.state;
                info.msg = this.status;
                info.category = this.category;
                info.tempdir = this.tempdir;
                if (this.prgListener != null && this.prgListener.isValidWindow()) {
                    this.prgListener.update(info);
                }
                if (this.dwnListener != null) {
                    if (this.state == 70) {
                        this.dwnListener.downloadConfirmed(this.id, info);
                    } else {
                        this.dwnListener.updateManager(this.id, info);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (time - this.lastSavedTime > 5000L) {
            try {
                if (this.state != 50) {
                    this.saveState();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lastSavedTime = time;
        }
    }

    void connect(String url, String fileName, long startOff, long length, long contentLength, int timeout) throws UnsupportedProtocolException {
        if (url.startsWith("ftp://")) {
            FTPConnection c = new FTPConnection(url, fileName, startOff, length, contentLength, timeout, this, this.lock, this.creditential, this.config);
            this.list.add(c);
            c.start();
        } else if (url.startsWith("http")) {
            HttpConnection c = new HttpConnection(url, fileName, startOff, length, contentLength, this, this.lock, this.creditential, this.config);
            this.list.add(c);
            c.start();
        } else {
            throw new UnsupportedProtocolException();
        }
    }

    String getFileName(String url) {
        String file = null;
        try {
            file = XDMUtil.getFileName(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null || file.length() < 1) {
            file = "FILE";
        }
        return file;
    }

    /*
     * Exception decompiling
     */
    synchronized void createChunk() throws UnsupportedProtocolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Connection findChunk() {
        long len = -9999L;
        Connection c = null;
        int i = 0;
        while (i < this.list.size()) {
            Connection cl = this.list.get(i);
            long diff = cl.getLength() - cl.getDownloaded();
            if (diff > len && diff > 0L) {
                len = diff;
                c = cl;
            }
            ++i;
        }
        if (len < (long)this.MIN_CHUNK_SZ) {
            return null;
        }
        return c;
    }

    Connection findNextChunk(long end) {
        int i = 0;
        while (i < this.list.size()) {
            Connection cl = this.list.get(i);
            if (cl.getStartOff() == end && cl.status != 20 && cl.getDownloaded() == 0L) {
                return cl;
            }
            ++i;
        }
        return null;
    }

    public synchronized boolean donwloadComplete(Connection c) throws UnsupportedProtocolException {
        this.saveState();
        if (this.length < 0L) {
            c.close();
            this.list.remove(c);
            this.fileList.add(new ChunkFileInfo(c.fileName, c.getStartOff(), c.getDownloaded()));
            this.downloaded += c.getDownloaded();
            this.length = this.downloaded;
            this.checkFinished();
            return true;
        }
        Connection nc = this.findNextChunk(c.getStartOff() + c.getLength());
        if (nc == null) {
            try {
                c.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fileList.add(new ChunkFileInfo(c.fileName, c.getStartOff(), c.getLength()));
            this.downloaded += c.getLength();
            this.list.remove(c);
            boolean finish = this.checkFinished();
            if (!finish) {
                this.createChunk();
                this.needsHelp();
            }
            return true;
        }
        this.list.remove(nc);
        nc.stop();
        c.setLength(c.getLength() + nc.getLength());
        this.createChunk();
        return false;
    }

    boolean checkFinished() {
        if (this.list.size() == 0 && this.length > -1L && this.downloaded == this.length) {
            this.assemble();
            return true;
        }
        return false;
    }

    void assemble() {
        this.status = StringResource.getString("ASSEMBLE_MSG");
        if (this.helper != null) {
            this.helper.stop();
        }
        this.assembling = true;
        this.updated();
        Collections.sort(this.fileList, new ChunkFileInfo());
        if (this.stop) {
            return;
        }
        try {
            ChunkFileInfo info;
            File outDir = new File(this.destdir);
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            if (!this.overwrite) {
                this.finalFileName = this.getUniqueFileName(this.destdir, this.finalFileName);
            }
            File outFile = new File(this.getDestdir(), this.finalFileName);
            FileOutputStream out = new FileOutputStream(outFile);
            int state2 = this.state;
            this.state = 70;
            this.updated();
            this.state = state2;
            this.updated();
            FileInputStream in = null;
            int count = 0;
            long MB = 0x100000L;
            int i = 0;
            while (i < this.fileList.size()) {
                info = this.fileList.get(i);
                System.out.println("Reading..." + info.file);
                in = new FileInputStream(info.file);
                long rem = info.len;
                byte[] buf = new byte[65536];
                do {
                    int x;
                    int r;
                    if ((r = ((InputStream)in).read(buf, 0, x = (int)(rem > (long)buf.length ? (long)buf.length : rem))) == -1) {
                        throw new IllegalArgumentException("Assemble EOF");
                    }
                    ((OutputStream)out).write(buf, 0, r);
                    rem -= (long)r;
                    this.assemble_len += (long)r;
                    if ((long)(count += r) <= MB) continue;
                    this.updated();
                    count = 0;
                } while (rem != 0L);
                ((InputStream)in).close();
                ++i;
            }
            ((OutputStream)out).close();
            i = 0;
            while (i < this.fileList.size()) {
                info = this.fileList.get(i);
                System.out.println("Deleting: " + info.file + " " + new File(info.file).delete());
                ++i;
            }
            File t = new File(this.tempdir);
            File[] f = t.listFiles();
            int i2 = 0;
            while (i2 < f.length) {
                f[i2].delete();
                ++i2;
            }
            t.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status = StringResource.getString("ASSEMBLE_ERR");
            this.state = 30;
            this.updated();
            if (this.dwnListener != null) {
                this.dwnListener.downloadFailed(this.id);
            }
            return;
        }
        this.status = StringResource.getString("DOWNLOAD_COMPLETE");
        this.state = 50;
        this.updated();
        if (this.dwnListener != null) {
            this.dwnListener.downloadComplete(this.id);
        }
    }

    public void start() throws UnsupportedProtocolException {
        this.state = 20;
        this.startTime = System.currentTimeMillis();
        this.connect(this.getUrl(), "FILE", 0L, -1L, -1L, this.config.timeout);
    }

    public synchronized void saveDownload() {
        long time = System.currentTimeMillis();
        if (time - this.endTime > 5000L) {
            this.saveState();
            this.endTime = time;
        }
    }

    public synchronized void saveState() {
        try {
            if (!this.init) {
                return;
            }
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.statefile));
            out.writeUTF(this.getUrl());
            out.writeObject(this.creditential);
            out.writeUTF(this.fileName);
            out.writeUTF(this.finalFileName);
            out.writeUTF(this.getDestdir());
            out.writeLong(this.length);
            out.writeLong(this.downloaded);
            out.writeInt(this.fileList.size());
            int i = 0;
            while (i < this.fileList.size()) {
                out.writeObject(this.fileList.get(i));
                ++i;
            }
            out.writeInt(this.list.size());
            i = 0;
            while (i < this.list.size()) {
                Connection c = this.list.get(i);
                out.writeObject(c.getState());
                ++i;
            }
            long dwn = 0L;
            int i2 = 0;
            while (i2 < this.fileList.size()) {
                ChunkFileInfo cinfo = this.fileList.get(i2);
                dwn += cinfo.len;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.list.size()) {
                long dwnl;
                Connection c = this.list.get(i2);
                long len = c.getLength();
                dwn = len < (dwnl = c.getDownloaded()) ? (dwn += len) : (dwn += dwnl);
                ++i2;
            }
            out.writeLong(dwn);
            out.writeBoolean(this.overwrite);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean restoreState() {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.statefile));
            String u = in.readUTF();
            if (this.url != null && this.url.length() >= 1) {
                u = this.url;
            }
            this.setUrl(u);
            this.creditential = (Credential)in.readObject();
            this.fileName = in.readUTF();
            String finalFileName2 = in.readUTF();
            if (this.finalFileName == null) {
                this.finalFileName = finalFileName2;
            }
            String destdir2 = in.readUTF();
            if (this.destdir == null) {
                this.setDestdir(destdir2);
            }
            this.length = in.readLong();
            this.downloaded = in.readLong();
            int sz = in.readInt();
            this.fileList = new ArrayList<ChunkFileInfo>();
            int i = 0;
            while (i < sz) {
                this.fileList.add((ChunkFileInfo)in.readObject());
                ++i;
            }
            sz = in.readInt();
            this.list = new ArrayList<Connection>();
            i = 0;
            while (i < sz) {
                Connection.State state = (Connection.State)in.readObject();
                state.url = this.url;
                if (this.url.startsWith("http")) {
                    this.list.add(new HttpConnection(state, this.timeout, this, this.lock, this.creditential, this.config));
                } else {
                    this.list.add(new FTPConnection(state, this.timeout, this, this.lock, this.creditential, this.config));
                }
                ++i;
            }
            this.prevdownload = in.readLong();
            this.overwrite = in.readBoolean();
            in.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            return false;
        }
    }

    public void stop() {
        this.stop = true;
        this.status = StringResource.getString("STOPPED");
        int i = 0;
        while (i < this.list.size()) {
            Connection c = this.list.get(i);
            c.stop();
            try {
                c.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        this.saveState();
        this.state = 40;
        this.lastTime = 0L;
        this.updated();
        if (this.dwnListener != null) {
            this.dwnListener.downloadPaused(this.id);
        }
    }

    public void resume() {
        if (this.state == 20) {
            return;
        }
        this.state = 20;
        this.startTime = System.currentTimeMillis();
        this.init = this.restoreState();
        if (this.init) {
            if (this.list.size() < 1) {
                long d = 0L;
                int i = 0;
                while (i < this.fileList.size()) {
                    d += this.fileList.get((int)i).len;
                    ++i;
                }
                if (d == this.length) {
                    new Thread(){

                        @Override
                        public void run() {
                            ConnectionManager.this.assemble();
                        }
                    }.start();
                }
            } else {
                int i = 0;
                while (i < this.list.size()) {
                    Connection c = this.list.get(i);
                    c.start();
                    ++i;
                }
            }
        } else {
            this.state = 30;
            this.status = StringResource.getString("PART_ERR");
            this.updated();
            if (this.dwnListener != null) {
                this.dwnListener.downloadFailed(this.id);
            }
        }
    }

    void checkExt(String mime) {
        System.out.println("MIME-TYPE: " + mime);
        if (mime == null) {
            return;
        }
        if (mime.equals("text/html") && !this.fileName.endsWith("html") && !this.fileName.endsWith(".htm")) {
            this.fileName = String.valueOf(this.fileName) + ".html";
            return;
        }
        if (this.fileName.indexOf(".") < 0) {
            String ext = MIMEUtil.getFileExt(mime);
            System.out.println("EXTENSION: " + ext);
            if (ext != null) {
                this.fileName = String.valueOf(this.fileName) + "." + ext;
            }
        }
    }

    public void setTimeOut(int tout) {
        this.timeout = tout * 1000;
    }

    public void setMaxConn(int c) {
        this.MAX_CHUNK = c;
    }

    public void setCredential(String user, String pass) {
        this.creditential = new Credential();
        this.creditential.user = user;
        this.creditential.pass = pass;
    }

    public synchronized Credential getCreditential() {
        System.out.println("Ask for credentials");
        if (this.creditential != null) {
            return this.creditential;
        }
        String[] a = AuthDialog.getAuth();
        if (a == null) {
            this.creditential = null;
            return null;
        }
        this.creditential = new Credential();
        this.creditential.host = this.url;
        this.creditential.pass = a[1];
        this.creditential.user = a[0];
        return this.creditential;
    }

    @Override
    public void helpComplete(Object invoker, Object data) {
        block10: {
            if (invoker instanceof HelperConnection) {
                System.out.println("Helper Connection Complete...");
                HelperConnection hc = (HelperConnection)invoker;
                if (this.state == 50) {
                    System.out.println("Helper returing because MGR state is complete.");
                    return;
                }
                if (this.list.size() != 1) {
                    System.out.println("Helper returing because list size!=1: " + this.list.size());
                    return;
                }
                Connection c = this.list.get(0);
                if (c == hc.c) {
                    if (hc.stop) {
                        System.out.println("Helper return as stopped");
                        return;
                    }
                    if (c.status == 50) {
                        System.out.println("Helper returning because thread state COMPLETE");
                        return;
                    }
                    c.stop();
                    try {
                        System.out.println("Replace stream");
                        c.out.close();
                        RandomAccessFile raf = new RandomAccessFile(hc.fileName, "rw");
                        raf.write(hc.out.toByteArray());
                        raf.close();
                        this.fileList.add(new ChunkFileInfo(hc.fileName, hc.start, hc.length));
                        System.out.println("Finalized download: HELPER");
                        this.downloaded += hc.length;
                        System.out.println("HELPER CALLING DWNCOMPLETE");
                        System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&HELPER USED AND DONE");
                        c.downloaded = c.length = hc.start - c.startOff;
                        c.status = 50;
                        System.out.println("DWN: " + this.downloaded + " LEN: " + this.length);
                        if (this.donwloadComplete(c)) {
                            System.out.println("Helper Thread complete.");
                            break block10;
                        }
                        System.out.println("Mgr return false ERROR!!!");
                    }
                    catch (Exception e) {
                        System.out.println(e);
                        e.printStackTrace();
                    }
                } else {
                    System.out.println("Helper is returning because reference is not same");
                }
            }
        }
    }

    boolean needsHelp() {
        if (this.list.size() == 1) {
            Connection c = this.list.get(0);
            if (c instanceof HttpConnection) {
                HttpConnection hc = (HttpConnection)c;
                if (hc.length + this.downloaded == this.length) {
                    long start = hc.startOff + hc.downloaded;
                    long dwn = hc.downloaded;
                    long len = hc.length - dwn;
                    if (len - dwn < (long)this.MIN_CHUNK_SZ) {
                        if (this.helper != null) {
                            System.out.println("HELPER!=NULL");
                            return false;
                        }
                        if (start == hc.startOff) {
                            System.out.println("Helper return as startoff same");
                            return false;
                        }
                        this.helper = new HelperConnection(this.config, start, len, this.url, this, hc, new File(this.getTempdir(), String.valueOf(start) + this.fileName).toString(), hc.credential, this);
                        this.helper.start();
                        System.out.println("Helper Connection Started");
                        return true;
                    }
                    System.out.println("HELPER Chunk SZ>32K");
                    return false;
                }
                System.out.println("HELPER SIZE DOES NOT MATCH");
                return false;
            }
            System.out.println("Helper reference ERROR");
            return false;
        }
        System.out.println("Helper return: List size!=1 : " + this.list.size());
        return false;
    }

    public static void main(String[] a) throws Exception {
        String url = "http://localhost:8080/x.zip";
        URI uri = new URI("http://localhost:8080/x.zip");
        System.out.println(String.valueOf(uri.getRawPath()) + "?" + uri.getQuery() + " " + uri.getScheme());
        System.out.println(uri.getRawSchemeSpecificPart());
        XDMConfig config = XDMConfig.load(null);
        ConnectionManager mgr = new ConnectionManager(null, url, "x.zip", "g:/tst", "g:/tst", null, null, null, config);
        DownloadWindow d = new DownloadWindow(mgr);
        d.showWindow();
        mgr.start();
    }
}

