/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.sdg.xdman.core.common.DownloadStateListner;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.gui.MediaInfo;
import org.sdg.xdman.gui.MediaTableModel;
import org.sdg.xdman.gui.StringResource;
import org.sdg.xdman.gui.XDMIconMap;
import org.sdg.xdman.gui.XDMTableHeaderRenderer;
import org.sdg.xdman.util.MIMEUtil;
import org.sdg.xdman.util.XDMUtil;

public class MediaGrabberWindow
extends JFrame
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 8673545666964719266L;
    JButton download;
    JButton remove;
    JButton copy;
    JButton clear;
    MediaTableModel model;
    JTable table;
    JCheckBox top;
    DownloadStateListner mgr;
    XDMConfig config;

    public MediaGrabberWindow(MediaTableModel model, DownloadStateListner mgr, XDMConfig config) {
        this.setIconImage(XDMIconMap.getIcon("APP_ICON").getImage());
        this.config = config;
        this.model = model;
        this.mgr = mgr;
        this.init();
    }

    public void init() {
        if (this.config.mgW <= 0) {
            this.setSize(500, 300);
        } else {
            this.setSize(this.config.mgW, this.config.mgH);
        }
        this.setTitle(StringResource.getString("MG_TXT1"));
        this.table = new JTable(this.model);
        this.table.setAutoResizeMode(0);
        this.table.setShowGrid(false);
        TableColumnModel cm = this.table.getColumnModel();
        int i = 0;
        while (i < cm.getColumnCount()) {
            TableColumn c = cm.getColumn(i);
            if (c.getHeaderValue().equals(StringResource.getString("FILE_NAME"))) {
                c.setPreferredWidth(250);
            } else {
                c.setPreferredWidth(180);
            }
            ++i;
        }
        JScrollPane jsp = new JScrollPane(this.table);
        if (System.getProperty("xdm.defaulttheme") != null) {
            this.table.getTableHeader().setDefaultRenderer(new XDMTableHeaderRenderer());
        }
        this.table.setFillsViewportHeight(true);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new EmptyBorder(10, 10, 10, 10));
        p.add(jsp);
        this.add(p);
        Box box = Box.createHorizontalBox();
        this.top = new JCheckBox(StringResource.getString("MG_TXT2"));
        this.top.addItemListener(this);
        box.add(this.top);
        box.add(Box.createHorizontalGlue());
        this.copy = new JButton(StringResource.getString("MG_TXT3"));
        this.copy.addActionListener(this);
        this.download = new JButton(StringResource.getString("DOWNLOAD"));
        this.download.addActionListener(this);
        this.remove = new JButton(StringResource.getString("DELETE"));
        this.remove.addActionListener(this);
        this.clear = new JButton(StringResource.getString("CLEAR"));
        this.clear.addActionListener(this);
        this.copy.setPreferredSize(this.download.getPreferredSize());
        box.add(this.copy);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.download);
        box.add(Box.createHorizontalStrut(10));
        this.clear.setPreferredSize(this.download.getPreferredSize());
        box.add(this.clear);
        box.add(Box.createHorizontalStrut(10));
        this.remove.setPreferredSize(this.download.getPreferredSize());
        box.add(this.remove);
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)box, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.download) {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                JOptionPane.showMessageDialog(this, StringResource.getString("NONE_SELECTED"));
                return;
            }
            MediaInfo info = this.model.list.get(index);
            if (info.name != null) {
                String ext;
                info.name = XDMUtil.createSafeFileName(info.name);
                System.out.println("TYPE: " + info.type);
                if (info.type != null && (ext = MIMEUtil.getFileExt(info.type)) != null && info.name.indexOf(46) < 0) {
                    info.name = String.valueOf(info.name) + "." + ext;
                }
            } else {
                info.name = "video";
            }
            this.mgr.addDownload(info.url, info.name, this.config.destdir, null, null, info.referer, info.cookies, info.userAgent);
        } else if (e.getSource() == this.remove) {
            System.out.println("Remove video");
            int[] index = this.table.getSelectedRows();
            if (index.length < 1) {
                JOptionPane.showMessageDialog(this, StringResource.getString("NONE_SELECTED"));
                return;
            }
            MediaInfo[] info = new MediaInfo[index.length];
            int i = 0;
            while (i < index.length) {
                info[i] = this.model.list.get(index[i]);
                ++i;
            }
            i = 0;
            while (i < index.length) {
                this.model.list.remove(info[i]);
                ++i;
            }
            this.model.fireTableDataChanged();
        } else if (e.getSource() == this.copy) {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                JOptionPane.showMessageDialog(this, StringResource.getString("NONE_SELECTED"));
                return;
            }
            MediaInfo info = this.model.list.get(index);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(info.url), null);
        } else if (e.getSource() == this.clear) {
            this.model.list.clear();
            this.model.fireTableDataChanged();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        this.setAlwaysOnTop(this.top.isSelected());
    }
}

