/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class XDMButtonUI
extends BasicButtonUI {
    static XDMButtonUI buttonUI;
    GradientPaint gp1 = new GradientPaint(0.0f, 0.0f, new Color(250, 250, 250), 0.0f, 50.0f, new Color(200, 200, 200));
    GradientPaint gp2 = new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, 50.0f, new Color(205, 205, 205));
    GradientPaint gp3 = new GradientPaint(0.0f, 0.0f, new Color(240, 240, 240), 0.0f, 50.0f, new Color(180, 180, 180));

    public static ComponentUI createUI(JComponent c) {
        if (buttonUI == null) {
            buttonUI = new XDMButtonUI();
        }
        return buttonUI;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JButton) {
            JButton btn = (JButton)c;
            btn.setBorderPainted(false);
            Insets margins = btn.getInsets();
            btn.setMargin(new Insets(2, margins.top, 2, margins.bottom));
        }
    }

    protected void paintButtonNormal(Graphics g, AbstractButton b) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.gp1);
        g2.fillRoundRect(0, 0, b.getWidth() - 1, b.getHeight() - 1, 4, 4);
        g2.setColor(Color.LIGHT_GRAY);
        g2.drawRoundRect(0, 0, b.getWidth() - 1, b.getHeight() - 1, 4, 4);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.gp3);
        g2.fillRoundRect(0, 0, b.getWidth() - 1, b.getHeight() - 1, 6, 6);
        g2.setColor(Color.LIGHT_GRAY);
        g2.drawRoundRect(0, 0, b.getWidth() - 1, b.getHeight() - 1, 6, 6);
    }

    protected void paintButtonRollOver(Graphics g, AbstractButton b) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.gp2);
        g2.fillRoundRect(0, 0, b.getWidth() - 1, b.getHeight() - 1, 6, 6);
        g2.setColor(Color.LIGHT_GRAY);
        g2.drawRoundRect(0, 0, b.getWidth() - 1, b.getHeight() - 1, 6, 6);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel bm = b.getModel();
        if (bm.isRollover()) {
            this.paintButtonRollOver(g, b);
        } else {
            this.paintButtonNormal(g, b);
        }
        super.paint(g, c);
    }
}

