/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.sdg.xdman.gui.XDMIconMap;
import org.sdg.xdman.gui.XDMToolBarButtonUI;

public class XDMScrollBarUI
extends BasicScrollBarUI {
    Color thumbColor = new Color(190, 190, 190);
    GradientPaint tgph;
    GradientPaint tgpv;
    GradientPaint rgph;
    GradientPaint rgpv;
    Color thumbColorR = new Color(170, 170, 170);
    GradientPaint trackGrad;

    public static ComponentUI createUI(JComponent c) {
        return new XDMScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        int w = thumbBounds.width;
        int h = thumbBounds.height;
        g.translate(thumbBounds.x, thumbBounds.y);
        Graphics2D g2 = (Graphics2D)g;
        if (this.isThumbRollover()) {
            if (this.scrollbar.getOrientation() == 0) {
                if (this.rgph == null) {
                    this.rgph = new GradientPaint(0.0f, 0.0f, new Color(240, 240, 240), 0.0f, h, new Color(200, 200, 200));
                }
                g2.setPaint(this.rgph);
            } else {
                if (this.rgpv == null) {
                    this.rgpv = new GradientPaint(0.0f, 0.0f, new Color(240, 240, 240), w, 0.0f, new Color(200, 200, 200));
                }
                g2.setPaint(this.rgpv);
            }
        } else if (this.scrollbar.getOrientation() == 0) {
            if (this.tgph == null) {
                this.tgph = new GradientPaint(0.0f, 0.0f, new Color(250, 250, 250), 0.0f, h, new Color(180, 180, 180));
            }
            g2.setPaint(this.tgph);
        } else {
            if (this.tgpv == null) {
                this.tgpv = new GradientPaint(0.0f, 0.0f, new Color(250, 250, 250), w, 0.0f, new Color(200, 200, 200));
            }
            g2.setPaint(this.tgpv);
        }
        g.fillRect(1, 0, w - 3, h - 3);
        g.setColor(Color.LIGHT_GRAY);
        if (this.scrollbar.getOrientation() == 0) {
            if (w > 30 & h > 10) {
                int x = (w - 2) / 2 - 5;
                int y = (h - 3) / 2 - 3;
                if (x > 0 && y > 0) {
                    g.setColor(Color.GRAY);
                    g.drawLine(x, y, x, y + 6);
                    g.setColor(this.thumbColor);
                    g.drawLine(x + 1, y, x + 1, y + 6);
                    g.setColor(Color.GRAY);
                    g.drawLine(x + 3, y, x + 3, y + 6);
                    g.setColor(this.thumbColor);
                    g.drawLine(x + 4, y, x + 4, y + 6);
                    g.setColor(Color.GRAY);
                    g.drawLine(x + 6, y, x + 6, y + 6);
                    g.setColor(this.thumbColor);
                    g.drawLine(x + 7, y, x + 7, y + 6);
                }
            }
        } else if (w > 15 & h > 30) {
            int x = (w - 2) / 2 - 3;
            int y = (h - 3) / 2 - 5;
            if (x > 0 && y > 0) {
                g.setColor(Color.GRAY);
                g.drawLine(x, y, x + 6, y);
                g.setColor(this.thumbColor);
                g.drawLine(x, y + 1, x + 6, y + 1);
                g.setColor(Color.GRAY);
                g.drawLine(x, y + 3, x + 6, y + 3);
                g.setColor(this.thumbColor);
                g.drawLine(x, y + 4, x + 6, y + 4);
                g.setColor(Color.GRAY);
                g.drawLine(x, y + 6, x + 6, y + 6);
                g.setColor(this.thumbColor);
                g.drawLine(x, y + 7, x + 6, y + 7);
            }
        }
        g.drawRect(1, 0, w - 3, h - 3);
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        JButton btn = new JButton();
        btn.setUI(new XDMToolBarButtonUI());
        btn.setContentAreaFilled(false);
        btn.setBorderPainted(false);
        btn.setOpaque(false);
        btn.setMargin(new Insets(0, 2, 0, 2));
        if (orientation == 1) {
            btn.setIcon(XDMIconMap.getIcon("UP_ARROW"));
        }
        if (orientation == 5) {
            btn.setIcon(XDMIconMap.getIcon("DOWN_ARROW"));
        }
        if (orientation == 3) {
            btn.setIcon(XDMIconMap.getIcon("LEFT_ARROW"));
        }
        if (orientation == 7) {
            btn.setIcon(XDMIconMap.getIcon("RIGHT_ARROW"));
        }
        return btn;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        JButton btn = new JButton();
        btn.setUI(new XDMToolBarButtonUI());
        btn.setContentAreaFilled(false);
        btn.setBorderPainted(false);
        btn.setMargin(new Insets(0, 2, 0, 2));
        if (orientation == 1) {
            btn.setIcon(XDMIconMap.getIcon("UP_ARROW"));
        }
        if (orientation == 5) {
            btn.setIcon(XDMIconMap.getIcon("DOWN_ARROW"));
        }
        if (orientation == 3) {
            btn.setIcon(XDMIconMap.getIcon("LEFT_ARROW"));
        }
        if (orientation == 7) {
            btn.setIcon(XDMIconMap.getIcon("RIGHT_ARROW"));
        }
        return btn;
    }

    protected void paintTrack2(Graphics g, JComponent c, Rectangle r) {
        if (this.trackGrad == null) {
            this.trackGrad = new GradientPaint(0.0f, 0.0f, new Color(220, 220, 220), 0.0f, c.getHeight(), new Color(240, 240, 240));
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.trackGrad);
        g2.fill(r);
    }
}

