/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.core.common.http.XDMHttpClient2;
import org.sdg.xdman.gui.StringResource;
import org.sdg.xdman.gui.XDMIconMap;
import org.sdg.xdman.interceptor.HTMLEscapeUtil;
import org.sdg.xdman.interceptor.HTMLTitleParser;
import org.sdg.xdman.interceptor.IMediaGrabber;
import org.sdg.xdman.plugin.youtube.JSONParser;
import org.sdg.xdman.plugin.youtube.ParserProgressListner;
import org.sdg.xdman.plugin.youtube.YTVideoInfo;
import org.sdg.xdman.util.XDMUtil;

public class YoutubeGrabberDlg
extends JFrame
implements ActionListener,
ParserProgressListner,
Runnable {
    private static final long serialVersionUID = -1072376334080340930L;
    Dimension btnDim;
    CardLayout card;
    JPanel p1;
    JPanel p2;
    JTextField ytaddr;
    JButton get_video;
    JButton cancel;
    JButton abort;
    JPanel p;
    String info1 = StringResource.getString("YT_LBL1");
    String info2 = StringResource.getString("YT_LBL2");
    XDMConfig config;
    Thread ytd;
    IMediaGrabber mg;
    JProgressBar prg;
    JTextField lbl;
    byte[] b = new byte[8192];
    boolean network_err = true;
    boolean available = true;
    private XDMHttpClient2 client;

    public YoutubeGrabberDlg(IMediaGrabber mg) {
        super(StringResource.getString("YT_LBL3"));
        this.mg = mg;
        this.setSize(420, 250);
        this.createP1();
        this.createP2();
        this.card = new CardLayout();
        this.p = new JPanel(this.card);
        this.p.add((Component)this.p1, "1");
        this.p.add((Component)this.p2, "2");
        this.add(this.p);
        try {
            this.setIconImage(XDMIconMap.getIcon("APP_ICON").getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.card.show(this.p, "1");
    }

    void showDialog(JFrame f, XDMConfig config, String txt2) {
        if (this.available) {
            this.card.show(this.p, "1");
            this.ytaddr.setText(txt2);
            this.setLocationRelativeTo(f);
            String txt = String.valueOf(this.info2) + " 0 KB";
            this.lbl.setText(txt);
            this.config = config;
            this.pack();
            this.setSize(420, this.getHeight());
            this.setVisible(true);
        }
    }

    void createP1() {
        Box p11 = Box.createVerticalBox();
        p11.setBackground(Color.white);
        p11.setOpaque(true);
        this.p1 = new JPanel(new BorderLayout());
        Box b1 = Box.createHorizontalBox();
        b1.setBackground(Color.white);
        b1.setOpaque(true);
        b1.setBorder(new EmptyBorder(25, 15, 10, 15));
        JLabel lbl = new JLabel();
        lbl.setText(StringResource.getString("YT_LBL1"));
        lbl.setOpaque(false);
        JLabel icon = new JLabel(XDMIconMap.getIcon("YT_ICON"));
        icon.setMaximumSize(new Dimension(75, 75));
        b1.add(icon);
        b1.add(Box.createRigidArea(new Dimension(10, 10)));
        b1.add(lbl);
        this.ytaddr = new JTextField();
        this.ytaddr.setMaximumSize(new Dimension(this.ytaddr.getMaximumSize().width, this.ytaddr.getPreferredSize().height));
        p11.add(b1);
        Box b2 = Box.createHorizontalBox();
        b2.add(this.ytaddr);
        b2.setBackground(Color.white);
        b2.setOpaque(true);
        b2.setBorder(new EmptyBorder(10, 15, 15, 15));
        p11.add(b2);
        p11.add(Box.createVerticalStrut(20));
        this.p1.add(p11);
        Box b3 = Box.createHorizontalBox();
        this.get_video = new JButton(StringResource.getString("YT_LBL4"));
        this.btnDim = this.get_video.getPreferredSize();
        this.get_video.setName("YT_LBL4");
        this.get_video.addActionListener(this);
        this.cancel = new JButton(StringResource.getString("CANCEL"));
        this.cancel.setName("CANCEL");
        this.cancel.addActionListener(this);
        this.cancel.setPreferredSize(this.btnDim);
        b3.add(Box.createHorizontalGlue());
        b3.add(this.get_video);
        b3.add(Box.createRigidArea(new Dimension(10, 10)));
        b3.add(this.cancel);
        b3.setBorder(new EmptyBorder(10, 15, 10, 15));
        this.p1.add((Component)b3, "South");
    }

    void createP2() {
        this.p2 = new JPanel(new BorderLayout());
        Box p22 = Box.createVerticalBox();
        Box b0 = Box.createHorizontalBox();
        b0.setOpaque(true);
        b0.setBackground(Color.white);
        Box b1 = Box.createVerticalBox();
        b1.setOpaque(true);
        b1.setBackground(Color.white);
        b0.setBorder(new EmptyBorder(25, 15, 10, 15));
        this.lbl = new JTextField();
        this.lbl.setFont(new Font("Dialog", 1, 14));
        this.lbl.setOpaque(false);
        this.lbl.setEditable(false);
        this.lbl.setBorder(null);
        this.lbl.setText(StringResource.getString("YT_LBL2"));
        JLabel icon = new JLabel(XDMIconMap.getIcon("YT_ICON"));
        icon.setMaximumSize(new Dimension(75, 75));
        Box bb = Box.createVerticalBox();
        bb.add(icon);
        bb.add(Box.createVerticalGlue());
        b0.add(bb);
        b0.add(Box.createRigidArea(new Dimension(10, 10)));
        this.prg = new JProgressBar();
        this.prg.setIndeterminate(true);
        this.prg.setPreferredSize(new Dimension(15, 15));
        this.prg.setMinimumSize(new Dimension(0, 15));
        this.prg.setMaximumSize(new Dimension(Integer.MAX_VALUE, 15));
        JTextArea label = new JTextArea(StringResource.getString("YT_LBL9"));
        label.setEditable(false);
        label.setWrapStyleWord(true);
        label.setOpaque(false);
        label.setBorder(null);
        label.setLineWrap(true);
        this.lbl.setPreferredSize(new Dimension(label.getPreferredSize().width, 50));
        b1.add(this.lbl);
        b1.add(label);
        this.lbl.setText(StringResource.getString("YT_LBL2"));
        b1.add(Box.createVerticalStrut(20));
        b1.add(this.prg);
        b1.add(Box.createVerticalStrut(15));
        b0.add(b1);
        Box b3 = Box.createHorizontalBox();
        this.abort = new JButton(StringResource.getString("CANCEL"));
        if (this.btnDim != null) {
            this.abort.setPreferredSize(this.btnDim);
        }
        this.abort.setName("ABORT");
        this.abort.addActionListener(this);
        b3.add(Box.createHorizontalGlue());
        b3.add(this.abort);
        b3.setBorder(new EmptyBorder(10, 15, 10, 15));
        p22.add(b0);
        this.p2.add(p22);
        this.p2.add((Component)b3, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.get_video) {
            String addr = this.ytaddr.getText();
            if (addr.length() < 1) {
                JOptionPane.showMessageDialog(this, StringResource.getString("URL_EMPTY"));
                return;
            }
            if (!XDMUtil.validateURL(addr)) {
                JOptionPane.showMessageDialog(this, StringResource.getString("YT_LBL5"));
                return;
            }
            if (!addr.startsWith("http://www.youtube.com/watch") && !addr.startsWith("https://www.youtube.com/watch")) {
                JOptionPane.showMessageDialog(this, StringResource.getString("YT_LBL5"));
                return;
            }
            this.card.show(this.p, "2");
            this.ytd = new Thread(this);
            this.ytd.start();
        }
        if (e.getSource() == this.abort) {
            if (this.ytd != null) {
                this.ytd.interrupt();
                this.setVisible(false);
            }
            this.setVisible(false);
        }
        if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
    }

    @Override
    public void update(long downloaded) {
        String txt = String.valueOf(this.info2) + XDMUtil.getFormattedLength(downloaded);
        this.lbl.setText(txt);
    }

    @Override
    public void run() {
        this.grabVideo();
    }

    void grabVideo() {
        String url;
        String ua;
        String title;
        ArrayList<YTVideoInfo> list;
        OutputStream tmpStreamOut;
        InputStream tmpStreamIn;
        String tmpFile;
        block45: {
            this.network_err = true;
            tmpFile = null;
            tmpStreamIn = null;
            tmpStreamOut = null;
            list = null;
            title = "";
            int count = 0;
            ua = "Mozilla/5.0 (Windows NT 6.1; rv:31.0) Gecko/20100101 Firefox/31.0";
            url = this.ytaddr.getText();
            do {
                int x;
                this.available = false;
                this.client = new XDMHttpClient2(this.config);
                this.client.addRequestHeaders("accept-encoding", "gzip");
                if (count > 0) {
                    ua = "Mozilla/5.0 (Linux; U; Android 4.0.3; ko-kr; LG-L160L Build/IML74K) AppleWebkit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30";
                }
                this.client.addRequestHeaders("user-agent", ua);
                this.client.connect(url);
                this.client.sendRequest();
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                int rc = this.client.getResponseCode();
                if (rc == 302) {
                    url = this.client.getResponseHeader("location");
                    this.client.close();
                    continue;
                }
                if (rc != 200 && rc != 206) {
                    throw new Exception("Invalid response: " + rc);
                }
                InputStream in = this.client.in;
                tmpFile = XDMUtil.getTempFile(this.config.tempdir).getAbsolutePath();
                tmpStreamOut = new FileOutputStream(tmpFile);
                long read = 0L;
                while ((x = in.read(this.b, 0, this.b.length)) != -1) {
                    tmpStreamOut.write(this.b, 0, x);
                    this.update(read += (long)x);
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException();
                }
                tmpStreamOut.close();
                this.client.close();
                this.network_err = false;
                tmpStreamIn = new FileInputStream(tmpFile);
                BufferedReader r = new BufferedReader(new InputStreamReader(tmpStreamIn));
                title = HTMLTitleParser.GetTitleFromPage(r);
                title = HTMLEscapeUtil.escapeHTMLLine(title);
                title = XDMUtil.createSafeFileName(title);
                tmpStreamIn.close();
                tmpStreamIn = new FileInputStream(tmpFile);
                JSONParser p = new JSONParser();
                list = p.list(tmpStreamIn);
                if (list != null && list.size() > 0) break;
                try {
                    tmpStreamIn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tmpFile != null) {
                    new File(tmpFile).delete();
                }
                ++count;
                System.out.println("Retrying with mobile ua");
            } while (count < 2);
            if (list != null && list.size() >= 1) break block45;
            this.showError();
            new File(tmpFile).delete();
            try {
                tmpStreamIn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tmpStreamOut.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tmpFile != null) {
                new File(tmpFile).delete();
            }
            this.available = true;
            this.setVisible(false);
            return;
        }
        try {
            try {
                int i = 0;
                while (i < list.size()) {
                    YTVideoInfo info = (YTVideoInfo)list.get(i);
                    if (info != null && this.mg != null) {
                        this.mg.mediaCaptured(title, info.url, info.type, info.itag, url, ua, null);
                        this.mg.showGrabber();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!(e instanceof InterruptedException)) {
                    this.showError();
                }
                try {
                    tmpStreamIn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tmpStreamOut.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tmpFile != null) {
                    new File(tmpFile).delete();
                }
                this.available = true;
                this.setVisible(false);
            }
        }
        catch (Throwable throwable) {
            try {
                tmpStreamIn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tmpStreamOut.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tmpFile != null) {
                new File(tmpFile).delete();
            }
            this.available = true;
            this.setVisible(false);
            throw throwable;
        }
        try {
            tmpStreamIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tmpStreamOut.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tmpFile != null) {
            new File(tmpFile).delete();
        }
        this.available = true;
        this.setVisible(false);
    }

    void showError() {
        if (this.network_err) {
            JOptionPane.showMessageDialog(this, StringResource.getString("YT_LBL7"));
        } else {
            JOptionPane.showMessageDialog(this, StringResource.getString("YT_LBL8"));
        }
    }

    public static void main(String[] args) {
    }
}

