/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import org.sdg.xdman.core.common.ConnectionManager;
import org.sdg.xdman.core.common.DownloadInfo;
import org.sdg.xdman.gui.ConnectionTableModel;
import org.sdg.xdman.gui.MainWindow;
import org.sdg.xdman.gui.SegmentPanel;
import org.sdg.xdman.gui.XDMProgressBar;
import org.sdg.xdman.util.Java6Util;
import org.sdg.xdman.util.XDMUtil;

public class DownloadWindow
implements Observer,
ActionListener {
    JFrame window;
    JLabel url;
    JLabel status;
    JLabel filesize;
    JLabel downloaded;
    JLabel rate;
    JLabel time;
    JLabel resume;
    SegmentPanel p = new SegmentPanel();
    XDMProgressBar prg = new XDMProgressBar();
    JButton bg;
    JButton view;
    JButton cancel;
    ConnectionTableModel model = new ConnectionTableModel();
    JTable table = new JTable(this.model);
    ConnectionManager mgr;
    File file;
    boolean showed = false;

    public DownloadWindow(ConnectionManager mgr) {
        this.init();
        this.mgr = mgr;
    }

    public void showWindow() {
        this.window.setVisible(true);
    }

    public void update(Observable arg0, Object arg1) {
        DownloadInfo info = (DownloadInfo)arg1;
        this.window.setTitle(String.valueOf(info.prg) + " % " + info.file);
        this.url.setText(info.url);
        if (info.state == 30) {
            this.status.setText("Error");
        } else {
            this.status.setText(info.status);
        }
        this.filesize.setText(info.length);
        this.downloaded.setText(String.valueOf(info.downloaded) + " (" + info.progress + "%)");
        this.rate.setText(info.speed);
        this.time.setText(info.eta);
        this.resume.setText(info.resume);
        this.p.setValues(info.startoff, info.len, info.dwn, info.rlen);
        this.prg.setValue(info.prg);
        this.model.update(info.dwnld, info.stat);
        this.file = info.path;
        if (info.state == 30) {
            ConnectionManager c = (ConnectionManager)arg0;
            if (!c.stop && c.state != 50 && !this.showed) {
                JOptionPane.showMessageDialog(this.window, info.msg);
                this.window.setVisible(false);
                this.window.dispose();
                this.showed = true;
            }
        }
        if (info.state == 50) {
            System.out.println("%%%%%%%%%%%%%%%%%%DOWNLOAD COMPLETE");
            this.bg.setEnabled(false);
            this.window.setVisible(false);
            this.window.dispose();
        }
        if (info.state == 40) {
            System.out.println("%%%%%%%%%%%%%%%%%%DOWNLOAD STOPPED");
            this.bg.setEnabled(false);
            this.window.setVisible(false);
            this.window.dispose();
        }
    }

    void init() {
        this.window = new JFrame();
        ImageIcon img = MainWindow.icon;
        if (img != null) {
            this.window.setIconImage(img.getImage());
        }
        this.window.setSize(450, 400);
        Toolkit t = Toolkit.getDefaultToolkit();
        Dimension d = t.getScreenSize();
        this.window.setLocation(d.width / 2 - this.window.getWidth() / 2, d.height / 2 - this.window.getHeight() / 2);
        Box vbox = Box.createVerticalBox();
        vbox.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.url = new JLabel("", 2);
        this.status = new JLabel("", 2);
        this.filesize = new JLabel("", 2);
        this.downloaded = new JLabel("", 2);
        this.rate = new JLabel("", 2);
        this.time = new JLabel("", 2);
        this.resume = new JLabel("", 2);
        JPanel infoPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(0, 5, 0, 5);
        gc.fill = 2;
        gc.gridwidth = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        infoPanel.add((Component)this.url, gc);
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        gc.gridy = 1;
        infoPanel.add((Component)new JLabel("Status", 2), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        infoPanel.add((Component)this.status, gc);
        gc.gridy = 2;
        gc.gridx = 0;
        infoPanel.add((Component)new JLabel("File size", 2), gc);
        gc.gridx = 1;
        gc.gridy = 2;
        infoPanel.add((Component)this.filesize, gc);
        gc.gridy = 3;
        gc.gridx = 0;
        infoPanel.add((Component)new JLabel("Downloaded", 2), gc);
        gc.gridx = 1;
        gc.gridy = 3;
        infoPanel.add((Component)this.downloaded, gc);
        gc.gridx = 0;
        gc.gridy = 4;
        infoPanel.add((Component)new JLabel("Transfer rate", 2), gc);
        gc.gridx = 1;
        gc.gridy = 4;
        infoPanel.add((Component)this.rate, gc);
        gc.gridx = 0;
        gc.gridy = 5;
        infoPanel.add((Component)new JLabel("Time left", 2), gc);
        gc.gridx = 1;
        gc.gridy = 5;
        infoPanel.add((Component)this.time, gc);
        gc.gridx = 0;
        gc.gridy = 6;
        infoPanel.add((Component)new JLabel("Resume support", 2), gc);
        gc.gridx = 1;
        gc.gridy = 6;
        infoPanel.add((Component)this.resume, gc);
        vbox.add(infoPanel);
        vbox.add(Box.createVerticalStrut(10));
        Box prgBox = Box.createHorizontalBox();
        prgBox.add(Box.createRigidArea(new Dimension(0, 15)));
        prgBox.add(this.prg);
        vbox.add(prgBox);
        vbox.add(Box.createVerticalStrut(10));
        this.bg = new JButton("Background");
        this.bg.addActionListener(this);
        this.view = new JButton("Preview");
        this.view.addActionListener(this);
        this.cancel = new JButton("Pause");
        this.cancel.addActionListener(this);
        Box hbox8 = Box.createHorizontalBox();
        hbox8.add(this.bg);
        hbox8.add(Box.createHorizontalGlue());
        hbox8.add(this.view);
        hbox8.add(Box.createHorizontalStrut(10));
        hbox8.add(this.cancel);
        vbox.add(hbox8);
        vbox.add(Box.createVerticalStrut(10));
        Box hbox9 = Box.createHorizontalBox();
        hbox9.add(Box.createRigidArea(new Dimension(0, 15)));
        hbox9.add(this.p);
        vbox.add(hbox9);
        vbox.add(Box.createVerticalStrut(10));
        Box hbox10 = Box.createHorizontalBox();
        JScrollPane jsp = new JScrollPane(this.table);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setFocusable(false);
        Java6Util.jtable$setFillsViewportHeight(this.table, true);
        this.table.setShowGrid(false);
        hbox10.add(jsp);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setPreferredWidth(10);
        cm.getColumn(1).setPreferredWidth(50);
        cm.getColumn(2).setPreferredWidth(200);
        vbox.add(hbox10);
        this.window.add(vbox);
        this.window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (DownloadWindow.this.mgr != null) {
                    DownloadWindow.this.mgr.stop();
                }
                DownloadWindow.this.window.setVisible(false);
                DownloadWindow.this.window.dispose();
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Pause")) {
            if (this.mgr != null) {
                this.mgr.stop();
            }
            this.window.setVisible(false);
            this.window.dispose();
        }
        if (e.getActionCommand().equals("Preview") && this.file != null) {
            XDMUtil.open(this.file);
        }
        if (e.getActionCommand().equals("Background")) {
            this.window.setVisible(false);
        }
    }

    public static void main(String[] args) {
        new DownloadWindow(null).showWindow();
    }
}

