/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.sdg.xdman.gui.DownloadListItem;
import org.sdg.xdman.gui.MainWindow;
import org.sdg.xdman.util.Java6Util;
import org.sdg.xdman.util.XDMUtil;

public class PropDlg
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 7041991846285917185L;
    JTextField file;
    JTextField url;
    JTextField path;
    JTextField ref;
    JLabel type;
    JLabel size;
    JLabel date;
    JButton open;
    JButton open_folder;
    JButton save_in;
    JButton close;
    JFileChooser fc;
    DownloadListItem item;

    public PropDlg(JFrame f) {
        super(f);
        this.setTitle("Properties");
        Box b = Box.createVerticalBox();
        this.url = new JTextField();
        this.url.setEditable(false);
        this.path = new JTextField();
        this.path.setEditable(false);
        this.ref = new JTextField();
        GridBagConstraints gc = new GridBagConstraints();
        Insets inset = new Insets(10, 10, 10, 10);
        JPanel m1 = new JPanel(new GridBagLayout());
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.insets = inset;
        m1.add((Component)new JLabel("File"), gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 2;
        this.file = new JTextField();
        this.file.setEditable(false);
        m1.add((Component)this.file, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        m1.add((Component)new JLabel("URL"), gc);
        gc.gridx = 1;
        gc.weightx = 0.5;
        gc.gridwidth = 2;
        m1.add((Component)this.url, gc);
        b.add(m1);
        gc = new GridBagConstraints();
        gc.insets = inset;
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 2;
        gc.weightx = 0.0;
        m1.add((Component)new JLabel("PATH"), gc);
        gc.gridx = 1;
        gc.weightx = 0.5;
        gc.gridwidth = 2;
        m1.add((Component)this.path, gc);
        gc = new GridBagConstraints();
        gc.insets = inset;
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 3;
        m1.add((Component)new JLabel("Type of file"), gc);
        gc.gridx = 1;
        gc.gridy = 3;
        gc.weightx = 1.0;
        this.type = new JLabel("<TYPE>");
        gc.gridwidth = 2;
        m1.add((Component)this.type, gc);
        gc = new GridBagConstraints();
        gc.insets = inset;
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 4;
        m1.add((Component)new JLabel("Size"), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.gridwidth = 2;
        this.size = new JLabel("<SIZE>");
        m1.add((Component)this.size, gc);
        this.date = new JLabel("<DATE>");
        gc = new GridBagConstraints();
        gc.insets = inset;
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 5;
        m1.add((Component)new JLabel("Date"), gc);
        gc.gridwidth = 2;
        gc.gridx = 1;
        gc.weightx = 1.0;
        m1.add((Component)this.date, gc);
        gc = new GridBagConstraints();
        gc.insets = inset;
        gc.gridx = 0;
        gc.gridy = 6;
        this.save_in = new JButton("Save As");
        this.save_in.addActionListener(this);
        gc.gridx = 0;
        m1.add((Component)this.save_in, gc);
        this.open = new JButton("Open");
        this.open.addActionListener(this);
        gc.gridx = 1;
        m1.add((Component)this.open, gc);
        gc.gridx = 2;
        this.open_folder = new JButton("Open Folder");
        this.open_folder.addActionListener(this);
        m1.add((Component)this.open_folder, gc);
        JLabel glue = new JLabel();
        gc.gridx = 0;
        gc.gridy = 7;
        gc.fill = 3;
        gc.insets = inset;
        gc.weighty = 1.0;
        m1.add((Component)glue, gc);
        this.close = new JButton("Close");
        this.close.addActionListener(this);
        Box l = Box.createHorizontalBox();
        l.add(Box.createHorizontalGlue());
        l.add(this.close);
        l.add(Box.createRigidArea(new Dimension(10, 40)));
        this.add((Component)l, "South");
        b.add(Box.createVerticalGlue());
        this.add(b);
        try {
            Java6Util.jdialog$setIconImage(this, MainWindow.icon.getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setDownloadProperty(DownloadListItem item) {
        this.file.setText(item.filename);
        this.url.setText(item.url);
        this.path.setText(item.saveto);
        this.size.setText(item.size);
        this.type.setText(item.type);
        this.date.setText(item.dateadded);
        this.item = item;
        if (item.state == 50) {
            this.save_in.setEnabled(false);
        } else {
            this.save_in.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String str = e.getActionCommand();
        if (str.equals("Save As")) {
            if (this.item == null) {
                return;
            }
            if (this.item.state == 50) {
                JOptionPane.showMessageDialog(this, "Can't change completed downloads");
                return;
            }
            if (this.fc == null) {
                this.fc = new JFileChooser();
            }
            this.fc.setFileSelectionMode(0);
            this.fc.setSelectedFile(new File(this.item.saveto, this.item.filename));
            if (this.fc.showSaveDialog(this) == 0) {
                if (this.item.state == 50 || this.item.state == 60) {
                    JOptionPane.showMessageDialog(this, "Can't change download property while it is almost complete");
                    return;
                }
                this.item.saveto = this.fc.getSelectedFile().getParent();
                this.item.filename = this.fc.getSelectedFile().getName();
                if (this.item.mgr != null) {
                    this.item.mgr.setDestdir(this.item.saveto);
                    this.item.mgr.setFileName(this.item.filename);
                }
                MainWindow.list.downloadStateChanged();
                this.setDownloadProperty(this.item);
            }
        }
        if (str.equals("Open")) {
            if (this.item == null) {
                return;
            }
            XDMUtil.open(new File(this.item.saveto, this.item.filename));
        }
        if (str.equals("Open Folder")) {
            if (this.item == null) {
                return;
            }
            XDMUtil.open(new File(this.item.saveto));
        }
        if (str.equals("Close")) {
            this.setVisible(false);
        }
    }
}

