/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.sdg.xdman.gui.DownloadListItem;
import org.sdg.xdman.gui.MainWindow;
import org.sdg.xdman.util.Java6Util;
import org.sdg.xdman.util.XDMUtil;

public class RefreshLinkDlg
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1359910126781110728L;
    String info1 = "The Old Download Link was contained in the following web page: ";
    String info2 = "\nPlease open the web page in your browser\nFind the download link again and paste it in the 'New Download Link' field.";
    JTextField link;
    String oldLink = "";
    JTextArea txt;
    DownloadListItem item;
    JButton openPage;

    public RefreshLinkDlg(JFrame f) {
        super(f);
        this.setTitle("Refresh Link");
        this.setModal(true);
        this.init();
    }

    void init() {
        this.setSize(300, 300);
        this.txt = new JTextArea();
        this.txt.setEditable(false);
        this.txt.setWrapStyleWord(true);
        this.txt.setLineWrap(true);
        JScrollPane jsp = new JScrollPane(this.txt);
        this.add(jsp);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridwidth = 2;
        gc.fill = 2;
        this.openPage = new JButton("Open Web Page");
        this.openPage.addActionListener(this);
        gc.gridy = 1;
        panel.add((Component)this.openPage, gc);
        gc.gridwidth = 1;
        gc.weightx = 1.0;
        gc.gridy = 2;
        gc.weightx = 0.5;
        panel.add((Component)new JLabel("New Download Link"), gc);
        gc.weightx = 1.0;
        this.link = new JTextField();
        gc.gridx = 1;
        panel.add((Component)this.link, gc);
        gc.weightx = 0.0;
        JButton ok = new JButton("OK");
        ok.addActionListener(this);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(ok);
        box.add(Box.createHorizontalStrut(10));
        box.add(cancel);
        gc.gridx = 0;
        gc.gridy = 3;
        gc.gridwidth = 2;
        panel.add((Component)box, gc);
        this.add((Component)panel, "South");
    }

    void showDlg(DownloadListItem item, String ref) {
        this.item = item;
        if (ref == null || ref.length() < 1) {
            this.oldLink = "Unknown";
            this.openPage.setEnabled(false);
        } else {
            this.oldLink = ref;
            this.openPage.setEnabled(true);
        }
        this.link.setText("");
        this.txt.setText(String.valueOf(this.info1) + this.oldLink + this.info2);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        System.out.println(cmd);
        if (cmd.equals("OK")) {
            System.out.println(cmd);
            if (this.item != null) {
                String url = this.link.getText().trim();
                if (url.length() < 1) {
                    JOptionPane.showMessageDialog(this, "Field is empty");
                    return;
                }
                if (!XDMUtil.validateURL(url)) {
                    JOptionPane.showMessageDialog(this, "Invalid URL");
                    return;
                }
                this.item.url = url;
                MainWindow.list.downloadStateChanged();
                this.setVisible(false);
            }
        }
        if (cmd.equals("Cancel")) {
            this.setVisible(false);
        }
        if (cmd.equals("Open Web Page")) {
            try {
                Java6Util.desktop$browse(new URI(this.oldLink));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        new RefreshLinkDlg(null).showDlg(null, null);
    }
}

