/*
 * Decompiled with CFR 0.152.
 */
package xdman.downloaders.hls;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.UUID;
import xdman.Config;
import xdman.downloaders.AbstractChannel;
import xdman.downloaders.Downloader;
import xdman.downloaders.Segment;
import xdman.downloaders.SegmentDetails;
import xdman.downloaders.SegmentImpl;
import xdman.downloaders.SegmentInfo;
import xdman.downloaders.SegmentListener;
import xdman.downloaders.http.HttpChannel;
import xdman.downloaders.metadata.HlsMetadata;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.downloaders.metadata.manifests.M3U8Manifest;
import xdman.mediaconversion.FFmpeg;
import xdman.mediaconversion.MediaConversionListener;
import xdman.mediaconversion.MediaFormats;
import xdman.util.FormatUtilities;
import xdman.util.Logger;
import xdman.util.StringUtils;
import xdman.util.XDMUtils;

public class HlsDownloader
extends Downloader
implements SegmentListener,
MediaConversionListener {
    private HlsMetadata metadata;
    private ArrayList<String> urlList;
    private Segment manifestSegment;
    private long totalAssembled;
    private String newFileName;
    private boolean assembleFinished;
    private FFmpeg ffmpeg;
    private int lastProgress;
    private float totalDuration;

    public HlsDownloader(String id, String folder, HlsMetadata metadata) {
        this.id = id;
        this.folder = new File(folder, id).getAbsolutePath();
        this.length = -1L;
        this.metadata = metadata;
        this.MAX_COUNT = Config.getInstance().getMaxSegments();
        this.urlList = new ArrayList();
        this.chunks = new ArrayList();
        this.eta = "---";
    }

    @Override
    public void start() {
        Logger.log("creating folder " + this.folder);
        new File(this.folder).mkdirs();
        this.lastDownloaded = this.downloaded;
        this.prevTime = System.currentTimeMillis();
        try {
            this.manifestSegment = new SegmentImpl(this, this.folder);
            this.manifestSegment.setTag("MF");
            this.manifestSegment.setLength(-1L);
            this.manifestSegment.setStartOffset(0L);
            this.manifestSegment.setDownloaded(0L);
            this.manifestSegment.setTag("HLS");
            this.manifestSegment.download(this);
        }
        catch (IOException e) {
            this.errorCode = 135;
            this.listener.downloadFailed(this.id);
        }
    }

    @Override
    public void chunkInitiated(String id) {
        if (!id.equals(this.manifestSegment.getId())) {
            System.out.println("Non manifest segment: " + id + " manifest seg: " + this.manifestSegment.getId());
            this.processSegments();
        } else {
            this.isJavaClientRequired = ((HttpChannel)this.manifestSegment.getChannel()).isJavaClientRequired();
            super.getLastModifiedDate(this.manifestSegment);
        }
    }

    @Override
    public boolean chunkComplete(String id) {
        Segment s;
        if (this.finished) {
            return true;
        }
        if (this.stopFlag) {
            return true;
        }
        if (id.equals(this.manifestSegment.getId())) {
            Logger.log("Manifest segment complete: " + id);
            if (this.initOrUpdateSegments()) {
                this.listener.downloadConfirmed(this.id);
            } else if (!this.stopFlag) {
                this.errorCode = 100;
                this.listener.downloadFailed(this.id);
                return true;
            }
        } else {
            s = this.getById(id);
            if (s.getLength() < 0L) {
                s.setLength(s.getDownloaded());
            }
            if (this.allFinished()) {
                block12: {
                    this.saveState();
                    this.finished = true;
                    this.updateStatus();
                    try {
                        this.assemble();
                        if (!this.assembleFinished) {
                            throw new IOException("Assemble not finished successfully");
                        }
                        Logger.log("********Download finished*********");
                        this.updateStatus();
                        this.listener.downloadFinished(this.id);
                    }
                    catch (Exception e) {
                        if (this.stopFlag) break block12;
                        Logger.log(e);
                        this.errorCode = 132;
                        this.listener.downloadFailed(this.id);
                    }
                }
                this.listener = null;
                return true;
            }
        }
        s = this.getById(id);
        this.clearChannel(s);
        this.processSegments();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void chunkUpdated(String id) {
        HlsDownloader hlsDownloader;
        if (this.manifestSegment != null && id.equals(this.manifestSegment.getId())) {
            return;
        }
        if (this.stopFlag) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastSaved > 5000L) {
            hlsDownloader = this;
            synchronized (hlsDownloader) {
                this.saveState();
            }
            this.lastSaved = now;
        }
        if (now - this.lastUpdated > 1000L) {
            this.updateStatus();
            this.lastUpdated = now;
            hlsDownloader = this;
            synchronized (hlsDownloader) {
                this.processSegments();
            }
        }
    }

    @Override
    public AbstractChannel createChannel(Segment segment) {
        int i = 0;
        while (i < this.chunks.size()) {
            if (segment == this.chunks.get(i)) {
                HlsMetadata md = new HlsMetadata();
                md.setUrl(this.urlList.get(i));
                md.setHeaders(this.metadata.getHeaders());
                return new HttpChannel(segment, md.getUrl(), md.getHeaders(), -1L, this.isJavaClientRequired);
            }
            ++i;
        }
        Logger.log("Create manifest channel");
        return new HttpChannel(segment, this.metadata.getUrl(), this.metadata.getHeaders(), -1L, this.isJavaClientRequired);
    }

    @Override
    public boolean shouldCleanup() {
        return this.assembleFinished;
    }

    private boolean initOrUpdateSegments() {
        ArrayList<String> urls;
        block11: {
            block10: {
                M3U8Manifest mf = new M3U8Manifest(new File(this.folder, this.manifestSegment.getId()).getAbsolutePath(), this.metadata.getUrl());
                this.totalDuration = mf.getDuration();
                Logger.log("Total duration");
                urls = mf.getMediaUrls();
                if (urls.size() >= 1) break block10;
                Logger.log("Manifest contains no media");
                return false;
            }
            if (this.urlList.size() <= 0 || this.urlList.size() == urls.size()) break block11;
            Logger.log("Manifest media count mismatch- expected: " + this.urlList.size() + " got: " + urls.size());
            return false;
        }
        try {
            if (this.urlList.size() > 0) {
                this.urlList.clear();
            }
            this.urlList.addAll(urls);
            String newExtension = null;
            if (this.chunks.size() < 1) {
                int i = 0;
                while (i < this.urlList.size()) {
                    if (newExtension == null && this.outputFormat == 0) {
                        newExtension = this.findExtension(this.urlList.get(i));
                        if (newExtension != null) {
                            Logger.log("HLS: found new extension: " + newExtension);
                            this.newFileName = this.getOutputFileName(true).replace(".ts", newExtension);
                        } else {
                            newExtension = ".ts";
                        }
                    }
                    Logger.log("segment creating for url: " + this.urlList.get(i));
                    SegmentImpl s2 = new SegmentImpl(this, this.folder);
                    s2.setTag("HLS");
                    s2.setLength(-1L);
                    Logger.log("Adding chunk: " + s2);
                    this.chunks.add(s2);
                    ++i;
                }
                System.out.println("Segments created");
            }
            return true;
        }
        catch (Exception e) {
            Logger.log(e);
            return false;
        }
    }

    private synchronized void processSegments() {
        Logger.log("HLS: process segment");
        int activeCount = this.getActiveChunkCount();
        Logger.log("active: " + activeCount);
        if (activeCount < this.MAX_COUNT) {
            int rem = this.MAX_COUNT - activeCount;
            try {
                this.retryFailedChunks(rem);
            }
            catch (IOException e) {
                Logger.log(e);
            }
        }
    }

    private void updateStatus() {
        try {
            long now = System.currentTimeMillis();
            if (this.eta == null) {
                this.eta = "---";
            }
            if (this.converting) {
                this.progress = this.convertPrg;
            } else if (this.assembling) {
                long len = this.length > 0L ? this.length : this.downloaded;
                this.progress = (int)(this.totalAssembled * 100L / len);
            } else {
                long downloaded2 = 0L;
                int processedSegments = 0;
                int partPrg = 0;
                this.downloadSpeed = 0.0f;
                int i = 0;
                while (i < this.chunks.size()) {
                    Segment s = (Segment)this.chunks.get(i);
                    downloaded2 += s.getDownloaded();
                    this.downloadSpeed += s.getTransferRate();
                    if (s.isFinished()) {
                        ++processedSegments;
                    } else if (s.getDownloaded() > 0L && s.getLength() > 0L) {
                        int prg2 = (int)(s.getDownloaded() * 100L / s.getLength());
                        partPrg += prg2;
                    }
                    ++i;
                }
                this.downloaded = downloaded2;
                if (this.chunks.size() > 0) {
                    this.progress = processedSegments * 100 / this.chunks.size();
                    this.progress += partPrg / this.chunks.size();
                    if (this.segDet == null) {
                        this.segDet = new SegmentDetails();
                        if (this.segDet.getCapacity() < this.chunks.size()) {
                            this.segDet.extend(this.chunks.size() - this.segDet.getCapacity());
                        }
                        this.segDet.setChunkCount(this.chunks.size());
                    }
                    SegmentInfo info = this.segDet.getChunkUpdates().get(0);
                    info.setDownloaded(this.progress);
                    info.setLength(100L);
                    info.setStart(0L);
                    long diff = this.downloaded - this.lastDownloaded;
                    long timeSpend = now - this.prevTime;
                    if (timeSpend > 0L) {
                        int prgDiff;
                        float rate = (float)diff / (float)timeSpend * 1000.0f;
                        if (rate > this.downloadSpeed) {
                            this.downloadSpeed = rate;
                        }
                        if ((prgDiff = this.progress - this.lastProgress) > 0) {
                            long eta = timeSpend * (long)(100 - this.progress) / 1000L * (long)prgDiff;
                            this.lastProgress = this.progress;
                            this.eta = FormatUtilities.hms((int)eta);
                        }
                        this.prevTime = now;
                        this.lastDownloaded = this.downloaded;
                    }
                }
            }
            this.listener.downloadUpdated(this.id);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    @Override
    public void stop() {
        this.stopFlag = true;
        this.saveState();
        int i = 0;
        while (i < this.chunks.size()) {
            ((Segment)this.chunks.get(i)).stop();
            ++i;
        }
        if (this.ffmpeg != null) {
            this.ffmpeg.stop();
        }
        this.listener.downloadStopped(this.id);
        this.listener = null;
    }

    @Override
    public void resume() {
        try {
            this.stopFlag = false;
            Logger.log("Resuming");
            if (!this.restoreState()) {
                Logger.log("Starting from beginning");
                this.start();
                return;
            }
            Logger.log("Restore success");
            this.lastDownloaded = this.downloaded;
            this.lastProgress = this.progress;
            this.prevTime = System.currentTimeMillis();
            if (this.allFinished()) {
                this.assembleAsync();
            } else {
                Logger.log("Starting");
                this.start();
            }
        }
        catch (Exception e) {
            Logger.log(e);
            this.errorCode = 135;
            this.listener.downloadFailed(this.id);
            return;
        }
    }

    @Override
    public int getType() {
        return 1001;
    }

    @Override
    public boolean isFileNameChanged() {
        return this.newFileName != null;
    }

    @Override
    public String getNewFile() {
        return this.newFileName;
    }

    @Override
    public HttpMetadata getMetadata() {
        return this.metadata;
    }

    private void saveState() {
        if (this.chunks.size() < 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.length) + "\n");
        sb.append(String.valueOf(this.downloaded) + "\n");
        sb.append(String.valueOf((long)this.totalDuration) + "\n");
        sb.append(String.valueOf(this.urlList.size()) + "\n");
        int i = 0;
        while (i < this.urlList.size()) {
            String url = this.urlList.get(i);
            sb.append(String.valueOf(url) + "\n");
            ++i;
        }
        sb.append(String.valueOf(this.chunks.size()) + "\n");
        i = 0;
        while (i < this.chunks.size()) {
            Segment seg = (Segment)this.chunks.get(i);
            sb.append(String.valueOf(seg.getId()) + "\n");
            if (seg.isFinished()) {
                sb.append(String.valueOf(seg.getLength()) + "\n");
                sb.append(String.valueOf(seg.getStartOffset()) + "\n");
                sb.append(String.valueOf(seg.getDownloaded()) + "\n");
            } else {
                sb.append("-1\n");
                sb.append(String.valueOf(seg.getStartOffset()) + "\n");
                sb.append(String.valueOf(seg.getDownloaded()) + "\n");
            }
            ++i;
        }
        if (!StringUtils.isNullOrEmptyOrBlank(this.lastModified)) {
            sb.append(String.valueOf(this.lastModified) + "\n");
        }
        try {
            File tmp = new File(this.folder, String.valueOf(System.currentTimeMillis()) + ".tmp");
            File out = new File(this.folder, "state.txt");
            FileOutputStream fs = new FileOutputStream(tmp);
            fs.write(sb.toString().getBytes());
            fs.close();
            out.delete();
            tmp.renameTo(out);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    private boolean restoreState() {
        BufferedReader br = null;
        this.chunks = new ArrayList();
        File file = new File(this.folder, "state.txt");
        if (!file.exists() && (file = this.getBackupFile(this.folder)) == null) {
            return false;
        }
        try {
            br = new BufferedReader(new FileReader(file));
            this.length = Long.parseLong(br.readLine());
            this.downloaded = Long.parseLong(br.readLine());
            this.totalDuration = Long.parseLong(br.readLine());
            int urlCount = Integer.parseInt(br.readLine());
            int i = 0;
            while (i < urlCount) {
                String url = br.readLine();
                this.urlList.add(url);
                ++i;
            }
            int chunkCount = Integer.parseInt(br.readLine());
            int i2 = 0;
            while (i2 < chunkCount) {
                String cid = br.readLine();
                long len = Long.parseLong(br.readLine());
                long off = Long.parseLong(br.readLine());
                long dwn = Long.parseLong(br.readLine());
                SegmentImpl seg = new SegmentImpl(this.folder, cid, off, len, dwn);
                seg.setTag("HLS");
                Logger.log("id: " + seg.getId() + "\nlength: " + seg.getLength() + "\noffset: " + seg.getStartOffset() + "\ndownload: " + seg.getDownloaded());
                this.chunks.add(seg);
                ++i2;
            }
            this.lastModified = br.readLine();
            return true;
        }
        catch (Exception e) {
            Logger.log("Failed to load saved state");
            Logger.log(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private void assembleAsync() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block3: {
                    HlsDownloader.this.finished = true;
                    try {
                        HlsDownloader.this.assemble();
                        if (!HlsDownloader.this.assembleFinished) {
                            throw new IOException("Assemble not finished successfully");
                        }
                        Logger.log("********Download finished*********");
                        HlsDownloader.this.updateStatus();
                        HlsDownloader.this.cleanup();
                        HlsDownloader.this.listener.downloadFinished(HlsDownloader.this.id);
                    }
                    catch (Exception e) {
                        if (HlsDownloader.this.stopFlag) break block3;
                        Logger.log(e);
                        HlsDownloader.this.errorCode = 132;
                        HlsDownloader.this.listener.downloadFailed(HlsDownloader.this.id);
                    }
                }
            }
        }).start();
    }

    private String findExtension(String urlStr) {
        String ext;
        String newExtension = null;
        String fileName = XDMUtils.getFileName(urlStr);
        if (!(StringUtils.isNullOrEmptyOrBlank(fileName) || StringUtils.isNullOrEmptyOrBlank(ext = XDMUtils.getExtension(fileName)) || ext.length() <= 1 || ext.toLowerCase().contains("ts"))) {
            newExtension = ext.toLowerCase();
            if (newExtension.contains("m4s")) {
                Logger.log("HLS extension: MP4");
                newExtension = ".mp4";
            }
            if (!newExtension.contains("mp4")) {
                newExtension = ".mkv";
            }
        }
        return newExtension;
    }

    private void assemble() throws IOException {
        File ffOutFile = null;
        XDMUtils.mkdirs(this.getOutputFolder());
        try {
            File realFile;
            this.assembleFinished = false;
            StringBuffer sb = new StringBuffer();
            for (Segment s : this.chunks) {
                sb.append("file '" + new File(this.folder, s.getId()) + "'\r\n");
            }
            FileOutputStream hlsTextStream = null;
            File hlsFile = new File(this.folder, String.valueOf(this.id) + "-hls.txt");
            try {
                hlsTextStream = new FileOutputStream(hlsFile);
                ((OutputStream)hlsTextStream).write(sb.toString().getBytes());
                ((OutputStream)hlsTextStream).close();
            }
            catch (Exception e) {
                try {
                    ((OutputStream)hlsTextStream).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.converting = true;
            ArrayList<String> inputFiles = new ArrayList<String>();
            inputFiles.add(hlsFile.getAbsolutePath());
            ffOutFile = new File(this.getOutputFolder(), UUID.randomUUID() + "_" + this.getOutputFileName(true));
            this.ffmpeg = new FFmpeg(inputFiles, ffOutFile.getAbsolutePath(), this, MediaFormats.getSupportedFormats()[this.outputFormat], this.outputFormat == 0);
            this.ffmpeg.setHls(true);
            this.ffmpeg.setHLSDuration(this.totalDuration);
            int ret = this.ffmpeg.convert();
            Logger.log("FFmpeg exit code: " + ret);
            if (ret != 0) {
                throw new IOException("FFmpeg failed");
            }
            long length = ffOutFile.length();
            if (length > 0L) {
                this.length = length;
            }
            if ((realFile = new File(this.getOutputFolder(), this.getOutputFileName(true))).exists()) {
                realFile.delete();
            }
            ffOutFile.renameTo(realFile);
            this.assembleFinished = true;
        }
        finally {
            if (!this.assembleFinished && ffOutFile != null) {
                ffOutFile.delete();
            }
        }
    }

    @Override
    public void progress(int progress) {
        this.convertPrg = progress;
        long now = System.currentTimeMillis();
        if (now - this.lastUpdated > 1000L) {
            this.updateStatus();
            this.lastUpdated = now;
        }
    }
}

