/*
 * Decompiled with CFR 0.152.
 */
package xdman.downloaders.metadata.manifests;

import java.io.FileReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import xdman.util.Base64;
import xdman.util.Logger;
import xdman.util.StringUtils;

public class F4MManifest {
    private static XPath xpath;
    private long selectedBitRate;
    private ArrayList<Fragment> fragTable;
    private ArrayList<Segment> segTable;
    private int duration;
    private long fromTimestamp;
    private int start;
    private boolean live;
    private int fragCount;
    private int segStart;
    private int fragStart;
    private boolean isMetadata;
    private int fragsPerSeg;
    private F4MMedia selectedMedia;
    private int segNum;
    private int fragNum;
    private int lastFrag;
    private String fragUrl;
    private String baseUrl;
    private int discontinuity;
    private String query;
    private String pv;
    private String url;
    private String file;

    public F4MManifest(String url, String file) {
        this.url = url;
        this.file = file;
    }

    public ArrayList<String> getMediaUrls() throws Exception {
        ArrayList<String> urlList = new ArrayList<String>();
        this.fragTable = new ArrayList();
        this.segTable = new ArrayList();
        this.query = this.getQuery(this.url);
        this.parseDoc(this.loadDoc(this.file), this.url);
        this.segNum = this.segStart;
        this.fragNum = this.fragStart;
        if (this.start > 0) {
            this.segNum = this.getSegmentFromFragment(this.start);
            this.fragNum = this.start - 1;
            this.segStart = this.segNum;
            this.fragStart = this.fragNum;
        }
        byte[] fragmentData = new byte[]{};
        this.lastFrag = this.fragNum;
        System.out.println(String.valueOf(this.fragNum) + " " + this.fragCount);
        if (this.fragNum >= this.fragCount) {
            throw new Exception("No fragment available for downloading");
        }
        Logger.log("[F4M Parser: selectedMedia.url: " + this.selectedMedia.url);
        if (this.selectedMedia.getUrl().startsWith("http")) {
            System.out.println("============ " + this.selectedMedia.getUrl());
            this.fragUrl = this.selectedMedia.getUrl();
        } else {
            this.fragUrl = this.baseUrl.endsWith("/") ? String.valueOf(this.baseUrl) + this.selectedMedia.getUrl() : String.valueOf(this.baseUrl) + "/" + this.selectedMedia.getUrl();
        }
        Logger.log("fragUrl: " + this.fragUrl + "\nfragCount: " + this.fragCount + " baseUrl: " + this.baseUrl);
        int fragsToDownload = this.fragCount - this.fragNum;
        while (this.fragNum < this.fragCount) {
            Logger.log("Remaining: " + (this.fragCount - this.fragNum));
            ++this.fragNum;
            this.segNum = this.getSegmentFromFragment(this.fragNum);
            int fragIndex = this.findFragmentInTable(this.fragNum);
            if (fragIndex >= 0) {
                this.discontinuity = this.fragTable.get(fragIndex).discontinuityIndicator;
            } else {
                int i = 0;
                while (i < this.fragTable.size()) {
                    if (this.fragTable.get(i).firstFragment >= this.fragNum) {
                        this.discontinuity = this.fragTable.get(i).discontinuityIndicator;
                        break;
                    }
                    ++i;
                }
            }
            if (this.discontinuity != 0) {
                Logger.log("Skipping fragment " + this.fragNum + " due to discontinuity, Type: " + this.discontinuity);
                continue;
            }
            String ___url = this.getFragmentUrl(this.segNum, this.fragNum);
            if (!StringUtils.isNullOrEmpty(this.query)) {
                ___url = ___url.contains("?") ? String.valueOf(___url) + "&" + this.query : String.valueOf(___url) + "?" + this.query;
            }
            if (!StringUtils.isNullOrEmpty(this.pv)) {
                ___url = ___url.contains("?") ? String.valueOf(___url) + "&" + this.pv : String.valueOf(___url) + "?" + this.pv;
            }
            Logger.log(___url);
            urlList.add(___url);
        }
        return urlList;
    }

    private void parseDoc(Document doc, String surl) throws XPathExpressionException {
        if (xpath == null) {
            F4MManifest.initXPath();
        }
        this.baseUrl = xpath.evaluate("/ns:manifest/ns:baseURL", doc);
        if (StringUtils.isNullOrEmptyOrBlank(this.baseUrl)) {
            try {
                URL url = new URL(surl);
                StringBuilder sb = new StringBuilder();
                sb.append(url.getProtocol());
                sb.append("://");
                sb.append(url.getHost());
                int port = url.getPort();
                if (port < 1) {
                    port = url.getDefaultPort();
                }
                sb.append(port == 80 ? "" : Integer.valueOf(port));
                String path = url.getPath();
                String[] arr = path.split("/");
                int i = 0;
                while (i < arr.length - 1) {
                    if (arr[i].length() > 0) {
                        sb.append("/" + arr[i]);
                    }
                    ++i;
                }
                this.baseUrl = sb.toString();
                System.out.println("*** URL: " + this.baseUrl);
            }
            catch (Exception url) {
                // empty catch block
            }
        }
        this.pv = xpath.evaluate("/ns:manifest/ns:pv-2.0", doc);
        NodeList mediaNodeList = (NodeList)xpath.evaluate("/ns:manifest/ns:media", doc, XPathConstants.NODESET);
        F4MMedia media = null;
        int i = 0;
        while (i < mediaNodeList.getLength()) {
            Node mediaNode = mediaNodeList.item(i);
            NamedNodeMap attrMap = mediaNode.getAttributes();
            Node bitRateAttr = attrMap.getNamedItem("bitrate");
            long bitRate = 0L;
            if (bitRateAttr != null) {
                bitRate = Long.parseLong(bitRateAttr.getNodeValue());
            }
            boolean mediaFound = false;
            if (this.selectedBitRate > 0L) {
                if (this.selectedBitRate == bitRate) {
                    mediaFound = true;
                }
            } else {
                mediaFound = true;
            }
            if (mediaFound) {
                media = new F4MMedia();
                media.setBaseUrl(this.baseUrl);
                media.setBitRate(bitRate);
                media.setUrl(attrMap.getNamedItem("url").getNodeValue());
                Node bootstrapInfoIdNode = attrMap.getNamedItem("bootstrapInfoId");
                String bootstrapInfoStr = null;
                if (bootstrapInfoIdNode != null) {
                    String bootstrapInfoId = bootstrapInfoIdNode.getNodeValue();
                    bootstrapInfoStr = xpath.evaluate("/ns:manifest/ns:bootstrapInfo[@id='" + bootstrapInfoId + "']", doc);
                } else {
                    bootstrapInfoStr = xpath.evaluate("/ns:manifest/ns:bootstrapInfo", doc);
                }
                media.setBootstrap(Base64.decode(bootstrapInfoStr));
                break;
            }
            ++i;
        }
        if (media == null) {
            Logger.log("Could not find media");
            return;
        }
        int pos = 0;
        BufferPointer ptr = new BufferPointer();
        ptr.setBuf(media.getBootstrap());
        ptr.setPos(pos);
        BoxInfo boxInfo = this.readBoxHeader(ptr);
        pos = ptr.getPos();
        long boxSize = boxInfo.getBoxSize();
        String boxType = boxInfo.getBoxType();
        if (boxType.equals("abst")) {
            this.parseBootstrapBox(media.bootstrap, pos);
        }
        if (this.fragsPerSeg == 0) {
            this.fragsPerSeg = this.fragCount;
        }
        if (this.live) {
            this.fromTimestamp = -1L;
            Logger.log("F4M Parser: [Live stream]");
        } else {
            Logger.log("F4M Parser: [Not Live stream]");
        }
        Logger.log("F4M Parser: Start- " + this.start);
        this.selectedMedia = media;
    }

    public long[] getBitRates() {
        NodeList mediaNodeList;
        block7: {
            Document doc;
            if (xpath == null) {
                F4MManifest.initXPath();
            }
            if ((mediaNodeList = (NodeList)xpath.evaluate("/ns:manifest/ns:media", doc = this.loadDoc(this.file), XPathConstants.NODESET)) != null) break block7;
            return null;
        }
        try {
            ArrayList<Long> bitRates = new ArrayList<Long>();
            int i = 0;
            while (i < mediaNodeList.getLength()) {
                Node mediaNode = mediaNodeList.item(i);
                Node bitRateAttr = mediaNode.getAttributes().getNamedItem("bitrate");
                if (bitRateAttr != null) {
                    bitRates.add(Long.parseLong(bitRateAttr.getNodeValue()));
                }
                ++i;
            }
            long[] bitRateArr = new long[bitRates.size()];
            int i2 = 0;
            while (i2 < bitRateArr.length) {
                bitRateArr[i2] = (Long)bitRates.get(i2);
                ++i2;
            }
            return bitRateArr;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Document loadDoc(String fileName) {
        FileReader r = null;
        try {
            Document doc;
            r = new FileReader(fileName);
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document document = doc = builder.parse(new InputSource(r));
            return document;
        }
        catch (Exception e) {
            Logger.log(e);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private static final void initXPath() {
        xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public Iterator<String> getPrefixes(String s) {
                return null;
            }

            @Override
            public String getPrefix(String s) {
                return null;
            }

            @Override
            public String getNamespaceURI(String s) {
                if ("ns".equals(s)) {
                    return "http://ns.adobe.com/f4m/1.0";
                }
                return null;
            }
        });
    }

    private int getSegmentFromFragment(int fragN) {
        if (this.segTable.size() == 0 || this.fragTable.size() == 0) {
            return 1;
        }
        Segment firstSegment = this.segTable.get(0);
        Segment lastSegment = this.segTable.get(this.segTable.size() - 1);
        Fragment firstFragment = this.fragTable.get(0);
        Fragment lastFragment = this.fragTable.get(this.fragTable.size() - 1);
        if (this.segTable.size() == 1) {
            return firstSegment.firstSegment;
        }
        Segment prev = firstSegment;
        int start = firstFragment.firstFragment;
        int i = firstSegment.firstSegment;
        while (i <= lastSegment.firstSegment) {
            Segment seg = this.segTable.size() >= i - 1 ? this.segTable.get(i) : prev;
            int end = start + seg.fragmentsPerSegment;
            if (fragN >= start && fragN < end) {
                return i;
            }
            prev = seg;
            start = end;
            ++i;
        }
        return lastSegment.firstSegment;
    }

    private void parseBootstrapBox(byte[] bootstrapInfo, int pos) {
        BoxInfo boxInfo;
        System.out.println("parsing abst");
        this.live = false;
        this.isMetadata = true;
        int version = this.readByte(bootstrapInfo, pos);
        int flags = (int)this.readInt24(bootstrapInfo, pos + 1);
        int bootstrapVersion = (int)F4MManifest.readInt32(bootstrapInfo, pos + 4);
        int b = this.readByte(bootstrapInfo, pos + 8);
        int profile = (b & 0xC0) >> 6;
        int update = (b & 0x10) >> 4;
        if ((b & 0x20) >> 5 > 0) {
            this.live = true;
            this.isMetadata = false;
        }
        if (update == 0) {
            this.segTable.clear();
            this.fragTable.clear();
        }
        int timescale = (int)F4MManifest.readInt32(bootstrapInfo, pos + 9);
        long currentMediaTime = F4MManifest.readInt64(bootstrapInfo, 13);
        long smpteTimeCodeOffset = F4MManifest.readInt64(bootstrapInfo, 21);
        BufferPointer bPtr = new BufferPointer();
        bPtr.setBuf(bootstrapInfo);
        bPtr.setPos(pos += 29);
        String movieIdentifier = this.readString(bPtr);
        Logger.log("[F4M Parser- movieIdentifier: " + movieIdentifier);
        pos = bPtr.getPos();
        int serverEntryCount = this.readByte(bootstrapInfo, pos++);
        bPtr.setPos(pos);
        int i = 0;
        while (i < serverEntryCount) {
            this.readString(bPtr);
            ++i;
        }
        int qualityEntryCount = this.readByte(bootstrapInfo, pos++);
        bPtr.setPos(pos);
        int i2 = 0;
        while (i2 < qualityEntryCount) {
            this.readString(bPtr);
            ++i2;
        }
        String drmData = this.readString(bPtr);
        String smetadata = this.readString(bPtr);
        pos = bPtr.getPos();
        int segRunTableCount = this.readByte(bootstrapInfo, pos++);
        long boxSize = 0L;
        BufferPointer ptr = new BufferPointer();
        ptr.setBuf(bootstrapInfo);
        int i3 = 0;
        while (i3 < segRunTableCount) {
            ptr.setPos(pos);
            String boxType = "";
            boxInfo = this.readBoxHeader(ptr);
            boxSize = boxInfo.getBoxSize();
            boxType = boxInfo.getBoxType();
            pos = ptr.getPos();
            if (boxType.equals("asrt")) {
                this.parseAsrtBox(bootstrapInfo, pos);
            }
            pos = (int)((long)pos + boxSize);
            ++i3;
        }
        int fragRunTableCount = this.readByte(bootstrapInfo, pos++);
        int i4 = 0;
        while (i4 < fragRunTableCount) {
            ptr.setPos(pos);
            boxInfo = this.readBoxHeader(ptr);
            pos = ptr.getPos();
            boxSize = boxInfo.getBoxSize();
            String boxType = boxInfo.getBoxType();
            Logger.log("555 " + boxType + " " + boxSize);
            if (boxType.equals("afrt")) {
                this.parseAfrtBox(bootstrapInfo, pos);
            }
            pos += (int)boxSize;
            ++i4;
        }
        this.parseSegAndFragTable();
    }

    private void parseSegAndFragTable() {
        Logger.log("parseSegAndFragTable called");
        if (this.segTable.size() == 0 || this.fragTable.size() == 0) {
            System.out.println("return as zero " + this.segTable.size() + " " + this.fragTable.size());
            return;
        }
        Segment firstSegment = this.segTable.get(0);
        Segment lastSegment = this.segTable.get(this.segTable.size() - 1);
        Fragment firstFragment = this.fragTable.get(0);
        Fragment lastFragment = this.fragTable.get(this.fragTable.size() - 1);
        if (lastFragment.fragmentDuration == 0 && lastFragment.discontinuityIndicator == 0) {
            this.live = false;
            if (this.fragTable.size() > 0) {
                this.fragTable.remove(this.fragTable.size() - 1);
            }
            if (this.fragTable.size() > 0) {
                lastFragment = this.fragTable.get(this.fragTable.size() - 1);
            }
        }
        boolean invalidFragCount = false;
        Segment prev = this.segTable.get(0);
        this.fragCount = prev.fragmentsPerSegment;
        int i = 0;
        while (i < this.segTable.size()) {
            Segment current = this.segTable.get(i);
            this.fragCount += (current.firstSegment - prev.firstSegment - 1) * prev.fragmentsPerSegment;
            this.fragCount += current.fragmentsPerSegment;
            prev = current;
            ++i;
        }
        if ((this.fragCount & Integer.MIN_VALUE) == 0) {
            this.fragCount += firstFragment.firstFragment - 1;
        }
        if ((this.fragCount & Integer.MIN_VALUE) != 0) {
            this.fragCount = 0;
            invalidFragCount = true;
        }
        if (this.fragCount < lastFragment.firstFragment) {
            this.fragCount = lastFragment.firstFragment;
        }
        if (this.segStart < 0) {
            this.segStart = this.live ? lastSegment.firstSegment : firstSegment.firstSegment;
            if (this.segStart < 1) {
                this.segStart = 1;
            }
        }
        if (this.fragStart < 0) {
            this.fragStart = this.live && !invalidFragCount ? this.fragCount - 2 : firstFragment.firstFragment - 1;
            if (this.fragStart < 0) {
                this.fragStart = 0;
            }
        }
    }

    private void parseAsrtBox(byte[] asrt, int pos) {
        System.out.println("parsing asrt");
        int version = this.readByte(asrt, pos);
        int flags = (int)this.readInt24(asrt, pos + 1);
        int qualityEntryCount = this.readByte(asrt, pos + 4);
        this.segTable.clear();
        pos += 5;
        BufferPointer bPtr = new BufferPointer();
        int i = 0;
        while (i < qualityEntryCount) {
            bPtr.setBuf(asrt);
            bPtr.setPos(pos);
            this.readString(bPtr);
            pos = bPtr.getPos();
            ++i;
        }
        int segCount = (int)F4MManifest.readInt32(asrt, pos);
        pos += 4;
        System.out.println("segcount: " + segCount);
        int i2 = 0;
        while (i2 < segCount) {
            int firstSegment = (int)F4MManifest.readInt32(asrt, pos);
            Segment segEntry = new Segment();
            segEntry.firstSegment = firstSegment;
            segEntry.fragmentsPerSegment = (int)F4MManifest.readInt32(asrt, pos + 4);
            if ((segEntry.fragmentsPerSegment & Integer.MIN_VALUE) > 0) {
                segEntry.fragmentsPerSegment = 0;
            }
            pos += 8;
            this.segTable.add(segEntry);
            ++i2;
        }
    }

    private void parseAfrtBox(byte[] afrt, int pos) {
        System.out.println("Parse afrt");
        this.fragTable.clear();
        int version = this.readByte(afrt, pos);
        int flags = (int)this.readInt24(afrt, pos + 1);
        int timescale = (int)F4MManifest.readInt32(afrt, pos + 4);
        int qualityEntryCount = this.readByte(afrt, pos + 8);
        pos += 9;
        BufferPointer args = new BufferPointer();
        int i = 0;
        while (i < qualityEntryCount) {
            args.setBuf(afrt);
            args.setPos(pos);
            this.readString(args);
            pos = args.getPos();
            ++i;
        }
        int fragEntries = (int)F4MManifest.readInt32(afrt, pos);
        pos += 4;
        int i2 = 0;
        while (i2 < fragEntries) {
            int firstFragment = (int)F4MManifest.readInt32(afrt, pos);
            Fragment fragEntry = new Fragment();
            fragEntry.firstFragment = firstFragment;
            fragEntry.firstFragmentTimestamp = F4MManifest.readInt64(afrt, pos + 4);
            fragEntry.fragmentDuration = (int)F4MManifest.readInt32(afrt, pos + 12);
            this.duration += fragEntry.fragmentDuration;
            fragEntry.discontinuityIndicator = 0;
            pos += 16;
            if (fragEntry.fragmentDuration == 0) {
                fragEntry.discontinuityIndicator = this.readByte(afrt, pos++);
            }
            this.fragTable.add(fragEntry);
            if (this.fromTimestamp > 0L && fragEntry.firstFragmentTimestamp > 0L && fragEntry.firstFragmentTimestamp < this.fromTimestamp) {
                this.start = fragEntry.firstFragment + 1;
            }
            ++i2;
        }
    }

    private BoxInfo readBoxHeader(BufferPointer ptr) {
        int pos = ptr.getPos();
        byte[] bytesData = ptr.getBuf();
        StringBuilder boxType = new StringBuilder();
        long boxSize = 0L;
        boxSize = F4MManifest.readInt32(bytesData, pos);
        boxType.append(this.readStringBytes(bytesData, pos + 4, 4L));
        if (boxSize == 1L) {
            boxSize = F4MManifest.readInt64(bytesData, pos + 8) - 16L;
            pos += 16;
        } else {
            boxSize -= 8L;
            pos += 8;
        }
        ptr.setPos(pos);
        BoxInfo boxInfo = new BoxInfo();
        boxInfo.setBoxSize(boxSize);
        boxInfo.setBoxType(boxType.toString());
        return boxInfo;
    }

    private String readStringBytes(byte[] bytesData, int pos, long len) {
        StringBuilder resultValue = new StringBuilder();
        int i = 0;
        while ((long)i < len) {
            resultValue.append((char)bytesData[pos + i]);
            ++i;
        }
        return resultValue.toString();
    }

    private String readString(BufferPointer bufPtr) {
        byte[] bytesData = bufPtr.getBuf();
        int pos = bufPtr.getPos();
        StringBuilder resultValue = new StringBuilder();
        int bytesCount = bytesData.length;
        while (pos < bytesCount && bytesData[pos] != 0) {
            resultValue.append((char)bytesData[pos]);
            ++pos;
        }
        bufPtr.setPos(++pos);
        return resultValue.toString();
    }

    private int readByte(byte[] data, int pos) {
        return data[pos] & 0xFF;
    }

    private long readInt24(byte[] data, int pos) {
        long iValLo = data[pos + 2] & 255 + (data[pos + 1] & 0xFF) * 256;
        long iValHi = data[pos + 0] & 0xFF;
        long iVal = iValLo + iValHi * 65536L;
        return iVal;
    }

    private static long readInt32(byte[] data, int pos) {
        long iValLo = (long)(data[pos + 3] & 0xFF) + (long)(data[pos + 2] & 0xFF) * 256L;
        long iValHi = (long)(data[pos + 1] & 0xFF) + (long)(data[pos + 0] & 0xFF) * 256L;
        long iVal = iValLo + iValHi * 65536L;
        return iVal;
    }

    private static long readInt64(byte[] data, int pos) {
        long iValLo = F4MManifest.readInt32(data, pos + 4);
        long iValHi = F4MManifest.readInt32(data, pos + 0);
        long iVal = iValLo + iValHi * 0x100000000L;
        return iVal;
    }

    private int findFragmentInTable(int needle) {
        int i = 0;
        while (i < this.fragTable.size()) {
            if (this.fragTable.get(i).firstFragment == needle) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String getQuery(String url) {
        int index = url.indexOf(63);
        if (index < 0) {
            return "";
        }
        return url.substring(index + 1);
    }

    private String getFragmentUrl(int segNum, int fragNum) {
        return String.valueOf(this.fragUrl) + "Seg" + segNum + "-Frag" + fragNum;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public long getSelectedBitRate() {
        return this.selectedBitRate;
    }

    public void setSelectedBitRate(long selectedBitRate) {
        this.selectedBitRate = selectedBitRate;
    }

    class BoxInfo {
        private String boxType;
        private long boxSize;

        BoxInfo() {
        }

        public String getBoxType() {
            return this.boxType;
        }

        public void setBoxType(String boxType) {
            this.boxType = boxType;
        }

        public long getBoxSize() {
            return this.boxSize;
        }

        public void setBoxSize(long boxSize) {
            this.boxSize = boxSize;
        }
    }

    class BufferPointer {
        private byte[] buf;
        private int pos;

        BufferPointer() {
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public void setBuf(byte[] buf) {
            this.buf = buf;
        }

        public int getPos() {
            return this.pos;
        }

        public void setPos(int pos) {
            this.pos = pos;
        }
    }

    static class F4MMedia {
        private String baseUrl;
        private String url;
        private String bootstrapUrl;
        private byte[] bootstrap;
        private byte[] metadata;
        private long bitRate;

        F4MMedia() {
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getBootstrapUrl() {
            return this.bootstrapUrl;
        }

        public void setBootstrapUrl(String bootstrapUrl) {
            this.bootstrapUrl = bootstrapUrl;
        }

        public byte[] getBootstrap() {
            return this.bootstrap;
        }

        public void setBootstrap(byte[] bootstrap) {
            this.bootstrap = bootstrap;
        }

        public byte[] getMetadata() {
            return this.metadata;
        }

        public void setMetadata(byte[] metadata) {
            this.metadata = metadata;
        }

        public long getBitRate() {
            return this.bitRate;
        }

        public void setBitRate(long bitRate) {
            this.bitRate = bitRate;
        }
    }

    class Fragment {
        private int firstFragment;
        private long firstFragmentTimestamp;
        private int fragmentDuration;
        private int discontinuityIndicator;

        Fragment() {
        }

        public int getFirstFragment() {
            return this.firstFragment;
        }

        public void setFirstFragment(int firstFragment) {
            this.firstFragment = firstFragment;
        }

        public long getFirstFragmentTimestamp() {
            return this.firstFragmentTimestamp;
        }

        public void setFirstFragmentTimestamp(long firstFragmentTimestamp) {
            this.firstFragmentTimestamp = firstFragmentTimestamp;
        }

        public int getFragmentDuration() {
            return this.fragmentDuration;
        }

        public void setFragmentDuration(int fragmentDuration) {
            this.fragmentDuration = fragmentDuration;
        }

        public int getDiscontinuityIndicator() {
            return this.discontinuityIndicator;
        }

        public void setDiscontinuityIndicator(int discontinuityIndicator) {
            this.discontinuityIndicator = discontinuityIndicator;
        }
    }

    class Segment {
        private int firstSegment;
        private int fragmentsPerSegment;

        Segment() {
        }

        public int getFirstSegment() {
            return this.firstSegment;
        }

        public void setFirstSegment(int firstSegment) {
            this.firstSegment = firstSegment;
        }

        public int getFragmentsPerSegment() {
            return this.fragmentsPerSegment;
        }

        public void setFragmentsPerSegment(int fragmentsPerSegment) {
            this.fragmentsPerSegment = fragmentsPerSegment;
        }
    }
}

