/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import javax.swing.JComponent;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;

public class CircleProgressBar
extends JComponent {
    private static final long serialVersionUID = 3778513245025142955L;
    private int padding = 4;
    Stroke stroke = new BasicStroke(4.0f);
    private int value;
    Color foreColor = ColorResource.getSelectionColor();
    Color backColor = ColorResource.getDarkBgColor();

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (g2 == null) {
            return;
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int sweep_angle = (int)((float)this.value * 360.0f / 100.0f);
        g2.setColor(Color.GRAY);
        g2.setStroke(this.stroke);
        g2.drawArc(this.padding, this.padding, this.getWidth() - 2 * this.padding, this.getHeight() - 2 * this.padding, 90, -360);
        if (this.value > 0) {
            g2.setColor(this.foreColor);
            g2.drawArc(this.padding, this.padding, this.getWidth() - 2 * this.padding, this.getHeight() - 2 * this.padding, 90, -sweep_angle);
        }
        g2.setFont(FontResource.getItemFont());
        FontMetrics fm = g2.getFontMetrics();
        String str = String.valueOf(this.value) + "%";
        int w = (int)fm.getStringBounds(str, g2).getWidth();
        LineMetrics lm = fm.getLineMetrics(str, g2);
        int h = (int)(lm.getAscent() + lm.getDescent());
        g2.drawString(str, (float)((this.getWidth() - w) / 2), (float)((this.getHeight() + h) / 2) - lm.getDescent());
    }

    public void setValue(int value) {
        this.value = value;
        this.repaint();
    }

    public int getValue() {
        return this.value;
    }
}

