/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.TextAttribute;
import java.io.File;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import xdman.ClipboardMonitor;
import xdman.Config;
import xdman.CredentialManager;
import xdman.DownloadQueue;
import xdman.QueueManager;
import xdman.ui.components.CustomButton;
import xdman.ui.components.DarkScrollBar;
import xdman.ui.components.MessageBox;
import xdman.ui.components.PasswordItem;
import xdman.ui.components.QueueListRenderer;
import xdman.ui.components.QueuedItemsRenderer;
import xdman.ui.components.SimpleListRenderer;
import xdman.ui.components.XDMFrame;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.BrowserLauncher;
import xdman.util.DateTimeUtils;
import xdman.util.Logger;
import xdman.util.StringUtils;
import xdman.util.XDMUtils;

public class SettingsPage
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static SettingsPage page;
    Color bgColor;
    JScrollPane jsp;
    XDMFrame parent;
    int diffx;
    int diffy;
    int level;
    JPanel overviewPanel;
    JPanel browserIntPanel;
    JPanel networkPanel;
    JPanel passwordPanel;
    JPanel queuePanel;
    JPanel advPanel;
    JLabel titleLbl;
    JLabel btnNav;
    JList<PasswordItem> passList;
    DefaultListModel<PasswordItem> passListModel;
    JTextField txtCredHostName;
    ArrayList<JPanel> pageStack;
    JList<DownloadQueue> qList;
    JList<String> qItemsList;
    JTextField txtQueueName;
    JCheckBox chkQStart;
    JCheckBox chkQStop;
    JRadioButton radOnetime;
    JRadioButton radPeriodic;
    JCheckBox[] chkDays;
    JSpinner spExecDate;
    JSpinner spEndTime;
    JSpinner spStartTime;
    JButton btnQMoveTo;
    int[] sizeArr;
    SpinnerDateModel spinnerDateModel1;
    SpinnerDateModel spinnerDateModel2;
    SpinnerDateModel spinnerDateModel3;
    DefaultListModel<DownloadQueue> queueModel;
    DefaultListModel<String> queuedItemsModel;
    JTextField txtUserName;
    JTextField txtPassword;
    JPanel currentPage;
    JCheckBox chkPrgWnd;
    JCheckBox chkEndWnd;
    JCheckBox chkVidPan;
    JCheckBox chkOverwriteExisting;
    JComboBox<String> cmbMax;
    JComboBox<String> cmbMinVidSize;
    JTextField txtDefFolder;
    JTextField txtTempFolder;
    JTextArea txtFileTyp;
    JTextArea txtVidType;
    JTextArea txtBlockedHosts;
    JComboBox<String> cmbTimeout;
    JComboBox<String> cmbSeg;
    JComboBox<String> cmbTcp;
    JTextField txtSpeedLimit;
    JCheckBox chkUsePac;
    JCheckBox chkUseProxy;
    JCheckBox chkUseSocks;
    JTextField txtPACUrl;
    JTextField txtProxyHostnPort;
    JTextField txtProxyPass;
    JTextField txtProxyUser;
    JTextField txtSocksHostnPort;
    JCheckBox chkHaltAfterFinish;
    JCheckBox chkKeepAwake;
    JCheckBox chkExecCmd;
    JCheckBox chkExecAntivir;
    JCheckBox chkAutoStart;
    JCheckBox chkMonitorClipboard;
    JCheckBox chkDwnAuto;
    JCheckBox chkGetTs;
    JCheckBox chkNoTransparency;
    JTextField txtCustomCmd;
    JTextField txtAntivirCmd;
    JTextField txtAntivirArgs;
    JComboBox<String> cmbCategory;
    private static final String chromeWebStoreURL = "https://chrome.google.com/webstore/detail/xdm-browser-monitor/bgpkelneombgembocnickiddlbebmica";
    private static final String ffAMOURL = "https://addons.mozilla.org/en-US/firefox/addon/xdm-browser-monitor/";
    private static final String operaExtURL = "http://xdman.sourceforge.net/addons/xdm_chromium.crx";
    private static final String directCRXURL = "http://xdman.sourceforge.net/addons/xdm_chromium.crx";
    int y;
    int h;

    public static SettingsPage getInstance() {
        if (page == null) {
            page = new SettingsPage();
        }
        return page;
    }

    public SettingsPage() {
        int[] nArray = new int[5];
        nArray[1] = 524288;
        nArray[2] = 0x100000;
        nArray[3] = 0x500000;
        nArray[4] = 0xA00000;
        this.sizeArr = nArray;
        this.y = 0;
        this.h = 0;
        this.setOpaque(false);
        this.setLayout(null);
        this.bgColor = new Color(0, 0, 0, Config.getInstance().isNoTransparency() ? 255 : 200);
        MouseInputAdapter ma = new MouseInputAdapter(){};
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
        this.jsp = new JScrollPane();
        this.jsp.setOpaque(false);
        this.jsp.setBorder(null);
        this.jsp.getViewport().setOpaque(false);
        DarkScrollBar scrollBar = new DarkScrollBar(1);
        this.jsp.setVerticalScrollBar(scrollBar);
        this.jsp.setHorizontalScrollBarPolicy(31);
        this.jsp.getVerticalScrollBar().setUnitIncrement(10);
        this.jsp.getVerticalScrollBar().setBlockIncrement(25);
        this.add(this.jsp);
        this.registerMouseListener();
        this.init();
        this.pageStack = new ArrayList();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.bgColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void showPanel(XDMFrame xframe, String pageName) {
        this.parent = xframe;
        int x = xframe.getWidth() - 350;
        this.jsp.setBounds(0, this.y, 350, xframe.getHeight() - this.y);
        this.setBounds(x, 0, 350, xframe.getHeight());
        JScrollBar vertical = this.jsp.getVerticalScrollBar();
        vertical.setValue(vertical.getMinimum());
        this.setPage(pageName);
        xframe.showDialog(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SettingsPage.this.jsp.getVerticalScrollBar().setValue(0);
            }
        });
    }

    public void registerMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                SettingsPage.this.diffx = me.getXOnScreen() - SettingsPage.this.parent.getLocationOnScreen().x;
                SettingsPage.this.diffy = me.getYOnScreen() - SettingsPage.this.parent.getLocationOnScreen().y;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                SettingsPage.this.parent.setLocation(me.getXOnScreen() - SettingsPage.this.diffx, me.getYOnScreen() - SettingsPage.this.diffy);
            }
        });
    }

    private void init() {
        this.y = 25;
        this.h = 40;
        this.btnNav = new JLabel(ImageResource.get("back24.png"));
        this.btnNav.setFont(FontResource.getBiggerFont());
        this.btnNav.setForeground(ColorResource.getSelectionColor());
        this.btnNav.setBounds(15, this.y, 25, this.h);
        this.add(this.btnNav);
        this.btnNav.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SettingsPage.this.currentPage == SettingsPage.this.overviewPanel) {
                    SettingsPage.this.saveOverviewSettings();
                } else if (SettingsPage.this.currentPage == SettingsPage.this.browserIntPanel) {
                    SettingsPage.this.saveMonitoringSettings();
                } else if (SettingsPage.this.currentPage == SettingsPage.this.networkPanel) {
                    SettingsPage.this.saveNetworkSettings();
                } else if (SettingsPage.this.currentPage == SettingsPage.this.advPanel) {
                    SettingsPage.this.saveAdvSettings();
                }
                if (SettingsPage.this.level == 0) {
                    SettingsPage.this.close();
                }
                if (SettingsPage.this.level == 1) {
                    SettingsPage.this.level = 0;
                    SettingsPage.this.setPage("PG_SETTINGS");
                }
            }
        });
        this.titleLbl = new JLabel(StringResource.get("TITLE_SETTINGS"));
        this.titleLbl.setFont(FontResource.getBiggerFont());
        this.titleLbl.setForeground(ColorResource.getSelectionColor());
        this.titleLbl.setBounds(50, this.y, 200, this.h);
        this.add(this.titleLbl);
        this.y += this.h;
        this.y += 10;
        this.h = 2;
        JLabel lineLbl = new JLabel();
        lineLbl.setBackground(ColorResource.getSelectionColor());
        lineLbl.setBounds(0, this.y, 400, this.h);
        lineLbl.setOpaque(true);
        this.add(lineLbl);
        this.y += this.h;
    }

    private JPanel createOverviewPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(null);
        int y = 0;
        int h = 0;
        y += 10;
        h = 30;
        JLabel lblMonitorHeader = new JLabel(StringResource.get("SETTINGS_MONITORING"));
        lblMonitorHeader.setForeground(Color.WHITE);
        lblMonitorHeader.setFont(FontResource.getItemFont());
        lblMonitorHeader.setBounds(15, y += 10, 320, h);
        panel.add(lblMonitorHeader);
        y += h;
        y += 10;
        h = 50;
        JTextArea lblMonitoringTitle = new JTextArea();
        lblMonitoringTitle.setOpaque(false);
        lblMonitoringTitle.setWrapStyleWord(true);
        lblMonitoringTitle.setLineWrap(true);
        lblMonitoringTitle.setEditable(false);
        lblMonitoringTitle.setForeground(Color.WHITE);
        lblMonitoringTitle.setText(StringResource.get("HINT_BROWSER_MON"));
        lblMonitoringTitle.setFont(FontResource.getNormalFont());
        lblMonitoringTitle.setBounds(15, y, 320, h);
        panel.add(lblMonitoringTitle);
        JButton btViewMonitoring = this.createButton1("SETTINGS_VIEW", 15, y += h);
        btViewMonitoring.setName("BTN_MONITORING");
        panel.add(btViewMonitoring);
        y += btViewMonitoring.getHeight();
        y += 10;
        h = 30;
        JLabel lblGenHeader = new JLabel(StringResource.get("SETTINGS_GENERAL"));
        lblGenHeader.setForeground(Color.WHITE);
        lblGenHeader.setFont(FontResource.getItemFont());
        lblGenHeader.setBounds(15, y += 20, 320, h);
        panel.add(lblGenHeader);
        y += h;
        h = 30;
        this.chkPrgWnd = this.createCheckBox("SHOW_DWN_PRG");
        this.chkPrgWnd.setBounds(15, y += 10, 320, h);
        panel.add(this.chkPrgWnd);
        y += h;
        h = 30;
        this.chkEndWnd = this.createCheckBox("SHOW_DWN_COMPLETE");
        this.chkEndWnd.setBounds(15, y, 320, h);
        panel.add(this.chkEndWnd);
        y += h;
        h = 30;
        this.chkOverwriteExisting = this.createCheckBox("LBL_OVERWRITE_EXISTING");
        this.chkOverwriteExisting.setBounds(15, y, 320, h);
        panel.add(this.chkOverwriteExisting);
        y += h;
        h = 30;
        this.chkNoTransparency = this.createCheckBox("LBL_TRANSPARENCY");
        this.chkNoTransparency.setBounds(15, y, 320, h);
        panel.add(this.chkNoTransparency);
        y += h;
        h = 30;
        JLabel lblMaxTitle = new JLabel(StringResource.get("MSG_MAX_DOWNLOAD"));
        lblMaxTitle.setForeground(Color.WHITE);
        lblMaxTitle.setFont(FontResource.getNormalFont());
        lblMaxTitle.setBounds(15, y += 10, 320, h);
        panel.add(lblMaxTitle);
        h = 25;
        this.cmbMax = new JComboBox<String>(new String[]{"1", "2", "5", "10", "50", "100", "N/A"});
        this.cmbMax.setBackground(ColorResource.getDarkerBgColor());
        this.cmbMax.setBounds(250, y += 3, 75, h);
        this.cmbMax.setRenderer(new SimpleListRenderer());
        panel.add(this.cmbMax);
        y += h;
        y += 10;
        y += 10;
        h = 30;
        JLabel lblFolderTitle = new JLabel(StringResource.get("SETTINGS_FOLDER"));
        lblFolderTitle.setForeground(Color.WHITE);
        lblFolderTitle.setFont(FontResource.getNormalFont());
        lblFolderTitle.setBounds(15, y += 10, 320, h);
        panel.add(lblFolderTitle);
        y += h;
        h = 25;
        this.cmbCategory = new JComboBox<String>(new String[]{StringResource.get("LBL_GENERAL_CAT"), StringResource.get("CAT_DOCUMENTS"), StringResource.get("CAT_COMPRESSED"), StringResource.get("CAT_MUSIC"), StringResource.get("CAT_VIDEOS"), StringResource.get("CAT_PROGRAMS")});
        this.cmbCategory.setName("CMB_CATEGORY");
        this.cmbCategory.setBackground(ColorResource.getDarkerBgColor());
        this.cmbCategory.setBounds(15, y, 310, h);
        this.cmbCategory.setRenderer(new SimpleListRenderer());
        this.cmbCategory.addActionListener(this);
        panel.add(this.cmbCategory);
        y += h;
        h = 25;
        this.txtDefFolder = new JTextField();
        this.txtDefFolder.setBounds(15, y += 10, 210, h);
        this.txtDefFolder.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtDefFolder.setEditable(false);
        this.txtDefFolder.setForeground(Color.WHITE);
        this.txtDefFolder.setOpaque(false);
        panel.add(this.txtDefFolder);
        JButton btnBrowseFolder = this.createButton2("SETTINGS_FOLDER_CHANGE");
        btnBrowseFolder.setName("SETTINGS_FOLDER_CHANGE");
        btnBrowseFolder.setBackground(ColorResource.getDarkBtnColor());
        btnBrowseFolder.setFont(FontResource.getNormalFont());
        btnBrowseFolder.setBounds(235, y, 90, h);
        panel.add(btnBrowseFolder);
        y += h;
        h = 30;
        JLabel lblTempFolderTitle = new JLabel(StringResource.get("LBL_TEMP_FOLDER"));
        lblTempFolderTitle.setForeground(Color.WHITE);
        lblTempFolderTitle.setFont(FontResource.getNormalFont());
        lblTempFolderTitle.setBounds(15, y += 10, 320, h);
        panel.add(lblTempFolderTitle);
        y += h;
        h = 25;
        this.txtTempFolder = new JTextField();
        this.txtTempFolder.setBounds(15, y, 210, h);
        this.txtTempFolder.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtTempFolder.setEditable(false);
        this.txtTempFolder.setForeground(Color.WHITE);
        this.txtTempFolder.setOpaque(false);
        panel.add(this.txtTempFolder);
        JButton btnBrowseFolder2 = this.createButton2("SETTINGS_FOLDER_CHANGE");
        btnBrowseFolder2.setName("SETTINGS_TEMP_FOLDER_CHANGE");
        btnBrowseFolder2.setBackground(ColorResource.getDarkBtnColor());
        btnBrowseFolder2.setFont(FontResource.getNormalFont());
        btnBrowseFolder2.setBounds(235, y, 90, h);
        panel.add(btnBrowseFolder2);
        y += h;
        y += 10;
        y += 20;
        h = 30;
        JLabel lblNetHeader = new JLabel(StringResource.get("SETTINGS_NETWORK"));
        lblNetHeader.setForeground(Color.WHITE);
        lblNetHeader.setFont(FontResource.getItemFont());
        lblNetHeader.setBounds(15, y += 10, 320, h);
        panel.add(lblNetHeader);
        y += h;
        h = 40;
        JTextArea lblNetworkTitle = new JTextArea();
        lblNetworkTitle.setOpaque(false);
        lblNetworkTitle.setWrapStyleWord(true);
        lblNetworkTitle.setLineWrap(true);
        lblNetworkTitle.setEditable(false);
        lblNetworkTitle.setForeground(Color.WHITE);
        lblNetworkTitle.setText(StringResource.get("HINT_NETWORK"));
        lblNetworkTitle.setFont(FontResource.getNormalFont());
        lblNetworkTitle.setBounds(15, y, 320, h);
        panel.add(lblNetworkTitle);
        JButton btViewNet = this.createButton1("SETTINGS_VIEW", 15, y += h);
        btViewNet.setName("BTN_NETWORK");
        panel.add(btViewNet);
        y += btViewNet.getHeight();
        y += 10;
        y += 10;
        h = 30;
        JLabel lblSchHeader = new JLabel(StringResource.get("SETTINGS_SCHEDULER"));
        lblSchHeader.setForeground(Color.WHITE);
        lblSchHeader.setFont(FontResource.getItemFont());
        lblSchHeader.setBounds(15, y += 10, 320, h);
        panel.add(lblSchHeader);
        y += h;
        h = 50;
        JTextArea lblScheduleTitle = new JTextArea();
        lblScheduleTitle.setOpaque(false);
        lblScheduleTitle.setWrapStyleWord(true);
        lblScheduleTitle.setLineWrap(true);
        lblScheduleTitle.setEditable(false);
        lblScheduleTitle.setForeground(Color.WHITE);
        lblScheduleTitle.setText(StringResource.get("HINT_SCHEDULER"));
        lblScheduleTitle.setFont(FontResource.getNormalFont());
        lblScheduleTitle.setBounds(15, y, 320, h);
        panel.add(lblScheduleTitle);
        JButton btViewScheduler = this.createButton1("SETTINGS_VIEW", 15, y += h);
        btViewScheduler.setName("Q_MAN");
        panel.add(btViewScheduler);
        y += btViewScheduler.getHeight();
        y += 10;
        y += 10;
        h = 30;
        JLabel lblPwdHeader = new JLabel(StringResource.get("SETTINGS_CRED"));
        lblPwdHeader.setForeground(Color.WHITE);
        lblPwdHeader.setFont(FontResource.getItemFont());
        lblPwdHeader.setBounds(15, y += 10, 320, h);
        panel.add(lblPwdHeader);
        y += h;
        h = 40;
        JTextArea lblCredTitle = new JTextArea();
        lblCredTitle.setOpaque(false);
        lblCredTitle.setWrapStyleWord(true);
        lblCredTitle.setLineWrap(true);
        lblCredTitle.setEditable(false);
        lblCredTitle.setForeground(Color.WHITE);
        lblCredTitle.setText(StringResource.get("HINT_PASSWORD"));
        lblCredTitle.setFont(FontResource.getNormalFont());
        lblCredTitle.setBounds(15, y, 320, h);
        panel.add(lblCredTitle);
        JButton btViewCred = this.createButton1("SETTINGS_VIEW", 15, y += h);
        btViewCred.setName("PASS_MAN");
        panel.add(btViewCred);
        y += btViewCred.getHeight();
        y += 10;
        y += 10;
        h = 30;
        JLabel lblAdvHeader = new JLabel(StringResource.get("SETTINGS_ADV"));
        lblAdvHeader.setForeground(Color.WHITE);
        lblAdvHeader.setFont(FontResource.getItemFont());
        lblAdvHeader.setBounds(15, y += 10, 320, h);
        panel.add(lblAdvHeader);
        y += h;
        h = 50;
        JTextArea lblAdvTitle = new JTextArea();
        lblAdvTitle.setOpaque(false);
        lblAdvTitle.setWrapStyleWord(true);
        lblAdvTitle.setLineWrap(true);
        lblAdvTitle.setEditable(false);
        lblAdvTitle.setForeground(Color.WHITE);
        lblAdvTitle.setText(StringResource.get("HINT_ADV"));
        lblAdvTitle.setFont(FontResource.getNormalFont());
        lblAdvTitle.setBounds(15, y, 320, h);
        panel.add(lblAdvTitle);
        JButton btViewAdv = this.createButton1("SETTINGS_VIEW", 15, y += h);
        btViewAdv.setName("ADV_MAN");
        panel.add(btViewAdv);
        y += btViewAdv.getHeight();
        h = 30;
        panel.setPreferredSize(new Dimension(300, (y += 10) + 50));
        return panel;
    }

    private JButton createButton1(String name, int x, int y) {
        CustomButton btn = new CustomButton(StringResource.get(name));
        btn.setBackground(ColorResource.getDarkBtnColor());
        btn.setBorderPainted(false);
        btn.setFocusPainted(false);
        btn.setForeground(Color.WHITE);
        btn.setFont(FontResource.getNormalFont());
        Dimension d = btn.getPreferredSize();
        btn.setBounds(x, y, d.width, d.height);
        btn.addActionListener(this);
        return btn;
    }

    private JButton createButton2(String name) {
        CustomButton btn = new CustomButton(StringResource.get(name));
        btn.setBackground(ColorResource.getDarkBtnColor());
        btn.setBorderPainted(false);
        btn.setFocusPainted(false);
        btn.setForeground(Color.WHITE);
        btn.setFont(FontResource.getNormalFont());
        btn.addActionListener(this);
        return btn;
    }

    private JCheckBox createCheckBox(String name, Font font) {
        JCheckBox chk = new JCheckBox(StringResource.get(name));
        chk.setName(name);
        chk.setIcon(ImageResource.get("unchecked.png"));
        chk.setSelectedIcon(ImageResource.get("checked.png"));
        chk.setOpaque(false);
        chk.setFocusPainted(false);
        chk.setForeground(Color.WHITE);
        chk.setFont(font);
        return chk;
    }

    private JCheckBox createCheckBox(String name) {
        return this.createCheckBox(name, FontResource.getNormalFont());
    }

    private void close() {
        this.parent.hideDialog(this);
        System.gc();
    }

    private void showMsgFF() {
        String msg = String.format(StringResource.get("MSG_GENERIC_ADDON_DESC"), "", ffAMOURL);
        MessageBox.show(this.parent, StringResource.get("MSG_ADDON_TITLE"), msg, 10, 10);
    }

    private void showMsgChrome() {
        String msg = String.format(StringResource.get("MSG_GENERIC_ADDON_DESC"), chromeWebStoreURL, "http://xdman.sourceforge.net/addons/xdm_chromium.crx");
        MessageBox.show(this.parent, StringResource.get("MSG_ADDON_TITLE"), msg, 10, 10);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String name;
        JRadioButton chk;
        if (e.getSource() instanceof JRadioButton && ("Q_DAILY".equals((chk = (JRadioButton)e.getSource()).getName()) || "Q_ONCE".equals(chk.getName()))) {
            this.enableSchedulerFields();
        }
        if (e.getSource() instanceof JMenuItem && (name = ((JMenuItem)e.getSource()).getName()) != null) {
            if (name.startsWith("Q_MOVE_TO:")) {
                String targetQ = "";
                targetQ = name.endsWith(":") ? "" : name.split(":")[1].trim();
                int index = this.qItemsList.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                String id = this.queuedItemsModel.get(index);
                Logger.log("Moving to target queue: " + targetQ);
                index = this.qList.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                DownloadQueue sourceQ = this.queueModel.getElementAt(index);
                sourceQ.removeFromQueue(id);
                QueueManager.getInstance().getQueueById(targetQ).addToQueue(id);
                this.loadSchedulerSettings(index);
            }
            return;
        }
        if (e.getSource() == this.cmbCategory) {
            int index = this.cmbCategory.getSelectedIndex();
            switch (index) {
                case 0: {
                    this.txtDefFolder.setText(Config.getInstance().getCategoryOther());
                    break;
                }
                case 1: {
                    this.txtDefFolder.setText(Config.getInstance().getCategoryDocuments());
                    break;
                }
                case 2: {
                    this.txtDefFolder.setText(Config.getInstance().getCategoryCompressed());
                    break;
                }
                case 3: {
                    this.txtDefFolder.setText(Config.getInstance().getCategoryMusic());
                    break;
                }
                case 4: {
                    this.txtDefFolder.setText(Config.getInstance().getCategoryVideos());
                    break;
                }
                case 5: {
                    this.txtDefFolder.setText(Config.getInstance().getCategoryPrograms());
                }
            }
        }
        if (e.getSource() instanceof JCheckBox) {
            JCheckBox chk2 = (JCheckBox)e.getSource();
            if ("MSG_Q_START".equals(chk2.getName())) {
                this.enableSchedulerFields();
            }
        } else if (e.getSource() instanceof JButton) {
            File folder;
            File file;
            String folderText;
            JFileChooser jfc;
            int index;
            JButton btn = (JButton)e.getSource();
            String name2 = btn.getName();
            if ("BTN_Q_SAVE".equals(name2)) {
                this.saveQueue();
                return;
            }
            if ("Q_MOVE_TO".equals(name2)) {
                this.showMoveQPopup(btn);
                return;
            }
            if ("BTN_Q_DEL".equals(name2)) {
                this.removeQueue();
            }
            if ("Q_MOVE_UP".equals(name2)) {
                this.queueMoveUp();
                return;
            }
            if ("Q_MOVE_DN".equals(name2)) {
                this.queueMoveDown();
                return;
            }
            if ("BTN_Q_NEW".equals(name2)) {
                this.createNewQueue();
                return;
            }
            if ("BTN_DEF_FILE_EXT".equals(name2)) {
                this.txtFileTyp.setText(XDMUtils.appendArray2Str(Config.getInstance().getDefaultFileTypes()));
                return;
            }
            if ("BTN_DEF_VID_EXT".equals(name2)) {
                this.txtVidType.setText(XDMUtils.appendArray2Str(Config.getInstance().getDefaultVideoTypes()));
                return;
            }
            if ("BTN_Q_NEW".equals(name2)) {
                this.createNewQueue();
                return;
            }
            if ("DEL_CRED".equals(name2) && (index = this.passList.getSelectedIndex()) > -1) {
                PasswordItem item = this.passListModel.get(index);
                CredentialManager.getInstance().removeSavedCredential(item.host);
                this.loadPasswordSettings();
            }
            if ("NEW_CRED".equals(name2)) {
                this.txtCredHostName.setText("");
                this.txtUserName.setText("");
                this.txtPassword.setText("");
            }
            if ("SAVE_CRED".equals(name2)) {
                this.savePasswordSettings();
            }
            if ("BROWSE_ANTIVIR".equals(name2) && (jfc = new JFileChooser()).showOpenDialog(this.parent) == 0) {
                this.txtAntivirCmd.setText(jfc.getSelectedFile().getAbsolutePath());
            }
            if ("SETTINGS_FOLDER_CHANGE".equals(name2)) {
                jfc = new JFileChooser();
                folderText = this.txtDefFolder.getText().trim();
                file = new File(StringUtils.isNullOrEmptyOrBlank(folderText) ? Config.getInstance().getCategoryOther() : folderText);
                if (file.exists()) {
                    jfc.setCurrentDirectory(file);
                }
                jfc.setFileSelectionMode(1);
                if (jfc.showOpenDialog(this.parent) == 0 && (folder = jfc.getSelectedFile()).exists()) {
                    this.txtDefFolder.setText(folder.getAbsolutePath());
                    int index2 = this.cmbCategory.getSelectedIndex();
                    switch (index2) {
                        case 0: {
                            Config.getInstance().setCategoryOther(this.txtDefFolder.getText());
                            break;
                        }
                        case 1: {
                            Config.getInstance().setCategoryDocuments(this.txtDefFolder.getText());
                            break;
                        }
                        case 2: {
                            Config.getInstance().setCategoryCompressed(this.txtDefFolder.getText());
                            break;
                        }
                        case 3: {
                            Config.getInstance().setCategoryMusic(this.txtDefFolder.getText());
                            break;
                        }
                        case 4: {
                            Config.getInstance().setCategoryVideos(this.txtDefFolder.getText());
                            break;
                        }
                        case 5: {
                            Config.getInstance().setCategoryPrograms(this.txtDefFolder.getText());
                        }
                    }
                }
            }
            if ("SETTINGS_TEMP_FOLDER_CHANGE".equals(name2)) {
                jfc = new JFileChooser();
                folderText = this.txtTempFolder.getText().trim();
                file = new File(StringUtils.isNullOrEmptyOrBlank(folderText) ? Config.getInstance().getCategoryOther() : folderText);
                if (file.exists()) {
                    jfc.setCurrentDirectory(file);
                }
                jfc.setFileSelectionMode(1);
                if (jfc.showOpenDialog(this.parent) == 0 && (folder = jfc.getSelectedFile()).exists()) {
                    this.txtTempFolder.setText(folder.getAbsolutePath());
                }
            }
            if ("FF_INSTALL".equals(name2) && !BrowserLauncher.launchFirefox(ffAMOURL)) {
                String msg = String.format(StringResource.get("MSG_ADDON_DESC"), "Mozilla Firefox", ffAMOURL);
                MessageBox.show(this.parent, StringResource.get("MSG_ADDON_TITLE"), msg, 10, 10);
            }
            if ("EDGE_INSTALL".equals(name2)) {
                XDMUtils.browseURL("https://sourceforge.net/p/xdman/blog/2018/01/xdm-integration-with-microsoft-edge/");
            }
            if ("CR_INSTALL".equals(name2) && !BrowserLauncher.launchChrome(chromeWebStoreURL)) {
                String msg = String.format(StringResource.get("MSG_ADDON_DESC"), "Google Chrome", chromeWebStoreURL);
                MessageBox.show(this.parent, StringResource.get("MSG_ADDON_TITLE"), msg, 10, 10);
            }
            if ("CM_INSTALL".equals(name2)) {
                String msg = String.format(StringResource.get("MSG_ADDON_DESC"), "Chromium", chromeWebStoreURL);
                MessageBox.show(this.parent, StringResource.get("MSG_ADDON_TITLE"), msg, 10, 10);
            }
            if ("VL_INSTALL".equals(name2)) {
                String msg = String.format(StringResource.get("MSG_ADDON_DESC"), "Vivaldi", chromeWebStoreURL);
                MessageBox.show(this.parent, StringResource.get("MSG_ADDON_TITLE"), msg, 10, 10);
            }
            if ("OP_INSTALL".equals(name2)) {
                String msg = String.format(StringResource.get("MSG_ADDON_DESC"), "Opera", "http://xdman.sourceforge.net/addons/xdm_chromium.crx");
                MessageBox.show(this.parent, StringResource.get("MSG_ADDON_TITLE"), msg, 10, 10);
            }
            if (this.setPage(name2)) {
                this.level = 1;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SettingsPage.this.jsp.getVerticalScrollBar().setValue(0);
                    }
                });
            }
        }
    }

    private void loadSchedulerSettings(int selectedQ) {
        this.queueModel.clear();
        for (DownloadQueue q : QueueManager.getInstance().getQueueList()) {
            this.queueModel.addElement(q);
        }
        this.qList.setSelectedIndex(selectedQ);
        this.qList.ensureIndexIsVisible(selectedQ);
    }

    private void loadOverviewSettings() {
        Config config = Config.getInstance();
        this.chkPrgWnd.setSelected(config.showDownloadWindow());
        this.chkEndWnd.setSelected(config.showDownloadCompleteWindow());
        this.chkOverwriteExisting.setSelected(config.getDuplicateAction() == 1);
        Logger.log("Max download: " + config.getMaxDownloads());
        this.cmbMax.setSelectedItem(config.getMaxDownloads() > 0 ? String.valueOf(config.getMaxDownloads()) : "N/A");
        this.txtTempFolder.setText(config.getTemporaryFolder());
        this.cmbCategory.setSelectedIndex(0);
        this.txtDefFolder.setText(config.getCategoryOther());
        this.chkNoTransparency.setSelected(config.isNoTransparency());
    }

    private void loadMonitoringSettings() {
        Config config = Config.getInstance();
        this.txtFileTyp.setText(XDMUtils.appendArray2Str(config.getFileExts()));
        this.txtVidType.setText(XDMUtils.appendArray2Str(config.getVidExts()));
        this.txtBlockedHosts.setText(XDMUtils.appendArray2Str(config.getBlockedHosts()));
        this.chkVidPan.setSelected(config.isShowVideoNotification());
        this.chkMonitorClipboard.setSelected(config.isMonitorClipboard());
        int index = -1;
        int sz = config.getMinVidSize();
        int i = 0;
        while (i < this.sizeArr.length) {
            if (sz == this.sizeArr[i]) {
                index = i;
            }
            ++i;
        }
        if (index < 0) {
            index = 2;
        }
        this.cmbMinVidSize.setSelectedIndex(index);
        this.chkDwnAuto.setSelected(config.isDownloadAutoStart());
        this.chkGetTs.setSelected(config.isFetchTs());
    }

    private void loadNetworkSettings() {
        Config config = Config.getInstance();
        this.cmbSeg.setSelectedItem(String.valueOf(config.getMaxSegments()));
        this.cmbTimeout.setSelectedItem(config.getNetworkTimeout() > 1 ? String.valueOf(config.getNetworkTimeout()) : "N/A");
        String val = "Default";
        int ival = config.getTcpWindowSize();
        if (ival > 0) {
            val = String.valueOf(ival);
        }
        this.cmbTcp.setSelectedItem(val);
        this.txtSpeedLimit.setText(config.getSpeedLimit() < 1 ? "N/A" : String.valueOf(config.getSpeedLimit()));
        int proxyMode = config.getProxyMode();
        if (proxyMode == 0) {
            this.chkUsePac.setSelected(false);
            this.chkUseProxy.setSelected(false);
            this.chkUseSocks.setSelected(false);
        } else if (proxyMode == 1) {
            this.chkUsePac.setSelected(true);
        } else if (proxyMode == 2) {
            this.chkUseProxy.setSelected(true);
        } else if (proxyMode == 3) {
            this.chkUseSocks.setSelected(true);
        }
        this.txtPACUrl.setText(config.getProxyPac());
        if (config.getProxyHost() == null || config.getProxyHost().length() < 1) {
            this.txtProxyHostnPort.setText("");
        } else {
            this.txtProxyHostnPort.setText(String.valueOf(config.getProxyHost()) + (config.getProxyPort() > 0 ? ":" + config.getProxyPort() : ""));
        }
        if (config.getSocksHost() == null || config.getSocksHost().length() < 1) {
            this.txtSocksHostnPort.setText("");
        } else {
            this.txtSocksHostnPort.setText(String.valueOf(config.getSocksHost()) + (config.getSocksPort() > 0 ? ":" + config.getSocksPort() : ""));
        }
        if (config.getProxyUser() == null || config.getProxyUser().length() < 1) {
            this.txtProxyUser.setText("");
            this.txtProxyPass.setText("");
        } else {
            this.txtProxyUser.setText(config.getProxyUser());
            if (config.getProxyPass() == null || config.getProxyPass().length() < 1) {
                this.txtProxyPass.setText("");
            } else {
                this.txtProxyPass.setText(config.getProxyPass());
            }
        }
    }

    private void loadPasswordSettings() {
        this.passListModel.clear();
        this.txtCredHostName.setText("");
        this.txtUserName.setText("");
        this.txtPassword.setText("");
        Set<Map.Entry<String, PasswordAuthentication>> credentials = CredentialManager.getInstance().getCredentials();
        for (Map.Entry<String, PasswordAuthentication> ent : credentials) {
            PasswordItem item = new PasswordItem();
            item.host = ent.getKey();
            item.user = ent.getValue().getUserName();
            item.password = new String(ent.getValue().getPassword());
            this.passListModel.addElement(item);
        }
    }

    private void savePasswordSettings() {
        String host = this.txtCredHostName.getText();
        String user = this.txtUserName.getText();
        String password = this.txtPassword.getText();
        Logger.log(String.valueOf(host) + " " + user);
        if (StringUtils.isNullOrEmptyOrBlank(host) || StringUtils.isNullOrEmptyOrBlank(user)) {
            return;
        }
        CredentialManager mgr = CredentialManager.getInstance();
        mgr.addCredentialForHost(host, user, password, true);
        mgr.save();
        this.loadPasswordSettings();
    }

    private boolean setPage(String name) {
        boolean pageFound = true;
        if ("PG_SETTINGS".equals(name)) {
            if (this.overviewPanel == null) {
                this.overviewPanel = this.createOverviewPanel();
            }
            this.jsp.setViewportView(this.overviewPanel);
            this.titleLbl.setText(StringResource.get("TITLE_SETTINGS"));
            this.loadOverviewSettings();
            this.currentPage = this.overviewPanel;
        } else if ("BTN_MONITORING".equals(name)) {
            if (this.browserIntPanel == null) {
                this.browserIntPanel = this.createBrowserIntPanel();
            }
            this.jsp.setViewportView(this.browserIntPanel);
            this.titleLbl.setText(StringResource.get("SETTINGS_MONITORING"));
            this.loadMonitoringSettings();
            this.currentPage = this.browserIntPanel;
        } else if ("BTN_NETWORK".equals(name)) {
            if (this.networkPanel == null) {
                this.networkPanel = this.createNetworkPanel();
            }
            this.jsp.setViewportView(this.networkPanel);
            this.titleLbl.setText(StringResource.get("DESC_NET_TITLE"));
            this.loadNetworkSettings();
            this.currentPage = this.networkPanel;
        } else if ("PASS_MAN".equals(name)) {
            if (this.passwordPanel == null) {
                this.passwordPanel = this.createPasswordPanel();
            }
            this.jsp.setViewportView(this.passwordPanel);
            this.titleLbl.setText(StringResource.get("DESC_PASS_TITLE"));
            this.loadPasswordSettings();
            this.currentPage = this.passwordPanel;
        } else if ("Q_MAN".equals(name)) {
            if (this.queuePanel == null) {
                this.queuePanel = this.createSchedulerPanel();
            }
            this.loadSchedulerSettings(0);
            this.jsp.setViewportView(this.queuePanel);
            this.titleLbl.setText(StringResource.get("DESC_Q_TITLE"));
            this.currentPage = this.queuePanel;
        } else if ("ADV_MAN".equals(name)) {
            if (this.advPanel == null) {
                this.advPanel = this.createAdvPanel();
            }
            this.jsp.setViewportView(this.advPanel);
            this.titleLbl.setText(StringResource.get("DESC_ADV_TITLE"));
            this.loadAdvSettings();
            this.currentPage = this.advPanel;
        } else {
            pageFound = false;
        }
        return pageFound;
    }

    private JTextArea createTextArea(String name, Font font) {
        JTextArea textArea = new JTextArea();
        textArea.setOpaque(false);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setForeground(Color.WHITE);
        textArea.setText(StringResource.get(name));
        textArea.setFont(font);
        return textArea;
    }

    private JTextArea createTextArea(String name) {
        return this.createTextArea(name, FontResource.getNormalFont());
    }

    private JPanel createBrowserIntPanel() {
        JPanel p = new JPanel();
        p.setLayout(null);
        p.setOpaque(false);
        int y = 30;
        int h = 70;
        JTextArea txt1 = this.createTextArea("DESC_MONITORING_1");
        txt1.setBounds(15, y, 320, h);
        p.add(txt1);
        y += h;
        h = 25;
        JLabel lblFirefox = new JLabel(StringResource.get("DESC_MOZILLA_FIREFOX"));
        lblFirefox.setFont(FontResource.getBigFont());
        lblFirefox.setBounds(15, y += 30, 135, h);
        p.add(lblFirefox);
        JLabel lblChrome = new JLabel(StringResource.get("DESC_GOOGLE_CHROME"));
        lblChrome.setFont(FontResource.getBigFont());
        lblChrome.setBounds(180, y, 135, h);
        p.add(lblChrome);
        JButton btnFF = this.createButton2("DESC_INSTALL");
        btnFF.setName("FF_INSTALL");
        btnFF.setBounds(15, y += h, 140, h);
        p.add(btnFF);
        JButton btnCr = this.createButton2("DESC_INSTALL");
        btnCr.setName("CR_INSTALL");
        btnCr.setBounds(180, y, 140, h);
        p.add(btnCr);
        y += h;
        h = 25;
        JLabel lblOpera = new JLabel(StringResource.get("DESC_OPERA"));
        lblOpera.setFont(FontResource.getBigFont());
        lblOpera.setBounds(15, y += 15, 135, h);
        p.add(lblOpera);
        JLabel lblCm = new JLabel(StringResource.get("DESC_CHROMIUM"));
        lblCm.setFont(FontResource.getBigFont());
        lblCm.setBounds(180, y, 135, h);
        p.add(lblCm);
        JButton btnOp = this.createButton2("DESC_INSTALL");
        btnOp.setName("OP_INSTALL");
        btnOp.setBounds(15, y += h, 140, h);
        p.add(btnOp);
        JButton btnCm = this.createButton2("DESC_INSTALL");
        btnCm.setName("CM_INSTALL");
        btnCm.setBounds(180, y, 140, h);
        p.add(btnCm);
        y += h;
        h = 25;
        JLabel lblEdge = new JLabel(StringResource.get("DESC_VIVALDI"));
        lblEdge.setFont(FontResource.getBigFont());
        lblEdge.setName("VL_INSTALL");
        lblEdge.setBounds(15, y += 15, 135, h);
        p.add(lblEdge);
        JLabel lblEdge2 = new JLabel(StringResource.get("DESC_MS_EDGE"));
        lblEdge2.setFont(FontResource.getBigFont());
        lblEdge2.setBounds(180, y, 135, h);
        p.add(lblEdge2);
        JButton btnEdge = this.createButton2("DESC_INSTALL");
        btnEdge.setName("VL_INSTALL");
        btnEdge.setBounds(15, y += h, 140, h);
        p.add(btnEdge);
        JButton btnEdge2 = this.createButton2("DESC_INSTRUCTION");
        btnEdge2.setName("EDGE_INSTALL");
        btnEdge2.setBounds(180, y, 140, h);
        p.add(btnEdge2);
        y += h;
        h = 70;
        JTextArea txt2 = this.createTextArea("DESC_OTHER_BROWSERS");
        txt2.setBounds(15, y += 40, 320, h);
        p.add(txt2);
        y += h;
        h = 30;
        JLabel labelMoz = new JLabel(StringResource.get("DESC_MOZ"));
        labelMoz.setCursor(new Cursor(12));
        labelMoz.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SettingsPage.this.showMsgFF();
            }
        });
        Font font = FontResource.getNormalFont();
        Map<TextAttribute, ?> attributes = font.getAttributes();
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        labelMoz.setBounds(15, y, 320, h);
        labelMoz.setFont(font.deriveFont(attributes));
        labelMoz.setForeground(Color.WHITE);
        p.add(labelMoz);
        y += h;
        h = 30;
        JLabel labelCr = new JLabel(StringResource.get("DESC_CHROME"));
        labelCr.setCursor(new Cursor(12));
        labelCr.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SettingsPage.this.showMsgChrome();
            }
        });
        labelCr.setBounds(15, y, 320, h);
        labelCr.setFont(font.deriveFont(attributes));
        labelCr.setForeground(Color.WHITE);
        p.add(labelCr);
        y += h;
        h = 40;
        JTextArea txt3 = this.createTextArea("DESC_FILETYPES");
        txt3.setBounds(15, y += 40, 310, h);
        p.add(txt3);
        y += h;
        h = 70;
        this.txtFileTyp = new JTextArea();
        this.txtFileTyp.setBorder(new LineBorder(ColorResource.getDarkBgColor()));
        this.txtFileTyp.setOpaque(false);
        this.txtFileTyp.setWrapStyleWord(true);
        this.txtFileTyp.setLineWrap(true);
        this.txtFileTyp.setForeground(Color.WHITE);
        this.txtFileTyp.setFont(FontResource.getNormalFont());
        this.txtFileTyp.setBounds(15, y, 310, h);
        p.add(this.txtFileTyp);
        y += h;
        h = 25;
        JButton btnDef1 = this.createButton2("DESC_DEF");
        btnDef1.setName("BTN_DEF_FILE_EXT");
        btnDef1.setBounds(185, y += 10, 140, h);
        p.add(btnDef1);
        y += h;
        h = 30;
        this.chkVidPan = this.createCheckBox("OPT_VID_PANE");
        this.chkVidPan.setBounds(15, y += 40, 320, h);
        p.add(this.chkVidPan);
        y += h;
        h = 40;
        JTextArea txt4 = this.createTextArea("DESC_VIDEOTYPES");
        txt4.setBounds(15, y += 10, 310, h);
        p.add(txt4);
        y += h;
        h = 70;
        this.txtVidType = new JTextArea();
        this.txtVidType.setOpaque(false);
        this.txtVidType.setBorder(new LineBorder(ColorResource.getDarkBgColor()));
        this.txtVidType.setWrapStyleWord(true);
        this.txtVidType.setLineWrap(true);
        this.txtVidType.setForeground(Color.WHITE);
        this.txtVidType.setFont(FontResource.getNormalFont());
        this.txtVidType.setBounds(15, y, 310, h);
        p.add(this.txtVidType);
        y += h;
        h = 25;
        JButton btnDef2 = this.createButton2("DESC_DEF");
        btnDef2.setName("BTN_DEF_VID_EXT");
        btnDef2.setBounds(185, y += 10, 140, h);
        p.add(btnDef2);
        y += h;
        JLabel lblMinVidSize = new JLabel(StringResource.get("LBL_MIN_VIDEO_SIZE"));
        lblMinVidSize.setForeground(Color.WHITE);
        lblMinVidSize.setFont(FontResource.getNormalFont());
        lblMinVidSize.setBounds(15, y += 30, 320, h);
        p.add(lblMinVidSize);
        h += 30;
        h = 25;
        this.cmbMinVidSize = new JComboBox<String>(new String[]{"N/A", "512 KB", "1 MB", "5 MB", "10 MB"});
        this.cmbMinVidSize.setBackground(ColorResource.getDarkerBgColor());
        this.cmbMinVidSize.setBounds(250, y, 75, h);
        this.cmbMinVidSize.setRenderer(new SimpleListRenderer());
        p.add(this.cmbMinVidSize);
        y += h;
        y += 10;
        h = 40;
        JTextArea txt6 = this.createTextArea("DESC_SITEEXCEPTIONS");
        txt6.setBounds(15, y += 20, 320, h);
        p.add(txt6);
        y += h;
        h = 70;
        this.txtBlockedHosts = new JTextArea();
        this.txtBlockedHosts.setOpaque(false);
        this.txtBlockedHosts.setBorder(new LineBorder(ColorResource.getDarkBgColor()));
        this.txtBlockedHosts.setWrapStyleWord(true);
        this.txtBlockedHosts.setLineWrap(true);
        this.txtBlockedHosts.setForeground(Color.WHITE);
        this.txtBlockedHosts.setFont(FontResource.getNormalFont());
        this.txtBlockedHosts.setBounds(15, y, 310, h);
        p.add(this.txtBlockedHosts);
        y += h;
        h = 30;
        this.chkMonitorClipboard = this.createCheckBox("MENU_CLIP_ADD");
        this.chkMonitorClipboard.setBounds(15, y += 20, 350, h);
        p.add(this.chkMonitorClipboard);
        y += h;
        h = 30;
        this.chkDwnAuto = this.createCheckBox("LBL_START_AUTO");
        this.chkDwnAuto.setBounds(15, y += 10, 350, h);
        p.add(this.chkDwnAuto);
        y += h;
        h = 30;
        this.chkGetTs = this.createCheckBox("LBL_GET_TIMESTAMP");
        this.chkGetTs.setBounds(15, y += 10, 350, h);
        p.add(this.chkGetTs);
        y += h;
        p.setPreferredSize(new Dimension(350, y += 50));
        return p;
    }

    private JPanel createNetworkPanel() {
        JPanel p = new JPanel();
        p.setLayout(null);
        p.setOpaque(false);
        int y = 20;
        int h = 50;
        h = 30;
        JLabel lbl1 = new JLabel(StringResource.get("DESC_NET"));
        lbl1.setForeground(Color.WHITE);
        lbl1.setFont(FontResource.getItemFont());
        lbl1.setBounds(15, y, 320, h);
        p.add(lbl1);
        y += h;
        h = 25;
        JLabel lbl2 = new JLabel(StringResource.get("DESC_NET1"));
        lbl2.setForeground(Color.WHITE);
        lbl2.setFont(FontResource.getNormalFont());
        lbl2.setBounds(15, y += 20, 200, h);
        p.add(lbl2);
        h = 20;
        this.cmbTimeout = new JComboBox<String>(new String[]{"10", "30", "60", "120", "180", "360", "N/A"});
        this.cmbTimeout.setBackground(ColorResource.getDarkerBgColor());
        this.cmbTimeout.setBounds(250, y += 5, 75, h);
        this.cmbTimeout.setRenderer(new SimpleListRenderer());
        p.add(this.cmbTimeout);
        y += h;
        h = 25;
        JLabel lbl3 = new JLabel(StringResource.get("DESC_NET2"));
        lbl3.setForeground(Color.WHITE);
        lbl3.setFont(FontResource.getNormalFont());
        lbl3.setBounds(15, y += 10, 200, h);
        p.add(lbl3);
        h = 20;
        this.cmbSeg = new JComboBox<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "20", "25", "30", "32"});
        this.cmbSeg.setBackground(ColorResource.getDarkerBgColor());
        this.cmbSeg.setBounds(250, y += 5, 75, h);
        this.cmbSeg.setRenderer(new SimpleListRenderer());
        p.add(this.cmbSeg);
        y += h;
        h = 25;
        JLabel lbl4 = new JLabel(StringResource.get("DESC_NET3"));
        lbl4.setForeground(Color.WHITE);
        lbl4.setFont(FontResource.getNormalFont());
        lbl4.setBounds(15, y += 10, 200, h);
        p.add(lbl4);
        h = 20;
        this.cmbTcp = new JComboBox<String>(new String[]{"Default", "8", "16", "32", "64", "128", "256", "512", "1024", "2048", "4096", "8192"});
        this.cmbTcp.setBackground(ColorResource.getDarkerBgColor());
        this.cmbTcp.setBounds(250, y += 5, 75, h);
        this.cmbTcp.setRenderer(new SimpleListRenderer());
        p.add(this.cmbTcp);
        y += h;
        h = 30;
        JLabel lbl51 = new JLabel(StringResource.get("SPEED_LIMIT_TITLE"));
        lbl51.setForeground(Color.WHITE);
        lbl51.setFont(FontResource.getItemFont());
        lbl51.setBounds(15, y += 50, 320, h);
        p.add(lbl51);
        y += h;
        h = 30;
        JLabel lbl71 = new JLabel(StringResource.get("MSG_SPEED_LIMIT"));
        lbl71.setForeground(Color.WHITE);
        lbl71.setFont(FontResource.getNormalFont());
        lbl71.setBounds(15, y, 320, h);
        p.add(lbl71);
        y += h;
        h = 25;
        this.txtSpeedLimit = new JTextField();
        this.txtSpeedLimit.setBounds(15, y, 100, h);
        this.txtSpeedLimit.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtSpeedLimit.setEditable(true);
        this.txtSpeedLimit.setCaretColor(ColorResource.getActiveTabColor());
        this.txtSpeedLimit.setForeground(Color.WHITE);
        this.txtSpeedLimit.setOpaque(false);
        p.add(this.txtSpeedLimit);
        y += h;
        h = 30;
        JLabel lbl5 = new JLabel(StringResource.get("DESC_NET4"));
        lbl5.setForeground(Color.WHITE);
        lbl5.setFont(FontResource.getItemFont());
        lbl5.setBounds(15, y += 50, 320, h);
        p.add(lbl5);
        y += h;
        h = 30;
        this.chkUsePac = this.createCheckBox("DESC_NET5");
        this.chkUsePac.setBounds(15, y += 10, 320, h);
        p.add(this.chkUsePac);
        y += h;
        h = 25;
        this.txtPACUrl = new JTextField();
        this.txtPACUrl.setBounds(15, y, 310, h);
        this.txtPACUrl.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtPACUrl.setEditable(true);
        this.txtPACUrl.setForeground(Color.WHITE);
        this.txtPACUrl.setCaretColor(ColorResource.getActiveTabColor());
        this.txtPACUrl.setOpaque(false);
        p.add(this.txtPACUrl);
        y += h;
        h = 30;
        this.chkUseProxy = this.createCheckBox("DESC_NET6");
        this.chkUseProxy.setBounds(15, y += 10, 320, h);
        p.add(this.chkUseProxy);
        y += h;
        h = 25;
        this.txtProxyHostnPort = new JTextField();
        this.txtProxyHostnPort.setBounds(15, y, 310, h);
        this.txtProxyHostnPort.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtProxyHostnPort.setEditable(true);
        this.txtProxyHostnPort.setCaretColor(ColorResource.getActiveTabColor());
        this.txtProxyHostnPort.setForeground(Color.WHITE);
        this.txtProxyHostnPort.setOpaque(false);
        p.add(this.txtProxyHostnPort);
        y += h;
        h = 30;
        this.chkUseSocks = this.createCheckBox("DESC_NET9");
        this.chkUseSocks.setBounds(15, y += 10, 320, h);
        p.add(this.chkUseSocks);
        y += h;
        h = 25;
        this.txtSocksHostnPort = new JTextField();
        this.txtSocksHostnPort.setBounds(15, y, 310, h);
        this.txtSocksHostnPort.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtSocksHostnPort.setEditable(true);
        this.txtSocksHostnPort.setCaretColor(ColorResource.getActiveTabColor());
        this.txtSocksHostnPort.setForeground(Color.WHITE);
        this.txtSocksHostnPort.setOpaque(false);
        p.add(this.txtSocksHostnPort);
        y += h;
        h = 30;
        JLabel lbl6 = new JLabel(StringResource.get("DESC_NET7"));
        lbl6.setForeground(Color.WHITE);
        lbl6.setFont(FontResource.getNormalFont());
        lbl6.setBounds(15, y += 10, 320, h);
        p.add(lbl6);
        y += h;
        h = 25;
        this.txtProxyUser = new JTextField();
        this.txtProxyUser.setBounds(15, y, 310, h);
        this.txtProxyUser.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtProxyUser.setCaretColor(ColorResource.getActiveTabColor());
        this.txtProxyUser.setEditable(true);
        this.txtProxyUser.setForeground(Color.WHITE);
        this.txtProxyUser.setOpaque(false);
        p.add(this.txtProxyUser);
        y += h;
        h = 30;
        JLabel lbl7 = new JLabel(StringResource.get("DESC_NET8"));
        lbl7.setForeground(Color.WHITE);
        lbl7.setFont(FontResource.getNormalFont());
        lbl7.setBounds(15, y += 10, 320, h);
        p.add(lbl7);
        y += h;
        h = 25;
        this.txtProxyPass = new JPasswordField();
        this.txtProxyPass.setBounds(15, y, 310, h);
        this.txtProxyPass.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtProxyPass.setCaretColor(ColorResource.getActiveTabColor());
        this.txtProxyPass.setEditable(true);
        this.txtProxyPass.setForeground(Color.WHITE);
        this.txtProxyPass.setOpaque(false);
        p.add(this.txtProxyPass);
        y += h;
        p.setPreferredSize(new Dimension(350, y += 50));
        return p;
    }

    private JPanel createPasswordPanel() {
        JPanel p = new JPanel();
        p.setLayout(null);
        p.setOpaque(false);
        int y = 20;
        int h = 100;
        this.passListModel = new DefaultListModel();
        this.passList = new JList<PasswordItem>(this.passListModel);
        this.passList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = SettingsPage.this.passList.getSelectedIndex();
                if (index > -1 && index < SettingsPage.this.passListModel.size()) {
                    PasswordItem item = SettingsPage.this.passListModel.get(index);
                    SettingsPage.this.txtCredHostName.setText(item.host);
                    SettingsPage.this.txtUserName.setText(item.user);
                    SettingsPage.this.txtPassword.setText(item.password);
                }
            }
        });
        this.passList.setCellRenderer(new SimpleListRenderer());
        this.passList.setBorder(null);
        this.passList.setOpaque(false);
        JScrollPane jsp2 = new JScrollPane();
        jsp2.setBorder(new LineBorder(ColorResource.getDarkBgColor()));
        jsp2.getViewport().setOpaque(false);
        jsp2.setViewportView(this.passList);
        jsp2.setBounds(15, y, 310, h);
        jsp2.setOpaque(false);
        DarkScrollBar scrollBar = new DarkScrollBar(1);
        jsp2.setVerticalScrollBar(scrollBar);
        jsp2.setHorizontalScrollBarPolicy(31);
        p.add(jsp2);
        y += h;
        h = 25;
        JButton btnDel = this.createButton2("DESC_PASS_DEL");
        btnDel.setBounds(245, y += 10, 80, h);
        btnDel.setName("DEL_CRED");
        p.add(btnDel);
        JButton btnNew = this.createButton2("DESC_PASS_NEW");
        btnNew.setName("NEW_CRED");
        btnNew.setBounds(155, y, 80, h);
        p.add(btnNew);
        y += h;
        h = 30;
        JLabel lbl64 = new JLabel(StringResource.get("DESC_USER"));
        lbl64.setForeground(Color.WHITE);
        lbl64.setFont(FontResource.getNormalFont());
        lbl64.setBounds(15, y, 320, h);
        p.add(lbl64);
        y += h;
        h = 25;
        this.txtCredHostName = new JTextField();
        this.txtCredHostName.setBounds(15, y, 310, h);
        this.txtCredHostName.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtCredHostName.setForeground(Color.WHITE);
        this.txtCredHostName.setOpaque(false);
        p.add(this.txtCredHostName);
        y += h;
        h = 30;
        JLabel lbl6 = new JLabel(StringResource.get("DESC_USER"));
        lbl6.setForeground(Color.WHITE);
        lbl6.setFont(FontResource.getNormalFont());
        lbl6.setBounds(15, y += 10, 320, h);
        p.add(lbl6);
        y += h;
        h = 25;
        this.txtUserName = new JTextField();
        this.txtUserName.setBounds(15, y, 310, h);
        this.txtUserName.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtUserName.setForeground(Color.WHITE);
        this.txtUserName.setOpaque(false);
        p.add(this.txtUserName);
        y += h;
        h = 30;
        JLabel lbl7 = new JLabel(StringResource.get("DESC_PASS"));
        lbl7.setForeground(Color.WHITE);
        lbl7.setFont(FontResource.getNormalFont());
        lbl7.setBounds(15, y += 10, 320, h);
        p.add(lbl7);
        y += h;
        h = 25;
        this.txtPassword = new JPasswordField();
        this.txtPassword.setBounds(15, y, 310, h);
        this.txtPassword.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtPassword.setForeground(Color.WHITE);
        this.txtPassword.setOpaque(false);
        p.add(this.txtPassword);
        y += h;
        JButton btnSave = this.createButton2("DESC_PASS_SAVE");
        btnSave.setName("SAVE_CRED");
        btnSave.setBounds(15, y += 10, 80, h);
        p.add(btnSave);
        y += h;
        p.setPreferredSize(new Dimension(350, y += 50));
        return p;
    }

    private JPanel createSchedulerPanel() {
        JPanel p = new JPanel();
        p.setLayout(null);
        p.setOpaque(false);
        int y = 5;
        this.h = 30;
        JLabel lbl67 = new JLabel(StringResource.get("Q_LIST_DESC"));
        lbl67.setForeground(Color.WHITE);
        lbl67.setFont(FontResource.getNormalFont());
        lbl67.setBounds(15, y, 320, this.h);
        p.add(lbl67);
        y += this.h;
        int h = 100;
        this.queueModel = new DefaultListModel();
        this.qList = new JList<DownloadQueue>(this.queueModel);
        this.qList.setCellRenderer(new QueueListRenderer());
        this.qList.setBorder(null);
        this.qList.setOpaque(false);
        this.qList.setSelectedIndex(0);
        this.qList.addListSelectionListener(this);
        JScrollPane jsp2 = new JScrollPane();
        jsp2.setBorder(new LineBorder(ColorResource.getDarkBgColor()));
        jsp2.getViewport().setOpaque(false);
        jsp2.setViewportView(this.qList);
        jsp2.setBounds(15, y, 310, h);
        jsp2.setOpaque(false);
        DarkScrollBar scrollBar = new DarkScrollBar(1);
        jsp2.setVerticalScrollBar(scrollBar);
        jsp2.setHorizontalScrollBarPolicy(31);
        p.add(jsp2);
        y += h;
        h = 25;
        JButton btnSave = this.createButton2("DESC_PASS_NEW");
        btnSave.setName("BTN_Q_NEW");
        btnSave.setBounds(15, y += 10, 80, h);
        p.add(btnSave);
        JButton btnDel = this.createButton2("DESC_PASS_DEL");
        btnDel.setName("BTN_Q_DEL");
        btnDel.setBounds(105, y, 80, h);
        p.add(btnDel);
        JButton btnNew = this.createButton2("DESC_SAVE_Q");
        btnNew.setName("BTN_Q_SAVE");
        btnNew.setBounds(245, y, 80, h);
        p.add(btnNew);
        y += h;
        h = 30;
        JLabel lbl6 = new JLabel(StringResource.get("MSG_QNAME"));
        lbl6.setForeground(Color.WHITE);
        lbl6.setFont(FontResource.getNormalFont());
        lbl6.setBounds(15, y += 20, 320, h);
        p.add(lbl6);
        y += h;
        h = 25;
        this.txtQueueName = new JTextField();
        this.txtQueueName.setCaretColor(Color.WHITE);
        this.txtQueueName.setBounds(15, y, 310, h);
        this.txtQueueName.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtQueueName.setEditable(true);
        this.txtQueueName.setForeground(Color.WHITE);
        this.txtQueueName.setOpaque(false);
        p.add(this.txtQueueName);
        y += h;
        h = 30;
        JLabel lbl69 = new JLabel(StringResource.get("Q_LIST_FILES"));
        lbl69.setForeground(Color.WHITE);
        lbl69.setFont(FontResource.getNormalFont());
        lbl69.setBounds(15, y += 20, 320, h);
        p.add(lbl69);
        y += h;
        h = 100;
        this.queuedItemsModel = new DefaultListModel();
        this.qItemsList = new JList<String>(this.queuedItemsModel);
        this.qItemsList.setCellRenderer(new QueuedItemsRenderer());
        this.qItemsList.setBorder(null);
        this.qItemsList.setOpaque(false);
        this.qItemsList.addListSelectionListener(this);
        JScrollPane jsp3 = new JScrollPane();
        jsp3.setBorder(new LineBorder(ColorResource.getDarkBgColor()));
        jsp3.getViewport().setOpaque(false);
        jsp3.setViewportView(this.qItemsList);
        jsp3.setBounds(15, y, 310, h);
        jsp3.setOpaque(false);
        DarkScrollBar scrollBar2 = new DarkScrollBar(1);
        jsp3.setVerticalScrollBar(scrollBar2);
        jsp3.setHorizontalScrollBarPolicy(31);
        jsp3.setAutoscrolls(true);
        p.add(jsp3);
        y += h;
        h = 25;
        JButton btnQMoveUp = this.createButton2("Q_MOVE_UP");
        btnQMoveUp.setName("Q_MOVE_UP");
        btnQMoveUp.setBounds(15, y += 10, 100, h);
        p.add(btnQMoveUp);
        JButton btnQMoveDown = this.createButton2("Q_MOVE_DN");
        btnQMoveDown.setName("Q_MOVE_DN");
        btnQMoveDown.setBounds(120, y, 100, h);
        p.add(btnQMoveDown);
        this.btnQMoveTo = this.createButton2("Q_MOVE_TO");
        this.btnQMoveTo.setName("Q_MOVE_TO");
        this.btnQMoveTo.setBounds(225, y, 100, h);
        p.add(this.btnQMoveTo);
        y += h;
        h = 30;
        JLabel lbl68 = new JLabel(StringResource.get("Q_SCHEDULE_TXT"));
        lbl68.setForeground(Color.WHITE);
        lbl68.setFont(FontResource.getNormalFont());
        lbl68.setBounds(15, y += 20, 320, h);
        p.add(lbl68);
        y += h;
        h = 20;
        this.chkQStart = this.createCheckBox("MSG_Q_START");
        this.chkQStart.setBounds(15, y += 10, 150, h);
        this.chkQStart.addActionListener(this);
        p.add(this.chkQStart);
        this.spinnerDateModel1 = new SpinnerDateModel(new Date(), null, null, 11);
        this.spStartTime = new JSpinner(this.spinnerDateModel1);
        this.spStartTime.setForeground(Color.WHITE);
        this.spStartTime.setBackground(ColorResource.getDarkBgColor());
        this.spStartTime.setBorder(null);
        JSpinner.DateEditor ed1 = new JSpinner.DateEditor(this.spStartTime, "hh:mm a");
        int n = ed1.getComponentCount();
        int i = 0;
        while (i < n) {
            Component c = ed1.getComponent(i);
            if (c instanceof JTextField) {
                c.setForeground(Color.WHITE);
                c.setBackground(ColorResource.getDarkBtnColor());
            }
            ++i;
        }
        this.spStartTime.setEditor(ed1);
        this.spStartTime.setBounds(210, y, 115, h);
        p.add(this.spStartTime);
        y += h;
        h = 20;
        this.chkQStop = this.createCheckBox("MSG_Q_STOP");
        this.chkQStop.setBounds(15, y += 5, 150, h);
        p.add(this.chkQStop);
        this.spinnerDateModel2 = new SpinnerDateModel(new Date(), null, null, 11);
        this.spEndTime = new JSpinner(this.spinnerDateModel2);
        this.spEndTime.setBorder(null);
        JSpinner.DateEditor ed2 = new JSpinner.DateEditor(this.spEndTime, "hh:mm a");
        n = ed2.getComponentCount();
        int i2 = 0;
        while (i2 < n) {
            Component c = ed2.getComponent(i2);
            if (c instanceof JTextField) {
                c.setForeground(Color.WHITE);
                c.setBackground(ColorResource.getDarkBtnColor());
            }
            ++i2;
        }
        this.spEndTime.setEditor(ed2);
        this.spEndTime.setBounds(210, y, 115, h);
        p.add(this.spEndTime);
        y += h;
        y += 20;
        ButtonGroup radioGroup = new ButtonGroup();
        h = 30;
        this.radOnetime = this.createRadioButton("MSQ_Q_ONETIME", FontResource.getNormalFont());
        this.radOnetime.setName("Q_ONCE");
        this.radOnetime.addActionListener(this);
        this.radOnetime.setBounds(15, y, 120, h);
        p.add(this.radOnetime);
        this.radOnetime.setEnabled(false);
        radioGroup.add(this.radOnetime);
        y += 5;
        h = 20;
        this.spinnerDateModel3 = new SpinnerDateModel(new Date(), DateTimeUtils.getBeginDate(), DateTimeUtils.getEndDate(), 5);
        this.spExecDate = new JSpinner(this.spinnerDateModel3);
        this.spExecDate.setBorder(null);
        JSpinner.DateEditor ed3 = new JSpinner.DateEditor(this.spExecDate, "dd-MMM-yy");
        n = ed3.getComponentCount();
        int i3 = 0;
        while (i3 < n) {
            Component c = ed3.getComponent(i3);
            if (c instanceof JTextField) {
                c.setForeground(Color.WHITE);
                c.setBackground(ColorResource.getDarkBtnColor());
            }
            ++i3;
        }
        this.spExecDate.setEditor(ed3);
        this.spExecDate.setBounds(120, y, 205, h);
        p.add(this.spExecDate);
        y += h;
        this.radPeriodic = this.createRadioButton("MSG_Q_DAILY", FontResource.getNormalFont());
        this.radPeriodic.setName("Q_DAILY");
        this.radPeriodic.addActionListener(this);
        this.radPeriodic.setBounds(15, y += 15, 100, h);
        p.add(this.radPeriodic);
        radioGroup.add(this.radPeriodic);
        h = 20;
        int x = 120;
        this.chkDays = new JCheckBox[7];
        int i4 = 1;
        while (i4 < 8) {
            JCheckBox chkDay = this.createCheckBox("MSG_Q_D" + i4, FontResource.getNormalFont());
            chkDay.setBounds(x, y, 100, h);
            p.add(chkDay);
            this.chkDays[i4 - 1] = chkDay;
            x += 100;
            if (i4 % 2 == 0) {
                x = 120;
                y += h;
            }
            ++i4;
        }
        y += h;
        y += 20;
        p.setPreferredSize(new Dimension(350, y += 50));
        return p;
    }

    private JPanel createAdvPanel() {
        JPanel p = new JPanel();
        p.setLayout(null);
        p.setOpaque(false);
        int y = 20;
        int h = 0;
        y += h;
        h = 30;
        this.chkHaltAfterFinish = this.createCheckBox("MSG_HALT");
        this.chkHaltAfterFinish.setBounds(15, y, 350, h);
        p.add(this.chkHaltAfterFinish);
        y += h;
        h = 30;
        this.chkKeepAwake = this.createCheckBox("MSG_AWAKE");
        this.chkKeepAwake.setBounds(15, y, 350, h);
        p.add(this.chkKeepAwake);
        y += h;
        h = 30;
        this.chkExecCmd = this.createCheckBox("EXEC_CMD");
        this.chkExecCmd.setBounds(15, y, 350, h);
        p.add(this.chkExecCmd);
        y += h;
        h = 25;
        this.txtCustomCmd = new JTextField();
        this.txtCustomCmd.setBounds(15, y, 310, h);
        this.txtCustomCmd.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtCustomCmd.setForeground(Color.WHITE);
        this.txtCustomCmd.setOpaque(false);
        p.add(this.txtCustomCmd);
        y += h;
        h = 30;
        this.chkExecAntivir = this.createCheckBox("EXE_ANTI_VIR");
        this.chkExecAntivir.setBounds(15, y += 20, 350, h);
        p.add(this.chkExecAntivir);
        y += h;
        h = 30;
        JLabel lbl12 = new JLabel(StringResource.get("ANTIVIR_CMD"));
        lbl12.setForeground(Color.WHITE);
        lbl12.setFont(FontResource.getNormalFont());
        lbl12.setBounds(15, y += 5, 320, h);
        p.add(lbl12);
        y += h;
        h = 25;
        this.txtAntivirCmd = new JTextField();
        this.txtAntivirCmd.setBounds(15, y, 210, h);
        this.txtAntivirCmd.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtAntivirCmd.setForeground(Color.WHITE);
        this.txtAntivirCmd.setOpaque(false);
        p.add(this.txtAntivirCmd);
        JButton btnBrowse = this.createButton2("BTN_BROWSE");
        btnBrowse.setName("BROWSE_ANTIVIR");
        btnBrowse.setBackground(ColorResource.getDarkBtnColor());
        btnBrowse.setFont(FontResource.getNormalFont());
        btnBrowse.setBounds(235, y, 90, h);
        p.add(btnBrowse);
        y += h;
        h = 30;
        JLabel lbl1 = new JLabel(StringResource.get("ANTIVIR_ARGS"));
        lbl1.setForeground(Color.WHITE);
        lbl1.setFont(FontResource.getNormalFont());
        lbl1.setBounds(15, y, 320, h);
        p.add(lbl1);
        y += h;
        h = 25;
        this.txtAntivirArgs = new JTextField();
        this.txtAntivirArgs.setBounds(15, y, 310, h);
        this.txtAntivirArgs.setBorder(new LineBorder(ColorResource.getDarkBtnColor()));
        this.txtAntivirArgs.setForeground(Color.WHITE);
        this.txtAntivirArgs.setOpaque(false);
        p.add(this.txtAntivirArgs);
        y += h;
        h = 30;
        this.chkAutoStart = this.createCheckBox("AUTO_START");
        this.chkAutoStart.setBounds(15, y += 20, 350, h);
        p.add(this.chkAutoStart);
        y += h;
        p.setPreferredSize(new Dimension(350, y += 50));
        return p;
    }

    private void loadAdvSettings() {
        Config config = Config.getInstance();
        this.chkHaltAfterFinish.setSelected(config.isAutoShutdown());
        this.chkKeepAwake.setSelected(config.isKeepAwake());
        this.chkExecCmd.setSelected(config.isExecCmd());
        this.chkExecAntivir.setSelected(config.isExecAntivir());
        this.chkAutoStart.setSelected(XDMUtils.isAlreadyAutoStart());
        if (!StringUtils.isNullOrEmptyOrBlank(config.getCustomCmd())) {
            this.txtCustomCmd.setText(config.getCustomCmd());
        }
        if (!StringUtils.isNullOrEmptyOrBlank(config.getAntivirCmd())) {
            this.txtAntivirArgs.setText(config.getAntivirCmd());
        }
        if (!StringUtils.isNullOrEmptyOrBlank(config.getAntivirExe())) {
            this.txtAntivirCmd.setText(config.getAntivirExe());
        }
    }

    private void saveAdvSettings() {
        Config config = Config.getInstance();
        config.setAutoShutdown(this.chkHaltAfterFinish.isSelected());
        config.setKeepAwake(this.chkKeepAwake.isSelected());
        config.setExecCmd(this.chkExecCmd.isSelected());
        config.setExecAntivir(this.chkExecAntivir.isSelected());
        if (this.chkAutoStart.isSelected()) {
            XDMUtils.addToStartup();
        } else {
            XDMUtils.removeFromStartup();
        }
        String customCmd = this.txtCustomCmd.getText();
        config.setCustomCmd(customCmd);
        String antivirExec = this.txtAntivirCmd.getText();
        config.setAntivirExe(antivirExec);
        String antivirCmd = this.txtAntivirArgs.getText();
        config.setAntivirCmd(antivirCmd);
    }

    private JRadioButton createRadioButton(String name, Font font) {
        JRadioButton chk = new JRadioButton(StringResource.get(name));
        chk.setIcon(ImageResource.get("unchecked.png"));
        chk.setSelectedIcon(ImageResource.get("checked.png"));
        chk.setOpaque(false);
        chk.setFocusPainted(false);
        chk.setForeground(Color.WHITE);
        chk.setFont(font);
        return chk;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.qList) {
            this.updateSchedulerFields();
        }
    }

    private void updateSchedulerFields() {
        int index = this.qList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        DownloadQueue q = this.queueModel.getElementAt(index);
        this.txtQueueName.setText(q.getName());
        this.loadQueuedItems(q);
        this.btnQMoveTo.setEnabled(QueueManager.getInstance().getQueueList().size() > 1 && q.getQueuedItems().size() > 0);
        Date startTime = DateTimeUtils.addTimePart(q.getStartTime());
        Date endTime = DateTimeUtils.addTimePart(q.getEndTime());
        if (startTime == null) {
            endTime = null;
        }
        this.chkQStart.setSelected(startTime != null);
        this.chkQStop.setSelected(endTime != null);
        if (startTime == null) {
            startTime = DateTimeUtils.getDefaultStart();
        }
        if (endTime == null || endTime.before(startTime)) {
            endTime = DateTimeUtils.getDefaultEnd();
        }
        this.spinnerDateModel1.setValue(startTime);
        this.spinnerDateModel2.setValue(endTime);
        int i = 1;
        while (i <= 7) {
            JCheckBox chk = this.chkDays[i - 1];
            chk.setSelected(false);
            ++i;
        }
        int mask = 1;
        if (q.isPeriodic()) {
            int i2 = 1;
            while (i2 <= 7) {
                JCheckBox chk = this.chkDays[i2 - 1];
                chk.setSelected((q.getDayMask() & mask) == mask);
                mask <<= 1;
                ++i2;
            }
            this.radPeriodic.setSelected(true);
        } else {
            Date execDate = q.getExecDate();
            if (execDate == null || execDate.before(new Date())) {
                execDate = new Date();
            }
            this.radOnetime.setSelected(true);
            this.spinnerDateModel3.setValue(execDate);
        }
        this.enableSchedulerFields();
    }

    private void loadQueuedItems(DownloadQueue q) {
        this.queuedItemsModel.clear();
        ArrayList<String> idList = q.getQueuedItems();
        int i = 0;
        while (i < idList.size()) {
            this.queuedItemsModel.addElement(idList.get(i));
            ++i;
        }
        if (idList.size() > 0) {
            this.qItemsList.setSelectedIndex(0);
        }
    }

    private void enableSchedulerFields() {
        this.radOnetime.setEnabled(this.chkQStart.isSelected());
        this.radPeriodic.setEnabled(this.chkQStart.isSelected());
        this.spExecDate.setEnabled(this.chkQStart.isSelected());
        this.spStartTime.setEnabled(this.chkQStart.isSelected());
        this.spEndTime.setEnabled(this.chkQStart.isSelected());
        this.chkQStop.setEnabled(this.chkQStart.isSelected());
        this.spExecDate.setEnabled(this.radOnetime.isSelected() && this.chkQStart.isSelected());
        int i = 0;
        while (i < 7) {
            this.chkDays[i].setEnabled(this.chkQStart.isSelected() && this.radPeriodic.isSelected());
            ++i;
        }
    }

    private void saveQueue() {
        int index = this.qList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        DownloadQueue q = this.queueModel.getElementAt(index);
        if (this.txtQueueName.getText().length() > 0) {
            q.setName(this.txtQueueName.getText());
        }
        if (this.chkQStart.isSelected()) {
            q.setStartTime(DateTimeUtils.getTimePart(this.spinnerDateModel1.getDate()));
            System.out.println(this.spinnerDateModel1.getDate());
            if (this.chkQStop.isSelected()) {
                q.setEndTime(DateTimeUtils.getTimePart(this.spinnerDateModel2.getDate()));
            } else {
                q.setEndTime(-1L);
            }
            if (this.radOnetime.isSelected()) {
                q.setPeriodic(false);
                q.setExecDate(this.spinnerDateModel3.getDate());
                q.setDayMask(0);
            } else {
                q.setPeriodic(true);
                q.setExecDate(null);
                int dayMask = 0;
                int mask = 1;
                int i = 1;
                while (i <= 7) {
                    JCheckBox chk = this.chkDays[i - 1];
                    if (chk.isSelected()) {
                        dayMask |= mask;
                    }
                    mask <<= 1;
                    ++i;
                }
                q.setDayMask(dayMask);
            }
        } else {
            q.setStartTime(-1L);
        }
        ArrayList<String> newOrder = new ArrayList<String>(this.queuedItemsModel.size());
        int i = 0;
        while (i < this.queuedItemsModel.size()) {
            newOrder.add(this.queuedItemsModel.get(i));
            ++i;
        }
        q.reorderItems(newOrder);
        QueueManager.getInstance().saveQueues();
    }

    private void queueMoveUp() {
        int index = this.qItemsList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        if (index == 0) {
            return;
        }
        String prevId = this.queuedItemsModel.get(index - 1);
        String nextId = this.queuedItemsModel.get(index);
        this.queuedItemsModel.set(index, prevId);
        this.queuedItemsModel.set(index - 1, nextId);
        this.qItemsList.setSelectedIndex(index - 1);
        this.qItemsList.ensureIndexIsVisible(index - 1);
    }

    private void queueMoveDown() {
        int index = this.qItemsList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        if (index == this.queuedItemsModel.size() - 1) {
            return;
        }
        String prevId = this.queuedItemsModel.get(index);
        String nextId = this.queuedItemsModel.get(index + 1);
        this.queuedItemsModel.set(index + 1, prevId);
        this.queuedItemsModel.set(index, nextId);
        this.qItemsList.setSelectedIndex(index + 1);
        this.qItemsList.ensureIndexIsVisible(index + 1);
    }

    private void queueMoveTo() {
    }

    private void removeQueue() {
        int index = this.qList.getSelectedIndex();
        if (index < 1) {
            return;
        }
        DownloadQueue q = this.queueModel.get(index);
        QueueManager.getInstance().removeQueue(q.getQueueId());
        this.loadSchedulerSettings(index < QueueManager.getInstance().getQueueList().size() ? index : index - 1);
    }

    private void createNewQueue() {
        int index = QueueManager.getInstance().getQueueList().size();
        QueueManager.getInstance().createNewQueue();
        int count = QueueManager.getInstance().getQueueList().size();
        this.loadSchedulerSettings(index < count ? index : 0);
    }

    private void showMoveQPopup(JButton btn) {
        int index = this.qList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        DownloadQueue q = this.queueModel.get(index);
        String qid = q.getQueueId();
        if (qid == null) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        int i = 0;
        while (i < QueueManager.getInstance().getQueueList().size()) {
            DownloadQueue tq = QueueManager.getInstance().getQueueList().get(i);
            if (!qid.equals(tq.getQueueId())) {
                JMenuItem item = new JMenuItem(tq.getName());
                item.setName("Q_MOVE_TO:" + tq.getQueueId());
                item.addActionListener(this);
                item.setForeground(Color.WHITE);
                item.setFont(FontResource.getNormalFont());
                popupMenu.add(item);
            }
            ++i;
        }
        popupMenu.setInvoker(btn);
        popupMenu.show(btn, 0, btn.getHeight());
    }

    private void saveOverviewSettings() {
        Config config = Config.getInstance();
        config.setShowDownloadWindow(this.chkPrgWnd.isSelected());
        config.setShowDownloadCompleteWindow(this.chkEndWnd.isSelected());
        config.setDuplicateAction(this.chkOverwriteExisting.isSelected() ? 1 : 0);
        String text = "" + this.cmbMax.getSelectedItem();
        if ("N/A".equals(text)) {
            config.setMaxDownloads(0);
        } else {
            config.setMaxDownloads(Integer.parseInt(text));
        }
        config.setDownloadFolder(this.txtDefFolder.getText());
        config.setTemporaryFolder(this.txtTempFolder.getText());
        config.setNoTransparency(this.chkNoTransparency.isSelected());
        config.save();
    }

    private void saveMonitoringSettings() {
        Config config = Config.getInstance();
        config.setFileExts(XDMUtils.appendStr2Array(this.txtFileTyp.getText()));
        config.setVidExts(XDMUtils.appendStr2Array(this.txtVidType.getText()));
        config.setBlockedHosts(XDMUtils.appendStr2Array(this.txtBlockedHosts.getText()));
        config.setShowVideoNotification(this.chkVidPan.isSelected());
        config.setMonitorClipboard(this.chkMonitorClipboard.isSelected());
        if (config.isMonitorClipboard()) {
            ClipboardMonitor.getInstance().startMonitoring();
        } else {
            ClipboardMonitor.getInstance().stopMonitoring();
        }
        int index = this.cmbMinVidSize.getSelectedIndex();
        if (index >= 0) {
            config.setMinVidSize(this.sizeArr[index]);
        }
        config.setDownloadAutoStart(this.chkDwnAuto.isSelected());
        config.setFetchTs(this.chkGetTs.isSelected());
        config.save();
    }

    private void saveNetworkSettings() {
        String socksText;
        Config config = Config.getInstance();
        config.setNetworkTimeout(this.cmbTimeout.getSelectedItem().equals("N/A") ? 0 : Integer.parseInt("" + this.cmbTimeout.getSelectedItem()));
        config.setMaxSegments(Integer.parseInt("" + this.cmbSeg.getSelectedItem()));
        String val = "" + this.cmbTcp.getSelectedItem();
        int ival = 0;
        try {
            ival = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        config.setTcpWindowSize(ival);
        try {
            int speedLimit = Integer.parseInt(this.txtSpeedLimit.getText());
            config.setSpeedLimit(speedLimit);
        }
        catch (Exception speedLimit) {
            // empty catch block
        }
        int proxyMode = 0;
        if (this.chkUsePac.isSelected()) {
            proxyMode = 1;
        } else if (this.chkUseProxy.isSelected()) {
            proxyMode = 2;
        } else if (this.chkUseSocks.isSelected()) {
            proxyMode = 3;
        }
        config.setProxyMode(proxyMode);
        config.setProxyPac(this.txtPACUrl.getText());
        String proxyText = this.txtProxyHostnPort.getText();
        if (proxyText.length() > 0) {
            String host = null;
            int port = 80;
            if (proxyText.indexOf(":") != -1) {
                String[] arr = proxyText.split(":");
                host = arr[0];
                try {
                    port = Integer.parseInt(arr[1]);
                }
                catch (Exception e) {
                    host = null;
                    port = 0;
                }
            } else {
                host = proxyText;
            }
            if (port > 0 && host != null && host.length() > 0) {
                config.setProxyHost(host);
                config.setProxyPort(port);
            }
        }
        if ((socksText = this.txtSocksHostnPort.getText()).length() > 0) {
            String host = null;
            int port = 1080;
            if (socksText.indexOf(":") != -1) {
                String[] arr = socksText.split(":");
                host = arr[0];
                try {
                    port = Integer.parseInt(arr[1]);
                }
                catch (Exception e) {
                    host = null;
                    port = 0;
                }
            } else {
                host = socksText;
            }
            if (port > 0 && host != null && host.length() > 0) {
                config.setSocksHost(host);
                config.setSocksPort(port);
            }
        }
        config.setProxyUser(this.txtProxyUser.getText());
        config.setProxyPass(this.txtProxyPass.getText());
    }
}

