/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.laf;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import xdman.ui.res.ColorResource;

public class XDMProgressBarUI
extends BasicProgressBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new XDMProgressBarUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(Color.GRAY);
        g2.fillRect(0, 0, c.getWidth(), c.getHeight());
        if (this.progressBar.isIndeterminate()) {
            this.paintIndeterminate(g, c);
        } else {
            this.paintDeterminate(g, c);
        }
    }

    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.boxRect = this.getBox(this.boxRect);
        if (this.boxRect != null) {
            g2.setPaint(ColorResource.getSelectionColor());
            g2.fillRect(this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height);
        }
    }

    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(ColorResource.getSelectionColor());
        if (this.progressBar.getOrientation() == 0) {
            g2.fillRect(0, 0, amountFull, c.getHeight());
        }
    }
}

