/*
 * Decompiled with CFR 0.152.
 */
package xdman;

import java.util.ArrayList;
import java.util.Date;
import xdman.DownloadEntry;
import xdman.QueueManager;
import xdman.XDMApp;
import xdman.util.Logger;

public class DownloadQueue {
    private boolean running;
    private String queueId;
    private int index;
    private String name;
    private ArrayList<String> queuedItems;
    private String currentItemId;
    private long startTime;
    private long endTime;
    private boolean periodic;
    private Date execDate;
    private int dayMask;

    public DownloadQueue(String id, String name) {
        this.name = name;
        this.queueId = id;
        this.queuedItems = new ArrayList();
        this.endTime = -1L;
        this.startTime = -1L;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.index = 0;
        this.running = true;
        this.next();
    }

    public void stop() {
        this.running = false;
        XDMApp app = XDMApp.getInstance();
        int i = 0;
        while (i < this.queuedItems.size()) {
            String id = this.queuedItems.get(i);
            DownloadEntry ent = app.getEntry(id);
            int state = ent.getState();
            if (state != 140 && state != 100 && state != 130) {
                app.pauseDownload(id);
            }
            ++i;
        }
    }

    public synchronized void next() {
        int state;
        DownloadEntry ent;
        Logger.log(String.valueOf(this.queueId) + " attmpting to process next item");
        if (!this.running) {
            return;
        }
        int c = 0;
        XDMApp app = XDMApp.getInstance();
        if (this.queuedItems == null) {
            return;
        }
        if (app.queueItemPending(this.queueId)) {
            Logger.log(String.valueOf(this.queueId) + " not processing as has already pending download");
            return;
        }
        if (this.currentItemId != null && (ent = app.getEntry(this.currentItemId)) != null && (state = ent.getState()) != 140 && state != 130 && state != 100) {
            Logger.log(String.valueOf(this.queueId) + " not processing as has already active download");
            return;
        }
        Logger.log(String.valueOf(this.queueId) + " total queued " + this.queuedItems.size());
        if (this.index >= this.queuedItems.size()) {
            this.index = 0;
        }
        while (this.index < this.queuedItems.size()) {
            int state2;
            String id = this.queuedItems.get(this.index);
            DownloadEntry ent2 = app.getEntry(id);
            if (ent2 != null && ((state2 = ent2.getState()) == 140 || state2 == 130)) {
                Logger.log("index: " + this.index + " c: " + c);
                this.currentItemId = id;
                ++this.index;
                ent2.setStartedByUser(false);
                XDMApp.getInstance().resumeDownload(id, false);
                return;
            }
            ++this.index;
        }
    }

    public void removeFromQueue(String id) {
        int c = 0;
        XDMApp app = XDMApp.getInstance();
        int i = 0;
        while (i < this.queuedItems.size()) {
            if (this.queuedItems.get(i).equals(id)) {
                DownloadEntry ent;
                c = i;
                if (c <= this.index) {
                    --this.index;
                }
                this.queuedItems.remove(i);
                if (id.equals(this.currentItemId)) {
                    this.currentItemId = null;
                }
                if ((ent = app.getEntry(id)) != null) {
                    ent.setQueueId("");
                }
                QueueManager.getInstance().saveQueues();
                return;
            }
            ++i;
        }
    }

    public void addToQueue(String id) {
        if (!this.queuedItems.contains(id)) {
            Logger.log(String.valueOf(id) + " added to " + this.queueId);
            this.queuedItems.add(id);
            DownloadEntry ent = XDMApp.getInstance().getEntry(id);
            if (ent != null) {
                ent.setQueueId(this.queueId);
            }
        }
        QueueManager.getInstance().saveQueues();
    }

    public final String getQueueId() {
        return this.queueId;
    }

    public final void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public ArrayList<String> getQueuedItems() {
        return this.queuedItems;
    }

    public String toString() {
        return this.getName();
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public final long getEndTime() {
        return this.endTime;
    }

    public final void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public final boolean isPeriodic() {
        return this.periodic;
    }

    public final void setPeriodic(boolean periodic) {
        this.periodic = periodic;
    }

    public final Date getExecDate() {
        return this.execDate;
    }

    public final void setExecDate(Date execDate) {
        this.execDate = execDate;
    }

    public final int getDayMask() {
        return this.dayMask;
    }

    public final void setDayMask(int dayMask) {
        this.dayMask = dayMask;
    }

    public final void setQueuedItems(ArrayList<String> queuedItems) {
        this.queuedItems = queuedItems;
    }

    public final synchronized void reorderItems(ArrayList<String> newOrder) {
        this.queuedItems.clear();
        for (String s : newOrder) {
            this.queuedItems.add(s);
        }
    }

    public boolean hasPendingItems() {
        if (!this.running) {
            return false;
        }
        for (String id : this.queuedItems) {
            DownloadEntry ent = XDMApp.getInstance().getEntry(id);
            if (ent == null || ent.getState() == 100) continue;
            return true;
        }
        return false;
    }
}

