/*
 * Decompiled with CFR 0.152.
 */
package xdman.downloaders;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.UUID;
import xdman.Config;
import xdman.downloaders.AbstractChannel;
import xdman.downloaders.Segment;
import xdman.downloaders.SegmentListener;
import xdman.util.Logger;

public class SegmentImpl
implements Segment {
    private volatile long length;
    private volatile long startOffset;
    private volatile long downloaded;
    private RandomAccessFile outStream;
    private String id;
    private volatile SegmentListener cl;
    private volatile AbstractChannel channel;
    private long bytesRead1;
    private long bytesRead2;
    private long time1;
    private long time2;
    private float transferRate;
    private Config config;
    private volatile boolean stop;
    private int errorCode;
    private Object tag;
    private String folder;

    public SegmentImpl(SegmentListener cl, String folder) throws IOException {
        this.id = UUID.randomUUID().toString();
        this.cl = cl;
        this.folder = folder;
        this.time2 = this.time1 = System.currentTimeMillis();
        this.config = Config.getInstance();
        this.outStream = new RandomAccessFile(new File(folder, this.id), "rw");
        Logger.log("File opened " + this.id);
    }

    public SegmentImpl(String folder, String id, long off, long len, long dwn) throws IOException {
        this.id = id;
        this.id = id;
        this.startOffset = off;
        this.folder = folder;
        this.length = len;
        this.downloaded = dwn;
        this.time2 = this.time1 = System.currentTimeMillis();
        this.bytesRead1 = dwn;
        this.bytesRead2 = dwn;
        try {
            this.outStream = new RandomAccessFile(new File(folder, id), "rw");
            this.outStream.seek(dwn);
            Logger.log("File opened " + id);
        }
        catch (IOException e) {
            Logger.log(e);
            if (this.outStream != null) {
                this.outStream.close();
            }
            throw new IOException(e);
        }
        this.config = Config.getInstance();
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getStartOffset() {
        return this.startOffset;
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    @Override
    public RandomAccessFile getOutStream() {
        return this.outStream;
    }

    @Override
    public boolean transferComplete() throws IOException {
        if (this.stop) {
            return true;
        }
        if (this.length < 0L) {
            this.length = this.downloaded;
        }
        if (this.cl.chunkComplete(this.id)) {
            try {
                this.outStream.close();
            }
            catch (IOException e) {
                Logger.log(e);
            }
            this.channel = null;
            if (this.cl != null && this.cl.shouldCleanup()) {
                this.cl.cleanup();
            }
            return true;
        }
        return false;
    }

    @Override
    public void clearChannel() {
        this.channel = null;
    }

    @Override
    public void transferInitiated() throws IOException {
        if (this.stop) {
            return;
        }
        this.cl.chunkInitiated(this.id);
        this.time2 = System.currentTimeMillis();
    }

    @Override
    public void transferFailed(String reason) {
        if (this.stop) {
            return;
        }
        if (this.outStream != null) {
            try {
                this.outStream.close();
                this.outStream = null;
            }
            catch (IOException e) {
                Logger.log(e);
            }
        }
        this.errorCode = this.channel.getErrorCode();
        Logger.log(String.valueOf(this.id) + " notifying failure " + this.channel);
        this.channel = null;
        this.cl.chunkFailed(this.id, reason);
        this.cl = null;
    }

    @Override
    public boolean isFinished() {
        return this.getLength() - this.getDownloaded() == 0L;
    }

    @Override
    public boolean isActive() {
        return this.channel != null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void download(SegmentListener cl) {
        this.cl = cl;
        this.channel = cl.createChannel(this);
        this.channel.open();
    }

    @Override
    public void setLength(long length) {
        this.length = length;
    }

    @Override
    public void setDownloaded(long downloaded) {
        this.downloaded = downloaded;
    }

    @Override
    public void setStartOffset(long offset) {
        this.startOffset = offset;
    }

    @Override
    public void stop() {
        this.stop = true;
        this.dispose();
    }

    @Override
    public SegmentListener getChunkListener() {
        return this.cl;
    }

    @Override
    public void dispose() {
        this.cl = null;
        if (this.channel != null) {
            this.channel.stop();
        }
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (IOException e) {
                Logger.log(e);
            }
        }
    }

    public String toString() {
        return this.id;
    }

    @Override
    public void transferring() {
        if (this.stop) {
            return;
        }
        this.cl.chunkUpdated(this.id);
        this.calculateTransferRate();
        this.throttle();
    }

    @Override
    public AbstractChannel getChannel() {
        return this.channel;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    private void calculateTransferRate() {
        long now = System.currentTimeMillis();
        long timeDiff = now - this.time1;
        long bytesDiff = this.downloaded - this.bytesRead1;
        if (timeDiff > 1000L && bytesDiff > 0L) {
            this.transferRate = (float)bytesDiff / (float)timeDiff * 1000.0f;
            this.bytesRead1 = this.downloaded;
            this.time1 = now;
        }
    }

    private void throttle() {
        try {
            if (this.config.getSpeedLimit() < 1) {
                return;
            }
            if (this.cl.getActiveChunkCount() < 1) {
                return;
            }
            long maxBpms = this.config.getSpeedLimit() * 1024 / (this.cl.getActiveChunkCount() * 1000);
            long now = System.currentTimeMillis();
            long timeSpentInReal = now - this.time2;
            if (timeSpentInReal > 0L) {
                this.time2 = now;
                long bytesDownloaded = this.downloaded - this.bytesRead2;
                this.bytesRead2 = this.downloaded;
                long timeShouldRequired = bytesDownloaded / maxBpms;
                if (timeShouldRequired > timeSpentInReal) {
                    long timeNeedToSleep = timeShouldRequired - timeSpentInReal;
                    Thread.sleep(timeNeedToSleep);
                }
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    @Override
    public final float getTransferRate() {
        return this.transferRate;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public Object getTag() {
        return this.tag;
    }

    @Override
    public void setTag(Object tag) {
        this.tag = tag;
    }

    public String getErrorMsg() {
        return null;
    }

    @Override
    public void resetStream() throws IOException {
        this.outStream.seek(0L);
        this.outStream.setLength(0L);
    }

    @Override
    public void reopenStream() throws IOException {
        if (this.outStream != null) {
            return;
        }
        try {
            this.outStream = new RandomAccessFile(new File(this.folder, this.id), "rw");
            this.outStream.seek(this.downloaded);
            Logger.log("File opened " + this.id);
        }
        catch (IOException e) {
            Logger.log(e);
            if (this.outStream != null) {
                this.outStream.close();
            }
            throw new IOException(e);
        }
    }

    @Override
    public boolean promptCredential(String msg, boolean proxy) {
        return this.cl.promptCredential(msg, proxy);
    }
}

