/*
 * Decompiled with CFR 0.152.
 */
package xdman.downloaders.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import xdman.downloaders.AbstractChannel;
import xdman.downloaders.Segment;
import xdman.network.ProxyResolver;
import xdman.network.http.HeaderCollection;
import xdman.network.http.HttpClient;
import xdman.network.http.HttpHeader;
import xdman.network.http.JavaClientRequiredException;
import xdman.network.http.JavaHttpClient;
import xdman.network.http.WebProxy;
import xdman.network.http.XDMHttpClient;
import xdman.util.Logger;
import xdman.util.XDMUtils;

public class HttpChannel
extends AbstractChannel {
    private String url;
    private HeaderCollection headers;
    private HttpClient hc;
    private InputStream in;
    private boolean javaClientRequired;
    private long firstLength;
    private long totalLength;
    private boolean redirected;
    private String redirectUrl;

    public HttpChannel(Segment chunk, String url, HeaderCollection headers, long totalLength, boolean javaClientRequired) {
        super(chunk);
        this.url = url;
        this.headers = headers;
        this.totalLength = totalLength;
        this.javaClientRequired = javaClientRequired;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean connectImpl() {
        int read;
        long len;
        InputStream inStr;
        ByteArrayOutputStream bout;
        boolean isRedirect;
        block35: {
            int sleepInterval = 0;
            isRedirect = false;
            if (this.stop) {
                this.closeImpl();
                return false;
            }
            if (!"HLS".equals(this.chunk.getTag())) {
                if (this.chunk.getLength() < 0L && this.chunk.getDownloaded() > 0L) {
                    this.errorCode = 103;
                    this.closeImpl();
                    Logger.log("server does not support resuming");
                    return false;
                }
                try {
                    this.chunk.reopenStream();
                }
                catch (IOException e) {
                    Logger.log(e);
                    this.closeImpl();
                    this.errorCode = 103;
                    return false;
                }
            } else {
                try {
                    this.chunk.reopenStream();
                    this.chunk.resetStream();
                    this.chunk.setDownloaded(0L);
                }
                catch (IOException e) {
                    Logger.log("Stream rest failed");
                    Logger.log(e);
                }
            }
            while (!this.stop) {
                isRedirect = false;
                try {
                    Logger.log("Connecting to: " + this.url + " " + this.chunk.getTag());
                    WebProxy wp = ProxyResolver.resolve(this.url);
                    if (wp != null) {
                        this.javaClientRequired = true;
                    }
                    this.hc = this.javaClientRequired ? new JavaHttpClient(this.url) : new XDMHttpClient(this.url);
                    if (this.headers != null) {
                        Iterator<HttpHeader> headerIt = this.headers.getAll();
                        while (headerIt.hasNext()) {
                            HttpHeader header = headerIt.next();
                            this.hc.setHeader(header.getName(), header.getValue());
                        }
                    }
                    long length = this.chunk.getLength();
                    long startOff = this.chunk.getStartOffset() + this.chunk.getDownloaded();
                    long endOff = startOff + length - this.chunk.getDownloaded();
                    long expectedLength = endOff - startOff;
                    if (length > 0L && expectedLength > 0L) {
                        Logger.log(this.chunk + " requesting:- " + "Range:" + "bytes=" + startOff + "-" + (endOff - 1L));
                        this.hc.setHeader("Range", "bytes=" + startOff + "-" + (endOff - 1L));
                    } else {
                        this.hc.setHeader("Range", "bytes=0-");
                    }
                    Logger.log("Initating connection");
                    this.hc.connect();
                    if (this.stop) {
                        this.closeImpl();
                        return false;
                    }
                    int code = this.hc.getStatusCode();
                    Logger.log(this.chunk + ": " + code);
                    if (code >= 300 && code < 400) {
                        this.closeImpl();
                        if (this.totalLength > 0L) {
                            this.errorCode = 100;
                            Logger.log(this.chunk + " Redirecting twice");
                            return false;
                        }
                        this.url = this.hc.getResponseHeader("location");
                        Logger.log(this.chunk + " location: " + this.url);
                        if (!this.url.startsWith("http")) {
                            if (!this.url.startsWith("/")) {
                                this.url = "/" + this.url;
                            }
                            this.url = "http://" + this.hc.getHost() + this.url;
                        }
                        this.url = this.url.replace(" ", "%20");
                        isRedirect = true;
                        this.redirected = true;
                        this.redirectUrl = this.url;
                        throw new Exception("Redirecting to: " + this.url);
                    }
                    if (code != 200 && code != 206 && code != 416 && code != 413 && code != 401 && code != 408 && code != 407 && code != 503) {
                        this.errorCode = 100;
                        this.closeImpl();
                        return false;
                    }
                    if (code == 407 || code == 401) {
                        if (this.javaClientRequired) {
                            boolean proxy;
                            Logger.log("asking for password");
                            boolean bl = proxy = code == 407;
                            if (!this.chunk.promptCredential(this.hc.getHost(), proxy)) {
                                this.errorCode = 100;
                                this.closeImpl();
                                return false;
                            }
                        }
                        throw new JavaClientRequiredException();
                    }
                    if (("T1".equals(this.chunk.getTag()) || "T2".equals(this.chunk.getTag())) && "text/plain".equals(this.hc.getResponseHeader("content-type"))) {
                        bout = new ByteArrayOutputStream();
                        inStr = this.hc.getInputStream();
                        System.out.println(inStr);
                        len = this.hc.getContentLength();
                        read = 0;
                        System.out.println("reading url of length: " + len);
                        break block35;
                    }
                    if (this.chunk.getDownloaded() + this.chunk.getStartOffset() > 0L && code != 206) {
                        this.closeImpl();
                        this.errorCode = 103;
                        return false;
                    }
                    this.firstLength = "HLS".equals(this.chunk.getTag()) ? -1L : this.hc.getContentLength();
                    if (length > 0L && this.firstLength != expectedLength) {
                        Logger.log(this.chunk + " length mismatch: expected: " + expectedLength + " got: " + this.firstLength);
                        this.errorCode = 103;
                        this.closeImpl();
                        return false;
                    }
                    if (this.hc.getContentLength() > 0L && XDMUtils.getFreeSpace(null) < this.hc.getContentLength()) {
                        Logger.log("Disk is full");
                        this.errorCode = 133;
                        this.closeImpl();
                        return false;
                    }
                    this.in = this.hc.getInputStream();
                    Logger.log("Connection success");
                    return true;
                }
                catch (JavaClientRequiredException e) {
                    Logger.log("java client required");
                    this.javaClientRequired = true;
                    sleepInterval = 0;
                }
                catch (Exception e) {
                    Logger.log(this.chunk);
                    Logger.log(e);
                    if (isRedirect) {
                        this.closeImpl();
                        continue;
                    }
                    sleepInterval = 5000;
                }
                this.closeImpl();
                try {
                    Thread.sleep(sleepInterval);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Logger.log("return as " + this.errorCode);
            return false;
        }
        while (len <= 0L || (long)read != len) {
            int x = inStr.read();
            if (x == -1) {
                if (len <= 0L) break;
                throw new IOException("Unable to read url: unexpected EOF");
            }
            ++read;
            System.out.print((char)x);
            bout.write(x);
        }
        byte[] buf = bout.toByteArray();
        this.url = new String(buf, Charset.forName("ASCII"));
        isRedirect = true;
        throw new Exception("Youtube text redirect to: " + this.url);
    }

    @Override
    protected InputStream getInputStreamImpl() {
        return this.in;
    }

    @Override
    protected long getLengthImpl() {
        return this.firstLength;
    }

    @Override
    protected void closeImpl() {
        if (this.hc != null) {
            this.hc.dispose();
        }
    }

    public boolean isFinished() {
        if (this.hc instanceof XDMHttpClient) {
            return ((XDMHttpClient)this.hc).isFinished();
        }
        return false;
    }

    public boolean isJavaClientRequired() {
        return this.javaClientRequired;
    }

    public boolean isRedirected() {
        return this.redirected;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getHeader(String name) {
        return this.hc.getResponseHeader(name);
    }
}

