/*
 * Decompiled with CFR 0.152.
 */
package xdman.monitoring;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import xdman.XDMApp;
import xdman.downloaders.metadata.HdsMetadata;
import xdman.downloaders.metadata.manifests.F4MManifest;
import xdman.monitoring.ParsedHookData;
import xdman.util.Logger;
import xdman.util.StringUtils;
import xdman.util.XDMUtils;

public class F4mHandler {
    public static boolean handle(File f4mfile, ParsedHookData data) {
        block12: {
            StringBuffer buf;
            block11: {
                block10: {
                    block9: {
                        String ln;
                        buf = new StringBuffer();
                        FileInputStream in = new FileInputStream(f4mfile);
                        BufferedReader r = new BufferedReader(new InputStreamReader(in));
                        while ((ln = r.readLine()) != null) {
                            buf.append(String.valueOf(ln) + "\n");
                        }
                        ((InputStream)in).close();
                        Logger.log("HDS manifest validating...");
                        if (buf.indexOf("http://ns.adobe.com/f4m/1.0") >= 0) break block9;
                        Logger.log("No namespace");
                        return false;
                    }
                    if (buf.indexOf("manifest") >= 0) break block10;
                    Logger.log("No manifest keyword");
                    return false;
                }
                if (buf.indexOf("drmAdditional") <= 0) break block11;
                Logger.log("DRM");
                return false;
            }
            if (buf.indexOf("media") != 0 && buf.indexOf("href") <= 0 && buf.indexOf(".f4m") <= 0) break block12;
            Logger.log("Not a valid manifest");
            return false;
        }
        try {
            Logger.log("URL: " + data.getUrl());
            F4MManifest manifest = new F4MManifest(data.getUrl(), f4mfile.getAbsolutePath());
            long[] bitRates = manifest.getBitRates();
            Logger.log("Bitrates: " + bitRates.length);
            int i = 0;
            while (i < bitRates.length) {
                HdsMetadata metadata = new HdsMetadata();
                metadata.setUrl(data.getUrl());
                metadata.setBitRate((int)bitRates[i]);
                metadata.setHeaders(data.getRequestHeaders());
                String file = data.getFile();
                if (StringUtils.isNullOrEmptyOrBlank(file)) {
                    file = XDMUtils.getFileName(data.getUrl());
                }
                XDMApp.getInstance().addMedia(metadata, String.valueOf(file) + ".flv", "FLV " + bitRates[i] + " bps");
                ++i;
            }
            Logger.log("Manifest valid");
            return true;
        }
        catch (Exception e) {
            Logger.log(e);
            return false;
        }
    }
}

