/*
 * Decompiled with CFR 0.152.
 */
package xdman.network.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xdman.network.http.HttpHeader;
import xdman.util.NetUtils;

public class HeaderCollection {
    private List<HttpHeader> headers = new ArrayList<HttpHeader>();

    public String getValue(String name) {
        int i = 0;
        while (i < this.headers.size()) {
            HttpHeader header = this.headers.get(i);
            if (header.getName().equalsIgnoreCase(name)) {
                return header.getValue();
            }
            ++i;
        }
        return null;
    }

    public boolean containsHeader(String name) {
        int i = 0;
        while (i < this.headers.size()) {
            HttpHeader header = this.headers.get(i);
            if (header.getName().equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Iterator<HttpHeader> getHeaders(String name) {
        ArrayList<HttpHeader> list = new ArrayList<HttpHeader>();
        int i = 0;
        while (i < this.headers.size()) {
            HttpHeader header = this.headers.get(i);
            if (header.getName().equalsIgnoreCase(name)) {
                list.add(header);
            }
            ++i;
        }
        return list.iterator();
    }

    public Iterator<HttpHeader> getAll() {
        return this.headers.iterator();
    }

    public void addHeader(String name, String value) {
        this.addHeader(new HttpHeader(name, value));
    }

    public void addHeader(HttpHeader header) {
        if (header == null) {
            throw new NullPointerException("Header is null");
        }
        this.headers.add(header);
    }

    public void setValue(String name, String value) {
        boolean found = false;
        int i = 0;
        while (i < this.headers.size()) {
            HttpHeader header = this.headers.get(i);
            if (header.getName().equalsIgnoreCase(name)) {
                header.setValue(value);
                found = true;
            }
            ++i;
        }
        if (!found) {
            this.addHeader(name, value);
        }
    }

    public void add(String text) {
        this.addHeader(HttpHeader.parse(text));
    }

    public void clear() {
        this.headers.clear();
    }

    public void appendToBuffer(StringBuffer buf) {
        int i = 0;
        while (i < this.headers.size()) {
            HttpHeader header = this.headers.get(i);
            buf.append(String.valueOf(header.getName()) + ": " + header.getValue() + "\r\n");
            ++i;
        }
    }

    public void loadFromStream(InputStream inStream) throws IOException {
        String ln;
        while ((ln = NetUtils.readLine(inStream)).length() >= 1) {
            int index = ln.indexOf(":");
            if (index <= 0) continue;
            String key = ln.substring(0, index).trim();
            String value = ln.substring(index + 1).trim();
            HttpHeader header = new HttpHeader(key, value);
            this.headers.add(header);
        }
    }
}

