/*
 * Decompiled with CFR 0.152.
 */
package xdman.network.http;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import xdman.CredentialManager;
import xdman.network.ICredentialManager;
import xdman.util.Logger;

public class HttpContext {
    private boolean init = false;
    private SSLContext sslContext;
    private ICredentialManager credentialMgr;
    private static HttpContext _this;

    public static HttpContext getInstance() {
        if (_this == null) {
            _this = new HttpContext();
        }
        return _this;
    }

    public void registerCredentialManager(ICredentialManager mgr) {
        this.credentialMgr = mgr;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    private HttpContext() {
        this.init();
    }

    public void init() {
        if (!this.init) {
            Logger.log("Context initialized");
            System.setProperty("http.auth.preference", "ntlm");
            try {
                try {
                    this.sslContext = SSLContext.getInstance("TLS");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.sslContext = SSLContext.getInstance("SSL");
                }
                TrustManager[] trustAllCerts = new TrustManager[]{new X509ExtendedTrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                    }
                }};
                this.sslContext.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(this.sslContext.getSocketFactory());
            }
            catch (Exception e) {
                Logger.log(e);
            }
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    System.out.println("Called on " + (Object)((Object)this.getRequestorType()) + " scheme: " + this.getRequestingScheme() + " host: " + this.getRequestingHost() + " url: " + this.getRequestingURL() + " prompt: " + this.getRequestingPrompt());
                    if (this.getRequestorType() == Authenticator.RequestorType.SERVER) {
                        PasswordAuthentication pauth = CredentialManager.getInstance().getCredentialForHost(this.getRequestingHost());
                        return pauth;
                    }
                    return CredentialManager.getInstance().getCredentialForProxy();
                }
            });
            this.init = true;
        }
    }
}

