/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import xdman.mediaconversion.ConversionItem;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.StringUtils;

public class ConversionItemRender
implements ListCellRenderer<ConversionItem> {
    private JPanel panel;
    private JPanel component = new JPanel(new BorderLayout(5, 5));
    private JLabel lbl;
    private JLabel lblIcon;
    private JLabel lblVideoDet;
    private JLabel lblBorder;
    private JLabel lblVolume;
    private ImageIcon ico;

    public ConversionItemRender() {
        this.component.setBackground(ColorResource.getDarkerBgColor());
        this.component.setBorder(new EmptyBorder(0, 5, 5, 5));
        this.panel = new JPanel(new BorderLayout());
        this.lblIcon = new JLabel();
        this.lblIcon.setOpaque(true);
        this.lblIcon.setPreferredSize(new Dimension(64, 64));
        this.lblIcon.setMinimumSize(new Dimension(64, 64));
        this.lblIcon.setMaximumSize(new Dimension(64, 64));
        this.lblIcon.setHorizontalAlignment(0);
        this.ico = ImageResource.get("video.png");
        this.lblIcon.setIcon(this.ico);
        this.lblIcon.setVerticalAlignment(0);
        JPanel p1 = new JPanel(new BorderLayout());
        p1.setOpaque(false);
        p1.add(this.lblIcon);
        p1.setBorder(new EmptyBorder(12, 5, 5, 5));
        this.component.add((Component)p1, "West");
        this.lbl = new JLabel();
        this.lbl.setFont(FontResource.getItemFont());
        this.lbl.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.lbl.setVerticalAlignment(0);
        this.panel.add(this.lbl);
        this.lblVideoDet = new JLabel();
        this.lblVideoDet.setPreferredSize(new Dimension(200, 30));
        this.lblVideoDet.setOpaque(false);
        this.lblVideoDet.setVerticalAlignment(1);
        this.panel.add((Component)this.lblVideoDet, "South");
        this.panel.setOpaque(false);
        this.panel.setBorder(new EmptyBorder(5, 0, 7, 5));
        this.component.add(this.panel);
        this.lblBorder = new JLabel();
        this.lblBorder.setPreferredSize(new Dimension(100, 1));
        this.lblBorder.setMaximumSize(new Dimension(100, 1));
        this.lblBorder.setBackground(ColorResource.getDarkestBgColor());
        this.component.add((Component)this.lblBorder, "North");
        this.component.setOpaque(true);
        this.lblVolume = new JLabel();
        this.lblVolume.setIcon(ImageResource.get("vol.png"));
        this.lblVolume.setFont(FontResource.getNormalFont());
        this.lblVolume.setText(StringResource.get("LBL_VOLUME_BOOST"));
        this.lblVolume.setVerticalAlignment(0);
        this.lblVolume.setHorizontalAlignment(0);
        this.lblVolume.setVerticalTextPosition(3);
        this.lblVolume.setHorizontalTextPosition(0);
        this.lblVolume.setBorder(new EmptyBorder(0, 5, 0, 10));
        this.component.add((Component)this.lblVolume, "East");
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends ConversionItem> list, ConversionItem value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.component.setBackground(ColorResource.getSelectionColor());
        } else {
            this.component.setBackground(ColorResource.getDarkerBgColor());
        }
        this.lbl.setText(value.inputFileName);
        StringBuilder buf = new StringBuilder();
        if (value.info != null) {
            if (value.info.thumbnail != null) {
                this.lblIcon.setIcon(value.info.thumbnail);
            }
            if (!StringUtils.isNullOrEmptyOrBlank(value.info.duration)) {
                buf.append("[" + value.info.duration + "]");
            }
            if (!StringUtils.isNullOrEmptyOrBlank(value.info.resolution)) {
                buf.append(buf.length() > 0 ? " " : "");
                buf.append(value.info.resolution);
            }
            if (value.conversionState == 1) {
                if (buf.length() > 0) {
                    buf.append(" - ");
                }
                buf.append(StringResource.get("LBL_CONV_SUCCESS"));
            } else if (value.conversionState == 2) {
                if (buf.length() > 0) {
                    buf.append(" - ");
                }
                buf.append(StringResource.get("LBL_CONV_FAILED"));
            }
            if (buf.length() > 0) {
                this.lblVideoDet.setText(buf.toString());
            }
        }
        this.lbl.setText(value.inputFileName);
        if (index == 0) {
            this.lblBorder.setOpaque(false);
        } else {
            this.lblBorder.setOpaque(true);
        }
        return this.component;
    }

    public boolean isInside(int x) {
        Rectangle r = this.lblVolume.getBounds();
        return r.contains(x, 10);
    }
}

