/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import xdman.Config;
import xdman.DownloadEntry;
import xdman.ListChangeListener;
import xdman.XDMApp;
import xdman.ui.components.DownloadSorter;
import xdman.util.Logger;

public class DownloadTableModel
extends AbstractTableModel
implements ListChangeListener {
    private static final long serialVersionUID = 5474784018135644748L;
    ArrayList<String> idList = new ArrayList();
    Map<String, Integer> idIndexMap = new HashMap<String, Integer>();
    DownloadSorter _sorter;

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.idList.size();
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return DownloadEntry.class;
    }

    @Override
    public Object getValueAt(int row, int col) {
        String id = this.idList.get(row);
        if (id == null) {
            return null;
        }
        return XDMApp.getInstance().getEntry(id);
    }

    @Override
    public void listChanged() {
        Logger.log("List changed");
        this.idList = XDMApp.getInstance().getDownloadList(Config.getInstance().getCategoryFilter(), Config.getInstance().getStateFilter(), Config.getInstance().getSearchText());
        this.sort();
        this.refreshIdMap();
        this.fireTableDataChanged();
    }

    @Override
    public void listItemUpdated(String id) {
        Logger.log("List updated");
        Integer index = this.idIndexMap.get(id);
        if (index != null) {
            this.fireTableRowsUpdated(index, index);
        }
    }

    private void sort() {
        if (this._sorter == null) {
            this._sorter = new DownloadSorter();
        }
        Collections.sort(this.idList, this._sorter);
    }

    private void refreshIdMap() {
        this.idIndexMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < this.idList.size()) {
            this.idIndexMap.put(this.idList.get(i), i);
            ++i;
        }
    }

    public String getIdAt(int index) {
        return this.idList.get(index);
    }

    public int getIndexOfId(String id) {
        int i = 0;
        while (i < this.idList.size()) {
            if (this.idList.get(i).equals(id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

