/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import xdman.Config;
import xdman.DownloadEntry;
import xdman.DownloadQueue;
import xdman.XDMApp;
import xdman.downloaders.metadata.DashMetadata;
import xdman.downloaders.metadata.HdsMetadata;
import xdman.downloaders.metadata.HlsMetadata;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.network.http.HeaderCollection;
import xdman.network.http.HttpHeader;
import xdman.ui.components.AboutPage;
import xdman.ui.components.BarPanel;
import xdman.ui.components.BatchClipboardWnd;
import xdman.ui.components.ConversionWindow;
import xdman.ui.components.CustomButton;
import xdman.ui.components.DownloadListView;
import xdman.ui.components.MediaDownloaderWnd;
import xdman.ui.components.MessageBox;
import xdman.ui.components.PropertiesPage;
import xdman.ui.components.RefreshUrlPage;
import xdman.ui.components.SettingsPage;
import xdman.ui.components.SidePanel;
import xdman.ui.components.UpdateNotifyPanel;
import xdman.ui.components.XDMFrame;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.FFmpegDownloader;
import xdman.util.Logger;
import xdman.util.XDMUtils;

public class MainWindow
extends XDMFrame
implements ActionListener {
    private static final long serialVersionUID = -3119522563540700138L;
    CustomButton[] btnTabArr;
    CustomButton btnSort;
    JTextField txtSearch;
    JMenuItem[] sortItems;
    String[][] sortStatusText;
    JLabel[] lblCatArr;
    SidePanel sp;
    DownloadListView lv;
    JPopupMenu popupCtx;
    JMenu startQMenu;
    JMenu stopQMenu;
    JMenu convertMenu;
    Container warningPanel;
    JPanel toolbar;
    UpdateNotifyPanel updateNotifyPanel;

    public MainWindow() {
        this.setTitle(StringResource.get("WINDOW_TITLE"));
        this.setWindowSizeAndPosition();
        this.initWindow();
        if (Config.getInstance().isFirstRun()) {
            SettingsPage.getInstance().showPanel(this, "BTN_MONITORING");
        }
        this.showNotification();
    }

    @Override
    protected void registerTitlePanel(JPanel panel) {
        this.showTwitterIcon = true;
        this.showFBIcon = true;
        this.fbUrl = "https://www.facebook.com/XDM.subhra74/";
        this.twitterUrl = "https://twitter.com/XDM_subhra74";
        super.registerTitlePanel(panel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Config config = Config.getInstance();
        if (e.getSource() instanceof JComponent) {
            String name = ((JComponent)e.getSource()).getName();
            if (name == null) {
                return;
            }
            if (name.startsWith("STOP")) {
                this.stopQueue(name);
            } else if (name.equals("OPT_UPDATE_FFMPEG")) {
                if (this.warningPanel != null) {
                    this.warningPanel.setVisible(false);
                }
                this.updateFFmpeg();
            } else if (name.startsWith("OPT_CONVERT")) {
                this.convert();
            } else if (name.startsWith("START")) {
                this.startQueue(name);
            } else if ("ADD_URL".equals(name) || "MENU_ADD_URL".equals(name)) {
                XDMApp.getInstance().addDownload(null, null);
            } else if ("ALL_DOWNLOADS".equals(name)) {
                this.tabClicked(e);
                config.setStateFilter(0);
                this.filter();
            } else if ("ALL_UNFINISHED".equals(name)) {
                this.tabClicked(e);
                config.setStateFilter(150);
                this.filter();
            } else if ("ALL_FINISHED".equals(name)) {
                this.tabClicked(e);
                config.setStateFilter(100);
                this.filter();
            } else if ("PAUSE".equals(name) || "MENU_PAUSE".equals(name)) {
                this.pauseDownloads();
            } else if ("CTX_COPY_URL".equals(name)) {
                String[] ids = this.lv.getSelectedIds();
                if (ids.length > 0) {
                    String id = ids[0];
                    XDMUtils.copyURL(XDMApp.getInstance().getURL(id));
                }
            } else if ("MENU_RESTART".equals(name)) {
                String[] ids = this.lv.getSelectedIds();
                int i = 0;
                while (i < ids.length) {
                    XDMApp.getInstance().restartDownload(ids[i]);
                    ++i;
                }
            } else if ("RESUME".equals(name) || "MENU_RESUME".equals(name)) {
                String[] ids = this.lv.getSelectedIds();
                int i = 0;
                while (i < ids.length) {
                    XDMApp.getInstance().resumeDownload(ids[i], true);
                    ++i;
                }
            } else if ("CTX_OPEN_FILE".equals(name)) {
                this.openFile();
            } else if ("CTX_OPEN_FOLDER".equals(name)) {
                String[] ids = this.lv.getSelectedIds();
                if (ids.length > 0) {
                    String id = ids[0];
                    this.openFolder(id);
                }
            } else if ("MENU_EXIT".equals(name)) {
                XDMApp.getInstance().exit();
            } else if ("0".equals(name)) {
                config.setSortField(0);
                this.filter();
            } else if ("1".equals(name)) {
                config.setSortField(1);
                this.filter();
            } else if ("2".equals(name)) {
                config.setSortField(2);
                this.filter();
            } else if ("3".equals(name)) {
                config.setSortField(3);
                this.filter();
            } else if ("4".equals(name)) {
                config.setSortAsc(true);
                this.filter();
            } else if ("5".equals(name)) {
                config.setSortAsc(false);
                this.filter();
            } else if ("BTN_SEARCH".equals(name)) {
                config.setSearchText(this.txtSearch.getText());
                this.filter();
            } else if ("CAT_DOCUMENTS".equals(name)) {
                config.setCategoryFilter(10);
                this.updateSidePanel((JLabel)e.getSource());
            } else if ("CAT_COMPRESSED".equals(name)) {
                config.setCategoryFilter(50);
                this.updateSidePanel((JLabel)e.getSource());
            } else if ("CAT_MUSIC".equals(name)) {
                config.setCategoryFilter(40);
                this.updateSidePanel((JLabel)e.getSource());
            } else if ("CAT_PROGRAMS".equals(name)) {
                config.setCategoryFilter(20);
                this.updateSidePanel((JLabel)e.getSource());
            } else if ("CAT_VIDEOS".equals(name)) {
                config.setCategoryFilter(30);
                this.updateSidePanel((JLabel)e.getSource());
            } else if ("CAT_ALL".equals(name)) {
                config.setCategoryFilter(0);
                this.updateSidePanel((JLabel)e.getSource());
            } else if ("MENU_CLIP_ADD".equals(name)) {
                int ret = MessageBox.show(this, "sample title", "sample textdgdfgdfgdfghdfh gfhsdgh gfgfh dfgdfqwewrqwerwerqwerqwerwerwqerqwerqwerqwerwerwegfterj jgh ker gwekl hwgklerhg ek hrkjlwhlk kj hgeklgh jkle herklj gheklwerjgh sample textdgdfgdfgdfghdfh gfhsdgh gfgfh dfgdfqwewrqwerwerqwerqwerwerwqerqwerqwerqwerwerwegfterj jgh ker gwekl hwgklerhg ek hrkjlwhlk kj hgeklgh jkle herklj gheklwerjgh", 10, 10);
                System.out.println("After: " + ret);
            } else if ("MENU_OPTIONS".equals(name) || "OPTIONS".equals(name)) {
                SettingsPage.getInstance().showPanel(this, "PG_SETTINGS");
            } else if ("MENU_REFRESH_LINK".equals(name)) {
                this.openRefreshPage();
            } else if ("MENU_PROPERTIES".equals(name)) {
                this.showProperties();
            } else if ("MENU_BROWSER_INT".equals(name)) {
                SettingsPage.getInstance().showPanel(this, "BTN_MONITORING");
            } else if ("MENU_SPEED_LIMITER".equals(name)) {
                SettingsPage.getInstance().showPanel(this, "BTN_NETWORK");
            } else if ("DESC_Q_TITLE".equals(name)) {
                SettingsPage.getInstance().showPanel(this, "Q_MAN");
            } else if ("MENU_MEDIA_CONVERTER".equals(name)) {
                this.convert();
            } else if ("MENU_DELETE_DWN".equals(name) || "DELETE".equals(name)) {
                if (MessageBox.show(this, StringResource.get("DEL_TITLE"), StringResource.get("DEL_SEL_TEXT"), 20, 20, StringResource.get("LBL_DELETE_FILE")) == 20) {
                    String[] ids = this.lv.getSelectedIds();
                    ArrayList<String> idList = new ArrayList<String>();
                    int i = 0;
                    while (i < ids.length) {
                        idList.add(ids[i]);
                        ++i;
                    }
                    XDMApp.getInstance().deleteDownloads(idList, MessageBox.isChecked());
                }
            } else if ("MENU_DELETE_COMPLETED".equals(name)) {
                if (MessageBox.show(this, StringResource.get("DEL_TITLE"), StringResource.get("DEL_FINISHED_TEXT"), 20, 20) == 20) {
                    XDMApp.getInstance().deleteCompleted();
                }
            } else if ("MENU_ABOUT".equals(name)) {
                AboutPage aboutPage = new AboutPage(this);
                aboutPage.showPanel();
            } else if ("CTX_SAVE_AS".equals(name)) {
                String[] ids = this.lv.getSelectedIds();
                if (ids.length > 0) {
                    String id = ids[0];
                    this.changeFile(id);
                }
            } else if ("MENU_VIDEO_DWN".equals(name)) {
                this.showVideoDwnDlg();
            } else if ("MENU_IMPORT".equals(name)) {
                JFileChooser jfc = new JFileChooser();
                if (jfc.showOpenDialog(this) == 0) {
                    File file = jfc.getSelectedFile();
                    XDMApp.getInstance().loadDownloadList(file);
                }
            } else if ("MENU_EXPORT".equals(name)) {
                JFileChooser jfc = new JFileChooser();
                if (jfc.showSaveDialog(this) == 0) {
                    File file = jfc.getSelectedFile();
                    XDMApp.getInstance().saveDownloadList(file);
                }
            } else if ("MENU_CONTENTS".equals(name)) {
                XDMUtils.browseURL("http://xdman.sourceforge.net/#help");
            } else if ("MENU_HOME_PAGE".equals(name)) {
                XDMUtils.browseURL("http://xdman.sourceforge.net/");
            } else if ("MENU_UPDATE".equals(name)) {
                XDMUtils.browseURL("http://xdman.sourceforge.net/update/update.php?ver=7.1.2");
            } else if ("MENU_LANG".equals(name)) {
                this.showLanguageDlg();
            } else if ("MENU_BATCH_DOWNLOAD".equals(name)) {
                this.showBatchDialog();
            } else if ("DWN_PREVIEW".equals(name)) {
                String[] ids = this.lv.getSelectedIds();
                if (ids == null || ids.length < 1) {
                    return;
                }
                DownloadEntry ent = XDMApp.getInstance().getEntry(ids[0]);
                if (ent == null) {
                    return;
                }
                if (ent.getState() != 100) {
                    XDMApp.getInstance().openPreview(ent.getId());
                }
            } else if ("LBL_OPTIMIZE_NETWORK".equals(name)) {
                this.optimizeRWin();
            } else if ("LBL_TRANSLATE".equals(name)) {
                this.openTranslationPage();
            } else if ("LBL_SUPPORT_PAGE".equals(name)) {
                this.openSupportPage();
            } else if ("LBL_REPORT_PROBLEM".equals(name)) {
                this.openBugReportPage();
            }
        }
    }

    private void updateSidePanel(JLabel lbl) {
        int i = 0;
        while (i < this.lblCatArr.length) {
            if (lbl == this.lblCatArr[i]) {
                this.lblCatArr[i].setBackground(ColorResource.getActiveTabColor());
                this.lblCatArr[i].setOpaque(true);
            } else {
                this.lblCatArr[i].setOpaque(false);
            }
            ++i;
        }
        this.lv.refresh();
        this.sp.repaint();
    }

    private void filter() {
        this.lv.refresh();
        this.updateSortMenu();
        this.btnSort.setText(this.sortStatusText[Config.getInstance().getSortField()][Config.getInstance().getSortAsc() ? 1 : 0]);
    }

    private JPanel createToolbar() {
        JPanel p = new JPanel(new BorderLayout());
        Box toolBox = Box.createHorizontalBox();
        toolBox.add(Box.createRigidArea(new Dimension(20, 60)));
        toolBox.setBackground(ColorResource.getTitleColor());
        toolBox.setOpaque(true);
        JButton btn1 = this.createToolButton("ADD_URL", "tool_add.png");
        btn1.setToolTipText(StringResource.get("MENU_ADD_URL"));
        toolBox.add(btn1);
        toolBox.add(Box.createRigidArea(new Dimension(10, 10)));
        JButton btn2 = this.createToolButton("DELETE", "tool_del.png");
        btn2.setToolTipText(StringResource.get("MENU_DELETE_DWN"));
        toolBox.add(btn2);
        toolBox.add(Box.createRigidArea(new Dimension(10, 10)));
        JButton btn3 = this.createToolButton("PAUSE", "tool_pause.png");
        btn3.setToolTipText(StringResource.get("MENU_PAUSE"));
        toolBox.add(btn3);
        toolBox.add(Box.createRigidArea(new Dimension(10, 10)));
        JButton btn4 = this.createToolButton("RESUME", "tool_resume.png");
        btn4.setToolTipText(StringResource.get("MENU_RESUME"));
        toolBox.add(btn4);
        toolBox.add(Box.createRigidArea(new Dimension(10, 10)));
        JButton btn5 = this.createToolButton("OPTIONS", "tool_settings.png");
        btn5.setToolTipText(StringResource.get("TITLE_SETTINGS"));
        toolBox.add(btn5);
        toolBox.add(Box.createRigidArea(new Dimension(10, 10)));
        JButton btn6 = this.createToolButton("MENU_VIDEO_DWN", "add_video32.png");
        btn6.setToolTipText(StringResource.get("MENU_VIDEO_DWN"));
        toolBox.add(btn6);
        toolBox.add(Box.createRigidArea(new Dimension(10, 10)));
        JButton btn7 = this.createToolButton("MENU_MEDIA_CONVERTER", "convert.png");
        btn7.setToolTipText(StringResource.get("MENU_MEDIA_CONVERTER"));
        toolBox.add(btn7);
        toolBox.add(Box.createHorizontalGlue());
        JLabel btnMonitoring = new JLabel(ImageResource.get("on.png"));
        btnMonitoring.setIconTextGap(15);
        btnMonitoring.putClientProperty("xdmbutton.norollover", "true");
        btnMonitoring.setName("BROWSER_MONITORING");
        btnMonitoring.setText(StringResource.get("BROWSER_MONITORING"));
        btnMonitoring.setHorizontalTextPosition(10);
        btnMonitoring.setFont(FontResource.getBigFont());
        btnMonitoring.setIcon(Config.getInstance().isBrowserMonitoringEnabled() ? ImageResource.get("on.png") : ImageResource.get("off.png"));
        btnMonitoring.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                MainWindow.this.toggleMonitoring((JLabel)e.getSource());
            }
        });
        toolBox.add(btnMonitoring);
        toolBox.add(Box.createRigidArea(new Dimension(25, 10)));
        p.add(toolBox);
        return p;
    }

    private JButton createToolButton(String name, String icon) {
        CustomButton btn = new CustomButton(ImageResource.get(icon));
        btn.setPressedBackground(ColorResource.getDarkPressedColor());
        btn.setRolloverBackground(Color.DARK_GRAY);
        btn.setBorderPainted(false);
        btn.addActionListener(this);
        btn.setName(name);
        btn.setBackground(ColorResource.getTitleColor());
        btn.setMargin(new Insets(0, 0, 0, 0));
        return btn;
    }

    private SidePanel createSidePanel() {
        this.sp = new SidePanel();
        this.sp.setLayout(null);
        this.sp.setPreferredSize(new Dimension(150, 250));
        this.lblCatArr = new JLabel[6];
        this.lblCatArr[0] = this.createCategoryLabel("CAT_ALL");
        this.lblCatArr[1] = this.createCategoryLabel("CAT_DOCUMENTS");
        this.lblCatArr[2] = this.createCategoryLabel("CAT_COMPRESSED");
        this.lblCatArr[3] = this.createCategoryLabel("CAT_MUSIC");
        this.lblCatArr[4] = this.createCategoryLabel("CAT_VIDEOS");
        this.lblCatArr[5] = this.createCategoryLabel("CAT_PROGRAMS");
        this.lblCatArr[0].setBackground(ColorResource.getActiveTabColor());
        this.lblCatArr[0].setOpaque(true);
        int i = 0;
        while (i < 6) {
            this.lblCatArr[i].setBounds(0, 20 + i * 35, 149, 27);
            final int c = i;
            this.lblCatArr[i].addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    MainWindow.this.actionPerformed(new ActionEvent(MainWindow.this.lblCatArr[c], 0, ""));
                }
            });
            this.sp.add(this.lblCatArr[i]);
            ++i;
        }
        return this.sp;
    }

    private void toggleMonitoring(JLabel btn) {
        Config.getInstance().enableMonitoring(!Config.getInstance().isBrowserMonitoringEnabled());
        btn.setIcon(Config.getInstance().isBrowserMonitoringEnabled() ? ImageResource.get("on.png") : ImageResource.get("off.png"));
    }

    private void createMainMenu() {
        JMenuBar bar = new JMenuBar();
        bar.setBorderPainted(false);
        bar.setForeground(ColorResource.getWhite());
        bar.setMaximumSize(new Dimension(bar.getMaximumSize().width, 30));
        bar.setBackground(ColorResource.getTitleColor());
        JMenu file = this.createMenu(StringResource.get("MENU_FILE"));
        this.addMenuItem("MENU_ADD_URL", file);
        this.addMenuItem("MENU_VIDEO_DWN", file);
        this.addMenuItem("MENU_BATCH_DOWNLOAD", file);
        this.addMenuItem("MENU_DELETE_DWN", file);
        this.addMenuItem("MENU_DELETE_COMPLETED", file);
        this.addMenuItem("MENU_EXPORT", file);
        this.addMenuItem("MENU_IMPORT", file);
        this.addMenuItem("MENU_EXIT", file);
        JMenu dwn = this.createMenu(StringResource.get("MENU_DOWNLOAD"));
        this.addMenuItem("MENU_PAUSE", dwn);
        this.addMenuItem("MENU_RESUME", dwn);
        this.addMenuItem("MENU_RESTART", dwn);
        this.addMenuItem("DESC_Q_TITLE", dwn);
        PopupMenuListener popupListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                MainWindow.this.loadQueueMenu(MainWindow.this.startQMenu);
                MainWindow.this.loadQueueMenu(MainWindow.this.stopQMenu);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
        this.startQMenu = this.addSubMenu("MENU_START_Q", dwn, popupListener);
        this.stopQMenu = this.addSubMenu("MENU_STOP_Q", dwn, popupListener);
        JMenu tools = this.createMenu(StringResource.get("MENU_TOOLS"));
        this.addMenuItem("MENU_OPTIONS", tools);
        this.addMenuItem("MENU_REFRESH_LINK", tools);
        this.addMenuItem("MENU_PROPERTIES", tools);
        this.addMenuItem("MENU_SPEED_LIMITER", tools);
        this.addMenuItem("MENU_LANG", tools);
        this.addMenuItem("MENU_MEDIA_CONVERTER", tools);
        this.addMenuItem("LBL_OPTIMIZE_NETWORK", tools);
        this.addMenuItem("MENU_BROWSER_INT", tools);
        JMenu help = this.createMenu(StringResource.get("MENU_HELP"));
        this.addMenuItem("MENU_CONTENTS", help);
        this.addMenuItem("MENU_HOME_PAGE", help);
        this.addMenuItem("LBL_SUPPORT_PAGE", help);
        this.addMenuItem("LBL_REPORT_PROBLEM", help);
        this.addMenuItem("LBL_TRANSLATE", help);
        this.addMenuItem("MENU_UPDATE", help);
        this.addMenuItem("OPT_UPDATE_FFMPEG", help);
        this.addMenuItem("MENU_ABOUT", help);
        bar.add(file);
        bar.add(dwn);
        bar.add(tools);
        bar.add(help);
        Box menuBox = Box.createHorizontalBox();
        menuBox.add(Box.createHorizontalGlue());
        menuBox.add(bar);
        menuBox.add(Box.createHorizontalStrut(30));
        this.getTitlePanel().add(menuBox);
    }

    private JMenu createMenu(String title) {
        JMenu menu = new JMenu(title);
        menu.setFont(FontResource.getBoldFont());
        menu.setBorderPainted(false);
        menu.setBorder(new EmptyBorder(5, 5, 5, 5));
        return menu;
    }

    private void addMenuItem(String id, JComponent menu) {
        JMenuItem mitem = new JMenuItem(StringResource.get(id));
        mitem.setName(id);
        mitem.setFont(FontResource.getNormalFont());
        mitem.addActionListener(this);
        menu.add(mitem);
    }

    private JMenu addSubMenu(String id, JMenu parentMenu, PopupMenuListener popupListener) {
        JMenu menu = new JMenu(StringResource.get(id));
        menu.setName(id);
        menu.setFont(FontResource.getNormalFont());
        menu.addActionListener(this);
        menu.setBorderPainted(false);
        menu.getPopupMenu().addPopupMenuListener(popupListener);
        parentMenu.add(menu);
        return menu;
    }

    private JLabel createCategoryLabel(String name) {
        JLabel lblCat = new JLabel(StringResource.get(name));
        lblCat.setName(name);
        lblCat.setFont(FontResource.getBigFont());
        lblCat.setForeground(Color.BLACK);
        lblCat.setBorder(new EmptyBorder(5, 20, 5, 5));
        return lblCat;
    }

    private Component createSearchPane() {
        this.btnSort = new CustomButton("Newest on top");
        this.btnSort.setBackground(ColorResource.getActiveTabColor());
        this.btnSort.setBorderPainted(false);
        this.btnSort.setFocusPainted(false);
        this.btnSort.setContentAreaFilled(false);
        this.btnSort.setFont(FontResource.getNormalFont());
        this.txtSearch = new JTextField();
        this.txtSearch.setBackground(Color.WHITE);
        this.txtSearch.setForeground(Color.BLACK);
        this.txtSearch.setBorder(null);
        this.txtSearch.setName("BTN_SEARCH");
        this.txtSearch.addActionListener(this);
        CustomButton btnSearch = new CustomButton();
        btnSearch.setName("BTN_SEARCH");
        btnSearch.setRolloverBackground(Color.WHITE);
        btnSearch.setPressedBackground(Color.WHITE);
        btnSearch.addActionListener(this);
        btnSearch.setPreferredSize(new Dimension(20, 20));
        btnSearch.setBackground(Color.WHITE);
        btnSearch.setIcon(ImageResource.get("search16.png"));
        btnSearch.setBorderPainted(false);
        btnSearch.setFocusPainted(false);
        this.txtSearch.addActionListener(this);
        Box b = Box.createHorizontalBox();
        b.setOpaque(true);
        b.setBackground(Color.WHITE);
        b.setPreferredSize(new Dimension(130, 20));
        b.setMaximumSize(new Dimension(130, 20));
        this.txtSearch.setPreferredSize(new Dimension(70, 20));
        this.txtSearch.setMaximumSize(new Dimension(this.txtSearch.getMaximumSize().width, 20));
        b.add(this.txtSearch);
        b.add(btnSearch);
        b.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        Box bp = Box.createHorizontalBox();
        bp.setOpaque(false);
        bp.setBorder(new EmptyBorder(3, 3, 3, 10));
        bp.add(Box.createHorizontalGlue());
        bp.add(this.btnSort);
        bp.add(Box.createHorizontalStrut(10));
        bp.add(b);
        bp.add(Box.createHorizontalStrut(10));
        this.sortItems = new JMenuItem[6];
        this.sortItems[0] = new JMenuItem(StringResource.get("SORT_DATE"));
        this.sortItems[0].setName("0");
        this.sortItems[1] = new JMenuItem(StringResource.get("SORT_SIZE"));
        this.sortItems[1].setName("1");
        this.sortItems[2] = new JMenuItem(StringResource.get("SORT_NAME"));
        this.sortItems[2].setName("2");
        this.sortItems[3] = new JMenuItem(StringResource.get("SORT_TYPE"));
        this.sortItems[3].setName("3");
        this.sortItems[4] = new JMenuItem(StringResource.get("SORT_ASC"));
        this.sortItems[4].setName("4");
        this.sortItems[5] = new JMenuItem(StringResource.get("SORT_DESC"));
        this.sortItems[5].setName("5");
        final JPopupMenu popSort = new JPopupMenu();
        int i = 0;
        while (i < this.sortItems.length) {
            popSort.add(this.sortItems[i]);
            if (i > 3) {
                this.sortItems[i].putClientProperty("bgColor", ColorResource.getDarkBgColor());
            }
            this.sortItems[i].addActionListener(this);
            ++i;
        }
        this.updateSortMenu();
        popSort.setInvoker(this.btnSort);
        this.btnSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popSort.show(MainWindow.this.btnSort, 0, MainWindow.this.btnSort.getHeight());
            }
        });
        return bp;
    }

    private void updateSortMenu() {
        int i = 0;
        while (i < this.sortItems.length) {
            if (i >= 0 && i <= 3) {
                if (i == Config.getInstance().getSortField()) {
                    this.sortItems[i].setFont(FontResource.getBoldFont());
                    this.sortItems[i].setForeground(ColorResource.getLightFontColor());
                } else {
                    this.sortItems[i].setFont(FontResource.getNormalFont());
                    this.sortItems[i].setForeground(ColorResource.getDeepFontColor());
                }
            }
            ++i;
        }
        this.sortItems[4].setFont(Config.getInstance().getSortAsc() ? FontResource.getBoldFont() : FontResource.getNormalFont());
        this.sortItems[4].setForeground(Config.getInstance().getSortAsc() ? ColorResource.getLightFontColor() : ColorResource.getDeepFontColor());
        this.sortItems[5].setFont(!Config.getInstance().getSortAsc() ? FontResource.getBoldFont() : FontResource.getNormalFont());
        this.sortItems[5].setForeground(!Config.getInstance().getSortAsc() ? ColorResource.getLightFontColor() : ColorResource.getDeepFontColor());
    }

    private void createTabs() {
        CustomButton btnAllTab = new CustomButton(StringResource.get("ALL_DOWNLOADS"));
        CustomButton btnIncompleteTab = new CustomButton(StringResource.get("ALL_UNFINISHED"));
        CustomButton btnCompletedTab = new CustomButton(StringResource.get("ALL_FINISHED"));
        this.btnTabArr = new CustomButton[3];
        this.btnTabArr[0] = btnAllTab;
        this.btnTabArr[0].setName("ALL_DOWNLOADS");
        this.btnTabArr[1] = btnIncompleteTab;
        this.btnTabArr[1].setName("ALL_UNFINISHED");
        this.btnTabArr[2] = btnCompletedTab;
        this.btnTabArr[2].setName("ALL_FINISHED");
        int i = 0;
        while (i < 3) {
            this.btnTabArr[i].setFont(FontResource.getBigBoldFont());
            this.btnTabArr[i].setBorderPainted(false);
            this.btnTabArr[i].setFocusPainted(false);
            this.btnTabArr[i].addActionListener(this);
            ++i;
        }
        btnAllTab.setBackground(ColorResource.getActiveTabColor());
        btnAllTab.setForeground(ColorResource.getDarkBgColor());
        btnIncompleteTab.setBackground(ColorResource.getTitleColor());
        btnIncompleteTab.setForeground(ColorResource.getDeepFontColor());
        btnCompletedTab.setBackground(ColorResource.getTitleColor());
        btnCompletedTab.setForeground(ColorResource.getDeepFontColor());
        JPanel pp = new JPanel(new BorderLayout());
        pp.setOpaque(false);
        JPanel p = new JPanel(new GridLayout(1, 3, 5, 0));
        p.setOpaque(false);
        Dimension d = new Dimension(380, 30);
        p.setPreferredSize(d);
        p.setMaximumSize(d);
        p.setMinimumSize(d);
        p.setBackground(Color.WHITE);
        p.add(btnAllTab);
        p.add(btnIncompleteTab);
        p.add(btnCompletedTab);
        pp.add((Component)p, "East");
        this.getTitlePanel().add((Component)pp, "South");
    }

    private void tabClicked(ActionEvent e) {
        int i = 0;
        while (i < 3) {
            if (this.btnTabArr[i] == e.getSource()) {
                this.btnTabArr[i].setBackground(ColorResource.getActiveTabColor());
                this.btnTabArr[i].setForeground(ColorResource.getDarkBgColor());
            } else {
                this.btnTabArr[i].setBackground(ColorResource.getTitleColor());
                this.btnTabArr[i].setForeground(ColorResource.getDeepFontColor());
            }
            ++i;
        }
    }

    private void initWindow() {
        this.setIconImage(ImageResource.get("icon.png").getImage());
        JLabel lblTitle = new JLabel(StringResource.get("WINDOW_TITLE"));
        lblTitle.setBorder(new EmptyBorder(20, 20, 0, 0));
        lblTitle.setFont(FontResource.getBiggestFont());
        lblTitle.setForeground(ColorResource.getWhite());
        this.getTitlePanel().add((Component)lblTitle, "West");
        this.createTabs();
        this.createMainMenu();
        BarPanel bp = new BarPanel();
        bp.setLayout(new BorderLayout());
        bp.add(Box.createRigidArea(new Dimension(0, 30)));
        bp.add(this.createSearchPane(), "East");
        JPanel panCenter = new JPanel(new BorderLayout());
        panCenter.setBackground(Color.WHITE);
        panCenter.add((Component)bp, "North");
        JPanel pClient = new JPanel(new BorderLayout());
        pClient.add(panCenter);
        pClient.add((Component)this.createSidePanel(), "West");
        this.toolbar = this.createToolbar();
        pClient.add((Component)this.toolbar, "South");
        this.add(pClient);
        this.sortStatusText = new String[4][2];
        this.sortStatusText[0][0] = StringResource.get("SORT_DATE_DESC");
        this.sortStatusText[0][1] = StringResource.get("SORT_DATE_ASC");
        this.sortStatusText[1][0] = StringResource.get("SORT_SIZE_DESC");
        this.sortStatusText[1][1] = StringResource.get("SORT_SIZE_ASC");
        this.sortStatusText[2][0] = StringResource.get("SORT_NAME_DESC");
        this.sortStatusText[2][1] = StringResource.get("SORT_NAME_ASC");
        this.sortStatusText[3][0] = StringResource.get("SORT_TYPE_DESC");
        this.sortStatusText[3][1] = StringResource.get("SORT_TYPE_ASC");
        this.setMenuActionListener(this);
        this.lv = new DownloadListView(panCenter);
        this.filter();
        this.createPopupMenu();
        ToolTipManager.sharedInstance().setInitialDelay(500);
    }

    private void setWindowSizeAndPosition() {
        if (Config.getInstance().getWidth() < 0 || Config.getInstance().getHeight() < 0) {
            this.setSize(750, 450);
        }
        if (Config.getInstance().getX() < 0 || Config.getInstance().getY() < 0) {
            this.setLocationRelativeTo(null);
        }
    }

    private void stopQueue(String name) {
        DownloadQueue q;
        String queueId = "";
        String[] arr = name.split(":");
        if (arr.length > 1) {
            queueId = arr[1].trim();
        }
        if ((q = XDMApp.getInstance().getQueueById(queueId)) != null) {
            q.stop();
        }
    }

    private void startQueue(String name) {
        DownloadQueue q;
        String queueId = "";
        String[] arr = name.split(":");
        if (arr.length > 1) {
            queueId = arr[1].trim();
        }
        if ((q = XDMApp.getInstance().getQueueById(queueId)) != null) {
            q.start();
        }
    }

    private void loadQueueMenu(JMenu menu) {
        if (menu.getName().equals("MENU_START_Q")) {
            this.loadStartQueueMenu(menu);
        } else if (menu.getName().equals("MENU_STOP_Q")) {
            this.loadStopQueueMenu(menu);
        }
    }

    private void loadStopQueueMenu(JMenu menu) {
        menu.removeAll();
        ArrayList<DownloadQueue> queues = XDMApp.getInstance().getQueueList();
        int i = 0;
        while (i < queues.size()) {
            DownloadQueue q = queues.get(i);
            if (q.isRunning()) {
                JMenuItem mitem = new JMenuItem(q.getName());
                mitem.setForeground(ColorResource.getLightFontColor());
                mitem.setName("STOP:" + q.getQueueId());
                mitem.addActionListener(this);
                menu.add(mitem);
            }
            ++i;
        }
    }

    private void loadStartQueueMenu(JMenu menu) {
        menu.removeAll();
        ArrayList<DownloadQueue> queues = XDMApp.getInstance().getQueueList();
        int i = 0;
        while (i < queues.size()) {
            DownloadQueue q = queues.get(i);
            if (!q.isRunning()) {
                JMenuItem mitem = new JMenuItem(q.getName());
                mitem.setForeground(ColorResource.getLightFontColor());
                mitem.setName("START:" + q.getQueueId());
                mitem.addActionListener(this);
                menu.add(mitem);
            }
            ++i;
        }
    }

    private void createPopupMenu() {
        this.popupCtx = new JPopupMenu();
        this.addMenuItem("CTX_OPEN_FILE", this.popupCtx);
        this.addMenuItem("CTX_OPEN_FOLDER", this.popupCtx);
        this.addMenuItem("CTX_SAVE_AS", this.popupCtx);
        this.addMenuItem("MENU_PAUSE", this.popupCtx);
        this.addMenuItem("MENU_RESUME", this.popupCtx);
        this.addMenuItem("MENU_DELETE_DWN", this.popupCtx);
        this.addMenuItem("MENU_REFRESH_LINK", this.popupCtx);
        this.addMenuItem("DWN_PREVIEW", this.popupCtx);
        this.addMenuItem("CTX_COPY_URL", this.popupCtx);
        this.addMenuItem("CTX_COPY_FILE", this.popupCtx);
        this.addMenuItem("OPT_CONVERT", this.popupCtx);
        this.addMenuItem("MENU_PROPERTIES", this.popupCtx);
        this.popupCtx.setInvoker(this.lv.getTable());
        this.lv.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    System.out.println("Opening file");
                    MainWindow.this.openFile();
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (me.getButton() == 3 || SwingUtilities.isRightMouseButton(me) || me.isPopupTrigger() || XDMUtils.isMacPopupTrigger(me)) {
                    int row;
                    Point p = me.getPoint();
                    JTable tbl = MainWindow.this.lv.getTable();
                    if (tbl.getRowCount() < 1) {
                        return;
                    }
                    if (tbl.getSelectedRow() < 0 && (row = tbl.rowAtPoint(p)) >= 0) {
                        tbl.setRowSelectionInterval(row, row);
                    }
                    if (tbl.getSelectedRows().length > 0) {
                        MainWindow.this.popupCtx.show(MainWindow.this.lv.getTable(), me.getX(), me.getY());
                    }
                }
            }
        });
    }

    private void showProperties() {
        String[] ids = this.lv.getSelectedIds();
        if (ids.length > 0) {
            String id = ids[0];
            DownloadEntry ent = XDMApp.getInstance().getEntry(id);
            if (id != null) {
                PropertiesPage propPage = PropertiesPage.getPage(this);
                HttpMetadata md = HttpMetadata.load(id);
                HeaderCollection headers = md.getHeaders();
                String referer = "";
                StringBuilder cookies = new StringBuilder();
                Iterator<HttpHeader> cookieIt = headers.getAll();
                while (cookieIt.hasNext()) {
                    HttpHeader header = cookieIt.next();
                    if ("referer".equalsIgnoreCase(header.getName())) {
                        referer = header.getValue();
                    }
                    if (!"cookie".equalsIgnoreCase(header.getName())) continue;
                    cookies.append(String.valueOf(header.getValue()) + "\n");
                }
                String type = "HTTP";
                if (md instanceof DashMetadata) {
                    type = "DASH";
                } else if (md instanceof HlsMetadata) {
                    type = "HLS";
                } else if (md instanceof HdsMetadata) {
                    type = "HDS";
                }
                propPage.setDetails(ent.getFile(), XDMApp.getInstance().getFolder(ent), ent.getSize(), md.getUrl(), referer, ent.getDateStr(), cookies.toString(), type);
                propPage.showPanel();
            }
        }
    }

    public void openRefreshPage() {
        String[] ids = this.lv.getSelectedIds();
        if (ids.length > 0) {
            String id = ids[0];
            DownloadEntry ent = XDMApp.getInstance().getEntry(id);
            if (ent == null) {
                return;
            }
            if (ent.getState() != 130 && ent.getState() != 140) {
                return;
            }
            try {
                HttpMetadata md = HttpMetadata.load(id);
                RefreshUrlPage rp = RefreshUrlPage.getPage(this);
                rp.setDetails(md);
                rp.showPanel();
            }
            catch (Exception e2) {
                Logger.log(e2);
            }
        }
    }

    public void openFile(String id) {
        DownloadEntry ent = XDMApp.getInstance().getEntry(id);
        if (ent != null && ent.getState() == 100) {
            try {
                XDMUtils.openFile(ent.getFile(), XDMApp.getInstance().getFolder(ent));
            }
            catch (FileNotFoundException e) {
                Logger.log(e);
                MessageBox.show(this, StringResource.get("ERR_MSG_FILE_NOT_FOUND"), StringResource.get("ERR_MSG_FILE_NOT_FOUND_MSG"), 10, 10);
            }
            catch (Exception e) {
                Logger.log(e);
            }
        }
    }

    public void openFolder(String id) {
        DownloadEntry ent = XDMApp.getInstance().getEntry(id);
        if (ent != null && ent.getState() == 100) {
            try {
                XDMUtils.openFolder(ent.getFile(), XDMApp.getInstance().getFolder(ent));
            }
            catch (FileNotFoundException e) {
                Logger.log(e);
                MessageBox.show(this, StringResource.get("ERR_MSG_FILE_NOT_FOUND"), StringResource.get("ERR_MSG_FILE_NOT_FOUND_MSG"), 10, 10);
            }
            catch (Exception e) {
                Logger.log(e);
            }
        }
    }

    private void showConversionWindow(String[] ids) {
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            File f;
            String id = stringArray[n2];
            DownloadEntry ent = XDMApp.getInstance().getEntry(id);
            if (ent != null && ent.getState() == 100 && (f = new File(XDMApp.getInstance().getFolder(ent), ent.getFile())).exists()) {
                list.add(f.getAbsolutePath());
            }
            ++n2;
        }
        if (list.size() > 0) {
            ConversionWindow cw = new ConversionWindow(list);
            cw.setVisible(true);
            cw.load();
        }
    }

    private void convert() {
        try {
            String[] ids = this.lv.getSelectedIds();
            if (ids.length > 0) {
                this.showConversionWindow(ids);
                return;
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    private void updateFFmpeg() {
        FFmpegDownloader fd = new FFmpegDownloader();
        fd.start();
    }

    private void changeFile(String id) {
        DownloadEntry ent = XDMApp.getInstance().getEntry(id);
        if (ent == null) {
            return;
        }
        if (ent.getState() == 100) {
            return;
        }
        JFileChooser jfc = new JFileChooser();
        jfc.setSelectedFile(new File(XDMApp.getInstance().getOutputFolder(id), XDMApp.getInstance().getOutputFile(id, false)));
        if (jfc.showSaveDialog(this) == 0) {
            File f = jfc.getSelectedFile();
            ent.setFolder(f.getParent());
            ent.setFile(f.getName());
        }
    }

    private void showVideoDwnDlg() {
        MediaDownloaderWnd wnd = new MediaDownloaderWnd();
        wnd.setVisible(true);
    }

    private void showLanguageDlg() {
        Properties langMap;
        block20: {
            langMap = new Properties();
            InputStream in = null;
            try {
                try {
                    in = StringResource.class.getResourceAsStream("/lang/map");
                    if (in == null) {
                        in = new FileInputStream("lang/map");
                    }
                    langMap.load(new InputStreamReader(in, Charset.forName("utf-8")));
                }
                catch (Exception e) {
                    Logger.log(e);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        int index = 0;
        ArrayList<String> keyList = new ArrayList<String>(langMap.stringPropertyNames());
        Vector<String> valList = new Vector<String>();
        int i = 0;
        while (i < keyList.size()) {
            String name = keyList.get(i);
            String val = langMap.getProperty(name);
            valList.add(val);
            if (name.equals(Config.getInstance().getLanguage())) {
                index = i;
            }
            ++i;
        }
        JComboBox cmbLang = new JComboBox(valList);
        cmbLang.setSelectedIndex(index);
        String prompt = StringResource.get("MSG_LANG1");
        Object[] obj = new Object[]{prompt, cmbLang, StringResource.get("MSG_LANG2")};
        if (JOptionPane.showOptionDialog(null, obj, StringResource.get("MSG_LANG1"), 2, -1, null, null, null) == 0) {
            String lang;
            index = cmbLang.getSelectedIndex();
            if (index != -1) {
                Config.getInstance().setLanguage(keyList.get(index));
            }
            if ((lang = langMap.getProperty("" + cmbLang.getSelectedItem())) != null) {
                Config.getInstance().setLanguage(lang);
            }
        }
    }

    public void showNotification() {
        int mode = XDMApp.getInstance().getNotification();
        if (mode == -1) {
            this.clearNotification();
            return;
        }
        if (this.updateNotifyPanel == null) {
            this.updateNotifyPanel = new UpdateNotifyPanel();
            this.toolbar.add((Component)this.updateNotifyPanel, "South");
        }
        this.updateNotifyPanel.setDetails(mode);
        this.revalidate();
        this.repaint();
    }

    private void clearNotification() {
        if (this.updateNotifyPanel == null) {
            return;
        }
        this.updateNotifyPanel.setVisible(false);
        this.toolbar.remove(this.updateNotifyPanel);
        this.updateNotifyPanel = null;
        this.invalidate();
        this.repaint();
    }

    private void pauseDownloads() {
        DownloadQueue q;
        String qid2;
        String[] ids = this.lv.getSelectedIds();
        HashSet<String> queues = new HashSet<String>();
        int i = 0;
        while (i < ids.length) {
            DownloadEntry ent = XDMApp.getInstance().getEntry(ids[i]);
            qid2 = ent.getQueueId();
            queues.add(qid2);
            ++i;
        }
        Iterator qit = queues.iterator();
        boolean qRunning = false;
        while (qit.hasNext()) {
            qid2 = (String)qit.next();
            if (qid2 == null || (q = XDMApp.getInstance().getQueueById(qid2)) == null || !q.isRunning()) continue;
            qRunning = true;
            break;
        }
        if (qRunning && MessageBox.show(this, StringResource.get("MSG_REF_LINK_CONFIRM"), StringResource.get("LBL_STOP_Q"), 20, 20) == 20) {
            for (String qid2 : queues) {
                if (qid2 == null || (q = XDMApp.getInstance().getQueueById(qid2)) == null || !q.isRunning()) continue;
                q.stop();
            }
        } else {
            int i2 = 0;
            while (i2 < ids.length) {
                XDMApp.getInstance().pauseDownload(ids[i2]);
                ++i2;
            }
        }
    }

    private void openFile() {
        String[] ids = this.lv.getSelectedIds();
        if (ids.length > 0) {
            String id = ids[0];
            this.openFile(id);
        }
    }

    private void showBatchDialog() {
        List<String> urlList = BatchClipboardWnd.getUrls();
        if (urlList.size() > 0) {
            new BatchClipboardWnd(urlList).setVisible(true);
        } else {
            MessageBox.show(this, StringResource.get("MENU_BATCH_DOWNLOAD"), StringResource.get("LBL_BATCH_EMPTY_CLIPBOARD"), 10, 10);
        }
    }

    private void optimizeRWin() {
        int index;
        JComboBox<String> cmbLang = new JComboBox<String>(new String[]{StringResource.get("LBL_NET_OPT_DEF"), StringResource.get("LBL_NET_OPT_64"), StringResource.get("LBL_NET_OPT_128"), StringResource.get("LBL_NET_OPT_256")});
        cmbLang.setSelectedIndex(0);
        String prompt = StringResource.get("LBL_NET_OPT_MSG");
        Object[] obj = new Object[]{prompt, cmbLang};
        switch (Config.getInstance().getTcpWindowSize()) {
            case 64: {
                cmbLang.setSelectedIndex(1);
                break;
            }
            case 128: {
                cmbLang.setSelectedIndex(2);
                break;
            }
            case 256: {
                cmbLang.setSelectedIndex(3);
                break;
            }
            default: {
                cmbLang.setSelectedIndex(0);
            }
        }
        if (JOptionPane.showOptionDialog(null, obj, StringResource.get("LBL_OPTIMIZE_NETWORK"), 2, -1, null, null, null) == 0 && (index = cmbLang.getSelectedIndex()) != -1) {
            switch (index) {
                case 1: {
                    Config.getInstance().setTcpWindowSize(64);
                    break;
                }
                case 2: {
                    Config.getInstance().setTcpWindowSize(128);
                    break;
                }
                case 3: {
                    Config.getInstance().setTcpWindowSize(256);
                    break;
                }
                default: {
                    Config.getInstance().setTcpWindowSize(0);
                }
            }
        }
    }

    private void openTranslationPage() {
        XDMUtils.browseURL("https://sourceforge.net/p/xdman/discussion/translate/");
    }

    private void openSupportPage() {
        XDMUtils.browseURL("https://sourceforge.net/p/xdman/discussion/xdmhelp/");
    }

    private void openBugReportPage() {
        XDMUtils.browseURL("https://sourceforge.net/p/xdman/discussion/xdmbug/");
    }
}

