/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import xdman.ui.res.StringResource;
import xdman.util.XDMUtils;

public class PopupAdapter
extends MouseAdapter
implements ActionListener {
    private JTextField txt;
    private JPopupMenu popup;
    private static PopupAdapter adapter;

    public static void registerTxtPopup(JTextField txt) {
        if (adapter == null) {
            adapter = new PopupAdapter();
            adapter.init();
        }
        txt.addMouseListener(adapter);
    }

    private void init() {
        this.popup = new JPopupMenu();
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                PopupAdapter.this.txt = null;
                System.out.println("set to null");
            }
        });
        JMenuItem menuCut = new JMenuItem(StringResource.get("CTX_CUT"));
        menuCut.addActionListener(this);
        menuCut.setName("MENU_CUT");
        JMenuItem menuCopy = new JMenuItem(StringResource.get("CTX_COPY"));
        menuCopy.addActionListener(this);
        menuCopy.setName("MENU_COPY");
        JMenuItem menuSelect = new JMenuItem(StringResource.get("CTX_SELECT_ALL"));
        menuSelect.addActionListener(this);
        menuSelect.setName("MENU_SELECT_ALL");
        JMenuItem menuPaste = new JMenuItem(StringResource.get("CTX_PASTE"));
        menuPaste.setName("MENU_PASTE");
        menuPaste.addActionListener(this);
        this.popup.add(menuCut);
        this.popup.add(menuCopy);
        this.popup.add(menuSelect);
        this.popup.add(menuPaste);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if ((e.getButton() == 3 || SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger() || XDMUtils.isMacPopupTrigger(e)) && e.getSource() instanceof JTextField) {
            this.txt = (JTextField)e.getSource();
            this.popup.show(this.txt, e.getX(), e.getY());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.txt == null) {
            return;
        }
        System.out.println(this.txt);
        String name = ((JComponent)e.getSource()).getName();
        if ("MENU_CUT".equals(name)) {
            this.txt.cut();
        } else if ("MENU_COPY".equals(name)) {
            this.txt.copy();
        } else if ("MENU_SELECT_ALL".equals(name)) {
            this.txt.selectAll();
        } else if ("MENU_PASTE".equals(name)) {
            this.txt.paste();
        }
        System.out.println("set to null");
        this.txt = null;
    }
}

