/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import xdman.ui.components.MediaImageSource;
import xdman.ui.components.VideoItemWrapper;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.videoparser.YdlResponse;

public class VideoItemRenderer
implements TableCellRenderer {
    private JPanel panel;
    private JPanel component = new JPanel(new BorderLayout(5, 5));
    private JLabel lbl;
    private JLabel lblIcon;
    private JComboBox<String> cmb;
    private DefaultComboBoxModel<String> cmbModel;
    private JLabel lblBorder;
    private JCheckBox chk;
    private MediaImageSource imgSource;
    private ImageIcon ico;

    public VideoItemRenderer(MediaImageSource imgSource) {
        this.component.setBorder(new EmptyBorder(0, 5, 5, 5));
        this.panel = new JPanel(new BorderLayout());
        this.lblIcon = new JLabel();
        this.lblIcon.setOpaque(true);
        this.lblIcon.setPreferredSize(new Dimension(64, 64));
        this.lblIcon.setMinimumSize(new Dimension(64, 64));
        this.lblIcon.setMaximumSize(new Dimension(64, 64));
        this.lblIcon.setHorizontalAlignment(0);
        this.ico = ImageResource.get("video.png");
        this.lblIcon.setIcon(this.ico);
        this.lblIcon.setVerticalAlignment(0);
        JPanel p1 = new JPanel(new BorderLayout());
        p1.setOpaque(false);
        p1.add(this.lblIcon);
        this.chk = new JCheckBox("");
        this.chk.setOpaque(false);
        this.chk.setIcon(ImageResource.get("unchecked.png"));
        this.chk.setSelectedIcon(ImageResource.get("checked.png"));
        p1.add((Component)this.chk, "West");
        p1.setBorder(new EmptyBorder(12, 5, 5, 5));
        this.component.add((Component)p1, "West");
        this.lbl = new JLabel();
        this.lbl.setFont(FontResource.getBigFont());
        this.panel.add(this.lbl);
        this.cmbModel = new DefaultComboBoxModel();
        this.cmb = new JComboBox<String>(this.cmbModel);
        this.cmb.setPreferredSize(new Dimension(200, 20));
        this.cmb.setOpaque(false);
        this.cmb.setBorder(null);
        this.panel.add(this.cmb, "South");
        this.panel.setOpaque(false);
        this.panel.setBorder(new EmptyBorder(5, 0, 7, 5));
        this.component.add(this.panel);
        this.lblBorder = new JLabel();
        this.lblBorder.setPreferredSize(new Dimension(100, 1));
        this.lblBorder.setMaximumSize(new Dimension(100, 1));
        this.lblBorder.setBackground(ColorResource.getDarkerBgColor());
        this.component.add((Component)this.lblBorder, "North");
        this.component.setOpaque(false);
        this.imgSource = imgSource;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        VideoItemWrapper wrapper = (VideoItemWrapper)value;
        YdlResponse.YdlVideo obj = wrapper.videoItem;
        this.lbl.setText(obj.title);
        this.cmbModel.removeAllElements();
        this.cmbModel.addElement("" + obj.mediaFormats.get(obj.index));
        if (row == 0) {
            this.lblBorder.setOpaque(false);
        } else {
            this.lblBorder.setOpaque(true);
        }
        this.lblIcon.setIcon(this.ico);
        this.chk.setSelected(wrapper.checked);
        if (obj.thumbnail != null && this.imgSource != null) {
            ImageIcon icon = this.imgSource.getImage(obj.thumbnail);
            if (icon != null) {
                this.lblIcon.setIcon(icon);
            } else {
                System.out.println("null");
            }
        }
        return this.component;
    }
}

