/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import xdman.Config;
import xdman.XDMApp;
import xdman.downloaders.metadata.DashMetadata;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.ui.components.CustomButton;
import xdman.ui.components.DarkScrollBar;
import xdman.ui.components.SimpleListRenderer;
import xdman.ui.components.TitlePanel;
import xdman.ui.components.VideoPopupItem;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.Logger;
import xdman.util.StringUtils;
import xdman.util.XDMUtils;

public class VideoPopup
extends JDialog
implements ActionListener,
Comparator<VideoPopupItem> {
    private static VideoPopup _this;
    private int initialY;
    private boolean expanded;
    private JPanel bottomPanel;
    private JPanel panel;
    private JButton closePopupBtn;
    private JPanel itemPanel;
    private boolean upward = false;
    private DefaultListModel<VideoPopupItem> videoItems;
    private ArrayList<VideoPopupItem> itemList = new ArrayList();
    private JList<VideoPopupItem> itemListBox;
    private int mHoveredJListIndex = -1;
    private int menuCount = 0;
    private Box menuBox;

    public static VideoPopup getInstance() {
        if (_this == null) {
            _this = new VideoPopup();
        }
        return _this;
    }

    public static boolean hasInstance() {
        return _this != null;
    }

    public synchronized void addVideo(HttpMetadata metadata, String file, String info) {
        VideoPopupItem item = new VideoPopupItem();
        item.setMetadata(metadata);
        item.setInfo(info);
        item.setFile(file);
        item.setTimestamp(System.currentTimeMillis());
        if (this.addItem(item)) {
            CustomButton cb = new CustomButton();
            cb.setHorizontalAlignment(2);
            cb.setHorizontalTextPosition(2);
            cb.setMargin(new Insets(0, 0, 0, 0));
            cb.setForeground(Color.WHITE);
            cb.setName(metadata.getId());
            cb.setText(item.toString());
            cb.setBackground(ColorResource.getDarkestBgColor());
            cb.setBorderPainted(false);
            cb.setFocusPainted(false);
            cb.setPreferredSize(new Dimension(250, 30));
            cb.setMinimumSize(new Dimension(250, 30));
            cb.setMaximumSize(new Dimension(250, 30));
            cb.addActionListener(this);
            this.menuBox.add((Component)cb, 0);
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private void arrangeList() {
        this.videoItems.clear();
        ArrayList<VideoPopupItem> itemsCopy = new ArrayList<VideoPopupItem>();
        itemsCopy.addAll(this.itemList);
        Collections.sort(itemsCopy, this);
        for (VideoPopupItem item : itemsCopy) {
            this.videoItems.addElement(item);
        }
    }

    private VideoPopup() {
        this.videoItems = new DefaultListModel();
        this.init();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Insets scnMax = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        this.setLocation(d.width - this.getWidth() - 50, d.height - scnMax.bottom - this.getHeight() - 30);
    }

    private void init() {
        try {
            this.setUndecorated(true);
            this.setSize(250, 40);
            this.setIconImage(ImageResource.get("icon.png").getImage());
            this.setFocusableWindowState(false);
            this.setType(Window.Type.UTILITY);
            this.setAlwaysOnTop(true);
            try {
                if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT) && !Config.getInstance().isNoTransparency()) {
                    this.setOpacity(0.85f);
                }
            }
            catch (Exception e) {
                Logger.log(e);
            }
            this.panel = new JPanel(new BorderLayout());
            this.panel.setBackground(ColorResource.getDarkestBgColor());
            this.add(this.panel);
            this.bottomPanel = new TitlePanel((LayoutManager)new BorderLayout(), this);
            this.bottomPanel.setBorder(new EmptyBorder(0, 20, 0, 0));
            this.bottomPanel.setOpaque(true);
            this.bottomPanel.setBackground(ColorResource.getDarkerBgColor());
            this.panel.add(this.bottomPanel);
            CustomButton closeBtn = new CustomButton();
            closeBtn.setPreferredSize(new Dimension(30, 40));
            closeBtn.setMinimumSize(new Dimension(30, 40));
            closeBtn.setBackground(ColorResource.getDarkerBgColor());
            closeBtn.setBorderPainted(false);
            closeBtn.setFocusPainted(false);
            closeBtn.setName("CLOSE");
            closeBtn.setIcon(ImageResource.get("close_btn.png"));
            closeBtn.setMargin(new Insets(0, 0, 0, 0));
            closeBtn.addActionListener(this);
            this.bottomPanel.add((Component)closeBtn, "East");
            CustomButton popupBtn = new CustomButton();
            popupBtn.setBackground(ColorResource.getDarkerBgColor());
            popupBtn.setFont(FontResource.getItemFont());
            popupBtn.setPreferredSize(new Dimension(200, 40));
            popupBtn.setMinimumSize(new Dimension(200, 40));
            popupBtn.setBorderPainted(false);
            popupBtn.setForeground(Color.WHITE);
            popupBtn.setText("DOWNLOAD VIDEO");
            popupBtn.setFocusPainted(false);
            popupBtn.setName("EXPAND");
            popupBtn.addActionListener(this);
            this.bottomPanel.add(popupBtn);
            this.itemPanel = new JPanel(new BorderLayout());
            this.itemPanel.setOpaque(false);
            this.itemListBox = new JList<VideoPopupItem>(this.videoItems);
            this.itemListBox.setOpaque(false);
            this.itemListBox.setCellRenderer(new SimpleListRenderer());
            this.itemListBox.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent me) {
                    Point p = new Point(me.getX(), me.getY());
                    int index = VideoPopup.this.itemListBox.locationToIndex(p);
                    if (index != VideoPopup.this.mHoveredJListIndex) {
                        VideoPopup.this.mHoveredJListIndex = index;
                        if (VideoPopup.this.mHoveredJListIndex != -1) {
                            VideoPopup.this.itemListBox.setSelectedIndex(VideoPopup.this.mHoveredJListIndex);
                        } else {
                            VideoPopup.this.itemListBox.clearSelection();
                        }
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    VideoPopup.this.itemListBox.clearSelection();
                    VideoPopup.this.itemListBox.repaint();
                }
            });
            JScrollPane jsp = new JScrollPane();
            jsp.setOpaque(false);
            jsp.setBorder(null);
            jsp.getViewport().setOpaque(false);
            DarkScrollBar scrollBar = new DarkScrollBar(1);
            jsp.setVerticalScrollBar(scrollBar);
            jsp.setHorizontalScrollBarPolicy(31);
            jsp.getVerticalScrollBar().setUnitIncrement(10);
            jsp.getVerticalScrollBar().setBlockIncrement(25);
            this.menuBox = Box.createVerticalBox();
            this.menuBox.add(Box.createVerticalGlue());
            jsp.setViewportView(this.menuBox);
            this.itemPanel.add(jsp);
            CustomButton btn = new CustomButton();
            btn.setText(StringResource.get("LBL_MORE_FORMAT"));
            btn.setName("MORE_FORMAT");
            btn.addActionListener(this);
            btn.setMargin(new Insets(0, 0, 0, 0));
            btn.setForeground(Color.WHITE);
            btn.setBackground(ColorResource.getDarkestBgColor());
            btn.setBorderPainted(false);
            btn.setFocusPainted(false);
            this.itemPanel.add((Component)btn, "South");
            this.closePopupBtn = new CustomButton();
            this.closePopupBtn.setBackground(ColorResource.getDarkerBgColor());
            this.closePopupBtn.setBorderPainted(false);
            this.closePopupBtn.setFocusPainted(false);
            this.closePopupBtn.setName("COLAPSE");
            this.closePopupBtn.addActionListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String name = ((JComponent)e.getSource()).getName();
        for (VideoPopupItem item : this.itemList) {
            if (!name.equals(item.getMetadata().getId())) continue;
            this.collapse();
            HttpMetadata md = item.getMetadata().derive();
            Logger.log("dash metdata ? " + (md instanceof DashMetadata));
            XDMApp.getInstance().addVideo(md, item.getFile());
        }
        if (name.equals("CLOSE")) {
            this.collapse();
            this.menuBox.removeAll();
            this.itemList.clear();
            this.dispose();
            _this = null;
        } else if (name.equals("COLAPSE")) {
            this.collapse();
        } else if (name.equals("EXPAND")) {
            if (!this.expanded) {
                this.expand();
            } else {
                this.collapse();
            }
        } else if (name.equals("MORE_FORMAT")) {
            JOptionPane.showMessageDialog(null, StringResource.get("LBL_FORMAT_HINT"));
        }
    }

    private void expand() {
        this.initialY = this.getLocationOnScreen().y;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int preferedExpandedHeight = 400;
        Insets scnMax = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        int bottomTaskbarHeight = scnMax.bottom;
        int topTaskbarHeight = scnMax.top;
        this.upward = this.initialY > (screenHeight - (bottomTaskbarHeight + topTaskbarHeight)) / 2;
        this.arrangeList();
        this.panel.remove(this.bottomPanel);
        this.panel.add(this.itemPanel);
        if (this.upward) {
            if (this.getY() - topTaskbarHeight < preferedExpandedHeight) {
                preferedExpandedHeight = this.getY() - topTaskbarHeight;
            }
            this.setLocation(this.getX(), this.initialY - preferedExpandedHeight + this.getHeight());
            this.panel.add((Component)this.bottomPanel, "South");
            this.itemPanel.add((Component)this.closePopupBtn, "North");
            this.closePopupBtn.setIcon(ImageResource.get("down_arrow.png"));
        } else {
            if (screenHeight - this.getY() - bottomTaskbarHeight < preferedExpandedHeight) {
                preferedExpandedHeight = screenHeight - this.getY() - bottomTaskbarHeight;
            }
            this.panel.add((Component)this.bottomPanel, "North");
            this.itemPanel.add((Component)this.closePopupBtn, "South");
            this.closePopupBtn.setIcon(ImageResource.get("up_arrow.png"));
        }
        this.setSize(this.getWidth(), preferedExpandedHeight);
        this.revalidate();
        this.repaint();
        this.expanded = true;
    }

    private void collapse() {
        this.panel.remove(this.bottomPanel);
        this.panel.remove(this.itemPanel);
        int height = this.getHeight();
        int locationY = this.getY() + height - 40;
        this.setSize(this.getWidth(), 40);
        if (this.upward) {
            this.setLocation(this.getX(), locationY);
        }
        this.panel.add(this.bottomPanel);
        this.revalidate();
        this.repaint();
        this.expanded = false;
        this.upward = false;
        Logger.log("Closed");
    }

    @Override
    public int compare(VideoPopupItem item1, VideoPopupItem item2) {
        int ret = 0;
        if (item1.getTimestamp() > item2.getTimestamp()) {
            ret = 1;
        } else if (item1.getTimestamp() < item2.getTimestamp()) {
            ret = 1;
        }
        return this.upward ? ret : -ret;
    }

    private boolean addItem(VideoPopupItem item) {
        if (item.getMetadata() == null) {
            return false;
        }
        int i = 0;
        while (i < this.itemList.size()) {
            VideoPopupItem p = this.itemList.get(i);
            HttpMetadata m1 = item.getMetadata();
            HttpMetadata m2 = p.getMetadata();
            if (m1.getType() == m2.getType() && m1.getUrl().equals(m2.getUrl())) {
                if (m1 instanceof DashMetadata) {
                    DashMetadata dm1 = (DashMetadata)m1;
                    DashMetadata dm2 = (DashMetadata)m2;
                    if (dm1.getUrl2().equals(dm2.getUrl2())) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            ++i;
        }
        this.itemList.add(item);
        return true;
    }

    public void updateYoutubeTitle(String url, String title) {
        if (title == null) {
            return;
        }
        String[] arr = this.getIdAndLen(url);
        String id = arr[0];
        String len = arr[1];
        int i = 0;
        while (i < this.itemList.size()) {
            DashMetadata dm1;
            VideoPopupItem p = this.itemList.get(i);
            HttpMetadata m2 = p.getMetadata();
            if (m2 instanceof DashMetadata && (this.isSameURL((dm1 = (DashMetadata)m2).getUrl(), id, len) || this.isSameURL(dm1.getUrl2(), id, len))) {
                Logger.log("Updating title: " + title);
                this.updateFileName(title, p);
                this.updateButtonTitle(m2.getId(), p.toString());
            }
            ++i;
        }
    }

    private void updateFileName(String file, VideoPopupItem p) {
        String oldFile = p.getFile();
        String ext = XDMUtils.getExtension(oldFile);
        p.setFile(String.valueOf(file) + (StringUtils.isNullOrEmptyOrBlank(ext) ? "" : ext));
        Logger.log("renaming: " + oldFile + " to: " + file);
    }

    private void updateButtonTitle(String id, String title) {
        int i = 0;
        while (i < this.menuBox.getComponentCount()) {
            JButton jc;
            Component c = this.menuBox.getComponent(i);
            if (c instanceof JButton && id.equals((jc = (JButton)c).getName())) {
                jc.setText(title);
                return;
            }
            ++i;
        }
    }

    private String[] getIdAndLen(String url) {
        int index = url.indexOf("?");
        String query = url.substring(index + 1);
        String[] arr = query.split("&");
        String clen = null;
        String id = null;
        int i = 0;
        while (i < arr.length) {
            String str = arr[i];
            index = str.indexOf("=");
            if (index > 0) {
                String key = str.substring(0, index).trim();
                String val = str.substring(index + 1).trim();
                if (!key.startsWith("range")) {
                    if (key.equals("clen")) {
                        clen = val;
                    }
                    if (str.startsWith("id")) {
                        id = val;
                    }
                }
            }
            ++i;
        }
        return new String[]{id, clen};
    }

    private boolean isSameURL(String url, String id, String clen) {
        try {
            if (url != null) {
                return url.contains(id) && url.contains(clen);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

