/*
 * Decompiled with CFR 0.152.
 */
package xdman.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import xdman.DownloadEntry;
import xdman.DownloadQueue;
import xdman.QueueManager;
import xdman.ui.res.StringResource;

public class FormatUtilities {
    private static SimpleDateFormat _format;
    private static final int MB = 0x100000;
    private static final int KB = 1024;

    public static String formatDate(long date) {
        if (_format == null) {
            _format = new SimpleDateFormat("yyyy-MM-dd");
        }
        Date dt = new Date(date);
        return _format.format(dt);
    }

    public static String formatSize(double length) {
        if (length < 0.0) {
            return "---";
        }
        if (length > 1048576.0) {
            return String.format("%.1f MB", Float.valueOf((float)length / 1048576.0f));
        }
        if (length > 1024.0) {
            return String.format("%.1f KB", Float.valueOf((float)length / 1024.0f));
        }
        return String.format("%d B", (int)length);
    }

    public static String getFormattedStatus(DownloadEntry ent) {
        String statStr = "";
        if (ent.getQueueId() != null) {
            DownloadQueue q = QueueManager.getInstance().getQueueById(ent.getQueueId());
            String qname = "";
            if (q != null && q.getQueueId() != null) {
                qname = q.getQueueId().length() > 0 ? "[ " + q.getName() + " ] " : "";
            }
            statStr = String.valueOf(statStr) + qname;
        }
        statStr = ent.getState() == 100 ? String.valueOf(statStr) + StringResource.get("STAT_FINISHED") : (ent.getState() == 130 || ent.getState() == 140 ? String.valueOf(statStr) + StringResource.get("STAT_PAUSED") : (ent.getState() == 910 ? String.valueOf(statStr) + StringResource.get("STAT_ASSEMBLING") : String.valueOf(statStr) + StringResource.get("STAT_DOWNLOADING")));
        String sizeStr = FormatUtilities.formatSize(ent.getSize());
        if (ent.getState() == 100) {
            return String.valueOf(statStr) + " " + sizeStr;
        }
        if (ent.getSize() > 0L) {
            String downloadedStr = FormatUtilities.formatSize(ent.getDownloaded());
            String progressStr = String.valueOf(ent.getProgress()) + "%";
            return String.valueOf(statStr) + " " + progressStr + " [ " + downloadedStr + " / " + sizeStr + " ]";
        }
        return String.valueOf(statStr) + (ent.getProgress() > 0 ? " " + ent.getProgress() + "%" : "") + (ent.getDownloaded() > 0L ? " " + FormatUtilities.formatSize(ent.getDownloaded()) : (ent.getState() == 130 || ent.getState() == 140 ? "" : " ..."));
    }

    public static String getETA(double length, float rate) {
        if (length == 0.0) {
            return "00:00:00";
        }
        if (length < 1.0 || rate <= 0.0f) {
            return "---";
        }
        int sec = (int)(length / (double)rate);
        return FormatUtilities.hms(sec);
    }

    public static String hms(int sec) {
        int hrs = 0;
        int min = 0;
        hrs = sec / 3600;
        min = sec % 3600 / 60;
        String str = String.format("%02d:%02d:%02d", hrs, min, sec %= 60);
        return str;
    }
}

