/*
 * Decompiled with CFR 0.152.
 */
package xdman.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import xdman.util.Logger;
import xdman.util.XDMUtils;

public class MacUtils {
    public static void open(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException();
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command("open", f.getAbsolutePath());
            if (pb.start().waitFor() != 0) {
                throw new FileNotFoundException();
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static void openFolder(String folder, String file) throws FileNotFoundException {
        if (file == null) {
            MacUtils.openFolder2(folder);
            return;
        }
        File f = new File(folder, file);
        if (!f.exists()) {
            throw new FileNotFoundException();
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            Logger.log("Opening folder: " + f.getAbsolutePath());
            pb.command("open", "-R", f.getAbsolutePath());
            if (pb.start().waitFor() != 0) {
                throw new FileNotFoundException();
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    private static void openFolder2(String folder) {
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            ArrayList<String> lst = new ArrayList<String>();
            lst.add("open");
            lst.add(folder);
            builder.command(lst);
            builder.start();
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static boolean launchApp(String app, String args) {
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command("open", "-n", "-a", app, "--args", args);
            if (pb.start().waitFor() != 0) {
                throw new FileNotFoundException();
            }
            return true;
        }
        catch (Exception e) {
            Logger.log(e);
            return false;
        }
    }

    public static void keepAwakePing() {
        try {
            Runtime.getRuntime().exec("caffeinate -i -t 3");
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static void addToStartup() {
        File f;
        block14: {
            File dir = new File(System.getProperty("user.home"), "Library/LaunchAgents");
            dir.mkdirs();
            f = new File(dir, "org.sdg.xdman.plist");
            FileOutputStream fs = null;
            try {
                try {
                    fs = new FileOutputStream(f);
                    fs.write(MacUtils.getStartupPlist().getBytes());
                }
                catch (Exception e) {
                    Logger.log(e);
                    try {
                        if (fs != null) {
                            fs.close();
                        }
                        break block14;
                    }
                    catch (Exception exception) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fs != null) {
                        fs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        f.setExecutable(true);
    }

    public static boolean isAlreadyAutoStart() {
        File f = new File(System.getProperty("user.home"), "Library/LaunchAgents/org.sdg.xdman.plist");
        if (!f.exists()) {
            return false;
        }
        FileInputStream in = null;
        byte[] buf = new byte[(int)f.length()];
        try {
            in = new FileInputStream(f);
            if ((long)in.read(buf) != f.length()) {
                return false;
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        String str = new String(buf);
        String s1 = MacUtils.getProperPath(System.getProperty("java.home"));
        String s2 = XDMUtils.getJarFile().getAbsolutePath();
        return str.contains(s1) && str.contains(s2);
    }

    public static void removeFromStartup() {
        File f = new File(System.getProperty("user.home"), "Library/LaunchAgents/org.sdg.xdman.plist");
        f.delete();
    }

    public static String getStartupPlist() {
        String str = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\"\r\n\"http://www.apple.com/DTDs/PropertyList-1.0.dtd\" >\r\n<plist version=\"1.0\">\r\n\t<dict>\r\n\t\t<key>Label</key>\r\n\t\t<string>org.sdg.xdman</string>\r\n\t\t<key>ProgramArguments</key>\r\n\t\t<array>\r\n\t\t\t<string>%sbin/java</string>\r\n\t\t\t<string>-Xmx1024m</string>\r\n\t\t\t<string>-Xdock:name=XDM</string>\r\n\t\t\t<string>-jar</string>\r\n\t\t\t<!-- MODIFY THIS TO POINT TO YOUR EXECUTABLE JAR FILE -->\r\n\t\t\t<string>%s</string>\r\n\t\t\t<string>-m</string>\r\n\t\t</array>\r\n\t\t<key>OnDemand</key>\r\n\t\t<true />\r\n\t\t<key>RunAtLoad</key>\r\n\t\t<true />\r\n\t\t<key>KeepAlive</key>\r\n\t\t<false />\r\n\t</dict>\r\n</plist>";
        String s1 = MacUtils.getProperPath(System.getProperty("java.home"));
        String s2 = XDMUtils.getJarFile().getAbsolutePath();
        return String.format(str, s1, s2);
    }

    private static String getProperPath(String path) {
        if (path.endsWith("/")) {
            return path;
        }
        return String.valueOf(path) + "/";
    }

    public static void browseURL(String url) {
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command("open", url);
            pb.start();
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }
}

