#include <linux/init.h>
#include <linux/io.h>
#include <linux/platform_device.h>
#include <linux/leds.h>

#include <mach-ms104sh4ag/mach/ms104sh4ag.h>

static struct ms104sh4ag_led {
	struct led_classdev cdev;
	u8 mask;
} ms104sh4ag_leds[] = {
	{.cdev = {.name = "led0"}, .mask = 1 << 0},
	{.cdev = {.name = "led1"}, .mask = 1 << 1}
};

static void ms104sh4ag_led_set(struct led_classdev *led_cdev,
			       enum led_brightness value) 
{
	struct ms104sh4ag_led *p = 
		container_of(led_cdev, struct ms104sh4ag_led, cdev);

	if (value)
		outb(inb(CPLD0) | p->mask, CPLD0);
	else
		outb(inb(CPLD0) & ~p->mask, CPLD0);
}

static int ms104sh4ag_led_probe(struct platform_device *pdev)
{
	int i, ret;

	for (i = 0; i < ARRAY_SIZE(ms104sh4ag_leds); i++) {
		struct led_classdev *led_cdev = &ms104sh4ag_leds[i].cdev;

		led_cdev->brightness_set = ms104sh4ag_led_set; 
		if ((ret = led_classdev_register(&pdev->dev, led_cdev)))
			break;
	}

	if (ret) {
		while (i--)
			led_classdev_unregister(&ms104sh4ag_leds[i].cdev);
	}

	return ret;
}

static int ms104sh4ag_led_init(void)
{
	struct platform_device *pdev;

	pdev = platform_device_register_simple("ms104sh4ag-led", -1, NULL, 0);
	if (IS_ERR(pdev))
		return PTR_ERR(pdev);
	return ms104sh4ag_led_probe(pdev);
//	return platform_driver_probe(&ms104sh4ag_led_driver, ms104sh4ag_led_probe);
}

device_initcall(ms104sh4ag_led_init);
