#include <linux/init.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/platform_device.h>
#include <linux/kthread.h>
#include <linux/spi/spi.h>
#include <linux/spi/mmc_spi.h>
#include <linux/mmc/host.h>
#include <asm/spi.h>
#include <linux/i2c.h>
#include <linux/i2c/tsc2007.h>
#include <linux/delay.h>
#include <linux/rtc.h>
#include <linux/fb.h>
//#include <linux/gpio.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/partitions.h>
#include <linux/mtd/physmap.h>
#include <linux/mtd/map.h>
#include <linux/ata_platform.h>
#include <asm/sizes.h>
#include <asm/sh_eth.h>
#include <asm/io.h>
#include <asm/io_trapped.h>
#include <asm/rtc.h>
#include <asm/clock.h>
#include <asm/i2c-sh7764.h>
#include <asm/sh7760fb.h>

#include <mach-ms104sh4ag/mach/ms104sh4ag.h>

#define SD_CS 0x01
#define SD_CD 0x02
#define SD_WP 0x04

static struct resource ms104sh4ag_ide0_resources[] = {
	[0] = {
		.start          = 0xFFF00000,
		.end            = 0xFFF000C0 - 1,
		.flags          = IORESOURCE_MEM,
	},
	[1] = {
		.start          = ATAPI_IRQ,
		.end            = ATAPI_IRQ,
		.flags          = IORESOURCE_IRQ,
	}
};

static struct mtd_partition ms104sh4ag_partitions[] = {
	{
		.name =         "U-boot",
		.size =         0x00080000,
		.offset =       0,
		.mask_flags =   0,
	}, {
		.name =         "U-boot env",
		.size =         0x00020000,
		.offset =       MTDPART_OFS_APPEND,
	}, {
		.name =         "U-boot splash",
		.size =         0x00060000,
		.offset =       MTDPART_OFS_APPEND,
	}, {
		.name =         "Kernel",
		.size =         0x00400000,
		.offset =       MTDPART_OFS_APPEND,
	}, {
		.name =         "Userland",
		.size =         MTDPART_SIZ_FULL,
		.offset =       MTDPART_OFS_APPEND,
	}
};

static struct physmap_flash_data ms104sh4ag_flash_data = {
	.width		= 2,
	.nr_parts	= ARRAY_SIZE(ms104sh4ag_partitions),
	.parts		= ms104sh4ag_partitions
};

static struct resource ms104sh4ag_flash_resource = {
	.flags	= IORESOURCE_MEM,
	.start	= 0x00000000,
        .end	= 0x01000000 - 1
};

static struct platform_device ms104sh4ag_flash_device = {
	.name		= "physmap-flash",
	.id		= 0,
	.dev		= {
		.platform_data	= &ms104sh4ag_flash_data,
	},
	.num_resources	= 1,
	.resource	= &ms104sh4ag_flash_resource,
};

static u64 ide0_dmamask = ~(u32)0;

static struct platform_device ms104sh4ag_ide0_device = {
	.name		= "ms104sh4ag-ide",
	.id		= 0,
	.dev		= {
		.dma_mask		= &ide0_dmamask,
		.coherent_dma_mask	= 0xffffffff,
	},
	.num_resources = ARRAY_SIZE(ms104sh4ag_ide0_resources),
	.resource	= ms104sh4ag_ide0_resources,
};

static struct sh_eth_plat_data sh_eth_pdata = {
	.phy = 1,
	.edmac_endian = EDMAC_LITTLE_ENDIAN,
};

static struct resource sh_eth_resources[] = {
	{
		.start  = 0xfef00000,
		.end    = 0xfef001fc - 1,
		.flags  = IORESOURCE_MEM,
	}, {
		.start  = 57,   /* irq number */
		.end    = 57,
		.flags  = IORESOURCE_IRQ,
	},
};

static struct platform_device sh_eth_device = {
	.name		= "sh-eth",
	.id		= 0,
	.num_resources	= ARRAY_SIZE(sh_eth_resources),
	.resource	= sh_eth_resources,
	.dev = {
		.platform_data = &sh_eth_pdata,
	},
};

static struct resource r8a66597_usb_host_resources[] = {
	[0] = {
		.name	= "r8a66597_hcd",
		.start	= 0xfe400000,
		.end	= 0xfe400000 + 0x100 - 1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.name	= "r8a66597_hcd",
		.start	= 83,
		.end	= 83,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device r8a66597_usb_host_device = {
	.name		= "r8a66597_hcd",
	.id		= 0,
	.dev = {
		.dma_mask		= NULL,
		.coherent_dma_mask	= 0xffffffff,
	},
	.num_resources	= ARRAY_SIZE(r8a66597_usb_host_resources),
	.resource	= r8a66597_usb_host_resources,
};
#if 0
static struct resource m66597_hcd_resources[] = {
	[0] = {
		.start  = 0xFE400000,
		.end    = 0xFE4FFFFF,
		.flags  = IORESOURCE_MEM,
	},
	[1] = {
		.start  = 83,
		.end    = 83,
		.flags  = IORESOURCE_IRQ,
	},
};

static struct platform_device m66597_hcd_device = {
	.name           = "m66597-hcd",
	.id             = 0,
	.num_resources  = ARRAY_SIZE(m66597_hcd_resources),
	.resource       = m66597_hcd_resources,
};
#endif
static void sd_cs(struct sh_spi_info *spi, int cs, int state)
{
//	pr_info("%s: cs=%d state=%d\n", __func__, cs, state);
	BUG_ON(cs != 0);
//	ctrl_outw(state == BITBANG_CS_ACTIVE, PA_RTCCE);
	if (state)
		ctrl_outb(ctrl_inb(CPLD2) | SD_CS, CPLD2);
	else
		ctrl_outb(ctrl_inb(CPLD2) & ~SD_CS, CPLD2);
}

static struct sh_spi_info spi_info = {
	.bus_num = 0,
	.num_chipselect = 1,
	.chip_select = sd_cs,
};

static struct resource spi_sh_sci_resources[] = {
	{
		.start = 0xFFE10000,
		.end   = 0xFFE1002B,
		.flags = IORESOURCE_MEM
	}, {
		.start	= 76,
		.end	= 79,
		.flags	= IORESOURCE_IRQ,
	}
};

struct platform_device s35190a_rtc_device  = {
	.name	= "rtc-s35190a",
	.id	= -1
};

static struct platform_device sh7764_spi_device = {
	.name		= "sh7764_spi",
	.id		= 0,
	.dev = {
		.platform_data = &spi_info
	},
	.num_resources	= ARRAY_SIZE(spi_sh_sci_resources),
	.resource	= spi_sh_sci_resources,
};

static struct sh7764_i2c_platdata sh7764_i2c_pdata = {
	.speed_khz = 400
};

static struct resource sh7764_i2c_resources[] = {
	[0] = {
		.start  = 0xFFE70000,
		.end    = 0xFFE70024,
		.flags  = IORESOURCE_MEM,
	},
	[1] = {
		.start  = 53,             // irq number
		.end    = 53,
		.flags  = IORESOURCE_IRQ,
	},
};

static struct platform_device sh7764_i2c_device = {
	.name           = SH7764_I2C_DEVNAME,
	.id             = 0,
	.dev            = {
		.platform_data = &sh7764_i2c_pdata,
	},
	.num_resources  = ARRAY_SIZE(sh7764_i2c_resources),
        .resource       = sh7764_i2c_resources
};

static struct resource ms104sh4ag_fb_resources[] = {
	{
		.start  = 0xffeb0000,
		.end    = 0xffef032f,
		.flags  = IORESOURCE_MEM,
	},
};

static struct fb_videomode ms104sh4ag_videomode = {
	.refresh = 60,
	.name = "WQVGA LCD",
	.xres = 480,
	.yres = 272,
	.pixclock = 10000,
	.left_margin = 80,
	.right_margin = 24,
	.upper_margin = 30,
	.lower_margin = 1,
	.hsync_len = 96,
	.vsync_len = 1,
	.sync = 0,
	.vmode = FB_VMODE_NONINTERLACED,
	.flag = FBINFO_FLAG_DEFAULT,
};
struct ms104sh4ag_platdata {
	struct fb_videomode *def_mode;
};

static struct ms104sh4ag_platdata ms104sh4ag_fb_def_pdata = {
	.def_mode = &ms104sh4ag_videomode,
#if 0
	.ldmtr = (LDMTR_TFT_COLOR_16|LDMTR_MCNT),
	.lddfr = LDDFR_16BPP_RGB565,
	.ldpmmr = 0x0000,
	.ldpspr = 0xFFFF,
	.ldaclnr = 0x0001,
	.ldickr = 0x1102,
	.rotate = 0,
	.novsync = 0,
	.blank = NULL,
#endif
};

static struct platform_device ms104sh4ag_fb_device = {
	.name		= "sh7764-vdc2",
	.resource	= ms104sh4ag_fb_resources,
	.num_resources = ARRAY_SIZE(ms104sh4ag_fb_resources),
	.dev = {
		.platform_data = &ms104sh4ag_fb_def_pdata,
	},
};

static struct resource sh7764_fb_resources[] = {
	{
		.start  = 0xffe30000,
		.end    = 0xffe30442 - 1,
		.flags  = IORESOURCE_MEM,
	}, {
		.start	= 33,
		.end	= 33,
		.flags	= IORESOURCE_IRQ
	}
};

static struct fb_videomode sh7764fb_videomode = {
	.refresh = 60,
	.name = "VGA Monitor",
	.xres = 1024,
	.yres = 768,
	.pixclock = 18518,
	.left_margin = 80,
	.right_margin = 24,
	.upper_margin = 30,
	.lower_margin = 1,
	.hsync_len = 96,
	.vsync_len = 1,
	.sync = 0,
	.vmode = FB_VMODE_NONINTERLACED,
	.flag = FBINFO_FLAG_DEFAULT,
};

static struct sh7760fb_platdata sh7764fb_def_pdata = {
	.def_mode = &sh7764fb_videomode,
	.ldmtr = (LDMTR_TFT_COLOR_16|LDMTR_MCNT),
	.lddfr = LDDFR_16BPP_RGB565,
	.ldpmmr = 0x0000,
	.ldpspr = 0xFFFF,
	.ldaclnr = 0x0001,
	.ldickr = 0x1101,
	.rotate = 0,
	.novsync = 0,
	.blank = NULL,
};

static struct platform_device sh7764_fb_device = {
	.name		= "sh7760-lcdc",
	.resource	= sh7764_fb_resources,
	.num_resources = ARRAY_SIZE(sh7764_fb_resources),
	.dev = {
		.platform_data = &sh7764fb_def_pdata,
	},
};

static struct platform_device *ms104sh4ag_devices[] __initdata = {
	&ms104sh4ag_flash_device,
	&sh_eth_device,
	&s35190a_rtc_device,
#if 1
	&r8a66597_usb_host_device,
#else
	&m66597_hcd_device,
#endif
	&sh7764_spi_device,
        &ms104sh4ag_ide0_device,
	&sh7764_i2c_device,
	&ms104sh4ag_fb_device,
	&sh7764_fb_device,
};

static int tsc2007_get_pendown_state(void)
{
#if 0
	int i = ctrl_inb(CPLD10) & TP_INT_STATUS;
	printk("%s: %d\n", __func__, i);
	return i;
#else
	return ctrl_inb(CPLD10) & TP_INT_STATUS;
#endif
}

static int tsc2007_init_plat_hw(void)
{
	printk("%s: CPLD10=%02x INTREQ=%08x\n", __func__, ctrl_inb(0xafc00000), ctrl_inl(INTREQ));
	return 0;
}

static int tsc2007_exit_plat_hw(void)
{
	return 0;
}
static struct tsc2007_platform_data tsc2007_pdata = {
	.x_plate_ohms		= 419,
	.get_pendown_state	= tsc2007_get_pendown_state,
	.init_platform_hw	= tsc2007_init_plat_hw,
	.exit_platform_hw	= tsc2007_exit_plat_hw,
};

#ifdef CONFIG_MMC_SPI
static struct task_struct *mmc_task = NULL;
static wait_queue_head_t sdcd_wait;

static int get_sdcd(void)
{
  //	printk(KERN_DEBUG "%s: CPLD2=%02x\n", __func__, ctrl_inb(CPLD2));

	return ctrl_inb(CPLD2) & SD_CD;
}

static int sdcd_thread(void *data)
{
	struct mmc_host *mmc = data;
//	struct mmc_spi_host *host = mmc_priv(mmc);
	int current_cd = get_sdcd();

	printk("SD Card detect thread started\n");

	for ( ; ; ) {
		int cd;
		//	printk("current_cd=%d\n", current_cd);

		interruptible_sleep_on_timeout(&sdcd_wait, HZ);

		if (kthread_should_stop())
			break;

		cd = get_sdcd();

		if (current_cd != cd)
			mmc_detect_change(mmc, HZ/10);
		current_cd = cd;
	}
	return 0;
}
#endif
static int spi_init(struct device *dev, irqreturn_t (*irq)(int, void *), void *p)
{
#if 0
	struct spi_device *spi = to_spi_device(dev);
	struct spi_master *master = spi->master;
#endif
#define SCSMR1  0xFFE10000
#define SCBRR1  0xFFE10004
#define SCSCR1  0xFFE10008
#define SCSPTR1 0xFFE10020

#if 0
	ctrl_outw(0x0000, SCSCR1);
	ctrl_outw(0x0000, SCSMR1);
//#else
	ctrl_outb(0x0C, SCBRR1);
	ctrl_outw(0x0080, SCSMR1);
	mdelay(1);
	ctrl_outw(0x0031, SCSCR1);
#endif

#ifdef CONFIG_MMC_SPI
	init_waitqueue_head(&sdcd_wait);

	mmc_task = kthread_run(sdcd_thread, p, "sdcdd");
#endif
	return 0;
}

static void ms104sh4ag_mmc_setpower(struct device *dev, unsigned int maskval)
{
  //	pr_info("%s: maskval=%04xh\n", __func__, maskval);
}

static int ms104sh4ag_mmc_get_ro(struct device *dev)
{
	return ctrl_inb(CPLD2) & SD_WP;
}

static struct mmc_spi_platform_data mmc_pdata = {
	.init		= spi_init,
	.setpower	= ms104sh4ag_mmc_setpower,
	.get_ro		= ms104sh4ag_mmc_get_ro,
#if 0	
	.ocr_mask = MMC_VDD_33_34,
#endif
};

static struct spi_board_info spi_bus[] = {
	{
		.modalias	= "mmc_spi",
		.platform_data  = &mmc_pdata,
		.max_speed_hz	= 13500000,
		//.max_speed_hz	= 25000000,
		//.mode		= SPI_MODE_3,
	},
};

static struct i2c_board_info __initdata ms104sh4ag_i2c_devs[] = {
        {
                I2C_BOARD_INFO("tlv320aic23", 0x1A),   /* 001 1010b */
        }, {
                I2C_BOARD_INFO("ad5246", 0x2E),         /* 010 1110b */
        }, {
                I2C_BOARD_INFO("tsc2007", 0x48),        /* 100 1000b */
		.platform_data = &tsc2007_pdata,
                .irq = TP_IRQ,
        }
};

static int __init ms104sh4ag_devices_setup(void)
{
	int ret = 0;

	printk("%s:\n", __func__);

	printk("ARCH_PFN_OFFSET	: %08x\n", ARCH_PFN_OFFSET);
	printk("PAGE_SIZE	: %08lx\n", PAGE_SIZE);
	printk("mem_map		: %08x\n", (u32)mem_map);
	printk("_PAGE_FLAGS_H.. : %08x\n", _PAGE_FLAGS_HARDWARE_MASK);

	ret = spi_register_board_info(spi_bus, ARRAY_SIZE(spi_bus));
        ret |= i2c_register_board_info(0, ms104sh4ag_i2c_devs,
                                       ARRAY_SIZE(ms104sh4ag_i2c_devs));

	ret |=platform_add_devices(ms104sh4ag_devices,
				   ARRAY_SIZE(ms104sh4ag_devices));

	return 0;
}

device_initcall(ms104sh4ag_devices_setup);

/*
 * Platform specific clocks
 */
static void usb_clk_enable(struct clk *clk)
{
	printk("%s:\n", __func__);
	ctrl_outb(ctrl_inb(CPLD1) | 0x01, CPLD1);
}

static void usb_clk_disable(struct clk *clk)
{
	printk("%s:\n", __func__);
	ctrl_outb(ctrl_inb(CPLD1) & ~0x01, CPLD1);
}

static void usb_clk_recalc(struct clk *clk)
{
	printk("%s:\n", __func__);
	clk->rate = 48 * 1000 * 1000;
}

static struct clk_ops usb_clk_ops = {
	.enable		= usb_clk_enable,
	.disable	= usb_clk_disable,
	.recalc		= usb_clk_recalc,
};

static struct clk usb_clk = {
	.name		= "usb0",
	.ops		= &usb_clk_ops,
	.rate		= 48 * 1000 * 1000,
};

static struct clk *ms104sh4ag_clocks[] = {
	&usb_clk,
};

extern int ms104sh4ag_irq_demux(int);
extern void init_ms104sh4ag_IRQ(void);

static void __init ms104sh4ag_setup(char **cmdline_p)
{
	int i;

	__set_io_port_base(0x00000000);
	
	printk("%s: cmdline=%s\n", __func__, *cmdline_p);
//	console_verbose();
//	board_time_init = ms104sh4_time_init;

	for (i = 0; i < ARRAY_SIZE(ms104sh4ag_clocks); i++) {
		struct clk *clk = ms104sh4ag_clocks[i];
		clk_register(clk);
	}
	
#if 0				/* LCDC */
#define PTIO_H		0xFFF1001C
#define PTIO_I		0xFFF10020
#define PTDAT_H		0xFFF1005C
#define PTDAT_I		0xFFF10060
#define PTSEL_G		0xFFF10098
#define PTSEL_H		0xFFF1009C
#define PTSEL_I		0xFFF100A0
#define PTSEL_J		0xFFF100A4
#define PTSEL_K		0xFFF100A8
        /* DR3,DR2,DR1,DR0, DG5,DG4,DG3,DG2 */
        ctrl_outw(0x0000, PTSEL_G);
        /* PH3,DCLKOUT,DR4,DR5 */
        ctrl_outw((ctrl_inw(PTSEL_H) & 0xff00) | 0x0000, PTSEL_H);
        /* DB3,DB2,DB1,DG1, DG0,DB5,DB4,PI0 */
        ctrl_outw(0x0000, PTSEL_I);
        /* DB0, HSYNC/SPL,DCLKIN,VSYNC/SPS,DE_C/DE_H */
        ctrl_outw((ctrl_inw(PTSEL_K) & 0xfc00) | 0x0000, PTSEL_K);

//        outw(0x0040, PTIO_H);
        ctrl_outw(0x0001, PTIO_I);
//        outw(inw(PTDAT_H) | 0x0008, PTDAT_H);
//        outw(inw(PTDAT_I) & 0xfffe, PTDAT_I);

//        outw(inw(PTDAT_I) | 0x0001, PTDAT_I);
#endif
}

static struct sh_machine_vector mv_ms104sh4 __initmv = {
	.mv_setup		= ms104sh4ag_setup,
	.mv_name		= "MS104-SH4AG",
	.mv_irq_demux		= ms104sh4ag_irq_demux,
	.mv_init_irq		= init_ms104sh4ag_IRQ,
	//	.mv_ioport_map		= ms104sh4_ioport_map,
};
