/*
 * SH7764 Setup
 *
 *  Copyright (C) 2006  Paul Mundt
 *  Copyright (C) 2007  Yoshihiro Shimoda
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 */
#include <linux/platform_device.h>
#include <linux/init.h>
#include <linux/serial.h>
#include <linux/io.h>
#include <linux/serial_sci.h>

static struct plat_sci_port sci_platform_data[] = {
	{
		.mapbase	= 0xffe00000,
		.flags		= UPF_BOOT_AUTOCONF,
		.type		= PORT_SCIF,
		.irqs		= { 40, 41, 43, 42 },
	}, {
		.mapbase        = 0xffe10000,
		.flags          = UPF_BOOT_AUTOCONF,
		.type           = PORT_SCIF,
		.irqs           = { 76, 77, 79, 78 },
        }, {
		.mapbase        = 0xffe20000,
		.flags          = UPF_BOOT_AUTOCONF,
		.type           = PORT_SCIF,
		.irqs           = {104,105,107,106 },
        }, {
		.flags = 0,
	}
};

static struct platform_device sci_device = {
	.name		= "sh-sci",
	.id		= -1,
	.dev		= {
		.platform_data	= sci_platform_data,
	},
};
#if 0
static struct resource usb_ohci_resources[] = {
	[0] = {
		.start	= 0xffec8000,
		.end	= 0xffec80ff,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= 83,
		.end	= 83,
		.flags	= IORESOURCE_IRQ,
	},
};

static u64 usb_ohci_dma_mask = 0xffffffffUL;
static struct platform_device usb_ohci_device = {
	.name		= "sh_ohci",
	.id		= -1,
	.dev = {
		.dma_mask		= &usb_ohci_dma_mask,
		.coherent_dma_mask	= 0xffffffff,
	},
	.num_resources	= ARRAY_SIZE(usb_ohci_resources),
	.resource	= usb_ohci_resources,
};

static struct resource usbf_resources[] = {
	[0] = {
		.start	= 0xffec0000,
		.end	= 0xffec00ff,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= 84,
		.end	= 84,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device usbf_device = {
	.name		= "sh_udc",
	.id		= -1,
	.dev = {
		.dma_mask		= NULL,
		.coherent_dma_mask	= 0xffffffff,
	},
	.num_resources	= ARRAY_SIZE(usbf_resources),
	.resource	= usbf_resources,
};
#endif
static struct platform_device *sh7764_devices[] __initdata = {
	&sci_device,
#if 0
	&usb_ohci_device,
	&usbf_device,
#endif
};

static int __init sh7764_devices_setup(void)
{
	return platform_add_devices(sh7764_devices,
				    ARRAY_SIZE(sh7764_devices));
}
__initcall(sh7764_devices_setup);

enum {
	UNUSED = 0,

	/* interrupt sources */

	IRQ0, IRQ1,
	WDT,
	TMU0, TMU1, TMU2, TMU2_TICPI,
	HUDI, LCDC,
	DMAC_DMINT0, DMAC_DMINT1, DMAC_DMINT2, DMAC_DMINT3, DMAC_DMAE,
	SCIF0_ERI, SCIF0_RXI, SCIF0_BRI, SCIF0_TXI,
	DMAC_DMINT4, DMAC_DMINT5,
	VDC2,
	IIC,
	ETHERC,
	G2D,
	SSIDMA0, SSICH0, SSICH1, SSICH2,
	SSIDMA1, SSICH3, SSICH4, SSICH5,
	SCIF1_ERI, SCIF1_RXI, SCIF1_BRI, SCIF1_TXI,
	ATAPI,
	USB,
	FLSTE, FLTEND, FLTRQ0, FLTRQ1,
	TMU3, TMU4, TMU5,
	SRC_OVF, SRC_IDEI, SRC_ODFI,
	SCIF2_ERI, SCIF2_RXI, SCIF2_BRI, SCIF2_TXI,
	GPIO_CH0, GPIO_CH1, GPIO_CH2, GPIO_CH3,

	/* interrupt groups */
	TMU012,
	TMU345, 
	DMAC,
	SSI_A,
	SSI_B,
	FLCTL,
	SRC,
	SCIF0,
	SCIF1,
	SCIF2,
	GPIO,
};

static struct intc_vect vectors[] __initdata = {
	INTC_VECT(WDT, 0x560),
	INTC_VECT(TMU0, 0x580),
	INTC_VECT(TMU1, 0x5A0),
	INTC_VECT(TMU2, 0x5C0),
	INTC_VECT(TMU2_TICPI, 0x5E0),
	INTC_VECT(HUDI, 0x600),
	INTC_VECT(LCDC, 0x620),
	INTC_VECT(DMAC_DMINT0, 0x640),
	INTC_VECT(DMAC_DMINT1, 0x660),
	INTC_VECT(DMAC_DMINT2, 0x680),
	INTC_VECT(DMAC_DMINT3, 0x6A0),
	INTC_VECT(DMAC_DMAE, 0x6C0),
	INTC_VECT(SCIF0_ERI, 0x700), 
	INTC_VECT(SCIF0_RXI, 0x720),
	INTC_VECT(SCIF0_BRI, 0x740), 
	INTC_VECT(SCIF0_TXI, 0x760),
	INTC_VECT(DMAC_DMINT4, 0x780), 
	INTC_VECT(DMAC_DMINT5, 0x7A0),
	INTC_VECT(VDC2, 0x860),
	INTC_VECT(IIC, 0x8A0), 
	INTC_VECT(ETHERC, 0x920), 
	INTC_VECT(G2D, 0x980),
	INTC_VECT(SSIDMA0, 0xA00),
	INTC_VECT(SSICH0, 0xA20),
	INTC_VECT(SSICH1, 0xA40),
	INTC_VECT(SSICH2, 0xA60),
	INTC_VECT(SSIDMA1, 0xAA0),
	INTC_VECT(SSICH3, 0xAC0),
	INTC_VECT(SSICH4, 0xAE0),
	INTC_VECT(SSICH5, 0xB00),
	INTC_VECT(SCIF1_ERI, 0xB80),
	INTC_VECT(SCIF1_RXI, 0xBA0),
	INTC_VECT(SCIF1_BRI, 0xBC0),
	INTC_VECT(SCIF1_TXI, 0xBE0),
	INTC_VECT(ATAPI, 0xC00),
	INTC_VECT(USB, 0xC60),
	INTC_VECT(FLSTE, 0xD00),
	INTC_VECT(FLTEND, 0xD20),	
	INTC_VECT(FLTRQ0, 0xD40),
	INTC_VECT(FLTRQ1, 0xD60),
	INTC_VECT(TMU3, 0xE00),
	INTC_VECT(TMU4, 0xE20),
	INTC_VECT(TMU5, 0xE40),
	INTC_VECT(SRC_OVF, 0xE80),
	INTC_VECT(SRC_IDEI, 0xEA0),
	INTC_VECT(SRC_ODFI, 0xEC0),
	INTC_VECT(SCIF2_ERI, 0xF00), 
	INTC_VECT(SCIF2_RXI, 0xF20),
	INTC_VECT(SCIF2_BRI, 0xF40),
	INTC_VECT(SCIF2_TXI, 0xF60),
	INTC_VECT(GPIO_CH0, 0xF80),
	INTC_VECT(GPIO_CH1, 0xFA0),
	INTC_VECT(GPIO_CH2, 0xFC0),
	INTC_VECT(GPIO_CH3, 0xFE0),
};

static struct intc_group groups[] __initdata = {
	INTC_GROUP(TMU012, TMU0, TMU1, TMU2, TMU2_TICPI),
	INTC_GROUP(TMU345, TMU3, TMU4, TMU5),
	INTC_GROUP(DMAC, DMAC_DMINT0, DMAC_DMINT1, DMAC_DMINT2,
		   DMAC_DMINT3, DMAC_DMINT4, DMAC_DMINT5, DMAC_DMAE),
	INTC_GROUP(SSI_B, SSIDMA1, SSICH3, SSICH4, SSICH5),
	INTC_GROUP(FLCTL, FLSTE, FLTEND, FLTRQ0, FLTRQ1),
	INTC_GROUP(SRC, SRC_OVF, SRC_IDEI, SRC_ODFI),
	INTC_GROUP(SCIF0, SCIF0_ERI, SCIF0_RXI, SCIF0_BRI, SCIF0_TXI),
	INTC_GROUP(SCIF1, SCIF1_ERI, SCIF1_RXI, SCIF1_BRI, SCIF1_TXI),
	INTC_GROUP(SCIF2, SCIF2_ERI, SCIF2_RXI, SCIF2_BRI, SCIF2_TXI),
	INTC_GROUP(GPIO, GPIO_CH0, GPIO_CH1, GPIO_CH2, GPIO_CH3),
};
#if 0
static struct intc_prio priorities[] __initdata = {
	INTC_PRIO(SCIF0, 3),
	INTC_PRIO(SCIF1, 3),
	INTC_PRIO(SCIF2, 3),
};
#endif
static struct intc_mask_reg mask_registers[] __initdata = {
	{ 
		0xffd40038, 0xffd4003c, 32, /* INT2MSKR / INT2MSKCR */
		{ 
			0, 0, 0, 0, 
			0, 0, GPIO, 0,
			SRC_OVF, FLCTL, 0, ATAPI, 
			SSI_B, 0, SSICH2, SSICH1,
			SSICH0, SSIDMA0, G2D, 0,
			0, 0, 0, DMAC,
			HUDI, 0, WDT, SCIF1, 
			SCIF0, 0, TMU345, TMU012 
		}
	}, {
		0xffd400d0, 0xffd400d4, 32, /* INT2MSKR1 / INT2MSKCR1 */
		{ 
			0, 0, 0, 0, 
			0, 0, SCIF2, 0,
			0, 0, 0, 0, 
			VDC2, 0, USB, ETHERC, 
			0, 0, 0, 0, 
			0, 0, 0, 0,
			LCDC, 0, 0, IIC, 
			0, SRC_ODFI, SRC_IDEI, 0
		} 
	},
};

static struct intc_prio_reg prio_registers[] __initdata = {
	{ 0xffd40000, 0, 32, 8, /* INT2PRI0 */ { TMU0, TMU1,
						 TMU2, TMU2_TICPI } },
	{ 0xffd40004, 0, 32, 8, /* INT2PRI1 */ { TMU3, TMU4, TMU5  } },
	{ 0xffd40008, 0, 32, 8, /* INT2PRI2 */ { SCIF0, SCIF1, WDT } },
	{ 0xffd4000c, 0, 32, 8, /* INT2PRI3 */ { HUDI, DMAC } },
	{ 0xffd40010, 0, 32, 8, /* INT2PRI4 */ { 0, G2D, SSIDMA0, SSICH0 } },
	{ 0xffd40014, 0, 32, 8, /* INT2PRI5 */ { SSICH1, SSICH2, 0, SSI_B } },
	{ 0xffd40018, 0, 32, 8, /* INT2PRI6 */ { ATAPI, 0, FLCTL, SRC_OVF } },
	{ 0xffd4001c, 0, 32, 8, /* INT2PRI7 */ { SCIF2, GPIO } },
	{ 0xffd400a0, 0, 32, 8, /* INT2PRI8 */ { 0, SRC_ODFI, SRC_IDEI } },
	{ 0xffd400a4, 0, 32, 8, /* INT2PRI9 */ { LCDC, 0, 0, IIC } },
	{ 0xffd400a8, 0, 32, 8, /* INT2PRI10 */ {  } },
	{ 0xffd400ac, 0, 32, 8, /* INT2PRI11 */ {  } },
	{ 0xffd400b0, 0, 32, 8, /* INT2PRI12 */ { VDC2, 0, USB, ETHERC } },
};

static DECLARE_INTC_DESC(intc_desc, "sh7764", vectors, groups, 
			 mask_registers, prio_registers, NULL);

/* Support for external interrupt pins in IRQ mode */
#define ICR0		0xFFD00000
#define ICR1		0xFFD0001C
#define INTPRI		0xFFD00010
#define INTREQ		0xFD000024
#define INTMSK		0xFFD00044
#define INTMSKCLR	0xFFD00064

static struct intc_vect irq_vectors[] __initdata = {
	INTC_VECT(IRQ0, 0x240), INTC_VECT(IRQ1, 0x280),
};

static struct intc_mask_reg irq_mask_registers[] __initdata = {
	{ 0xffd00044, 0xffd00064, 32, /* INTMSK0 / INTMSKCLR0 */
	  { IRQ0, IRQ1 } },
};

static struct intc_prio_reg irq_prio_registers[] __initdata = {
	{ 0xffd00010, 0, 32, 4, /* INTPRI */ { IRQ0, IRQ1 } },
};

static struct intc_sense_reg irq_sense_registers[] __initdata = {
	{ 0xffd0001c, 32, 2, /* ICR1 */   { IRQ0, IRQ1 } },
};

static DECLARE_INTC_DESC(intc_irq_desc, "sh7764-irq", irq_vectors,
			 NULL, irq_mask_registers, irq_prio_registers,
			 irq_sense_registers);

void __init plat_irq_setup(void)
{
	register_intc_controller(&intc_desc);
	register_intc_controller(&intc_irq_desc);
}
