/*
 * Copyright 2008 ALPHAPROJECT Co., ltd.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * Version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <linux/module.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/cdev.h>
#include <linux/sched.h>
#include <linux/device.h>
#include <linux/miscdevice.h>
#include <asm/current.h>
#include <asm/uaccess.h>
#include <asm/io.h>
#include <linux/giorw.h>

#define DRIVER_NAME "giorw"

static int giorw_ioctl(struct inode *inode, struct file *filp,
		       unsigned int cmd, unsigned long arg)
{
	int retval = 0;
	struct giorw iorw;

	pr_debug("%s\n", __func__);

	if (!access_ok(VERIFY_READ, (void __user *)arg, _IOC_SIZE(cmd))) {
		retval = -EFAULT;
		goto done;
	}

	if (_IOC_DIR(cmd) & _IOC_READ) {
		if (!access_ok(VERIFY_WRITE, (void __user *)arg,
			       _IOC_SIZE(cmd))) {
			retval = -EFAULT;
			goto done;
		}
	}

	copy_from_user(&iorw, (void __user *)arg, _IOC_SIZE(cmd));

	switch (cmd) {
	case GIORW_IOC_IOR8:
		iorw.data8 = inb(iorw.addr);
		copy_to_user((void __user *)arg, &iorw, _IOC_SIZE(cmd));
		break;

	case GIORW_IOC_IOW8:
		outb(iorw.data8, iorw.addr);
		break;

	case GIORW_IOC_IOR16:
		iorw.data16 = inw(iorw.addr);
		copy_to_user((void __user *)arg, &iorw, _IOC_SIZE(cmd));
		break;

	case GIORW_IOC_IOW16:
		outw(iorw.data16, iorw.addr);
		break;

	case GIORW_IOC_IOR32:
		iorw.data32 = inl(iorw.addr);
		copy_to_user((void __user *)arg, &iorw, _IOC_SIZE(cmd));
		break;

	case GIORW_IOC_IOW32:
		outl(iorw.data32, iorw.addr);
		break;

	default:
		retval = -ENOTTY;
		break;
	}
done:
	return retval;
}

static int giorw_open(struct inode *inode, struct file *file)
{
	pr_debug("%s: major %d minor %d (pid %d)\n", __func__,
		 imajor(inode), iminor(inode), current->pid);	
	return 0;
}

static int giorw_close(struct inode *inode, struct file *file)
{
	pr_debug("%s: major %d minor %d (pid %d)\n", __func__,
		 imajor(inode), iminor(inode), current->pid);
	return 0;
}

struct file_operations giorw_fops = {
	.owner = THIS_MODULE,
	.open = giorw_open,
	.release = giorw_close,
	.ioctl = giorw_ioctl
};

static struct miscdevice giorw_device = {
	MISC_DYNAMIC_MINOR,
	DRIVER_NAME,
	&giorw_fops,
};

static int giorw_init(void)
{
	return misc_register(&giorw_device);
}

static void giorw_exit(void)
{
	misc_deregister(&giorw_device);
}

module_init(giorw_init);
module_exit(giorw_exit);

MODULE_LICENSE("GPL");
